/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.MMAPISoundManagerImp;
import ca.jamdat.flight.SoundPlayer;
import ca.jamdat.flight.SpecConstants;

public final class SoundManager {
    public short mMasterVolume = (short)255;
    public boolean mIsPauseSoundsOnInterrupt;
    public boolean mIsMuted;
    public MMAPISoundManagerImp mImplementor = new MMAPISoundManagerImp();
    public short mScaledMasterVolume = this.CalculateScaledMasterVolume();
    public SoundPlayer[] mChannels = null;

    public SoundManager() {
        FrameworkGlobals.GetInstance().soundManager = this;
        this.mChannels = SoundPlayer.InstArraySoundPlayer(1);
    }

    public static SoundManager Get() {
        if (FrameworkGlobals.GetInstance().soundManager == null) {
            FrameworkGlobals.GetInstance().soundManager = new SoundManager();
        }
        return FrameworkGlobals.GetInstance().soundManager;
    }

    public final SoundPlayer GetChannelSoundPlayer(int n) {
        return this.mChannels[n];
    }

    public final void SetMuted(boolean bl) {
        MMAPISoundManagerImp.SetMuted(bl);
    }

    public final boolean IsMuted() {
        return MMAPISoundManagerImp.IsMuted();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void PauseAllSoundPlayers() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            int n = 0;
            while (n < 1) {
                this.mChannels[n].Pause();
                ++n;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void ResumeAllSoundPlayers() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            int n = 0;
            while (n < 1) {
                if (this.mChannels[n].IsPaused()) {
                    this.mChannels[n].Play();
                }
                ++n;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void StopAllSoundPlayers() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            int n = 0;
            while (n < 1) {
                this.mChannels[n].Stop();
                ++n;
            }
            return;
        }
    }

    private void SetMasterVolume(short s) {
        if (s > 255) {
            s = (short)255;
        }
        if (s < 0) {
            s = 0;
        }
        this.mMasterVolume = s;
        this.mScaledMasterVolume = this.CalculateScaledMasterVolume();
        for (s = 0; s < 1; s = (short)(s + 1)) {
            this.mChannels[s].SetNativeVolume();
        }
    }

    public static void IncMasterVolume() {
        SoundManager soundManager = FrameworkGlobals.GetInstance().soundManager;
        soundManager.SetMasterVolume((short)(soundManager.mMasterVolume + 51));
    }

    public static void DecMasterVolume() {
        SoundManager soundManager = FrameworkGlobals.GetInstance().soundManager;
        soundManager.SetMasterVolume((short)(soundManager.mMasterVolume - 51));
    }

    private static int CalculateNativePlayerVolume(short s, int n) {
        return n * s * FrameworkGlobals.GetInstance().soundManager.mScaledMasterVolume >> 16;
    }

    private short CalculateScaledMasterVolume() {
        if (SpecConstants.GetMasterVolumeScaleFactor() > 0) {
            return (short)(this.mMasterVolume << (short)SpecConstants.GetMasterVolumeScaleFactor());
        }
        if (SpecConstants.GetMasterVolumeScaleFactor() < 0) {
            return (short)(this.mMasterVolume >> (short)(-SpecConstants.GetMasterVolumeScaleFactor()));
        }
        return this.mMasterVolume;
    }

    public static int CalculateNativePlayerVolume(short s) {
        return SoundManager.CalculateNativePlayerVolume(s, 100);
    }
}

