/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.Scroller;
import ca.jamdat.flight.Viewport;

public final class Scrollbar {
    public Viewport mTrack;
    public Component mKnob;
    public Scroller mScrollerAttached;

    public final void UpdateKnobPosition() {
        if (this.mScrollerAttached.mNumElements != 0 && this.mScrollerAttached.GetTotalScrollingSize() > this.mScrollerAttached.GetVisibleWindowSize()) {
            int n = this.mTrack.mRect_height - this.mKnob.mRect_height;
            short s = (short)F32.ToInt_i(16, F32.Mul_i(n, this.mScrollerAttached.GetScrollbarRatio()));
            if (s > n) {
                s = (short)n;
            }
            this.mKnob.SetTopLeft(this.mKnob.mRect_left, s);
        }
    }

    private void SetVisible(boolean bl) {
        this.mKnob.SetVisible(bl);
        this.mTrack.SetVisible(bl);
    }

    public Scrollbar(Viewport viewport) {
        this.mTrack = viewport;
    }

    public final void SetScroller(Scroller scroller) {
        this.mScrollerAttached = scroller;
        this.UpdateBar();
    }

    public final void Unload() {
        this.SetViewport(null);
        this.mKnob = null;
        this.mTrack = null;
        this.mScrollerAttached = null;
    }

    public final void GetEntryPoints() {
        this.mKnob = this.mTrack.GetChild(0);
    }

    private void SetViewport(Viewport viewport) {
        this.mTrack.SetViewport(viewport);
    }

    public final void UpdateBar() {
        Viewport viewport = (Viewport)this.mScrollerAttached.GetChild(1);
        short s = (short)(viewport.mRect_height - (viewport.GetChild((int)0).mRect_height + viewport.GetChild((int)1).mRect_height));
        short s2 = this.mTrack.mRect_width;
        this.mTrack.SetSize(s2, s);
        if (this.mScrollerAttached.mNumElements != 0 && this.mScrollerAttached.GetTotalScrollingSize() > this.mScrollerAttached.GetVisibleWindowSize()) {
            this.SetVisible(true);
            this.UpdateKnobPosition();
            return;
        }
        this.SetVisible(false);
    }
}

