/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.CO_Room;
import ca.jamdat.flight.ClueBaseScene;
import ca.jamdat.flight.GE_ActionWheel;
import ca.jamdat.flight.GE_Clock;
import ca.jamdat.flight.GE_Editor;
import ca.jamdat.flight.GE_MapMovement;
import ca.jamdat.flight.GE_Room;
import ca.jamdat.flight.GE_SelectionPopUp;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.MediaPlayer;
import ca.jamdat.flight.RTA_CallState;
import ca.jamdat.flight.RTA_ConfrontState;
import ca.jamdat.flight.RTA_FreeRoamingState;
import ca.jamdat.flight.RTA_GossipState;
import ca.jamdat.flight.RTA_SearchingState;
import ca.jamdat.flight.RTA_TalkingState;
import ca.jamdat.flight.RTA_TravellingState;
import ca.jamdat.flight.RTActionSceneState;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Viewport;

public final class RTActionScene
extends ClueBaseScene {
    public Viewport mMenuTransitionViewport;
    public GE_Clock mClock;
    public TimeSystem mMenuTransitionTimeSystem;
    public short mSavedRoomPositionX;
    public GE_SelectionPopUp mSelectionPopUp;
    public boolean mAlreadyLoadedOnce;
    public RTActionSceneState mRTActionSceneState;
    public GE_Editor mEditor;
    public GE_Room mRoom;
    public GE_MapMovement mMovementMap;
    public GE_ActionWheel mActionWheel;

    public RTActionScene() {
        super(35, 3080286);
        this.mType = 4;
    }

    public final void Load() {
        super.Load();
        this.mActionWheel = new GE_ActionWheel(this);
        this.mActionWheel.Load();
        this.mClock = new GE_Clock(this);
        this.mClock.Load();
        this.mSelectionPopUp = new GE_SelectionPopUp(this);
        this.mSelectionPopUp.Load();
        this.mEditor = new GE_Editor(this);
        this.mEditor.Load();
        this.mMovementMap = new GE_MapMovement(this, GameApp.Get().GetScenarioContext().GetMansion());
        this.mMovementMap.Load();
        CO_Room cO_Room = GameApp.Get().GetScenarioContext().GetCurrentRoom();
        int n = cO_Room.mRoomId;
        int n2 = cO_Room.mSuspectId;
        this.mRoom = new GE_Room(this, n, n2);
        this.mRoom.Load();
    }

    public final void Unload() {
        if (this.mRTActionSceneState != null) {
            this.mRTActionSceneState.OnDelete();
            this.mRTActionSceneState = null;
        }
        this.mActionWheel.Unload();
        this.mActionWheel = null;
        this.mClock.Unload();
        this.mClock = null;
        this.mSelectionPopUp.Unload();
        this.mSelectionPopUp = null;
        this.mEditor.Unload();
        this.mEditor = null;
        this.mMovementMap.Unload();
        this.mMovementMap = null;
        this.mSavedRoomPositionX = this.mRoom.mCurrentPositionX;
        this.mRoom.Unload();
        this.mRoom = null;
        MediaPlayer mediaPlayer = GameApp.Get().GetMediaPlayer();
        MediaPlayer.StopVibration();
        mediaPlayer.Terminate();
        this.StopMenuTransitionAnimation();
        this.mMenuTransitionViewport = null;
        this.mMenuTransitionTimeSystem = null;
        super.Unload();
        GameApp.Get().GetScenarioProcess().Step(9);
    }

    public final boolean IsLoaded() {
        return super.IsLoaded() && this.mActionWheel.IsLoaded() && this.mClock.IsLoaded() && this.mSelectionPopUp.IsLoaded() && this.mEditor.IsLoaded() && this.mMovementMap.IsLoaded() && this.mRoom.IsLoaded();
    }

    public final void SetDefaultSoftkeys() {
    }

    public final void SetRTActionSceneState(int n) {
        boolean bl = this.mRTActionSceneState == null;
        if (this.mRTActionSceneState != null) {
            this.mRTActionSceneState.OnDelete();
            this.mRTActionSceneState = null;
        }
        switch (n) {
            case 1: {
                this.mRTActionSceneState = new RTA_CallState(this, this.mDialogBox, this.mRoom, this.mTicker, this.mSelectionPopUp, this.mEditor, this.mNavTab);
                break;
            }
            case 2: {
                this.mRTActionSceneState = new RTA_ConfrontState(this, this.mDialogBox, this.mRoom, this.mTicker, this.mSelectionPopUp, this.mNavTab, this.mClock);
                break;
            }
            case 4: {
                this.mRTActionSceneState = new RTA_FreeRoamingState(this, this.mDialogBox, this.mRoom, this.mTicker, this.mClock, this.mActionWheel, this.mNavTab, this.mEditor);
                break;
            }
            case 5: {
                this.mRTActionSceneState = new RTA_GossipState(this, this.mDialogBox, this.mRoom, this.mTicker, this.mNavTab);
                break;
            }
            case 9: {
                this.mRTActionSceneState = new RTA_SearchingState(this, this.mDialogBox, this.mRoom, this.mTicker, this.mNavTab);
                break;
            }
            case 10: {
                this.mRTActionSceneState = new RTA_TalkingState(this, this.mDialogBox, this.mRoom, this.mTicker, this.mNavTab);
                break;
            }
            case 11: {
                this.mRTActionSceneState = new RTA_TravellingState(this, this.mDialogBox, this.mRoom, this.mTicker, this.mMovementMap, this.mClock, this.mNavTab);
            }
        }
        this.mRTActionSceneState.Init();
        this.Refresh();
        if (!bl) {
            this.mRTActionSceneState.ReceiveFocus();
        }
    }

    public final void Unlock(int n, int n2) {
        super.Unlock(n, n2);
        if (n == 0) {
            this.mActionWheel.Unlock(n2);
            return;
        }
        if (n == 13) {
            this.mSelectionPopUp.Unlock(n2);
        }
    }

    public final void LockAccess() {
        super.LockAccess();
        this.mActionWheel.LockAccess();
        this.mSelectionPopUp.LockAccess();
    }

    public final void ConfigureSceneFor(int n) {
        this.mRTActionSceneState.ConfigureSceneFor(n);
        this.mClock.BringToFront();
    }

    public final void OnHideNotification() {
        this.mRTActionSceneState.OnHideNotification();
    }

    private void InitFromState() {
        this.SetRTActionSceneState(GameApp.Get().GetScenarioContext().mState);
    }

    private void StartMenuTransitionAnimation() {
        this.mMenuTransitionViewport.BringToFront();
        this.mMenuTransitionViewport.SetVisible(true);
        Utilities.StartTimeSystem(this.mMenuTransitionTimeSystem);
        this.mTicker.StopTicker();
    }

    private void StopMenuTransitionAnimation() {
        Utilities.StopTimeSystem(this.mMenuTransitionTimeSystem);
        if (this.mMenuTransitionViewport != null) {
            this.mMenuTransitionViewport.SetVisible(false);
        }
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        boolean bl = super.OnPenUp(by, sArray);
        if (!bl) {
            bl = this.mRTActionSceneState.OnPenUp(by, sArray);
        }
        return bl;
    }

    public final boolean OnPenMove(byte by, short[] sArray, short[] sArray2) {
        boolean bl = super.OnPenMove(by, sArray, sArray2);
        if (!bl) {
            bl = this.mRTActionSceneState.OnPenMove(by, this.mPenDownCoord, sArray, sArray2);
        }
        return bl;
    }

    public final boolean OnPenDown(byte by, short[] sArray) {
        boolean bl = super.OnPenDown(by, sArray);
        if (!bl) {
            bl = this.mRTActionSceneState.OnPenDown(by, sArray);
        }
        return bl;
    }

    public final void Initialize() {
        super.Initialize();
        this.mMenuTransitionViewport.SetVisible(false);
        this.mRoom.Init(this.mViewport);
        this.mRoom.SetState(1);
        boolean bl = GameApp.Get().GetPreviousSceneID() == 34;
        boolean bl2 = bl;
        bl = GameApp.Get().GetPreviousSceneID() == 20;
        boolean bl3 = GameApp.Get().GetPreviousSceneID() == 36;
        if (this.mAlreadyLoadedOnce) {
            this.mRoom.SetCurrentPositionX(this.mSavedRoomPositionX);
        } else if (bl2 || bl || bl3) {
            this.mRoom.SetCurrentPositionX(this.mRoom.mProjectedPositionX);
        }
        this.mActionWheel.Init(this.mViewport);
        this.mClock.Init(this.mViewport);
        this.mEditor.Init(this.mViewport);
        this.mSelectionPopUp.Init(this.mViewport);
        this.mMovementMap.Init(this.mViewport);
        this.mTicker.Init(this.mViewport);
        this.mNavTab.Init(this.mViewport, 4);
        this.mDialogBox.Init(this.mViewport);
        this.InitFromState();
        this.mAlreadyLoadedOnce = true;
    }

    public final void Suspend() {
        super.Suspend();
    }

    public final boolean OnCommand(int n) {
        if (n == 18 || n == 19 || n == 20) {
            int n2 = 4;
            if (n == 18) {
                n2 = 0;
            } else if (n == 19) {
                n2 = 1;
            } else if (n == 20) {
                n2 = 2;
            }
            this.mSceneAnimType = 1;
            this.mRoom.SetState(1);
            this.mRTActionSceneState.OnNavTabAccess();
            this.mNavTab.SelectNavTab(n2);
        } else if (n == -14) {
            this.mSceneAnimType = 3;
        }
        return this.mSelectionPopUp.OnCommand(n) || this.mRTActionSceneState.OnCommand(n) || super.OnCommand(n);
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mMenuTransitionViewport = Viewport.Cast$7c352e71(this.mMetaPackage.mPackage.GetEntryPoint(3));
        this.mMenuTransitionTimeSystem = TimeSystem.Cast$3b277f7b(this.mMetaPackage.mPackage.GetEntryPoint(4));
        this.mMovementMap.GetEntryPoints();
        this.mRoom.GetEntryPoints();
        this.mActionWheel.GetEntryPoints();
        this.mClock.GetEntryPoints();
        this.mEditor.GetEntryPoints();
        this.mSelectionPopUp.GetEntryPoints();
    }

    public final void StartOpeningAnims() {
        int n = GameApp.Get().GetPreviousSceneID() == 30 ? 1 : 0;
        int n2 = n;
        n = GameApp.Get().GetPreviousSceneID() == 31 ? 1 : 0;
        int n3 = n;
        n = GameApp.Get().GetPreviousSceneID() == 37 ? 1 : 0;
        int n4 = n;
        if (n2 != 0 || n3 != 0 || n != 0) {
            super.StartOpeningAnims();
            this.mSceneAnimType = 2;
            n = 3;
            if (n2 != 0) {
                n = 0;
            } else if (n3 != 0) {
                n = 1;
            } else if (n4 != 0) {
                n = 2;
            }
            this.mNavTab.SelectNavTab(n);
            this.mNavTab.BringToFront();
            this.mNavTab.StartMinimizingAnimation();
        }
    }

    public final boolean IsOpeningAnimsEnded() {
        return super.IsOpeningAnimsEnded();
    }

    public final void ReceiveFocus() {
        super.ReceiveFocus();
        this.mRTActionSceneState.ReceiveFocus();
    }

    public final void StartClosingAnims() {
        if (this.mSceneAnimType == 1) {
            super.StartClosingAnims();
            this.mNavTab.BringToFront();
            this.mNavTab.StartMaximizingAnimation();
            return;
        }
        if (this.mSceneAnimType == 3) {
            this.StartMenuTransitionAnimation();
        }
    }

    public final boolean IsClosingAnimsEnded() {
        boolean bl = true;
        if (this.mSceneAnimType == 3) {
            bl = this.mMenuTransitionTimeSystem.mTotalTime > 750;
        }
        return bl && this.mRTActionSceneState.IsClosingAnimsEnded() && super.IsClosingAnimsEnded();
    }

    public final void SerializeObjects() {
        if (this.mRTActionSceneState != null) {
            this.mRTActionSceneState.OnCommand(6);
        }
        GameApp.Get().GetScenarioProcess().OnSerialize();
    }

    public final boolean OnKeyDown(int n) {
        boolean bl = false;
        if (this.mRTActionSceneState.CanTreatKeyEvents()) {
            boolean bl2 = this.mDialogBox.mIsActive && this.mDialogBox.OnKeyDown(n);
            bl = bl2;
            if (!bl2) {
                bl = this.mRTActionSceneState.OnKeyDown(n);
            }
            if (!bl) {
                bl = this.mNavTab.OnKeyDown(n);
            }
        }
        return bl || super.OnKeyDown(n);
    }

    public final boolean OnKeyUp(int n) {
        boolean bl = false;
        if (this.mRTActionSceneState.CanTreatKeyEvents() || this.mEditor.IsVisible()) {
            boolean bl2 = this.mDialogBox.mIsActive && this.mDialogBox.OnKeyUp(n) && !this.mEditor.IsVisible();
            bl = bl2;
            if (!bl2) {
                bl = this.mRTActionSceneState.OnKeyUp(n);
            }
            if (!bl) {
                bl = this.mNavTab.OnKeyUp(n);
            }
        }
        return bl || super.OnKeyUp(n);
    }

    public final boolean OnKeyDownOrRepeat(int n) {
        boolean bl = false;
        if (this.mRTActionSceneState.CanTreatKeyEvents()) {
            boolean bl2 = this.mDialogBox.mIsActive && this.mDialogBox.OnKeyDownOrRepeat(n);
            bl = bl2;
            if (!bl2) {
                bl = this.mRTActionSceneState.OnKeyDownOrRepeat(n);
            }
            if (!bl) {
                bl = this.mNavTab.OnKeyDownOrRepeat(n);
            }
        }
        return bl || super.OnKeyDownOrRepeat(n);
    }
}

