/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.Color888;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.GE_CharactersIcons;
import ca.jamdat.flight.GE_GameEntity;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.Mansion;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public abstract class GE_Map
extends GE_GameEntity {
    public int mFirstPushedRoomId;
    public int mCurrentBorderRooms;
    public int mCurrentDoorsShape;
    public Viewport mViewportCompleteMap;
    public short mCurrentOffsetY;
    public short mCurrentOffsetX;
    public GE_CharactersIcons mCharactersIcons;
    public Shape[] mMapRooms = null;
    public int mTimeToSlide;
    public Shape[] mRooms = new Shape[12];
    public short mProjectedOffsetX;
    public short mProjectedOffsetY;
    public Shape[] mMapBorderRooms = null;
    public short mMansionHeight;
    public Mansion mCurrentMansion;
    public int mCurrentSelectedShape;
    public int mCurrentSelectedRoom;
    public Shape[] mMapSelectedRooms = null;
    public Shape[] mMapDoors = new Shape[48];
    public short mMansionWidth;
    public short mOffsetX;
    public short mOffsetY;
    public short mOriginalOffsetY;
    public Viewport mMapViewport;
    public short mOriginalOffsetX;
    public BaseScene mScene;

    public GE_Map(BaseScene baseScene, Mansion mansion) {
        super(baseScene);
        int n;
        this.mScene = baseScene;
        this.mCurrentMansion = mansion;
        this.mCurrentSelectedRoom = 12;
        this.mCurrentOffsetX = (short)9999;
        this.mCurrentOffsetY = (short)9999;
        this.mProjectedOffsetX = (short)9999;
        this.mProjectedOffsetY = (short)9999;
        this.mFirstPushedRoomId = -1;
        for (n = 0; n < 48; ++n) {
            this.mMapDoors[n] = null;
        }
        for (n = 0; n < 12; ++n) {
            this.mRooms[n] = null;
        }
    }

    public short GetMansionHeight() {
        return this.mMansionHeight;
    }

    public final void CreateSelectedShape(Viewport viewport, short s, short s2, short s3, short s4, short[] sArray) {
        this.mMapSelectedRooms[this.mCurrentSelectedShape] = new Shape();
        this.mMapSelectedRooms[this.mCurrentSelectedShape].SetViewport(viewport);
        this.mMapSelectedRooms[this.mCurrentSelectedShape].SetTopLeft(s, s2);
        this.mMapSelectedRooms[this.mCurrentSelectedShape].SetSize(s3, s4);
        this.mMapSelectedRooms[this.mCurrentSelectedShape].SetColor(sArray);
        ++this.mCurrentSelectedShape;
    }

    public void InitMainViewport() {
    }

    public short GetVirtualWidthViewport() {
        return this.mMapViewport.mRect_width;
    }

    public short GetVirtualHeightViewport() {
        return this.mMapViewport.mRect_height;
    }

    public short GetVirtualHeaderViewport() {
        return 0;
    }

    public void OnSelectedRoom() {
    }

    public void SelectRoom(int n) {
        this.UnselectRoom();
        if (this.mCurrentSelectedRoom != n) {
            this.mCurrentSelectedRoom = n;
            this.ChangeMapPosition(n);
        }
        this.SelectionFill(n);
        for (int i = 0; i < this.mCurrentMansion.mHeight; ++i) {
            for (int j = 0; j < this.mCurrentMansion.mWidth; ++j) {
                if (!this.IsSameRoom(j, i, n)) continue;
                if (!(this.IsSameRoom(j - 1, i, n) || this.mCurrentMansion.IsDoorInRoom(j - 1, i) && this.mCurrentMansion.IsDoorInRoom(j, i))) {
                    this.SelectionUnderline(j, i, 2);
                    this.CreateSelectedShape(this.mViewportCompleteMap, (short)(j * this.GetTileWidth() + this.mOffsetX - this.GetMapSelectorInternalSize() / 2), (short)(i * this.GetTileHeight() + this.mOffsetY - this.GetMapSelectorInternalSize() / 2), this.GetMapSelectorInternalSize(), (short)(this.GetTileHeight() + this.GetMapSelectorInternalSize()), Color888.c_init_iii(255, 255, 255));
                }
                if (!(this.IsSameRoom(j + 1, i, n) || this.mCurrentMansion.IsDoorInRoom(j + 1, i) && this.mCurrentMansion.IsDoorInRoom(j, i))) {
                    this.SelectionUnderline(j, i, 3);
                    this.CreateSelectedShape(this.mViewportCompleteMap, (short)(j * this.GetTileWidth() + this.mOffsetX + this.GetTileWidth() - this.GetMapSelectorInternalSize() / 2), (short)(i * this.GetTileHeight() + this.mOffsetY - this.GetMapSelectorInternalSize() / 2), this.GetMapSelectorInternalSize(), (short)(this.GetTileHeight() + this.GetMapSelectorInternalSize()), Color888.c_init_iii(255, 255, 255));
                }
                if (!(this.IsSameRoom(j, i - 1, n) || this.mCurrentMansion.IsDoorInRoom(j, i - 1) && this.mCurrentMansion.IsDoorInRoom(j, i))) {
                    this.SelectionUnderline(j, i, 0);
                    this.CreateSelectedShape(this.mViewportCompleteMap, (short)(j * this.GetTileWidth() + this.mOffsetX - this.GetMapSelectorInternalSize() / 2), (short)(i * this.GetTileHeight() + this.mOffsetY - this.GetMapSelectorInternalSize() / 2), (short)(this.GetTileWidth() + this.GetMapSelectorInternalSize()), this.GetMapSelectorInternalSize(), Color888.c_init_iii(255, 255, 255));
                }
                if (!(this.IsSameRoom(j, i + 1, n) || this.mCurrentMansion.IsDoorInRoom(j, i + 1) && this.mCurrentMansion.IsDoorInRoom(j, i))) {
                    this.SelectionUnderline(j, i, 1);
                    this.CreateSelectedShape(this.mViewportCompleteMap, (short)(j * this.GetTileWidth() + this.mOffsetX - this.GetMapSelectorInternalSize() / 2), (short)(i * this.GetTileHeight() + this.mOffsetY + this.GetTileHeight() - this.GetMapSelectorInternalSize() / 2), (short)(this.GetTileWidth() + this.GetMapSelectorInternalSize()), this.GetMapSelectorInternalSize(), Color888.c_init_iii(255, 255, 255));
                }
                this.SelectionCreateDoor(j, i, n);
            }
        }
        this.SelectionBringToFront(n);
    }

    public void UnselectRoom() {
        for (int i = 0; i < this.mCurrentSelectedShape; ++i) {
            if (this.mMapSelectedRooms[i] == null) continue;
            this.mMapSelectedRooms[i].SetViewport(null);
            this.mMapSelectedRooms[i] = null;
        }
        this.mCurrentSelectedShape = 0;
    }

    public boolean Move(int n, boolean bl) {
        int n2;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.mCurrentMansion.mHeight;
        switch (n) {
            case 0: {
                n3 = -1;
                n4 = this.mCurrentMansion.mHeight - 1;
                break;
            }
            case 1: {
                n5 = this.mCurrentMansion.mHeight - 1;
                break;
            }
            case 2: {
                n3 = -1;
                n4 = this.mCurrentMansion.mWidth - 1;
                n6 = this.mCurrentMansion.mWidth;
                break;
            }
            case 3: {
                n5 = this.mCurrentMansion.mWidth - 1;
                n6 = this.mCurrentMansion.mWidth;
            }
        }
        int n7 = -1;
        int n8 = n == 1 || n == 0 ? this.mCurrentMansion.mWidth : this.mCurrentMansion.mHeight;
        int n9 = n8;
        for (int i = 0; i < n9; ++i) {
            int n10 = 0;
            int n11 = -1;
            n8 = n == 1 || n == 0 ? this.mCurrentMansion.mHeight : this.mCurrentMansion.mWidth;
            int n12 = n8;
            int n13 = -1;
            n8 = n4;
            do {
                n2 = n == 1 || n == 0 ? this.mCurrentMansion.GetRoomId(i, n8) : this.mCurrentMansion.GetRoomId(n8, i);
                if (n10 == 0) {
                    n2 = n2 == this.mCurrentSelectedRoom ? 1 : 0;
                    n10 = n2;
                } else if (n2 == this.mCurrentSelectedRoom) {
                    n11 = n8;
                    n2 = n == 1 || n == 0 ? this.mCurrentMansion.mHeight : this.mCurrentMansion.mWidth;
                    n12 = n2;
                    n13 = -1;
                } else if (GE_Map.CanMoveTo(n2, this.mCurrentSelectedRoom) && FlMath.Absolute(n8 - n11) < n12) {
                    n13 = n2;
                    n12 = FlMath.Absolute(n8 - n11);
                }
                n8 += n3;
            } while (!(n == 0 || n == 2 ? n8 <= n5 : n8 >= n5));
            if (n12 >= n6) continue;
            n6 = n12;
            n7 = n13;
        }
        n2 = n7 != -1 ? 1 : 0;
        n8 = n2;
        if (n2 != 0 && bl) {
            this.SelectRoom(n7);
        }
        return n8 != 0;
    }

    public void SetVisible(boolean bl) {
        this.mComponentViewport.SetVisible(bl);
    }

    public abstract short GetMapDoorsLength();

    public abstract short GetMapDoorsLarge();

    public abstract short GetMapWallSize();

    public abstract short GetMapSelectorInternalSize();

    public abstract short GetTileWidth();

    public abstract short GetTileHeight();

    public abstract short GetMapMarginWidth();

    public short GetRoomMarginHeight() {
        return 0;
    }

    public abstract boolean IsViewportRoomExists(int var1);

    public abstract void InitViewportRoom(int var1);

    public abstract void CreateViewportRoom(int var1, int var2, int var3, int var4, int var5);

    public void BringToFrontViewportRoom() {
    }

    public short GetMansionWidth() {
        return this.mMansionWidth;
    }

    public void ChangeMapPosition(int n) {
        if (this.GetMansionWidth() > this.GetVirtualWidthViewport() - this.GetMapMarginWidth() || this.GetMansionHeight() > this.GetVirtualHeightViewport()) {
            int n2;
            int n3;
            if (this.mTimeToSlide > 0 || this.mProjectedOffsetX != 9999 && this.mProjectedOffsetY != 9999) {
                this.mCurrentOffsetX = (short)(this.mCurrentOffsetX + this.mTimeToSlide * (this.mProjectedOffsetX - this.mCurrentOffsetX) / 400);
                this.mCurrentOffsetY = (short)(this.mCurrentOffsetY + this.mTimeToSlide * (this.mProjectedOffsetY - this.mCurrentOffsetY) / 400);
                this.mTimeToSlide = 0;
            }
            int n4 = this.mCurrentMansion.mWidth;
            int n5 = 0;
            int n6 = this.mCurrentMansion.mHeight;
            int n7 = 0;
            for (n3 = 0; n3 < this.mCurrentMansion.mHeight; n3 = (int)((short)(n3 + 1))) {
                for (n2 = 0; n2 < this.mCurrentMansion.mWidth; n2 = (int)((short)(n2 + 1))) {
                    if (this.mCurrentMansion.GetRoomId(n2, n3) != n) continue;
                    if (n2 < n4) {
                        n4 = n2;
                    }
                    if (n3 < n6) {
                        n6 = n3;
                    }
                    if (n2 > n5) {
                        n5 = n2;
                    }
                    if (n3 <= n7) continue;
                    n7 = n3;
                }
            }
            n2 = this.GetTileHeight() * (n7 - n6 + 1) + this.GetRoomMarginHeight();
            n3 = 0;
            if (n2 > this.mMapViewport.mRect_height) {
                n3 = this.mMapViewport.mRect_height - n2;
            }
            this.mProjectedOffsetX = this.GetMansionWidth() > this.GetVirtualWidthViewport() - this.GetMapMarginWidth() ? (short)((this.GetMansionWidth() + (this.GetVirtualWidthViewport() - this.mViewportCompleteMap.mRect_width) - this.GetTileWidth() * (n5 + n4 + 1 - 2 * this.mOriginalOffsetX)) / 2) : this.mViewportCompleteMap.mRect_left;
            if (this.GetMansionHeight() > this.GetVirtualHeightViewport()) {
                this.mProjectedOffsetY = (short)((this.GetMansionHeight() + n3 + (this.GetVirtualHeightViewport() - this.mViewportCompleteMap.mRect_height) - this.GetTileHeight() * (n7 + n6 + 1 - 2 * this.mOriginalOffsetY)) / 2);
                return;
            }
            this.mProjectedOffsetY = this.mViewportCompleteMap.mRect_top;
        }
    }

    public void SelectionFill(int n) {
    }

    public void SelectionCreateDoor(int n, int n2, int n3) {
    }

    public void SelectionBringToFront(int n) {
    }

    public void CreateRoomTile(int n, int n2, int n3) {
    }

    public void CreateHallSeparationHorizontal(int n, int n2, int n3) {
    }

    public void CreateHallSeparationVertical(int n, int n2, int n3) {
    }

    public void SelectionUnderline(int n, int n2, int n3) {
    }

    public final void CreateMap() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        for (n5 = 0; n5 <= this.mCurrentMansion.mHeight; ++n5) {
            n4 = -1;
            n3 = -1;
            for (n2 = 0; n2 < this.mCurrentMansion.mWidth; ++n2) {
                n = n5 == this.mCurrentMansion.mHeight ? -1 : this.mCurrentMansion.GetRoomId(n2, n5);
                if (!((n5 != 0 || n == -1 || n == 12) && (this.IsSameRoom(n2, n5 - 1, n) || this.mCurrentMansion.IsDoorInRoom(n2, n5) && this.mCurrentMansion.IsDoorInRoom(n2, n5 - 1) || this.mCurrentMansion.IsInHall(n2, n5) && this.mCurrentMansion.IsInHall(n2, n5 - 1)))) {
                    if (n4 < 0) {
                        n4 = n2;
                    }
                    if (n4 >= 0) {
                        n3 = n2;
                    }
                } else {
                    this.CreateHallSeparationHorizontal(n2, n5, n);
                    if (n4 >= 0 && n3 >= 0) {
                        this.CreateHorizontalWall(n5, n4, n3);
                        ++this.mCurrentBorderRooms;
                    }
                    n4 = -1;
                    n3 = -1;
                }
                if (n5 == this.mCurrentMansion.mHeight || n == -1) continue;
                if (this.mCurrentMansion.IsDoorInRoom(n2, n5)) {
                    if (this.mCurrentMansion.IsDoorInRoom(n2, n5 + 1) && !this.IsSameRoom(n2, n5 + 1, n)) {
                        this.CreateDoorsShape$161468fc((short)(n2 * this.GetTileWidth() + this.mOffsetX + this.GetMapWallSize() % 2), (short)((n5 + 1) * this.GetTileHeight() + this.mOffsetY), false, false);
                        this.CreateDoorsShape$161468fc((short)((n2 + 1) * this.GetTileWidth() + this.mOffsetX - this.GetMapWallSize() / 2), (short)((n5 + 1) * this.GetTileHeight() + this.mOffsetY), false, false);
                        this.CreateDoorsShape$161468fc((short)(n2 * this.GetTileWidth() + this.mOffsetX - this.GetMapWallSize() / 2), (short)((n5 + 1) * this.GetTileHeight() + this.mOffsetY), true, false);
                    }
                    if (this.mCurrentMansion.IsDoorInRoom(n2 + 1, n5) && !this.IsSameRoom(n2 + 1, n5, n)) {
                        this.CreateDoorsShape$161468fc((short)((n2 + 1) * this.GetTileWidth() + this.mOffsetX), (short)(n5 * this.GetTileHeight() + this.mOffsetY + this.GetMapWallSize() / 2), false, true);
                        this.CreateDoorsShape$161468fc((short)((n2 + 1) * this.GetTileWidth() + this.mOffsetX), (short)((n5 + 1) * this.GetTileHeight() + this.mOffsetY - this.GetMapWallSize() / 2), false, true);
                        this.CreateDoorsShape$161468fc((short)((n2 + 1) * this.GetTileWidth() + this.mOffsetX), (short)(n5 * this.GetTileHeight() + this.mOffsetY), true, true);
                    }
                }
                this.CreateRoomTile(n2, n5, n);
            }
            if (n4 < 0 || n3 < 0) continue;
            this.CreateHorizontalWall(n5, n4, n3);
            ++this.mCurrentBorderRooms;
        }
        for (n3 = 0; n3 <= this.mCurrentMansion.mWidth; ++n3) {
            n4 = -1;
            n = -1;
            for (n2 = 0; n2 < this.mCurrentMansion.mHeight; ++n2) {
                n5 = n3 == this.mCurrentMansion.mWidth ? -1 : this.mCurrentMansion.GetRoomId(n3, n2);
                if (!((n3 != 0 || n5 == -1 || n5 == 12) && (this.IsSameRoom(n3 - 1, n2, n5) || this.mCurrentMansion.IsDoorInRoom(n3, n2) && this.mCurrentMansion.IsDoorInRoom(n3 - 1, n2) || this.mCurrentMansion.IsInHall(n3, n2) && this.mCurrentMansion.IsInHall(n3 - 1, n2)))) {
                    if (n4 < 0) {
                        n4 = n2;
                    }
                    if (n4 < 0) continue;
                    n = n2;
                    continue;
                }
                this.CreateHallSeparationVertical(n3, n2, n5);
                if (n4 >= 0 && n >= 0) {
                    this.CreateVerticalWall(n3, n4, n);
                    ++this.mCurrentBorderRooms;
                }
                n4 = -1;
                n = -1;
            }
            if (n4 < 0 || n < 0) continue;
            this.CreateVerticalWall(n3, n4, n);
            ++this.mCurrentBorderRooms;
        }
        this.BringToFrontDoors();
        this.BringToFrontWalls();
        this.BringToFrontViewportRoom();
    }

    public final boolean IsSameRoom(int n, int n2, int n3) {
        if (n < 0 || n >= this.mCurrentMansion.mWidth || n2 < 0 || n2 >= this.mCurrentMansion.mHeight) {
            return n3 == -1;
        }
        return this.mCurrentMansion.GetRoomId(n, n2) == n3;
    }

    public final void CreateRoomShape(int n, int n2) {
        int n3 = n + this.mCurrentMansion.mWidth * n2;
        this.mMapRooms[n3] = new Shape();
        this.mMapRooms[n3].SetViewport(this.mViewportCompleteMap);
        this.mMapRooms[n3].SetTopLeft((short)(n * this.GetTileWidth() + this.mOffsetX), (short)(n2 * this.GetTileHeight() + this.mOffsetY));
        this.mMapRooms[n3].SetSize(this.GetTileWidth(), this.GetTileHeight());
    }

    /*
     * WARNING - void declaration
     */
    public final void CreateDoorsShape$161468fc(short s, short s2, boolean bl, boolean bl2) {
        this.mMapDoors[this.mCurrentDoorsShape] = new Shape();
        this.mMapDoors[this.mCurrentDoorsShape].SetViewport(this.mViewportCompleteMap);
        if (bl) {
            void var4_9;
            this.mMapDoors[this.mCurrentDoorsShape].SetTopLeft(s, s2);
            Shape shape = this.mMapDoors[this.mCurrentDoorsShape];
            s2 = bl2 ? (short)1 : this.GetTileWidth();
            if (bl2) {
                short s3 = this.GetTileHeight();
            } else {
                boolean bl3 = true;
            }
            shape.SetSize(s2, (short)var4_9);
        } else {
            void var4_12;
            Shape shape = this.mMapDoors[this.mCurrentDoorsShape];
            s = bl2 ? (short)(s - this.GetMapDoorsLength() / 2) : (short)(s - this.GetMapDoorsLarge() / 2);
            s = s;
            s2 = bl2 ? (short)(s2 - this.GetMapDoorsLarge() / 2) : (short)(s2 - this.GetMapDoorsLength() / 2);
            shape.SetTopLeft(s, s2);
            shape = this.mMapDoors[this.mCurrentDoorsShape];
            s2 = bl2 ? this.GetMapDoorsLength() : this.GetMapDoorsLarge();
            if (bl2) {
                short s4 = this.GetMapDoorsLarge();
            } else {
                short s5 = this.GetMapDoorsLength();
            }
            shape.SetSize(s2, (short)var4_12);
        }
        this.mMapDoors[this.mCurrentDoorsShape].SetColor(Color888.c_init_iii(0, 0, 0));
        ++this.mCurrentDoorsShape;
    }

    public static boolean CanMoveTo(int n, int n2) {
        return n != n2 && n != -1 && n != 8 && n != 9 && n != 10 && n != 11;
    }

    public void Load() {
        int n;
        super.Load();
        this.mPackage = GameLibrary.GetPackage(294921);
        this.mCharactersIcons = new GE_CharactersIcons(this.mScene);
        this.mCharactersIcons.Load();
        int n2 = this.mCurrentMansion.mWidth * this.mCurrentMansion.mHeight;
        this.mMapSelectedRooms = new Shape[n2];
        for (n = 0; n < this.mMapSelectedRooms.length; ++n) {
            this.mMapSelectedRooms[n] = null;
        }
        this.mMapBorderRooms = new Shape[n2];
        for (n = 0; n < this.mMapBorderRooms.length; ++n) {
            this.mMapBorderRooms[n] = null;
        }
    }

    public final void CalcMapPositionAndViewports() {
        int n;
        int n2;
        int n3 = this.mCurrentMansion.mWidth;
        int n4 = 0;
        int n5 = this.mCurrentMansion.mHeight;
        int n6 = 0;
        int[] nArray = new int[12];
        int[] nArray2 = new int[12];
        int[] nArray3 = new int[12];
        int[] nArray4 = new int[12];
        for (n2 = 0; n2 < 12; ++n2) {
            nArray[n2] = this.mCurrentMansion.mWidth;
            nArray3[n2] = this.mCurrentMansion.mHeight;
            nArray2[n2] = 0;
            nArray4[n2] = 0;
        }
        for (n = 0; n < this.mCurrentMansion.mHeight; n = (int)((short)(n + 1))) {
            for (n2 = 0; n2 < this.mCurrentMansion.mWidth; n2 = (int)((short)(n2 + 1))) {
                int n7 = this.mCurrentMansion.GetRoomId(n2, n);
                if (n7 <= -1) continue;
                if (n2 < n3) {
                    n3 = n2;
                }
                if (n < n5) {
                    n5 = n;
                }
                if (n2 > n4) {
                    n4 = n2;
                }
                if (n > n6) {
                    n6 = n;
                }
                if (!this.mCurrentMansion.IsInHall(n2, n) && !this.IsViewportRoomExists(n7)) {
                    this.InitViewportRoom(n7);
                }
                if (n2 < nArray[n7]) {
                    nArray[n7] = n2;
                }
                if (n < nArray3[n7]) {
                    nArray3[n7] = n;
                }
                if (n2 > nArray2[n7]) {
                    nArray2[n7] = n2;
                }
                if (n <= nArray4[n7]) continue;
                nArray4[n7] = n;
            }
        }
        this.mMansionWidth = (short)((n4 - n3 + 1) * this.GetTileWidth());
        this.mMansionHeight = (short)((n6 - n5 + 1) * this.GetTileHeight());
        this.mOffsetX = (short)((this.mViewportCompleteMap.mRect_width - this.GetTileWidth() * (n4 + n3 + 1)) / 2);
        this.mOffsetY = (short)((this.mViewportCompleteMap.mRect_height - (this.GetMansionHeight() - this.mMansionHeight) - this.GetTileHeight() * (n6 + n5 + 1)) / 2 + this.GetVirtualHeaderViewport());
        this.mOriginalOffsetX = (short)n3;
        this.mOriginalOffsetY = (short)n5;
        this.mCurrentOffsetX = (short)((this.mMapViewport.mRect_width - this.mViewportCompleteMap.mRect_width) / 2);
        this.mCurrentOffsetY = (short)((this.mMapViewport.mRect_height - this.mViewportCompleteMap.mRect_height) / 2);
        this.mProjectedOffsetX = this.mCurrentOffsetX;
        this.mProjectedOffsetY = this.mCurrentOffsetY;
        for (n = 0; n < 12; ++n) {
            this.CreateViewportRoom(n, nArray[n], nArray3[n], nArray2[n], nArray4[n]);
        }
    }

    public final void BringToFrontDoors() {
        for (int i = 0; i < this.mCurrentDoorsShape; ++i) {
            this.mMapDoors[i].BringToFront();
        }
    }

    public void Unload() {
        int n;
        this.UnRegisterInGlobalTime();
        this.mCharactersIcons.Unload();
        this.mCharactersIcons = null;
        for (n = 0; n < this.mCurrentMansion.mWidth * this.mCurrentMansion.mHeight; ++n) {
            if (this.mMapBorderRooms[n] != null) {
                this.mMapBorderRooms[n].SetViewport(null);
                this.mMapBorderRooms[n] = null;
            }
            if (this.mMapSelectedRooms[n] == null) continue;
            this.mMapSelectedRooms[n].SetViewport(null);
            this.mMapSelectedRooms[n] = null;
        }
        this.mMapSelectedRooms = null;
        this.mMapBorderRooms = null;
        for (n = 0; n < 48; ++n) {
            if (this.mMapDoors[n] == null) continue;
            this.mMapDoors[n].SetViewport(null);
            this.mMapDoors[n] = null;
        }
        for (n = 0; n < 12; ++n) {
            if (this.mRooms[n] == null) continue;
            this.mRooms[n].SetViewport(null);
            this.mRooms[n] = null;
        }
        super.Unload();
        GameLibrary.ReleasePackage(this.mPackage);
        this.mFirstPushedRoomId = -1;
    }

    public boolean IsLoaded() {
        return this.mPackage.IsLoaded() && this.mCharactersIcons.IsLoaded();
    }

    public final void BringToFrontWalls() {
        for (int i = 0; i < this.mCurrentBorderRooms; ++i) {
            this.mMapBorderRooms[i].BringToFront();
        }
    }

    public final void CreateVerticalWall(int n, int n2, int n3) {
        this.mMapBorderRooms[this.mCurrentBorderRooms] = new Shape();
        this.mMapBorderRooms[this.mCurrentBorderRooms].SetViewport(this.mViewportCompleteMap);
        this.mMapBorderRooms[this.mCurrentBorderRooms].SetTopLeft((short)(n * this.GetTileWidth() - this.GetMapWallSize() / 2 + this.mOffsetX), (short)(n2 * this.GetTileHeight() - this.GetMapWallSize() / 2 + this.mOffsetY));
        this.mMapBorderRooms[this.mCurrentBorderRooms].SetSize(this.GetMapWallSize(), (short)(this.GetTileHeight() * (n3 - n2 + 1) + this.GetMapWallSize()));
        this.mMapBorderRooms[this.mCurrentBorderRooms].SetColor(Color888.c_init_iii(0, 0, 0));
    }

    public final void CreateHorizontalWall(int n, int n2, int n3) {
        this.mMapBorderRooms[this.mCurrentBorderRooms] = new Shape();
        this.mMapBorderRooms[this.mCurrentBorderRooms].SetViewport(this.mViewportCompleteMap);
        this.mMapBorderRooms[this.mCurrentBorderRooms].SetTopLeft((short)(n2 * this.GetTileWidth() - this.GetMapWallSize() / 2 + this.mOffsetX), (short)(n * this.GetTileHeight() - this.GetMapWallSize() / 2 + this.mOffsetY));
        this.mMapBorderRooms[this.mCurrentBorderRooms].SetSize((short)(this.GetTileWidth() * (n3 - n2 + 1) + this.GetMapWallSize()), this.GetMapWallSize());
        this.mMapBorderRooms[this.mCurrentBorderRooms].SetColor(Color888.c_init_iii(0, 0, 0));
    }

    public boolean Move(int n) {
        return this.Move(n, true);
    }

    public boolean OnPenUp(byte by, short[] sArray) {
        boolean bl = false;
        int n = this.GetRoomIdUnderThePen(sArray);
        if (n != -1 && n >= 0 && n <= 7) {
            if (this.mFirstPushedRoomId == n) {
                if (n == this.mCurrentSelectedRoom) {
                    this.OnSelectedRoom();
                } else {
                    this.SelectRoom(n);
                }
            }
            bl = true;
        }
        return bl || super.OnPenUp(by, sArray);
    }

    public final boolean OnPenDown(byte by, short[] sArray) {
        this.mFirstPushedRoomId = this.GetRoomIdUnderThePen(sArray);
        return super.OnPenDown(by, sArray);
    }

    public void OnTime(int n, int n2) {
        n = this.mCurrentOffsetX;
        short s = this.mCurrentOffsetY;
        if (this.mCurrentOffsetX != this.mProjectedOffsetX || this.mCurrentOffsetY != this.mProjectedOffsetY) {
            if (this.mTimeToSlide + n2 < 400) {
                this.mTimeToSlide += n2;
                n = (short)(this.mCurrentOffsetX + this.mTimeToSlide * (this.mProjectedOffsetX - this.mCurrentOffsetX) / 400);
                s = (short)(this.mCurrentOffsetY + this.mTimeToSlide * (this.mProjectedOffsetY - this.mCurrentOffsetY) / 400);
            } else {
                n = this.mProjectedOffsetX;
                s = this.mProjectedOffsetY;
                this.mCurrentOffsetX = this.mProjectedOffsetX;
                this.mCurrentOffsetY = this.mProjectedOffsetY;
                this.mTimeToSlide = 0;
            }
        }
        this.mViewportCompleteMap.SetTopLeft((short)n, s);
    }

    public final int GetRoomIdUnderThePen(short[] sArray) {
        int n = -1;
        if (this.Contains(sArray)) {
            int n2 = (Vector2_short.GetX_(sArray) - this.mMapViewport.GetAbsoluteLeft() - Vector2_short.GetX_(this.mViewportCompleteMap.GetTopLeft()) - this.mOffsetX) / this.GetTileWidth();
            int n3 = (Vector2_short.GetY_(sArray) - this.mMapViewport.GetAbsoluteTop() - Vector2_short.GetY_(this.mViewportCompleteMap.GetTopLeft()) - this.mOffsetY) / this.GetTileHeight();
            if (n3 >= 0 && n3 < this.mCurrentMansion.mHeight && n2 >= 0 && n2 < this.mCurrentMansion.mWidth) {
                n = this.mCurrentMansion.GetRoomId(n2, n3);
            }
        }
        return n;
    }

    public void GetEntryPoints() {
        super.GetEntryPoints();
        this.mComponentViewport = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(0));
        this.mMapViewport = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(1));
        this.mMapViewport.SetVisible(true);
        this.mViewportCompleteMap = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(2));
        for (int i = 0; i < 12; ++i) {
            this.mRooms[i] = Shape.Cast$2392dbe5(this.mPackage.mPackage.GetEntryPoint(32 + i));
        }
        this.mCharactersIcons.GetEntryPoints();
    }

    public void Init(Viewport viewport) {
        super.Init(viewport);
        this.SetVisible(false);
        this.RegisterInGlobalTime();
        this.InitMainViewport();
        this.mViewportCompleteMap.SetTopLeft((short)((this.mMapViewport.mRect_width - this.mViewportCompleteMap.mRect_width) / 2), (short)((this.mMapViewport.mRect_height - this.mViewportCompleteMap.mRect_height) / 2));
        this.CalcMapPositionAndViewports();
        this.CreateMap();
    }
}

