/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.DisplayManager;
import ca.jamdat.flight.FlAppProperties;
import ca.jamdat.flight.FlKeyManager;
import ca.jamdat.flight.FlPenManager;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.Scene;
import ca.jamdat.flight.SoundManager;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Viewport;

public class FlApplication
extends Viewport {
    public Scene mCurrentScene;
    public int mLastKeyDown = 0;
    public boolean mExitProcessed;
    public boolean mIsSuspended;
    public short[] mKeyMap = new short[149];
    public boolean mIgnoreSecondKeyDown = true;
    public boolean mHasFocus = true;
    public byte mCurrentTransitionType = 0;
    public int mKeyRepeatTime;
    public Component mComponentWithFocus;
    public TimeSystem mApplicationTimeSystem = new TimeSystem();
    public long[] mLong64Array = null;

    public final void OnFocusLostFromOS() {
        if (this.mHasFocus) {
            this.mHasFocus = false;
            this.Invalidate();
            this.ReleaseAllInput();
        }
    }

    public final void OnFocusGainedFromOS() {
        if (!this.mHasFocus) {
            this.mHasFocus = true;
            this.Invalidate();
            FlPenManager.Get().OnAppResumed();
        }
    }

    public final void OnSuspendFromOS() {
        if (!this.mIsSuspended) {
            this.mIsSuspended = true;
            this.mLong64Array[1] = FlApplication.GetRealTime();
            this.Suspend();
        }
    }

    public final void OnResumeFromOS() {
        if (this.mIsSuspended) {
            long l;
            this.mIsSuspended = false;
            this.mLong64Array[0] = l = this.mLong64Array[0] + (FlApplication.GetRealTime() - this.mLong64Array[1]);
            this.mLong64Array[1] = 0L;
            this.Resume();
        }
    }

    public final void ReleaseAllInput() {
        this.SendKeyUpToLastKeyDown();
        Component.ReleasePen();
    }

    public final void Iteration(int n, int n2) {
        int n3 = this.mLastKeyDown;
        int n4 = this.mKeyRepeatTime;
        if (n3 != 0) {
            if (n4 == Integer.MAX_VALUE) {
                n4 = -350;
            } else if ((n4 += n2) > 150) {
                this.SendKeyRepeatMsg(this.GetTranslatedKey(n3));
                n4 = 0;
            }
        }
        this.mKeyRepeatTime = n4;
        this.mApplicationTimeSystem.OnTime(n, n2);
    }

    public static long GetRealTime() {
        return System.currentTimeMillis();
    }

    public static TimeSystem GetGlobalTimeSystem() {
        return FlApplication.GetInstance().mApplicationTimeSystem;
    }

    public final Component GetHitTestComponent(short s, short s2) {
        return super.GetHitTestComponent(s, s2);
    }

    public FlApplication() {
        FrameworkGlobals.GetInstance().application = this;
        this.mComponentWithFocus = this;
        short[] sArray = DisplayManager.GetVideoModeRect();
        this.SetRect(FlRect.GetLeft_(sArray), FlRect.GetTop_(sArray), FlRect.GetWidth_(sArray), FlRect.GetHeight_(sArray));
        FrameworkGlobals.GetInstance().penTracker = this;
        FlKeyManager.GetInstance();
        this.mLong64Array = new long[2];
        this.mLong64Array[0] = FlApplication.GetRealTime();
        this.mLong64Array[1] = 0L;
    }

    public static void OSExit() {
        clue.instance.OSExit();
    }

    public final void SendKeyDownMsg(int n) {
        this.mComponentWithFocus.SendMsg(this.mComponentWithFocus, -120, n);
    }

    public final void SendKeyUpMsg(int n) {
        this.mComponentWithFocus.SendMsg(this.mComponentWithFocus, -121, n);
    }

    public final void SendKeyRepeatMsg(int n) {
        this.mComponentWithFocus.SendMsg(this.mComponentWithFocus, -119, n);
    }

    public static void MoveFocusForNotifications(Component component, Component component2, int n) {
        if (component == component2) {
            return;
        }
        int n2 = n;
        Component component3 = null;
        if (n <= 0) {
            component.OnFocusChange(false);
            component = component.m_pViewport;
            n2 = n + 1;
            if (component == component2) {
                component2.OnFocusChange(true);
            }
        }
        if (n >= 0) {
            component3 = component2;
            component2 = component2.m_pViewport;
            --n2;
        }
        FlApplication.MoveFocusForNotifications(component, component2, n2);
        if (component3 != null) {
            component3.OnFocusChange(true);
        }
    }

    public void SaveGame() {
    }

    public void Suspend() {
    }

    public void Resume() {
    }

    public static FlApplication GetInstance() {
        return FrameworkGlobals.GetInstance().application;
    }

    public static FlString GetJamdatBuildString() {
        FlString flString = new FlString(FlApplication.GetVersionString());
        if (new FlString(FlApplication.GetPropertyValue(StringUtils.CreateString("MIDlet-Version"))).Equals(flString)) {
            return flString;
        }
        flString.AddAssign(StringUtils.CreateString("-Error"));
        return flString;
    }

    public static void Exit() {
        FlApplication.ProcessExit();
        FlApplication.OSExit();
    }

    public static void ProcessExit() {
        FlApplication flApplication = FlApplication.GetInstance();
        if (!flApplication.mExitProcessed) {
            Scene scene = flApplication.mCurrentScene;
            if (scene != null) {
                scene.SendMsg(scene, -109, -1);
            }
            flApplication.mExitProcessed = true;
        }
    }

    public static FlString GetDir() {
        return new FlString();
    }

    public static FlString GetDataDir() {
        return new FlString();
    }

    public static byte GetMajorVersion() {
        return (byte)Constants.ApplicationMajorVersion();
    }

    public static byte GetMinorVersion() {
        return (byte)Constants.ApplicationMinorVersion();
    }

    public static short GetBuildVersion() {
        return (byte)Constants.ApplicationBuildVersion();
    }

    public static FlString GetVersionString() {
        FlString flString = new FlString(StringUtils.CreateString("."));
        FlString flString2 = new FlString(FlApplication.GetMajorVersion());
        flString2.AddAssign(flString);
        flString2.AddAssign(new FlString(FlApplication.GetMinorVersion()));
        flString2.AddAssign(flString);
        flString2.AddAssign(new FlString(FlApplication.GetBuildVersion()));
        return flString2;
    }

    public static FlString GetPropertyValue(FlString flString) {
        return FlAppProperties.GetValue_FlString(flString, FlAppProperties.c_init_());
    }

    public final void OnKeyFromOS(int n, boolean bl) {
        switch (n) {
            case 0: {
                return;
            }
            case 12: {
                if (!bl) {
                    SoundManager.DecMasterVolume();
                }
                return;
            }
            case 11: {
                if (!bl) {
                    SoundManager.IncMasterVolume();
                }
                return;
            }
            case 144: 
            case 145: {
                return;
            }
        }
        int n2 = this.GetTranslatedKey(n);
        int n3 = this.mLastKeyDown;
        Component component = this.mComponentWithFocus;
        if (bl) {
            if (n3 == n) {
                this.mLastKeyDown = 0;
                this.SendKeyUpMsg(n2);
                return;
            }
            if (this.mIgnoreSecondKeyDown) {
                this.OnKeyFromOS(n3, true);
                return;
            }
        } else if (n3 != 0) {
            this.OnKeyFromOS(n3, true);
            if (!this.mIgnoreSecondKeyDown) {
                this.OnKeyFromOS(n, false);
                return;
            }
        } else {
            this.mLastKeyDown = n;
            this.mKeyRepeatTime = Integer.MAX_VALUE;
            this.SendKeyDownMsg(n2);
            if (this.mComponentWithFocus == component) {
                this.SendKeyRepeatMsg(n2);
            }
        }
    }

    public final void SendKeyUpToLastKeyDown() {
        this.OnKeyFromOS(this.mLastKeyDown, true);
    }

    public final void MapKey(int n, int n2) {
        this.ResetDownKeys();
        this.mKeyMap[n] = (short)n2;
    }

    public final void ResetDownKeys() {
        this.mLastKeyDown = 0;
    }

    public final int GetTranslatedKey(int n) {
        if (this.mKeyMap[n] != 0) {
            n = this.mKeyMap[n];
        }
        return n;
    }

    public final void SetCurrentFocus(Component component) {
        component = component.ForwardFocus();
        Component component2 = this.mComponentWithFocus;
        this.mComponentWithFocus = component;
        int n = component.GetDepth();
        int n2 = component2.GetDepth();
        FlApplication.MoveFocusForNotifications(component2, component, n - n2);
    }
}

