/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FileHandler;
import ca.jamdat.flight.FileSegmentStream;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.StringUtils;

public final class FileManager {
    public FileHandler mFileBackup;
    public FileHandler mFile;

    private void SelectMostRecentFileAndAlternateBackup() {
        if (this.mFileBackup.mWritingCount > this.mFile.mWritingCount) {
            this.mFileBackup.SetPathname(this.mFile.mPathname);
            this.mFile = null;
            this.mFile = this.mFileBackup;
            this.mFileBackup = null;
            return;
        }
        this.mFile.SetPathname(this.mFileBackup.mPathname);
        this.mFileBackup = null;
    }

    public FileManager() {
        FlString flString = new FlString(FlApplication.GetDataDir().Add(StringUtils.CreateString("a")));
        this.mFile = new FileHandler(flString.Add(new FlString(1)), this.AllocateSegments(), 5);
        this.mFileBackup = new FileHandler(flString.Add(new FlString(2)), this.AllocateSegments(), 5);
    }

    public final int OnLoad() {
        this.mFile.OnSerialize(0);
        this.mFileBackup.OnSerialize(0);
        this.SelectMostRecentFileAndAlternateBackup();
        this.ReadApplicationObjects();
        return 3;
    }

    public final boolean OnSave() {
        return this.mFile.OnSerialize(1);
    }

    public final void WriteObject(int n) {
        FileHandler fileHandler = ((FileManager)((Object)fileHandler)).mFile;
        GameApp gameApp = GameApp.Get();
        switch (n) {
            case 1: {
                gameApp.GetStatistics().Write(fileHandler.GetSegmentStream$6cc0491b(1));
                return;
            }
            case 0: {
                gameApp.GetSettings().Write(fileHandler.GetSegmentStream$6cc0491b(0));
                return;
            }
            case 2: {
                gameApp.GetScenarioProcess().WriteScenarioId();
                return;
            }
            case 3: {
                gameApp.GetAchievements().Write(fileHandler.GetSegmentStream$6cc0491b(3));
            }
        }
    }

    public final void WriteApplicationObjects() {
        for (int i = 0; i < 4; ++i) {
            this.WriteObject(i);
        }
    }

    private void ReadObject(int n) {
        FileHandler fileHandler = ((FileManager)((Object)fileHandler)).mFile;
        GameApp gameApp = GameApp.Get();
        switch (n) {
            case 1: {
                gameApp.GetStatistics().Read(fileHandler.GetSegmentStream$6cc0491b(1));
                return;
            }
            case 0: {
                gameApp.GetSettings().Read(fileHandler.GetSegmentStream$6cc0491b(0));
                return;
            }
            case 2: {
                gameApp.GetScenarioProcess().ReadScenarioId();
                return;
            }
            case 3: {
                gameApp.GetAchievements().Read(fileHandler.GetSegmentStream$6cc0491b(3));
            }
        }
    }

    private void ReadApplicationObjects() {
        for (int i = 0; i < 4; ++i) {
            this.ReadObject(i);
        }
    }

    public final FileSegmentStream GetInputSegmentStream(int n) {
        return this.mFile.GetSegmentStream$6cc0491b(n);
    }

    public final FileSegmentStream GetOutputSegmentStream(int n) {
        return this.mFile.GetSegmentStream$6cc0491b(n);
    }

    public final void ResetSegmentStream() {
        this.mFile.ResetSerializableData();
    }

    private FileSegmentStream[] AllocateSegments() {
        FileSegmentStream[] fileSegmentStreamArray = new FileSegmentStream[5];
        fileSegmentStreamArray[0] = new FileSegmentStream(51);
        fileSegmentStreamArray[1] = new FileSegmentStream(37);
        fileSegmentStreamArray[4] = new FileSegmentStream(400);
        fileSegmentStreamArray[2] = new FileSegmentStream(13);
        fileSegmentStreamArray[3] = new FileSegmentStream(61);
        return fileSegmentStreamArray;
    }
}

