/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Color888;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.FlDrawPropertyUtil;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.ForceInline;
import ca.jamdat.flight.MIDPDisplayContextImp;
import ca.jamdat.flight.VideoMode;
import ca.jamdat.flight.Viewport;

public abstract class DisplayContext {
    public short[] mDirtyRects_left = new short[3];
    public short mClipRect_top;
    public short[] mDirtyRects_top = new short[3];
    public int mSlotsUsed;
    public short[] mScreenRect;
    public boolean mBypassClipping;
    public short[] mDirtyRects_height;
    public short mClipRect_height;
    public short mClipRect_width;
    public short mCumulativeOffsetX;
    public boolean mDirtyRectsEnabled = true;
    public short mClipRect_left;
    public int[] mVideoMode;
    public short mCumulativeOffsetY;
    public short[] mDirtyRects_width = new short[3];
    public int[] mDirtyRectsAreas;
    public int mClearNextFramesCount;
    public int mDirtyRectIndex = -1;
    public int mDirtyRectMergePixelThreshold;

    public final void SetAbsoluteClippingRect(short s, short s2, short s3, short s4) {
        this.mClipRect_left = s;
        this.mClipRect_top = s2;
        this.mClipRect_width = s3;
        this.mClipRect_height = s4;
    }

    public final void BeginScene() {
        if (this.mClearNextFramesCount > 0) {
            --this.mClearNextFramesCount;
            this.ClearFullscreen(Color888.c_init_iii(0, 0, 0));
        }
        this.mDirtyRectIndex = 0;
    }

    public final void EndScene() {
        this.mDirtyRectIndex = -1;
        this.ClearDirtyRects();
    }

    public final void RenderApplication() {
        short s;
        short s2;
        int n;
        short s3;
        if (!this.mDirtyRectsEnabled) {
            this.ClearDirtyRects();
            this.AddDirtyRect((short)0, (short)0, (short)VideoMode.GetWidth_(this.mVideoMode), (short)VideoMode.GetHeight_(this.mVideoMode));
        }
        int[] nArray = this.mDirtyRectsAreas;
        for (int i = 0; i < this.mSlotsUsed - 1; ++i) {
            short s4 = this.mDirtyRects_left[i];
            short s5 = this.mDirtyRects_top[i];
            short s6 = this.mDirtyRects_width[i];
            short s7 = this.mDirtyRects_height[i];
            for (int j = i + 1; j < this.mSlotsUsed; ++j) {
                short s8 = this.mDirtyRects_left[j];
                short s9 = this.mDirtyRects_top[j];
                s3 = this.mDirtyRects_width[j];
                n = this.mDirtyRects_height[j];
                s2 = FlMath.Minimum(s4, s8);
                s = FlMath.Minimum(s5, s9);
                n = (s3 = (short)(FlMath.Maximum((short)(s4 + s6), (short)(s8 + s3)) - s2)) * (s9 = (short)(FlMath.Maximum((short)(s5 + s7), (short)(s9 + n)) - s));
                if (n - (this.mDirtyRectsAreas[i] + this.mDirtyRectsAreas[j]) > this.mDirtyRectMergePixelThreshold) continue;
                this.mDirtyRects_left[i] = s2;
                this.mDirtyRects_top[i] = s;
                this.mDirtyRects_width[i] = s3;
                this.mDirtyRects_height[i] = s9;
                nArray[i] = n;
                for (n = j + 1; n < this.mSlotsUsed; ++n) {
                    this.mDirtyRects_left[n - 1] = this.mDirtyRects_left[n];
                    this.mDirtyRects_top[n - 1] = this.mDirtyRects_top[n];
                    this.mDirtyRects_width[n - 1] = this.mDirtyRects_width[n];
                    this.mDirtyRects_height[n - 1] = this.mDirtyRects_height[n];
                    nArray[n - 1] = nArray[n];
                }
                s4 = this.mDirtyRects_left[i];
                s5 = this.mDirtyRects_top[i];
                s6 = this.mDirtyRects_width[i];
                s7 = this.mDirtyRects_height[i];
                --this.mSlotsUsed;
                --j;
            }
        }
        this.BeginScene();
        s = this.mClipRect_left;
        s2 = this.mClipRect_top;
        n = this.mClipRect_width;
        s3 = this.mClipRect_height;
        while (this.SetNextDirtyRect()) {
            if (this.mClipRect_width <= 0 || this.mClipRect_height <= 0) {
                this.SetAbsoluteClippingRect(s, s2, (short)n, s3);
                continue;
            }
            FlApplication.GetInstance().OnDraw(this);
            this.SetAbsoluteClippingRect(s, s2, (short)n, s3);
        }
        this.EndScene();
    }

    public final void AddDirtyRect(short s, short s2, short s3, short s4) {
        short s5;
        short s6;
        int n;
        int n2;
        short s7;
        int n3;
        if (s3 <= 0 || s4 <= 0) {
            return;
        }
        boolean bl = false;
        short s8 = 0;
        short s9 = 0;
        int n4 = 0;
        short s10 = 0;
        int n5 = 2000000;
        int n6 = 0;
        int n7 = 1;
        short s11 = s3 * s4;
        int[] nArray = this.mDirtyRectsAreas;
        int n8 = this.mSlotsUsed;
        for (n3 = 0; n3 < n8; ++n3) {
            short s12 = this.mDirtyRects_left[n3];
            s7 = this.mDirtyRects_top[n3];
            n2 = this.mDirtyRects_width[n3];
            n = this.mDirtyRects_height[n3];
            s6 = FlMath.Minimum(s12, s);
            s5 = FlMath.Minimum(s7, s2);
            n = (n2 = (short)(FlMath.Maximum((short)(s12 + n2), (short)(s + s3)) - s6)) * (s7 = (short)(FlMath.Maximum((short)(s7 + n), (short)(s2 + s4)) - s5));
            if (n - (this.mDirtyRectsAreas[n3] + s11) <= this.mDirtyRectMergePixelThreshold) {
                this.mDirtyRects_left[n3] = s6;
                this.mDirtyRects_top[n3] = s5;
                this.mDirtyRects_width[n3] = n2;
                this.mDirtyRects_height[n3] = s7;
                nArray[n3] = n;
                return;
            }
            if (n >= n5) continue;
            n5 = n;
            s8 = s6;
            s9 = s5;
            n4 = n2;
            s10 = s7;
            n6 = n3;
        }
        if (n8 < 3) {
            this.mDirtyRects_left[n8] = s;
            this.mDirtyRects_top[n8] = s2;
            this.mDirtyRects_width[n8] = s3;
            this.mDirtyRects_height[n8] = s4;
            nArray[n8] = s3 * s4;
            ++this.mSlotsUsed;
            return;
        }
        for (int i = 0; i < 2; ++i) {
            for (n = i + 1; n < 3; ++n) {
                short s13 = this.mDirtyRects_left[i];
                n2 = this.mDirtyRects_top[i];
                s7 = this.mDirtyRects_width[i];
                n3 = this.mDirtyRects_height[i];
                n8 = this.mDirtyRects_left[n];
                s11 = this.mDirtyRects_top[n];
                s5 = this.mDirtyRects_width[n];
                s6 = this.mDirtyRects_height[n];
                short s14 = FlMath.Minimum(s13, (short)n8);
                short s15 = FlMath.Minimum((short)n2, s11);
                n2 = (s5 = (short)(FlMath.Maximum((short)(s13 + s7), (short)(n8 + s5)) - s14)) * (s6 = (short)(FlMath.Maximum((short)(n2 + n3), (short)(s11 + s6)) - s15));
                if (n2 >= n5) continue;
                bl = true;
                n5 = n2;
                s8 = s14;
                s9 = s15;
                n4 = s5;
                s10 = s6;
                n6 = i;
                n7 = n;
            }
        }
        this.mDirtyRects_left[n6] = s8;
        this.mDirtyRects_top[n6] = s9;
        this.mDirtyRects_width[n6] = n4;
        this.mDirtyRects_height[n6] = s10;
        nArray[n6] = n5;
        if (bl) {
            this.mDirtyRects_left[n7] = s;
            this.mDirtyRects_top[n7] = s2;
            this.mDirtyRects_width[n7] = s3;
            this.mDirtyRects_height[n7] = s4;
            nArray[n7] = s3 * s4;
        }
    }

    public final void AddDirtyComponent(Component component) {
        short s = component.mRect_left;
        short s2 = component.mRect_top;
        int n = component.mRect_width;
        int n2 = component.mRect_height;
        Viewport viewport = component.m_pViewport;
        if (viewport != null) {
            Component component2 = component;
            short s3 = 0;
            short s4 = 0;
            while (viewport != null) {
                if (!viewport.mVisible) {
                    return;
                }
                s3 = (short)(s3 + viewport.mRect_left - viewport.mOffsetX);
                s4 = (short)(s4 + viewport.mRect_top - viewport.mOffsetY);
                component2 = viewport;
                viewport = viewport.m_pViewport;
            }
            if (FlApplication.GetInstance() != component2) {
                return;
            }
            s = (short)(s + s3);
            s2 = (short)(s2 + s4);
            s3 = (short)(s3 + component.m_pViewport.mOffsetX);
            s4 = (short)(s4 + component.m_pViewport.mOffsetY);
            int n3 = s3 + component.m_pViewport.mRect_width;
            int n4 = s + n;
            n = s4 + component.m_pViewport.mRect_height;
            n2 = s2 + n2;
            if (s3 > s) {
                s = s3;
            }
            if (s4 > s2) {
                s2 = s4;
            }
            if (n3 < n4) {
                n4 = n3;
            }
            if (n < n2) {
                n2 = n;
            }
            this.AddDirtyRect(s, s2, (short)(n4 - s), (short)(n2 - s2));
            return;
        }
        if (component == FlApplication.GetInstance()) {
            this.AddDirtyRect(s, s2, (short)n, (short)n2);
        }
    }

    public final boolean HasDirtyRects() {
        return this.mSlotsUsed > 0;
    }

    public final void ClearDirtyRects() {
        this.mSlotsUsed = 0;
    }

    public final boolean SetNextDirtyRect() {
        if (this.mDirtyRectIndex >= this.mSlotsUsed) {
            return false;
        }
        int n = this.mDirtyRectIndex;
        short s = this.mDirtyRects_left[n];
        short s2 = this.mDirtyRects_top[n];
        int n2 = s + this.mDirtyRects_width[n];
        int n3 = this.mClipRect_left + this.mClipRect_width;
        n = s2 + this.mDirtyRects_height[n];
        int n4 = this.mClipRect_top + this.mClipRect_height;
        if (s > this.mClipRect_left) {
            this.mClipRect_left = s;
        }
        if (s2 > this.mClipRect_top) {
            this.mClipRect_top = s2;
        }
        if (n2 < n3) {
            n3 = n2;
        }
        if (n < n4) {
            n4 = n;
        }
        this.mClipRect_width = (short)(n3 - this.mClipRect_left);
        this.mClipRect_height = (short)(n4 - this.mClipRect_top);
        ++this.mDirtyRectIndex;
        return true;
    }

    public final void DrawString(FlString flString, short s, short s2, short s3, short s4, FlFont flFont, byte by, int n, int n2, short s5) {
        this.DrawString$321141b(flString, s, s2, s3, s4, flFont, by, n, n2, s5);
    }

    public final void DrawMultilineString(FlString flString, int[] nArray, int n, short s, short s2, short s3, short s4, int n2, FlFont flFont, byte by, short[] sArray) {
        this.DrawMultilineString$1c014e88(flString, nArray, n, s, s2, s3, s4, n2, flFont, by, sArray);
    }

    public final void DrawRectangle(short s, short s2, short s3, short s4, boolean bl, int n, int n2, int n3) {
        this.DrawRectangle(s, s2, s3, s4, bl, n, n2, n3, 255);
    }

    public abstract void ClearFullscreen(short[] var1);

    public DisplayContext(int[] nArray) {
        this.mDirtyRects_height = new short[3];
        this.mDirtyRectsAreas = new int[3];
        this.mVideoMode = VideoMode.c_init_VideoMode(nArray);
        this.mScreenRect = FlRect.c_init_ssss((short)0, (short)0, (short)VideoMode.GetWidth_(nArray), (short)VideoMode.GetHeight_(nArray));
        this.mDirtyRectMergePixelThreshold = VideoMode.GetWidth_(nArray);
    }

    public static DisplayContext CreateContext(int[] nArray) {
        return new MIDPDisplayContextImp(nArray);
    }

    public static short GetAlignmentOffsetX(byte by, short s, short s2) {
        short s3 = 0;
        if (by != 0) {
            s3 = (short)(s - s2);
            if (by == 1) {
                s3 = (short)(s3 >> 1);
            }
        }
        return s3;
    }

    public final void DrawString$321141b(FlString flString, short s, short s2, short s3, short s4, FlFont flFont, byte by, int n, int n2, short s5) {
        if (flString.GetCharAt(n) == 0) {
            return;
        }
        short s6 = this.mClipRect_left;
        short s7 = this.mClipRect_top;
        short s8 = this.mClipRect_width;
        short s9 = this.mClipRect_height;
        short s10 = (short)(s + this.mCumulativeOffsetX);
        short s11 = (short)(s2 + this.mCumulativeOffsetY);
        if (FlRect.Contains(s6, s7, s8, s9, s10, s11, s3, s4)) {
            this.mBypassClipping = true;
        } else if (!FlRect.Intersects(s6, s7, s8, s9, s10, s11, s3, s4)) {
            return;
        }
        flFont.DrawString(this, flString, (short)(s + DisplayContext.GetAlignmentOffsetX(by, s3, s5)), s2, s5, n, n2);
        this.mBypassClipping = false;
    }

    public final void DrawMultilineString$1c014e88(FlString flString, int[] nArray, int n, short s, short s2, short s3, short s4, int n2, FlFont flFont, byte by, short[] sArray) {
        if (flFont == null) {
            return;
        }
        int n3 = flFont.GetLineHeight();
        int n4 = n3 - flFont.GetLeading();
        int n5 = s + this.mCumulativeOffsetX;
        int n6 = this.mCumulativeOffsetY;
        int n7 = s2 + n6;
        n5 = n5 >= this.mClipRect_left && (short)(n5 + s3 - 1) <= (short)(this.mClipRect_left + this.mClipRect_width - 1) ? 1 : 0;
        int n8 = n5;
        int n9 = this.mClipRect_top + this.mClipRect_height - 1;
        s4 = (short)(n7 + s4 - 1);
        int n10 = this.mClipRect_top - n7;
        int n11 = n2;
        n5 = n7;
        if (n10 > 0) {
            n5 = n7 + n10;
            if (n10 > n4) {
                n11 = n2 + 1 + (n10 - n4) / n3;
                n4 = n3;
            }
        }
        if (n11 > n - 1) {
            return;
        }
        n10 = s4;
        if (s4 > n9) {
            n10 = n9;
        }
        n9 = (n11 - n2) * n3;
        n2 = (short)(n7 - this.mCumulativeOffsetY + n9);
        n7 = n5 - n6;
        n6 = n10 - n6;
        n5 = n11;
        n11 = s2 + n9;
        n10 = n11 + n4;
        do {
            n11 = n8 != 0 && n11 >= n7 && n10 - 1 <= n6 ? 1 : 0;
            this.mBypassClipping = n11;
            n11 = nArray[n5] & 0xFFFF;
            n9 = (nArray[n5] >> 16) - n11 + 1;
            flFont.DrawString(this, flString, (short)(s + DisplayContext.GetAlignmentOffsetX(by, s3, sArray[n5])), (short)n2, sArray[n5], n11, n9);
            n2 = (short)(n2 + n3);
            n11 = n10;
            n10 += n3;
        } while (++n5 < n && n11 <= n6);
        this.mBypassClipping = false;
    }

    public abstract void DrawRectangle(short var1, short var2, short var3, short var4, boolean var5, int var6, int var7, int var8, int var9);

    public final void DrawBitmapSection(FlBitmap flBitmap, short n, short n2, short s, short s2, short n3, short n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        n = (short)(n + this.mCumulativeOffsetX);
        n2 = (short)(n2 + this.mCumulativeOffsetY);
        int n13 = FlDrawPropertyUtil.GetTransform(n5);
        int n14 = n13 == 327680 || n13 == 393216 || n13 == 458752 || n13 == 262144 ? 1 : 0;
        n13 = n14;
        if (n14 != 0) {
            n12 = n;
            n11 = n2;
            n10 = n4;
            n9 = n3;
        } else {
            n12 = n;
            n11 = n2;
            n10 = n3;
            n9 = n4;
        }
        if (!this.mBypassClipping) {
            n8 = this.mClipRect_left;
            n7 = this.mClipRect_top;
            n6 = n8 + this.mClipRect_width;
            n10 = n12 + n10;
            n14 = n7 + this.mClipRect_height;
            n9 = n11 + n9;
            if (n8 > n12) {
                n12 = n8;
            }
            if (n7 > n11) {
                n11 = n7;
            }
            if (n6 < n10) {
                n10 = n6;
            }
            if (n14 < n9) {
                n9 = n14;
            }
            n10 = (short)(n10 - n12);
            n9 = (short)(n9 - n11);
        }
        if (n10 <= 0 || n9 <= 0) {
            return;
        }
        n14 = n12;
        n6 = n11;
        n7 = n10;
        n8 = n9;
        int n15 = FlDrawPropertyUtil.IsFlippedX(n5);
        int n16 = FlDrawPropertyUtil.IsFlippedY(n5);
        if (n13 != 0) {
            n15 = n15 != 0 ? s + (n2 + n3 - (n11 + n9)) : s + (n11 - n2);
            n16 = n16 != 0 ? s2 + (n + n4 - (n14 + n7)) : s2 + (n14 - n);
        } else {
            n15 = n15 != 0 ? s + (n + n3 - (n12 + n10)) : s + (n12 - n);
            n16 = n16 != 0 ? s2 + (n2 + n4 - (n6 + n8)) : s2 + (n6 - n2);
        }
        this.DrawAbsoluteBitmapSection(flBitmap, n14, n6, n15, n16, n7, n8, n5);
    }

    public final void DrawTiledBitmapSection(FlBitmap flBitmap, short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9, short s10, short s11, short s12, int n) {
        int n2;
        boolean bl = FlDrawPropertyUtil.IsFlippedX(n);
        boolean bl2 = FlDrawPropertyUtil.IsFlippedY(n);
        int n3 = this.mCumulativeOffsetX;
        int n4 = this.mCumulativeOffsetY;
        int n5 = s9 + n3;
        int n6 = s10 + n4;
        int n7 = this.mClipRect_left + this.mClipRect_width;
        s11 = (short)(n5 + s11);
        int n8 = this.mClipRect_top + this.mClipRect_height;
        s12 = (short)(n6 + s12);
        if (this.mClipRect_left > n5) {
            n5 = this.mClipRect_left;
        }
        if (this.mClipRect_top > n6) {
            n6 = this.mClipRect_top;
        }
        if (n7 < s11) {
            s11 = (short)n7;
        }
        if (n8 < s12) {
            s12 = (short)n8;
        }
        int n9 = s11 - n5;
        int n10 = s12 - n6;
        if (n9 <= 0 || n10 <= 0) {
            return;
        }
        int n11 = n5 - n3;
        int n12 = n11 + n9;
        int n13 = n2 + n10;
        for (n2 = n6 - n4; n2 < n13; n2 += n7) {
            n8 = (n2 - s10) % s2;
            int n14 = FlMath.Minimum((int)s2, n13 - n2 + n8);
            n7 = n14 - n8;
            n6 = FlMath.Maximum(0, s4 - n8);
            n8 = FlMath.Maximum(0, n8 - s4);
            n5 = FlMath.Minimum((int)s8, n14 - s4);
            n4 = FlMath.Maximum(0, n5 - n8);
            if (bl2) {
                n8 = s8 - n5;
            }
            for (n5 = n11; n5 < n12; n5 += s12) {
                n3 = (n5 - s9) % s;
                int n15 = FlMath.Minimum((int)s, n12 - n5 + n3);
                s12 = (short)(n15 - n3);
                s11 = (short)FlMath.Maximum(0, s3 - n3);
                n3 = FlMath.Maximum(0, n3 - s3);
                n10 = FlMath.Minimum((int)s7, n15 - s3);
                n9 = FlMath.Maximum(0, n10 - n3);
                if (bl) {
                    n3 = s7 - n10;
                }
                this.mBypassClipping = true;
                this.DrawBitmapSection(flBitmap, (short)(n5 + s11), (short)(n2 + n6), (short)(s5 + n3), (short)(s6 + n8), (short)n9, (short)n4, n);
            }
        }
        this.mBypassClipping = false;
    }

    public abstract void DrawAbsoluteBitmapSection(FlBitmap var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public final void OffsetBy(short s, short s2) {
        ForceInline.v();
        this.mCumulativeOffsetX = (short)(this.mCumulativeOffsetX + s);
        this.mCumulativeOffsetY = (short)(this.mCumulativeOffsetY + s2);
    }

    public final short GetClippingRectLeft() {
        return (short)(this.mClipRect_left - this.mCumulativeOffsetX);
    }

    public final short GetClippingRectTop() {
        return (short)(this.mClipRect_top - this.mCumulativeOffsetY);
    }

    public final short GetClippingRectWidth() {
        return this.mClipRect_width;
    }

    public final short GetClippingRectHeight() {
        return this.mClipRect_height;
    }

    public final void SetClippingRect(short s, short s2, short s3, short s4) {
        this.SetAbsoluteClippingRect((short)(s + this.mCumulativeOffsetX), (short)(s2 + this.mCumulativeOffsetY), s3, s4);
    }
}

