/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Color888;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.Memory;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.TimeControlled;

public abstract class Controller
extends TimeControlled {
    public byte mAbsolute;
    public int mControlledValueCode;
    public byte mStartState;
    public byte mCacheState;
    public TimeControlled mControllee;
    public int[] mValueBuffer = new int[12];

    public final short GetCoord2ValueX() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return (short)(nArray[0] + nArray[4]);
        }
        return (short)nArray[0];
    }

    public final short GetCoord2ValueY() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return (short)(nArray[1] + nArray[5]);
        }
        return (short)nArray[1];
    }

    public final int GetLongValue() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return nArray[0] + nArray[4];
        }
        return nArray[0];
    }

    public final boolean GetBoolValue() {
        return (this.GetLongValue() & 1) != 0;
    }

    public final void SetValue(short s, short s2) {
        this.mValueBuffer[4] = s;
        this.mValueBuffer[5] = s2;
    }

    public final void SetValue(short s, short s2, short s3, short s4) {
        Object object = ((Controller)object).mValueBuffer;
        object[4] = s;
        object[5] = s2;
        object[6] = s3;
        object[7] = s4;
    }

    public final void SetValue(boolean bl) {
        Object object = ((Controller)object).mValueBuffer;
        bl = bl;
        object[4] = bl;
    }

    public final void GetControlledValue(int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.mValueBuffer[i];
            if (this.mAbsolute == 0) continue;
            nArray[i] = nArray[i] + this.mValueBuffer[4 + i];
        }
    }

    public final void SetRequestedValue(int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            this.mValueBuffer[4 + i] = nArray[i];
        }
    }

    public final void Refresh() {
        this.mCacheState = 0;
    }

    public final void SetControlParameters(TimeControlled timeControlled, int n) {
        this.mControllee = timeControlled;
        this.mControlledValueCode = n;
        this.mStartState = 0;
        this.mCacheState = 0;
    }

    public abstract void OnTime(int var1, int var2);

    public final void SetControllee(TimeControlled timeControlled) {
        this.SetControlParameters(timeControlled, this.mControlledValueCode);
    }

    public final void DefaultOnTime$255f295() {
        if (this.mControllee == null) {
            return;
        }
        if (this.mStartState == 0) {
            this.GetCurrentValue();
            this.mStartState = 1;
        }
        if (this.NeedsUpdate()) {
            this.mControllee.ControlValue(this.mControlledValueCode, true, this);
            this.UpdateCache();
        }
    }

    public final void GetCurrentValue() {
        this.mControllee.ControlValue(this.mControlledValueCode, false, this);
    }

    public final void SetIsAbsolute(boolean bl) {
        boolean bl2 = this.mAbsolute == 0;
        if (bl != bl2) {
            bl2 = !bl;
            this.mAbsolute = (byte)(bl2 ? 1 : 0);
            this.mStartState = 0;
        }
    }

    public final boolean NeedsUpdate() {
        if (this.mCacheState == 0) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.mValueBuffer[8 + i] == this.mValueBuffer[i]) continue;
            return true;
        }
        return false;
    }

    public final void UpdateCache() {
        this.CopyValue(8, 0);
        this.mCacheState = 1;
    }

    public final void CopyValue(int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            this.mValueBuffer[n + i] = this.mValueBuffer[n2 + i];
        }
    }

    public final void SetValue(short[] sArray) {
        Object object = ((Controller)object).mValueBuffer;
        object[4] = Color888.GetRed_(sArray);
        object[5] = Color888.GetGreen_(sArray);
        object[6] = Color888.GetBlue_(sArray);
    }

    public final short[] GetColorValue() {
        int[] nArray = this.mValueBuffer;
        short[] sArray = Color888.c_init_();
        if (this.mAbsolute != 0) {
            Color888.SetRed_i(Memory.MakeUnsignedByte((byte)(nArray[0] + nArray[4])), sArray);
            Color888.SetGreen_i(Memory.MakeUnsignedByte((byte)(nArray[1] + nArray[5])), sArray);
            Color888.SetBlue_i(Memory.MakeUnsignedByte((byte)(nArray[2] + nArray[6])), sArray);
        } else {
            Color888.SetRed_i(Memory.MakeUnsignedByte((byte)nArray[0]), sArray);
            Color888.SetGreen_i(Memory.MakeUnsignedByte((byte)nArray[1]), sArray);
            Color888.SetBlue_i(Memory.MakeUnsignedByte((byte)nArray[2]), sArray);
        }
        return sArray;
    }

    public void OnSerialize(Package package_) {
        this.mControllee = TimeControlled.Cast$544b2c47(package_.SerializePointer((byte)0, true, false));
        this.mControlledValueCode = package_.SerializeIntrinsic$134621();
        this.SetIsAbsolute(package_.SerializeIntrinsic$138603());
    }

    public final short[] GetRectValue() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return FlRect.c_init_ssss((short)(nArray[0] + nArray[4]), (short)(nArray[1] + nArray[5]), (short)(nArray[2] + nArray[6]), (short)(nArray[3] + nArray[7]));
        }
        return FlRect.c_init_ssss((short)nArray[0], (short)nArray[1], (short)nArray[2], (short)nArray[3]);
    }
}

