/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Controller;
import ca.jamdat.flight.DisplayContext;
import ca.jamdat.flight.DisplayManager;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.TimeControlled;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public abstract class Component
extends TimeControlled {
    public short mRect_width;
    public Component m_pPreviousSibling;
    public Viewport m_pViewport;
    public boolean mPassThrough = true;
    public short mRect_left;
    public boolean mVisible = true;
    public short mRect_top;
    public short mRect_height;

    public Component GetHitTestComponent(short s, short s2) {
        if (!this.IsPassThrough() && this.mVisible && this.HitTest(s, s2)) {
            return this;
        }
        return null;
    }

    public static Component Cast$202d8de5(Object object) {
        return (Component)object;
    }

    public final void SetViewport(Viewport viewport) {
        Viewport viewport2 = this.m_pViewport;
        if (viewport2 != null) {
            this.UpdateAttach(false);
            viewport2.RemoveChild(this);
        }
        this.m_pViewport = viewport;
        if (viewport != null) {
            viewport.AddChild(this);
            this.UpdateAttach(true);
        }
    }

    public final void TakeFocus() {
        FlApplication.GetInstance().SetCurrentFocus(this);
    }

    public final void OnFocusChange(boolean bl) {
        bl = bl;
        this.SendMsg(this, -128, bl ? 1 : 0);
    }

    public Component ForwardFocus() {
        return this;
    }

    public final boolean DescendentOrSelfHasFocus() {
        return this.IsSelfOrAncestorOf(FlApplication.GetInstance().mComponentWithFocus);
    }

    public final boolean IsSelfOrAncestorOf(Component component) {
        while (component != null) {
            if (component == this) {
                return true;
            }
            component = component.m_pViewport;
        }
        return false;
    }

    public final int GetDepth() {
        int n = 0;
        do {
            ++n;
        } while ((this = this.m_pViewport) != null);
        return n;
    }

    public final void SendMsg(Component component, int n, int n2) {
        do {
            if (this.OnMsg(component, n, n2)) {
                return;
            }
            if (!this.OnDefaultMsg(component, n, n2)) continue;
            return;
        } while ((this = this.m_pViewport) != null);
    }

    public boolean OnMsg(Component component, int n, int n2) {
        return false;
    }

    public boolean OnDefaultMsg(Component component, int n, int n2) {
        return false;
    }

    public final void SetRect(short s, short s2, short s3, short s4) {
        this.Invalidate();
        this.mRect_left = s;
        this.mRect_top = s2;
        this.mRect_width = s3;
        this.mRect_height = s4;
        this.OnRectChange();
        this.Invalidate();
    }

    public final void SetTopLeft(short s, short s2) {
        this.Invalidate();
        this.mRect_left = s;
        this.mRect_top = s2;
        this.OnRectChange();
        this.Invalidate();
    }

    public final short GetAbsoluteTop() {
        Viewport viewport = this.m_pViewport;
        if (viewport == null) {
            return this.mRect_top;
        }
        return (short)(this.mRect_top + viewport.GetAbsoluteTop() - viewport.mOffsetY);
    }

    public final short GetAbsoluteLeft() {
        Viewport viewport = this.m_pViewport;
        if (viewport == null) {
            return this.mRect_left;
        }
        return (short)(this.mRect_left + viewport.GetAbsoluteLeft() - viewport.mOffsetX);
    }

    public final short GetBottom() {
        return (short)(this.mRect_top + this.mRect_height - 1);
    }

    public final short GetRight() {
        return (short)(this.mRect_left + this.mRect_width - 1);
    }

    public final void SetSize(short s, short s2) {
        this.Invalidate();
        this.mRect_width = s;
        this.mRect_height = s2;
        this.OnRectChange();
        this.Invalidate();
    }

    public final void SetVisible(boolean bl) {
        if (this.mVisible != bl) {
            this.Invalidate();
            this.mVisible = bl;
            this.OnVisibilityChange();
            this.Invalidate();
        }
    }

    public final void BringToFront() {
        this.m_pViewport.BringComponentToFront(this);
        this.Invalidate();
    }

    public final void SendToBack() {
        this.m_pViewport.SendComponentToBack(this);
        this.Invalidate();
    }

    public final boolean IsAttached() {
        Component component;
        do {
            component = this;
        } while ((this = this.m_pViewport) != null);
        return component == FlApplication.GetInstance();
    }

    public void OnAttach(boolean bl) {
        if (!bl) {
            FlApplication flApplication = FlApplication.GetInstance();
            if (flApplication.mComponentWithFocus == this) {
                flApplication.TakeFocus();
            }
        }
    }

    public final void Invalidate() {
        if (this.mVisible) {
            DisplayManager.GetMainDisplayContext().AddDirtyComponent(this);
        }
    }

    public abstract void OnDraw(DisplayContext var1);

    public final boolean IsPassThrough() {
        return this.mPassThrough;
    }

    public void OnSerialize(Package package_) {
        this.mRect_left = package_.SerializeIntrinsic$136bb5();
        this.mRect_top = package_.SerializeIntrinsic$136bb5();
        this.mRect_width = package_.SerializeIntrinsic$136bb5();
        this.mRect_height = package_.SerializeIntrinsic$136bb5();
        byte by = package_.SerializeIntrinsic$132bd3();
        boolean bl = (by & 1) != 0;
        this.mVisible = bl;
        bl = (by & 2) != 0;
        this.mPassThrough = bl;
    }

    public void ControlValue(int n, boolean bl, Controller controller) {
        if (bl) {
            short s = 0;
            short s2 = 0;
            if (n == 1 || n == 2 || n == 3) {
                s = controller.GetCoord2ValueX();
                s2 = controller.GetCoord2ValueY();
            }
            switch (n) {
                case 1: {
                    this.SetTopLeft(s, s2);
                    return;
                }
                case 2: {
                    this.SetSize(s, s2);
                    return;
                }
                case 3: {
                    this.SetRect((short)(this.mRect_left + (this.mRect_width >> 1) - (s >> 1)), (short)(this.mRect_top + (this.mRect_height >> 1) - (s2 >> 1)), s, s2);
                    return;
                }
                case 4: {
                    short[] sArray = controller.GetRectValue();
                    this.SetRect(FlRect.GetLeft_(sArray), FlRect.GetTop_(sArray), FlRect.GetWidth_(sArray), FlRect.GetHeight_(sArray));
                    return;
                }
                case 5: {
                    this.SetVisible(controller.GetBoolValue());
                    return;
                }
            }
        } else {
            switch (n) {
                case 1: {
                    controller.SetValue(this.mRect_left, this.mRect_top);
                    return;
                }
                case 2: 
                case 3: {
                    controller.SetValue(this.mRect_width, this.mRect_height);
                    return;
                }
                case 4: {
                    controller.SetValue(this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height);
                    return;
                }
                case 5: {
                    controller.SetValue(this.mVisible);
                    return;
                }
            }
        }
        super.ControlValue(n, bl, controller);
    }

    public static void ReleasePen() {
        FrameworkGlobals.GetInstance().penTracker = FrameworkGlobals.GetInstance().application;
    }

    public final boolean HitTest(short s, short s2) {
        return FlRect.Contains(this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height, s, s2);
    }

    public void OnVisibilityChange() {
    }

    public void OnRectChange() {
    }

    public final void UpdateAttach(boolean bl) {
        if (this.IsAttached()) {
            this.Invalidate();
            this.OnAttach(bl);
        }
    }

    public final short[] GetSize() {
        return Vector2_short.c_init_ss(this.mRect_width, this.mRect_height);
    }

    public final short[] GetTopLeft() {
        return Vector2_short.c_init_ss(this.mRect_left, this.mRect_top);
    }

    public final short[] GetAbsoluteTopLeft() {
        return Vector2_short.c_init_ss(this.GetAbsoluteLeft(), this.GetAbsoluteTop());
    }
}

