/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.AboutMenu;
import ca.jamdat.flight.AchievementsMenu;
import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.BaseVerticalScrollerMenu;
import ca.jamdat.flight.BiographiesMenu;
import ca.jamdat.flight.BiographyMenu;
import ca.jamdat.flight.CrimeScene;
import ca.jamdat.flight.EASplash;
import ca.jamdat.flight.EnableSoundMenu;
import ca.jamdat.flight.ExtraMenu;
import ca.jamdat.flight.FileScene;
import ca.jamdat.flight.FlBrowser;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameSplash;
import ca.jamdat.flight.HelpMenu;
import ca.jamdat.flight.LanguageManager;
import ca.jamdat.flight.LanguageMenu;
import ca.jamdat.flight.MainMenu;
import ca.jamdat.flight.MessageMenu;
import ca.jamdat.flight.MoreGames15;
import ca.jamdat.flight.MoreGames15ProductsMenu;
import ca.jamdat.flight.OptionsMenu;
import ca.jamdat.flight.PauseMenu;
import ca.jamdat.flight.PromptMenu;
import ca.jamdat.flight.PublishScene;
import ca.jamdat.flight.RTActionScene;
import ca.jamdat.flight.ScenarioLoadingScene;
import ca.jamdat.flight.ScenarioProcess;
import ca.jamdat.flight.ScenarioSelectMenu;
import ca.jamdat.flight.SceneStack;
import ca.jamdat.flight.SceneTransitionController;
import ca.jamdat.flight.Settings;
import ca.jamdat.flight.StatisticsMenu;
import ca.jamdat.flight.SuspicionsScene;

public class CommandHandler {
    public SceneTransitionController mSceneTransitionController;
    public SceneStack mSceneStack;

    public final boolean ExecuteApplicationCommand(int n) {
        GameApp gameApp = GameApp.Get();
        Settings settings = gameApp.GetSettings();
        boolean bl = true;
        switch (n) {
            case 6: {
                CommandHandler.HandleQuitScenario();
                this.Execute(-47);
                this.Execute(-11);
                break;
            }
            case -64: {
                this.HandleSaveGame();
                break;
            }
            case 93: {
                GameApp.Get().GetScenarioProcess().Step(8);
                this.Execute(4);
                break;
            }
            case -63: {
                gameApp.GetScenarioProcess().Step(0);
                this.Execute(4);
                break;
            }
            case -65: {
                gameApp.GetScenarioProcess().Step(1);
                this.Execute(4);
                break;
            }
            case -66: {
                gameApp.Reset();
                this.Execute(-73);
                break;
            }
            case -59: {
                gameApp.Quit();
                break;
            }
            case 54: {
                GameApp.Get().GetScenarioProcess().Step(3);
                this.Execute(-73);
                break;
            }
            case -81: {
                if (gameApp.GetScenarioProcess().HasValidScenarioId()) {
                    this.Execute(-32);
                    break;
                }
                gameApp.GetScenarioProcess().Step(0);
                this.Execute(4);
                break;
            }
            case -48: {
                Settings.SetSoundEnabled(true);
                break;
            }
            case -49: {
                Settings.SetSoundEnabled(false);
                break;
            }
            case -55: {
                Settings.SetVibrationEnabled(true);
                break;
            }
            case -56: {
                Settings.SetVibrationEnabled(false);
                break;
            }
            case -57: {
                settings.mIsGameTipsEnabled = true;
                break;
            }
            case -58: {
                settings.mIsGameTipsEnabled = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean Execute(int n) {
        return this.ExecuteImpl(n);
    }

    public final boolean ExecuteNavigationCommand(int n) {
        boolean bl = true;
        Object object = this.mSceneStack;
        switch (n) {
            case -60: {
                this.PopAndLaunchScene();
                break;
            }
            case -47: {
                ((SceneStack)object).PopAll();
                break;
            }
            case -73: {
                ((SceneStack)object).PopAll();
                this.PushAndLaunchScene(this.CreateScene(-11));
                break;
            }
            case -74: {
                this.PushBootSequenceScenesAndLaunch();
                break;
            }
            case -75: {
                this.PopAndLaunchScene();
                break;
            }
            case -72: {
                this.ReloadCurrentScene();
                break;
            }
            default: {
                object = this.CreateScene(n);
                if (object != null) {
                    this.PushAndLaunchScene((BaseScene)object);
                    break;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean ExecuteInterruptionCommand(int n) {
        boolean bl = true;
        SceneStack sceneStack = this.mSceneStack;
        if (n == -61) {
            CommandHandler.SuspendScene(sceneStack.GetTop());
            if (CommandHandler.PushPauseMenuAfterGameScene()) {
                this.LaunchScene(sceneStack.GetTop());
            }
        } else if (n == -62) {
            CommandHandler.ResumeScene(sceneStack.GetTop());
        } else {
            bl = false;
        }
        return bl;
    }

    public final BaseScene CreateScene(int n) {
        BaseScene baseScene = null;
        ScenarioProcess scenarioProcess = GameApp.Get().GetScenarioProcess();
        switch (n) {
            case -10: {
                baseScene = new GameSplash(3, 2293830, 24562);
                break;
            }
            case -11: {
                baseScene = new MainMenu(8, 2654289);
                break;
            }
            case -12: {
                this.mSceneStack.Push(new MainMenu(8, 2654289));
                scenarioProcess.Step(0);
                baseScene = new ScenarioSelectMenu(scenarioProcess.mMediator);
                break;
            }
            case -29: {
                baseScene = new AboutMenu(9, 2392137);
                break;
            }
            case -28: {
                baseScene = new BaseVerticalScrollerMenu(10, 2457675);
                break;
            }
            case -27: {
                baseScene = new BaseVerticalScrollerMenu(11, 2424906);
                break;
            }
            case -26: {
                baseScene = new HelpMenu(17, 2621520);
                break;
            }
            case -16: {
                baseScene = new ExtraMenu(12, 2588751);
                break;
            }
            case -17: {
                baseScene = new BiographiesMenu(13, 2555982);
                break;
            }
            case -18: {
                baseScene = new BiographyMenu(14, 2523213, 0);
                break;
            }
            case -20: {
                baseScene = new BiographyMenu(14, 2523213, 2);
                break;
            }
            case -19: {
                baseScene = new BiographyMenu(14, 2523213, 1);
                break;
            }
            case -21: {
                baseScene = new BiographyMenu(14, 2523213, 3);
                break;
            }
            case -22: {
                baseScene = new BiographyMenu(14, 2523213, 4);
                break;
            }
            case -23: {
                baseScene = new BiographyMenu(14, 2523213, 5);
                break;
            }
            case -25: {
                baseScene = new AchievementsMenu(15, 2490444);
                break;
            }
            case -24: {
                baseScene = new StatisticsMenu(16, 2883672);
                break;
            }
            case -15: {
                baseScene = new OptionsMenu(18, 2687058);
                break;
            }
            case -14: {
                this.Execute(-47);
                baseScene = new PauseMenu(20, 2752596);
                break;
            }
            case -13: {
                this.Execute(-47);
                baseScene = new RTActionScene();
                break;
            }
            case 2: {
                this.Execute(-47);
                baseScene = new PublishScene();
                break;
            }
            case 1: {
                baseScene = new ScenarioLoadingScene();
                break;
            }
            case 18: {
                baseScene = new CrimeScene();
                break;
            }
            case 22: {
                this.mSceneStack.Pop();
                baseScene = this.CreateScene(18);
                break;
            }
            case 19: {
                baseScene = new FileScene();
                break;
            }
            case 23: {
                this.mSceneStack.Pop();
                baseScene = this.CreateScene(19);
                break;
            }
            case 20: {
                baseScene = new SuspicionsScene();
                break;
            }
            case 24: {
                this.mSceneStack.Pop();
                baseScene = this.CreateScene(20);
                break;
            }
            case -30: {
                baseScene = new PromptMenu(25, 2785365, -59, -60, 7);
                break;
            }
            case -31: {
                baseScene = new PromptMenu(26, 2785365, 6, -60, 8);
                break;
            }
            case -32: {
                baseScene = new PromptMenu(27, 2785365, -65, -63, 9);
                break;
            }
            case -43: {
                baseScene = new PromptMenu(28, 2785365, -66, -60, 10);
                break;
            }
            case -4: {
                baseScene = new EASplash(2, 2326599, 6000);
                break;
            }
            case -6: {
                baseScene = new LanguageMenu(6, 2359368);
                break;
            }
            case -7: {
                baseScene = new LanguageMenu(19, 2359368);
                break;
            }
            case -9: {
                baseScene = new EnableSoundMenu(5, 2719827, -48, 11, -49, 12, 3, 14);
                break;
            }
            case 4: {
                this.Execute(-47);
                baseScene = GameApp.Get().GetScenarioProcess().GetNextScene();
            }
        }
        if (baseScene == null) {
            baseScene = this.CreateMoreGamesScene(n);
        }
        return baseScene;
    }

    public final void PushAndLaunchScene(BaseScene baseScene) {
        this.mSceneStack.Push(baseScene);
        this.LaunchScene(baseScene);
    }

    public final void PopAndLaunchScene() {
        SceneStack sceneStack = this.mSceneStack;
        sceneStack.Pop();
        BaseScene baseScene = sceneStack.GetTop();
        if (baseScene != null) {
            this.LaunchScene(baseScene);
        }
    }

    public final void LaunchScene(BaseScene baseScene) {
        this.mSceneTransitionController.EnqueueTransition(baseScene);
    }

    public final void ReloadCurrentScene() {
        BaseScene baseScene = this.mSceneStack.GetTop();
        if (baseScene != null && baseScene.mId != 36) {
            this.mSceneTransitionController.EnqueueTransition(baseScene);
        }
    }

    public static void SuspendScene(BaseScene baseScene) {
        if (baseScene != null) {
            baseScene.Suspend();
        }
    }

    public static void ResumeScene(BaseScene baseScene) {
        if (baseScene != null) {
            baseScene.Resume();
        }
    }

    public static boolean PushPauseMenuAfterGameScene() {
        return false;
    }

    public final boolean PushBootSequenceScenesAndLaunch() {
        int[] nArray = new int[]{-11, -10, -4, -9, -6, 0};
        int n = 0;
        while (nArray[n] != 0) {
            Object object;
            if (nArray[n] != -6 || ((LanguageManager)(object = GameApp.Get().GetLanguageManager())).QueryLanguage() == 2 && ((LanguageManager)object).mUserSelectedLanguage == 2) {
                object = this.CreateScene(nArray[n]);
                this.mSceneStack.Push((BaseScene)object);
            }
            ++n;
        }
        this.LaunchScene(this.mSceneStack.GetTop());
        return true;
    }

    public final BaseScene CreateMoreGamesScene(int n) {
        BaseScene baseScene = null;
        MoreGames15 moreGames15 = GameApp.Get().GetMoreGames();
        if (n == -34) {
            baseScene = new MessageMenu(21, 2719827, 11, 12, 0, 4, -60, 1);
        } else if (n == -38 || n == -39) {
            int n2 = -40;
            if (n == -39) {
                n2 = -41;
            }
            baseScene = new PromptMenu(23, 2785365, n2, -60, 14);
        } else if (n == -35) {
            baseScene = new MoreGames15ProductsMenu(22, 5308578);
        } else if (n == -33) {
            baseScene = this.CreateMoreGamesScene(-35);
        } else if (n == -40 || n == -41) {
            boolean bl = MoreGames15.IsWapBrowserExitApp();
            FlString flString = new FlString();
            if (n == -40) {
                flString.Assign(MoreGames15.GetBuyUriAttributeName(moreGames15.mSelectedProductId));
            } else {
                flString.Assign(MoreGames15.GetCatUriAttributeName(moreGames15.mSelectedProductId));
            }
            if (FlBrowser.LaunchWAP_FlStringb(flString, bl, FlBrowser.GetInstance())) {
                GameApp.Get().GetMediaPlayer().StopMusic();
            } else {
                baseScene = this.CreateScene(-73);
            }
        }
        return baseScene;
    }

    public static void HandleQuitScenario() {
        GameApp.Get().GetScenarioProcess().QuitScenario();
    }

    public final void HandleSaveGame() {
        BaseScene baseScene = ((CommandHandler)((Object)baseScene)).mSceneStack.GetTop();
        if (baseScene != null) {
            baseScene.SerializeObjects();
        }
    }

    public final void Initialize(SceneTransitionController sceneTransitionController, SceneStack sceneStack) {
        this.mSceneTransitionController = sceneTransitionController;
        this.mSceneStack = sceneStack;
    }

    public final boolean ExecuteImpl(int n) {
        boolean bl = this.ExecuteInterruptionCommand(n);
        if (!bl) {
            bl = this.ExecuteNavigationCommand(n);
        }
        if (!bl) {
            bl = this.ExecuteApplicationCommand(n);
        }
        return bl;
    }
}

