/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.CO_Room;
import ca.jamdat.flight.ClueMemento;
import ca.jamdat.flight.ClueParser;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlBitmapMap;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.IndexedSprite;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.SA_Array_CO_Item;
import ca.jamdat.flight.SA_Array_CO_Room;
import ca.jamdat.flight.Scroller;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public final class ClueUtils {
    private static FlString GetStringForWeapon(int n, boolean bl) {
        return ClueUtils.GetGameString(ClueUtils.GetWeaponStringEntryPoint(n, bl));
    }

    public static FlString GetStringForGameTip(int n, int n2) {
        return ClueUtils.GetGameString(ClueUtils.GetGameTipEntryPoint(n, n2));
    }

    private static FlString GetStringForMemento(int n) {
        return ClueUtils.GetGameString(ClueUtils.GetMementoEntryPoint(n));
    }

    public static FlString GetStringFromMemento(ClueMemento clueMemento) {
        FlString flString = StringUtils.CreateStringPtr("");
        flString.AddAssign(ClueUtils.GetStringForMemento(clueMemento.GetType()));
        switch (clueMemento.GetType()) {
            case 0: 
            case 1: 
            case 3: {
                ClueUtils.ReplaceSuspectIDInString(flString, new FlString(FlString.FromChar((byte)-74)), clueMemento.GetFirstSuspectId());
                break;
            }
            case 2: {
                ClueUtils.ReplaceItemIDInString(flString, clueMemento.GetItemId());
                break;
            }
            case 4: {
                ClueUtils.ReplaceSuspectIDInString(flString, new FlString(FlString.FromChar((byte)-74)), clueMemento.GetFirstSuspectId());
                ClueUtils.ReplaceSuspectIDInString(flString, new FlString(FlString.FromChar((byte)-73)), clueMemento.GetSecondSuspectId());
            }
        }
        return flString;
    }

    public static FlString GetStringForRoomItems(int n) {
        return ClueUtils.GetGameString(ClueUtils.GetRoomItemsStringEntryPoint(n));
    }

    public static void ReplaceItemIDInString(FlString flString, int n) {
        FlString flString2 = new FlString(FlString.FromChar((byte)-77));
        flString.ReplaceStringAt(flString.FindSubstring(flString2), ClueUtils.GetStringForItem(n), flString2.GetLength());
    }

    public static void ReplaceAllSuspectIDInString(FlString flString, int n) {
        while (ClueUtils.ReplaceSuspectIDInString(flString, n)) {
        }
    }

    public static void ReplaceAllWeaponIDInString(FlString flString, int n) {
        while (ClueUtils.ReplaceWeaponIDInString(flString, n)) {
        }
    }

    public static void ReplaceAllRoomIDInString(FlString flString, int n) {
        while (ClueUtils.ReplaceRoomIDInString(flString, n)) {
        }
    }

    public static void ReplaceAllElementIDInStringIntoSuspect(FlString flString, int n) {
        while (ClueUtils.ReplaceElementIDInStringIntoSuspect(flString, n)) {
        }
    }

    public static void ReplaceAllElementIDInStringIntoWeapon(FlString flString, int n) {
        while (ClueUtils.ReplaceElementIDInStringIntoWeapon(flString, n)) {
        }
    }

    public static void ReplaceAllNumbersInStringIntoDigits(FlString flString, int n) {
        while (ClueUtils.ReplaceNumbersInStringIntoDigits(flString, n)) {
        }
    }

    public static boolean ReplaceClueGiverInString(FlString flString, int n) {
        FlString flString2 = new FlString(StringUtils.CreateString(ClueUtils.GetStringForSuspect(n)));
        flString2.AddAssign(StringUtils.CreateString(": "));
        n = flString.FindSubstring(flString2);
        if (n != -1) {
            flString.ReplaceStringAt(n, new FlString(StringUtils.CreateString("")), flString2.GetLength());
        }
        return n != -1;
    }

    public static boolean ReplaceJobTitleStringInString(FlString flString, FlString flString2) {
        return ClueUtils.StringReplacer(flString, new FlString(FlString.FromChar((byte)-78)), flString2);
    }

    public static FlString GetCommonString(int n) {
        MetaPackage metaPackage = GameLibrary.GetPackage(-2135195485);
        FlString flString = FlString.Cast$50263e8f(metaPackage.mPackage.GetEntryPoint(n));
        GameLibrary.ReleasePackage(metaPackage);
        return flString;
    }

    private static FlString GetMenuString(int n) {
        MetaPackage metaPackage = GameLibrary.GetPackage(-2134998876);
        FlString flString = FlString.Cast$50263e8f(metaPackage.mPackage.GetEntryPoint(n));
        GameLibrary.ReleasePackage(metaPackage);
        return flString;
    }

    public static FlString GetGameString(int n) {
        MetaPackage metaPackage = GameLibrary.GetPackage(-2134802267);
        FlString flString = FlString.Cast$50263e8f(metaPackage.mPackage.GetEntryPoint(n));
        GameLibrary.ReleasePackage(metaPackage);
        return flString;
    }

    public static FlString GetScenarioString(int n) {
        MetaPackage metaPackage = GameApp.Get().GetScenarioProcess().GetStringPackage();
        FlString flString = FlString.Cast$50263e8f(metaPackage.mPackage.GetEntryPoint(n));
        GameLibrary.ReleasePackage(metaPackage);
        return flString;
    }

    public static int GetCharacterPackageID(int n, int n2) {
        int n3 = 182;
        switch (n) {
            case 3: {
                if (n2 == 1) {
                    n3 = 819225;
                    break;
                }
                n3 = 688149;
                break;
            }
            case 4: {
                if (n2 == 1) {
                    n3 = 851994;
                    break;
                }
                n3 = 720918;
                break;
            }
            case 0: {
                if (n2 == 1) {
                    n3 = 884763;
                    break;
                }
                n3 = 589842;
                break;
            }
            case 5: {
                if (n2 == 1) {
                    n3 = 917532;
                    break;
                }
                n3 = 753687;
                break;
            }
            case 1: {
                if (n2 == 1) {
                    n3 = 950301;
                    break;
                }
                n3 = 622611;
                break;
            }
            case 2: {
                n3 = n2 == 1 ? 983070 : 655380;
            }
        }
        return n3;
    }

    public static int GetRoomGraphicPackageID(int n) {
        int n2 = 182;
        switch (n) {
            case 1: {
                n2 = 1179684;
                break;
            }
            case 2: {
                n2 = 1245222;
                break;
            }
            case 4: {
                n2 = 1376298;
                break;
            }
            case 6: {
                n2 = 1507374;
                break;
            }
            case 0: {
                n2 = 0x110022;
                break;
            }
            case 3: {
                n2 = 1310760;
                break;
            }
            case 7: {
                n2 = 1572912;
                break;
            }
            case 5: {
                n2 = 1441836;
            }
        }
        return n2;
    }

    public static int GetWeaponPackageID(int n) {
        int n2 = 182;
        switch (n) {
            case 0: {
                n2 = 1671219;
                break;
            }
            case 3: {
                n2 = 1703988;
                break;
            }
            case 5: {
                n2 = 1736757;
                break;
            }
            case 8: {
                n2 = 1769526;
                break;
            }
            case 1: {
                n2 = 1802295;
                break;
            }
            case 6: {
                n2 = 1835064;
                break;
            }
            case 2: {
                n2 = 1867833;
                break;
            }
            case 4: {
                n2 = 1933371;
                break;
            }
            case 7: {
                n2 = 1900602;
            }
        }
        return n2;
    }

    private static boolean StringReplacer(FlString flString, FlString flString2, FlString flString3) {
        int n = flString.FindSubstring(flString2);
        if (n != -1) {
            flString.ReplaceStringAt(n, flString3, flString2.GetLength());
        }
        return n != -1;
    }

    public static void AddGossip(int n, int n2) {
        GameApp.Get().GetScenarioContext().mClueInfo.AddClue(n, n2 + 1);
    }

    public static int GetStarsFromOutcome(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 4;
            }
        }
        return n2;
    }

    public static FlString GetStringNumberOfStars(int n) {
        FlString flString = new FlString(ClueUtils.GetGameString(128));
        FlString flString2 = new FlString(FlString.FromChar((byte)-72));
        FlString flString3 = new FlString(StringUtils.CreateString(""));
        flString3.Assign(n);
        ClueUtils.StringReplacer(flString, flString2, flString3);
        return flString;
    }

    public static void UpdateTab(Viewport viewport, int n, int n2, FlBitmapMap flBitmapMap) {
        ClueUtils.UpdateTabBackgroundAndWidth(viewport, n, n2, flBitmapMap);
    }

    public static void UpdateTabBackground(Viewport viewport, int n, FlBitmapMap flBitmapMap) {
        ClueUtils.UpdateTabBackgroundAndWidth(viewport, 0, n, flBitmapMap);
    }

    public static void UpdateTabWidth(Viewport viewport, int n, int n2) {
        ClueUtils.UpdateTabBackgroundAndWidth(viewport, n, n2);
    }

    public static int GetDialogBoxTypeFrom(int n) {
        int n2 = 8;
        if (n == 0) {
            n2 = 9;
        }
        if (n == 2) {
            n2 = 7;
        }
        if (n == 4) {
            n2 = 10;
        }
        return n2;
    }

    public static FlString GetTutorialControlTip(int n) {
        return ClueUtils.GetGameString(ClueUtils.GetTutorialControlTipEntryPoint(n));
    }

    public static FlString GetTutorialToolTip(int n) {
        return ClueUtils.GetGameString(ClueUtils.GetTutorialToolTipEntryPoint(n));
    }

    private static int GetSuspectStringEntryPoint(int n) {
        if (n == 7) {
            return 28;
        }
        return 22 + n;
    }

    private static int GetSuspectBioStringEntryPoint(int n) {
        return 38 + n;
    }

    private static int GetRoomStringEntryPoint(int n, boolean bl) {
        if (bl) {
            return 34 + n;
        }
        return 26 + n;
    }

    private static int GetItemStringEntryPoint(int n) {
        return 67 + n;
    }

    private static int GetWeaponStringEntryPoint(int n, boolean bl) {
        if (bl) {
            return 192 + n;
        }
        return 183 + n;
    }

    private static int GetGameTipEntryPoint(int n, int n2) {
        int n3 = -1;
        switch (n) {
            case 1: {
                n3 = 64 + n2 - 1;
                break;
            }
            case 2: {
                n3 = 63 + n2 - 1;
                break;
            }
            case 3: {
                n3 = 61 + n2 - 1;
                break;
            }
            case 4: {
                n3 = 60 + n2 - 1;
                break;
            }
            case 5: {
                n3 = 62;
                break;
            }
            case 0: {
                n3 = 59;
            }
        }
        return n3;
    }

    private static int GetMementoEntryPoint(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 91;
                break;
            }
            case 1: {
                n2 = 92;
                break;
            }
            case 2: {
                n2 = 93;
                break;
            }
            case 3: {
                n2 = 94;
                break;
            }
            case 4: {
                n2 = 95;
                break;
            }
            case 5: {
                n2 = 96;
                break;
            }
            case 6: {
                n2 = 97;
            }
        }
        return n2;
    }

    private static boolean ReplaceRoomIDInString(FlString flString, int n) {
        FlString flString2 = new FlString(FlString.FromChar((byte)-81));
        int n2 = flString.FindSubstring(flString2);
        if (n2 != -1) {
            flString.ReplaceStringAt(n2, ClueUtils.GetStringForRoom(n, false), flString2.GetLength());
        } else {
            flString2.Assign(FlString.FromChar((byte)-80));
            n2 = flString.FindSubstring(flString2);
            if (n2 != -1) {
                flString.ReplaceStringAt(n2, ClueUtils.GetStringForRoom(n, true), flString2.GetLength());
            }
        }
        return n2 != -1;
    }

    private static boolean ReplaceSuspectIDInString(FlString flString, int n) {
        FlString flString2 = new FlString(FlString.FromChar((byte)-79));
        int n2 = flString.FindSubstring(flString2);
        if (n2 != -1) {
            flString.ReplaceStringAt(n2, ClueUtils.GetStringForSuspect(n), flString2.GetLength());
        }
        return n2 != -1;
    }

    private static boolean ReplaceSuspectIDInString(FlString flString, FlString flString2, int n) {
        return ClueUtils.StringReplacer(flString, flString2, ClueUtils.GetStringForSuspect(n));
    }

    private static boolean ReplaceWeaponIDInString(FlString flString, int n) {
        FlString flString2 = new FlString(FlString.FromChar((byte)-76));
        int n2 = flString.FindSubstring(flString2);
        if (n2 != -1) {
            flString.ReplaceStringAt(n2, ClueUtils.GetStringForWeapon(n), flString2.GetLength());
        } else {
            flString2.Assign(FlString.FromChar((byte)-70));
            n2 = flString.FindSubstring(flString2);
            if (n2 != -1) {
                flString.ReplaceStringAt(n2, ClueUtils.GetStringForWeapon(n, true), flString2.GetLength());
            }
        }
        return n2 != -1;
    }

    private static boolean ReplaceElementIDInStringIntoSuspect(FlString flString, int n) {
        FlString flString2 = new FlString(FlString.FromChar((byte)-75));
        int n2 = flString.FindSubstring(flString2);
        if (n2 != -1) {
            flString.ReplaceStringAt(n2, ClueUtils.GetStringForSuspect(n), flString2.GetLength());
        }
        return n2 != -1;
    }

    private static boolean ReplaceElementIDInStringIntoWeapon(FlString flString, int n) {
        FlString flString2 = new FlString(FlString.FromChar((byte)-75));
        int n2 = flString.FindSubstring(flString2);
        if (n2 != -1) {
            flString.ReplaceStringAt(n2, ClueUtils.GetStringForWeapon(n, true), flString2.GetLength());
        }
        return n2 != -1;
    }

    private static boolean ReplaceNumbersInStringIntoDigits(FlString flString, int n) {
        FlString flString2 = new FlString(StringUtils.CreateString("[NB]"));
        int n2 = flString.FindSubstring(flString2);
        if (n2 != -1) {
            flString.ReplaceStringAt(n2, new FlString(n), flString2.GetLength());
        }
        return n2 != -1;
    }

    private static void UpdateTabBackgroundAndWidth(Viewport viewport, int n, int n2, FlBitmapMap flBitmapMap) {
        int n3 = n2 + 1;
        IndexedSprite indexedSprite = (IndexedSprite)viewport.GetChild(n2);
        int n4 = n3 + 1;
        IndexedSprite indexedSprite2 = (IndexedSprite)viewport.GetChild(n3);
        int n5 = n4 + 1;
        IndexedSprite indexedSprite3 = (IndexedSprite)viewport.GetChild(n4);
        n4 = n5 + 1;
        IndexedSprite indexedSprite4 = (IndexedSprite)viewport.GetChild(n5);
        IndexedSprite indexedSprite5 = (IndexedSprite)viewport.GetChild(n4);
        IndexedSprite indexedSprite6 = (IndexedSprite)viewport.GetChild(n4 + 1);
        if (n > 0) {
            viewport.SetSize((short)n, Vector2_short.GetY_(viewport.GetSize()));
            indexedSprite.SetSize((short)(n - Vector2_short.GetX_(indexedSprite2.GetSize())), Vector2_short.GetY_(indexedSprite.GetSize()));
            indexedSprite2.SetTopLeft(Vector2_short.GetX_(indexedSprite.GetSize()), Vector2_short.GetY_(indexedSprite2.GetTopLeft()));
            indexedSprite3.SetSize((short)(n - Vector2_short.GetX_(indexedSprite4.GetSize())), Vector2_short.GetY_(indexedSprite3.GetSize()));
            indexedSprite4.SetTopLeft(Vector2_short.GetX_(indexedSprite3.GetSize()), Vector2_short.GetY_(indexedSprite4.GetTopLeft()));
            indexedSprite5.SetSize((short)(n - Vector2_short.GetX_(indexedSprite6.GetSize())), Vector2_short.GetY_(indexedSprite5.GetSize()));
            indexedSprite6.SetTopLeft(Vector2_short.GetX_(indexedSprite5.GetSize()), Vector2_short.GetY_(indexedSprite6.GetTopLeft()));
        }
        if (flBitmapMap != null) {
            indexedSprite.SetBitmapMap(flBitmapMap);
            indexedSprite2.SetBitmapMap(flBitmapMap);
            indexedSprite3.SetBitmapMap(flBitmapMap);
            indexedSprite4.SetBitmapMap(flBitmapMap);
            indexedSprite5.SetBitmapMap(flBitmapMap);
            indexedSprite6.SetBitmapMap(flBitmapMap);
        }
    }

    private static int GetRoomItemsStringEntryPoint(int n) {
        return 100 + n;
    }

    private static int GetTutorialControlTipEntryPoint(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 142;
                break;
            }
            case 1: {
                n2 = 143;
                break;
            }
            case 2: {
                n2 = 144;
                break;
            }
            case 3: {
                n2 = 145;
                break;
            }
            case 4: {
                n2 = 146;
                break;
            }
            case 5: {
                n2 = 147;
                break;
            }
            case 6: {
                n2 = 148;
            }
        }
        return n2;
    }

    private static int GetTutorialToolTipEntryPoint(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 160;
                break;
            }
            case 1: {
                n2 = 161;
                break;
            }
            case 2: {
                n2 = 162;
                break;
            }
            case 3: {
                n2 = 163;
                break;
            }
            case 4: {
                n2 = 164;
                break;
            }
            case 5: {
                n2 = 165;
                break;
            }
            case 6: {
                n2 = 166;
                break;
            }
            case 7: {
                n2 = 167;
                break;
            }
            case 8: {
                n2 = 168;
            }
        }
        return n2;
    }

    public static FlString GetStringForRoom(int n) {
        return ClueUtils.GetStringForRoom(n, false);
    }

    public static FlString GetStringForWeapon(int n) {
        return ClueUtils.GetStringForWeapon(n, false);
    }

    private static void UpdateTabBackgroundAndWidth(Viewport viewport, int n, int n2) {
        ClueUtils.UpdateTabBackgroundAndWidth(viewport, n, n2, null);
    }

    public static void AddClue(int n, int n2) {
        GameApp gameApp = GameApp.Get();
        ClueParser clueParser = gameApp.GetClueParser();
        clueParser.Parse(ClueUtils.GetScenarioString(n2), n);
        while (clueParser.HasNext()) {
            gameApp.GetScenarioContext().mClueInfo.AddClue(clueParser.GetNext(), n2);
        }
    }

    public static boolean Contains(Component component, short[] sArray) {
        short s = Vector2_short.GetX_(sArray);
        short s2 = Vector2_short.GetY_(sArray);
        return component.GetAbsoluteLeft() < s && s < component.GetAbsoluteLeft() + component.mRect_width && component.GetAbsoluteTop() < s2 && s2 < component.GetAbsoluteTop() + component.mRect_height;
    }

    public static boolean ScrollOnDrag(Scroller scroller, Component component, short[] sArray, short[] sArray2) {
        boolean bl = false;
        int n = Vector2_short.GetY_(sArray2) - Vector2_short.GetY_(sArray);
        if (n != 0 && ClueUtils.Contains(component, sArray)) {
            Selection selection = n < 0 ? scroller.mPreviousArrow : scroller.mNextArrow;
            bl = scroller.OnDefaultMsg(selection, -125, 1);
        }
        return bl;
    }

    public static void ShuffleSuspects(SA_Array_CO_Room sA_Array_CO_Room) {
        for (int i = 0; i < sA_Array_CO_Room.Size(); ++i) {
            int n;
            int n2 = sA_Array_CO_Room.Get((int)i).mSuspectId;
            int n3 = FlMath.Rand() % sA_Array_CO_Room.Size();
            CO_Room cO_Room = sA_Array_CO_Room.Get(i);
            cO_Room.mSuspectId = n = sA_Array_CO_Room.Get((int)n3).mSuspectId;
            sA_Array_CO_Room.Get((int)n3).mSuspectId = n2;
        }
    }

    private static void SetAllItemsSearched(SA_Array_CO_Item sA_Array_CO_Item) {
        int n = sA_Array_CO_Item.Size();
        for (int i = 0; i < n; ++i) {
            sA_Array_CO_Item.Get((int)i).mSearched = true;
        }
    }

    public static void SetTutorialControlSettings(SA_Array_CO_Room sA_Array_CO_Room) {
        int n = sA_Array_CO_Room.Size();
        for (int i = 0; i < n; ++i) {
            CO_Room cO_Room = sA_Array_CO_Room.Get(i);
            if (cO_Room.mRoomId == 1) {
                cO_Room.mSuspectId = 1;
                continue;
            }
            if (cO_Room.mRoomId != 3) continue;
            cO_Room.mSuspectId = 3;
        }
    }

    public static void SetTutorialToolSettings(SA_Array_CO_Room sA_Array_CO_Room) {
        int n = sA_Array_CO_Room.Size();
        for (int i = 0; i < n; ++i) {
            CO_Room cO_Room = sA_Array_CO_Room.Get(i);
            ClueUtils.SetAllItemsSearched(cO_Room.mItems);
            if (cO_Room.mRoomId == 1) {
                cO_Room.mSuspectId = 3;
                continue;
            }
            if (cO_Room.mRoomId != 2) continue;
            cO_Room.mSuspectId = 1;
        }
    }

    public static FlString GetStringForSuspect(int n) {
        return ClueUtils.GetCommonString(ClueUtils.GetSuspectStringEntryPoint(n));
    }

    public static FlString GetSuspectStringForParser(int n) {
        return ClueUtils.GetCommonString(ClueUtils.GetSuspectStringEntryPoint(n));
    }

    public static FlString GetStringForSuspectBio(int n) {
        return ClueUtils.GetMenuString(ClueUtils.GetSuspectBioStringEntryPoint(n));
    }

    private static FlString GetStringForRoom(int n, boolean bl) {
        return ClueUtils.GetGameString(ClueUtils.GetRoomStringEntryPoint(n, bl));
    }

    public static FlString GetStringForItem(int n) {
        return ClueUtils.GetGameString(ClueUtils.GetItemStringEntryPoint(n));
    }
}

