/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class BasicModule
implements Variable {
    Random rand = null;
    BRCard brCard = null;
    int Lwidth = 0;
    int Lheight = 0;
    int fontHeight = 0;
    public Font sf;
    DataInputStream mDataInSrm;
    FontCustom customFont;
    int tmpA = 0;
    int lineTextValue = 0;
    int trsLineWidth = 0;
    byte limitLine = 0;

    public BasicModule(int Lwidth, int Lheight) {
        this.rand = new Random();
        this.Lwidth = Lwidth;
        this.Lheight = Lheight;
        this.sf = Font.getFont((int)0, (int)0, (int)8);
        this.fontHeight = this.sf.getHeight();
    }

    public BasicModule(BRCard card) {
        this.brCard = card;
        this.customFont = new FontCustom(card.lcd_width, card.lcd_height);
    }

    public void Draw_Rect(int x, int y, int w, int h, int color, Graphics g) {
        g.setColor(color);
        g.fillRect(x, y, w, h);
    }

    public void dRect(int x, int y, int w, int h, int color, Graphics g) {
        g.setClip(x, y, w + 1, h + 1);
        g.setColor(color);
        g.drawRect(x, y, w, h);
    }

    public Image Create_Image(String filename) {
        try {
            return Image.createImage((String)("/img/" + filename + ".png"));
        }
        catch (Exception e) {
            System.out.println("Create_Image Load Error : " + e);
            return null;
        }
    }

    public int Rand(int min, int max) {
        return (this.rand.nextInt() >>> 1) % (max + 1 - min) + min;
    }

    public void Draw_Clip(Image src, int x, int y, int i, int j, int w, int h, Graphics g) {
        g.setClip(x, y, w, h);
        g.drawImage(src, x - i, y - j, 20);
        g.setClip(0, 0, this.Lwidth, this.Lheight);
    }

    public void Draw_Str(String str, int x, int y, int color, int align, Graphics g) {
        g.setFont(this.sf);
        g.setColor(color);
        g.drawString(str, x, y, align);
    }

    public void Draw_Image(Image src, int x, int y, Graphics g) {
        g.drawImage(src, x, y, 20);
    }

    public short[] ReadMapData(int mapIdx) {
        try {
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("/map/" + mapIdx + ".dat"));
            byte[] lengthData = new byte[4];
            dis.read(lengthData, 0, 4);
            int length = this.byteToInt(lengthData);
            short[] data = new short[length];
            for (int i = 0; i < length; ++i) {
                data[i] = dis.readShort();
            }
            dis.close();
            dis = null;
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(" Map Data Read Error : " + e);
            return null;
        }
    }

    public String ReadTxtData(int idx) {
        String str = null;
        String tmpStr = "";
        try {
            int i;
            if (BRCard.mLangId == 1) {
                this.mDataInSrm = new DataInputStream(this.getClass().getResourceAsStream("/text_en.txt"));
            } else if (BRCard.mLangId == 2) {
                this.mDataInSrm = new DataInputStream(this.getClass().getResourceAsStream("/text_fr.txt"));
            } else if (BRCard.mLangId == 3) {
                this.mDataInSrm = new DataInputStream(this.getClass().getResourceAsStream("/text_es.txt"));
            }
            int dataLength = this.mDataInSrm.available();
            byte[] data = new byte[dataLength];
            int idxPass = 0;
            for (i = 0; i < data.length; ++i) {
                data[i] = this.mDataInSrm.readByte();
            }
            str = new String(data, 0, data.length);
            data = null;
            dataLength = str.length();
            for (i = 0; i < dataLength; ++i) {
                if (str.charAt(i) == '@') {
                    ++idxPass;
                    i += 2;
                    continue;
                }
                if (idxPass == idx) {
                    tmpStr = tmpStr + str.charAt(i);
                    continue;
                }
                if (idxPass > idx) break;
            }
            this.mDataInSrm.close();
            this.mDataInSrm = null;
        }
        catch (Exception e) {
            System.err.println(" TXT Data Read Error : " + e);
        }
        return tmpStr;
    }

    public int Draw_Trs(String str, int pageStart, int x, int y, int Color, Graphics g) {
        g.setColor(Color);
        g.setFont(this.sf);
        byte lineCnt = 0;
        int widthAdd = 0;
        int subSi = pageStart;
        int subEcnt = 0;
        for (int i = pageStart; i < str.length(); ++i) {
            if ((widthAdd += g.getFont().stringWidth(str.substring(i, i + 1))) >= this.trsLineWidth) {
                int n = i;
                for (int j = 1; j < n; ++j) {
                    if (!str.substring(i - j, i - j + 1).equals(" ")) continue;
                    i -= j;
                    n = 1;
                    g.drawSubstring(str, subSi, subEcnt - j, x, y + lineCnt * this.fontHeight, 20);
                    --i;
                    lineCnt = (byte)(lineCnt + 1);
                    if (lineCnt >= this.limitLine) {
                        return i + 1;
                    }
                    subSi = i + 1;
                    subEcnt = 0;
                    widthAdd = 0;
                }
                continue;
            }
            ++subEcnt;
        }
        g.drawSubstring(str, subSi, subEcnt, x, y + lineCnt * this.fontHeight, 20);
        return -99;
    }

    public void xTrsSetting(int width, Graphics g) {
        this.trsLineWidth = width;
        this.lineTextValue = width / g.getFont().stringWidth("\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd");
        this.fontHeight = this.sf.getHeight();
        this.limitLine = this.fontHeight * 4 > 48 ? (byte)3 : (byte)4;
    }

    protected int byteToInt(byte[] buffer) {
        return buffer[0] & 0xFF | buffer[1] << 8 & 0xFF00 | buffer[2] << 16 & 0xFF0000 | buffer[3] << 24 & 0xFF000000;
    }

    protected void Draw_Image_Jh(Graphics g, Image i, int x, int y, int base_point) {
        g.drawImage(i, x, y, base_point);
    }

    public void Draw_Num(Image num_img, byte align, int value, int gap, int x, int y, int w, int h, Graphics g) {
        block6: {
            int catchNum;
            int strLeng;
            String strValue;
            block7: {
                block5: {
                    if (value == -99) {
                        return;
                    }
                    g.setClip(0, 0, this.Lwidth, this.Lheight);
                    strValue = "" + value;
                    strLeng = strValue.length();
                    catchNum = 0;
                    if (align != 3) break block5;
                    for (int i = strLeng - 1; i >= 0; --i) {
                        catchNum = Integer.parseInt(strValue.substring(i, i + 1));
                        this.Draw_Clip(num_img, x - (w * (strLeng - 1 - i) + (strLeng - 1 == i ? 0 : gap++)), y, catchNum * w, 0, w, h, g);
                    }
                    break block6;
                }
                if (align != 2) break block7;
                for (int i = 0; i < strLeng; ++i) {
                    catchNum = Integer.parseInt(strValue.substring(i, i + 1));
                    this.Draw_Clip(num_img, x + (w * i + (i == 0 ? 0 : gap)), y, catchNum * w, 0, w, h, g);
                }
                break block6;
            }
            if (align != 1) break block6;
            int commaCnt = 0;
            int commaAdd = 0;
            for (int i = strLeng - 1; i >= 0; --i) {
                if (commaCnt == 3) {
                    this.Draw_Rect(x - (1 * (strLeng - 1 - i) + (strLeng - 1 == i ? 0 : gap++) + commaAdd) - (10 + commaAdd * 15), y + 7, 1, 1, 0, g);
                    commaCnt = 0;
                    ++commaAdd;
                }
                catchNum = Integer.parseInt(strValue.substring(i, i + 1));
                this.Draw_Clip(num_img, x - (w * (strLeng - 1 - i) + (strLeng - 1 == i ? 0 : gap++) + commaAdd), y, catchNum * w, 0, w, h, g);
                ++commaCnt;
            }
        }
    }
}

