/*
 * Decompiled with CFR 0.152.
 */
package mobi.data;

import mobi.data.RecordId;
import mobi.util.StringVector;

public class Bookmark
implements RecordId {
    private String titleId;
    private String recordId;
    private String name;
    private int recordStoreId;

    public int getRecordStoreId() {
        return this.recordStoreId;
    }

    public Bookmark(byte[] data) {
        this.parse(data);
    }

    private void parse(byte[] data) {
        StringVector stringVector = new StringVector(new String(data));
        this.titleId = stringVector.stringElementAt(0);
        this.recordId = stringVector.stringElementAt(1);
        this.name = stringVector.stringElementAt(2);
        this.recordStoreId = stringVector.intElementAt(3);
    }

    private String processName(String nameIn) {
        StringBuffer buf = new StringBuffer();
        for (int x = 0; x < nameIn.length(); ++x) {
            if (nameIn.charAt(x) == StringVector.getSeparator()) continue;
            buf.append(nameIn.charAt(x));
        }
        return buf.toString();
    }

    public Bookmark(String titleId, String recordId, String name, int recordStoreId) {
        this.titleId = titleId;
        this.recordId = recordId;
        this.name = this.processName(name);
        this.recordStoreId = recordStoreId;
    }

    public String getName() {
        return this.name;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public String getTitleId() {
        return this.titleId;
    }

    public byte[] getData() {
        StringBuffer buffer = new StringBuffer(this.titleId);
        buffer.append(StringVector.getSeparator());
        buffer.append(this.recordId);
        buffer.append(StringVector.getSeparator());
        buffer.append(this.name);
        buffer.append(StringVector.getSeparator());
        buffer.append(this.recordStoreId);
        return buffer.toString().getBytes();
    }
}

