/*
 * Decompiled with CFR 0.152.
 */
package mobi.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import mobi.items.BaseItem;
import mobi.items.RecordData;

public class WrapLine
implements Enumeration {
    private String text;
    private short width;
    private short position;
    private short length;
    private short start = 0;
    private Vector startStylePoint = new Vector();
    private Vector lastStylePoint = new Vector();
    private Vector fontStyle = new Vector();
    private boolean isDetailsStart = false;
    Vector styleVector;
    public static short imageposition = 0;
    Font currentFont = null;
    Font previousFont = null;
    boolean check_next = false;
    short last_point = 0;
    short index = 0;
    short totalPosition = 0;

    public WrapLine(String text, int width) {
        this.text = text;
        this.width = (short)width;
        this.length = (short)text.length();
    }

    public WrapLine(String text, int width, Vector startStylePoint, Vector lastStylePoint, Vector fontStyle) {
        this.text = text;
        this.width = (short)width;
        this.length = (short)text.length();
        this.startStylePoint = startStylePoint;
        this.lastStylePoint = lastStylePoint;
        this.fontStyle = fontStyle;
    }

    public boolean hasMoreElements() {
        return this.position < this.text.length() - 1;
    }

    public Object nextElement() throws NoSuchElementException {
        try {
            short next = this.next();
            String s = this.text.substring(this.start, next);
            this.start = next;
            if (this.text.length() - 1 > this.start && (this.text.charAt(this.start) == ' ' || this.text.charAt(this.start) == '\n')) {
                this.position = (short)(this.position + 1);
                this.start = (short)(this.start + 1);
            }
            this.text = this.text.substring(this.start);
            imageposition = this.totalPosition = (short)(this.totalPosition + this.position);
            this.start = 0;
            this.position = 0;
            return s;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException(e.getMessage());
        }
        catch (Exception e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    private Font getStyle(byte font) {
        Font fontObj = null;
        switch (font) {
            case 1: {
                fontObj = BaseItem.normal;
                break;
            }
            case 2: {
                fontObj = BaseItem.italics;
                break;
            }
            case 3: {
                fontObj = BaseItem.bold;
                break;
            }
            case 4: {
                fontObj = BaseItem.linkUps;
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                fontObj = BaseItem.footnotes;
                break;
            }
        }
        return fontObj;
    }

    public String getEndPosition() {
        return Integer.toString(this.start);
    }

    private short next() {
        int spaceCheck;
        int i;
        int lastBreak = -1;
        int line_width = 0;
        this.styleVector = new Vector();
        boolean next_line = true;
        int startfont = 0;
        for (i = 0; i < this.text.length(); i = (int)((short)(i + 1))) {
            if (this.startStylePoint.indexOf(i + this.totalPosition + "") != -1 || this.check_next) {
                this.index = (short)this.startStylePoint.indexOf(i + this.totalPosition + "");
                if (this.index != -1) {
                    this.check_next = true;
                    this.last_point = this.index;
                    this.currentFont = this.getStyle(Byte.parseByte((String)this.fontStyle.elementAt(this.last_point)));
                    startfont = i;
                } else if (i + this.totalPosition >= Integer.parseInt((String)this.lastStylePoint.elementAt(this.last_point))) {
                    this.check_next = false;
                    startfont = i;
                }
                line_width += this.currentFont.stringWidth(this.text.substring(i, i + 1));
            } else {
                this.currentFont = BaseItem.normal;
                if (RecordData.startFNDetails.indexOf(i + this.totalPosition + "") != -1) {
                    this.isDetailsStart = true;
                    startfont = i;
                }
                line_width += this.currentFont.stringWidth(this.text.substring(i, i + 1));
            }
            if (!this.currentFont.equals(this.previousFont) || this.isDetailsStart) {
                this.setStyleVector(this.currentFont, startfont);
                next_line = false;
            }
            this.previousFont = this.currentFont;
            if (this.text.charAt(i) == ' ' || this.text.charAt(i) == '-' || this.text.charAt(i) == '_' || this.text.charAt(i) == '/' || this.text.charAt(i) == ':' || this.text.charAt(i) == '.' || this.text.charAt(i) == '@') {
                lastBreak = i;
            }
            if (this.text.charAt(i) == '\n') {
                lastBreak = i;
                break;
            }
            if (line_width < this.width - 10) continue;
            if (startfont <= lastBreak) break;
            lastBreak = startfont;
            break;
        }
        this.position = i >= this.text.length() - 1 ? (short)i : (lastBreak < this.position ? (short)i : (lastBreak < i ? ((spaceCheck = this.text.indexOf(" ", lastBreak)) != -1 && this.currentFont.stringWidth(this.text.substring(lastBreak, spaceCheck)) <= this.width - 10 ? lastBreak : (short)(lastBreak + 1)) : lastBreak));
        if (next_line) {
            this.setStyleVector(null, 0);
        }
        return this.position;
    }

    private void setStyleVector(Font currentFont, int startfont) {
        String str = null;
        if (currentFont == null) {
            str = null;
        } else if (this.isDetailsStart) {
            str = "7|" + startfont;
            this.isDetailsStart = false;
        } else if (currentFont.equals(BaseItem.bold)) {
            str = "3|" + startfont;
        } else if (currentFont.equals(BaseItem.normal)) {
            str = "1|" + startfont;
        } else if (currentFont.equals(BaseItem.italics)) {
            str = "2|" + startfont;
        } else if (currentFont.equals(BaseItem.linkUps)) {
            str = "4|" + startfont;
        } else if (currentFont.equals(BaseItem.footnotes)) {
            str = "5|" + startfont;
        }
        this.styleVector.addElement(str);
    }

    public Vector getStyleVector() {
        return this.styleVector;
    }
}

