/*
 * Decompiled with CFR 0.152.
 */
package mobi.items;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import mobi.forms.MidpForm;
import mobi.items.BaseItem;
import mobi.midp.MobiViewer;
import mobi.util.ResourceBundle;
import mobi.util.WrapLine;

public class TextEditor
extends BaseItem {
    private String[] arrLines = null;
    private short[] lineLength = null;
    private static final int XOFFSET = 5;
    private int startLine;
    private byte numOflinesPerPage;
    private StringBuffer carryLine = new StringBuffer();
    public StringBuffer smsText = new StringBuffer();
    private int cursorXPosition = 0;
    private int cursorYPosition = 0;
    private char cursor = (char)124;
    private byte copyFlag = 0;
    private byte copyText = 0;
    private byte direction = 0;
    private int[][] copyPosition = new int[2][2];
    private MidpForm form;

    public TextEditor(String recStringData, MidpForm frm) {
        this.form = frm;
        if (recStringData != null) {
            this.wrap(recStringData);
        }
        this.setScreenTitle(ResourceBundle.get("text_editor"));
        this.numOflinesPerPage = (byte)((height - small.getHeight()) / small.getHeight());
        MobiViewer.appInterrupted = true;
    }

    private void selectTextUp(Graphics g, int YOFFSET, int localY, int i) {
        if (i == this.copyPosition[0][1] && this.cursorYPosition < this.copyPosition[0][1]) {
            String s = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(0, this.copyPosition[0][0]);
            g.drawRect(5, YOFFSET + localY, g.getFont().stringWidth(s), g.getFont().getHeight());
            g.fillRect(5, YOFFSET + localY, g.getFont().stringWidth(s), g.getFont().getHeight());
        } else if (i == this.copyPosition[0][1] && this.cursorYPosition == this.copyPosition[0][1]) {
            String s = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(this.cursorXPosition, this.copyPosition[0][0]);
            String s1 = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(0, this.cursorXPosition);
            g.drawRect(g.getFont().stringWidth(s1) + 5, YOFFSET + localY, g.getFont().stringWidth(s), g.getFont().getHeight());
            g.fillRect(g.getFont().stringWidth(s1) + 5, YOFFSET + localY, g.getFont().stringWidth(s), g.getFont().getHeight());
        } else if (i == this.cursorYPosition) {
            int curPos = this.cursorXPosition >= this.arrLines[i].length() ? this.arrLines[i].length() - 1 : this.cursorXPosition;
            String s = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(curPos, this.arrLines[i].length());
            String s1 = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(0, curPos);
            g.drawRect(g.getFont().stringWidth(s1) + 5, YOFFSET + localY, g.getFont().stringWidth(s), g.getFont().getHeight());
            g.fillRect(g.getFont().stringWidth(s1) + 5, YOFFSET + localY, g.getFont().stringWidth(s), g.getFont().getHeight());
        } else if (i < this.cursorYPosition && i > this.copyPosition[0][1]) {
            g.drawRect(5, YOFFSET + localY, g.getFont().stringWidth(this.arrLines[i]), g.getFont().getHeight());
            g.fillRect(5, YOFFSET + localY, g.getFont().stringWidth(this.arrLines[i]), g.getFont().getHeight());
        } else if (i > this.cursorYPosition && i < this.copyPosition[0][1]) {
            g.drawRect(5, YOFFSET + localY, g.getFont().stringWidth(this.arrLines[i]), g.getFont().getHeight());
            g.fillRect(5, YOFFSET + localY, g.getFont().stringWidth(this.arrLines[i]), g.getFont().getHeight());
        }
    }

    private void selectTextDown(Graphics g, int YOFFSET, int localY, int i) {
        if (i == this.copyPosition[0][1] && this.cursorYPosition > this.copyPosition[0][1]) {
            String s = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(this.copyPosition[0][0], this.arrLines[i].length());
            String s1 = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(0, this.copyPosition[0][0]);
            g.drawRect(g.getFont().stringWidth(s1) + 5, YOFFSET + localY, g.getFont().stringWidth(s), g.getFont().getHeight());
            g.fillRect(g.getFont().stringWidth(s1) + 5, YOFFSET + localY, g.getFont().stringWidth(s), g.getFont().getHeight());
        } else if (i == this.copyPosition[0][1] && this.cursorYPosition == this.copyPosition[0][1]) {
            String s = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(this.copyPosition[0][0], this.cursorXPosition);
            String s1 = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(0, this.copyPosition[0][0]);
            g.drawRect(g.getFont().stringWidth(s1) + 5, YOFFSET + localY, g.getFont().stringWidth(s), g.getFont().getHeight());
            g.fillRect(g.getFont().stringWidth(s1) + 5, YOFFSET + localY, g.getFont().stringWidth(s), g.getFont().getHeight());
        } else if (i == this.cursorYPosition) {
            int curPos = this.cursorXPosition >= this.arrLines[i].length() ? this.arrLines[i].length() - 1 : this.cursorXPosition;
            String s = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(0, curPos);
            g.drawRect(5, YOFFSET + localY, g.getFont().stringWidth(s), g.getFont().getHeight());
            g.fillRect(5, YOFFSET + localY, g.getFont().stringWidth(s), g.getFont().getHeight());
        } else if (i < this.cursorYPosition && i > this.copyPosition[0][1]) {
            g.drawRect(5, YOFFSET + localY, g.getFont().stringWidth(this.arrLines[i]), g.getFont().getHeight());
            g.fillRect(5, YOFFSET + localY, g.getFont().stringWidth(this.arrLines[i]), g.getFont().getHeight());
        } else if (i > this.cursorYPosition && i < this.copyPosition[0][1]) {
            g.drawRect(5, YOFFSET + localY, g.getFont().stringWidth(this.arrLines[i]), g.getFont().getHeight());
            g.fillRect(5, YOFFSET + localY, g.getFont().stringWidth(this.arrLines[i]), g.getFont().getHeight());
        }
    }

    public void paint(Graphics g) {
        int YOFFSET;
        this.clearScreen(g);
        int localY = YOFFSET = this.drawScreenTitle(g, 2) + 4;
        for (int i = this.startLine; i < this.arrLines.length; ++i) {
            if (this.copyFlag == 1) {
                g.setColor(199, 215, 244);
                switch (this.direction) {
                    case 1: {
                        if (this.cursorYPosition < this.copyPosition[0][1] || i == this.copyPosition[0][1] && this.cursorXPosition <= this.copyPosition[0][0] && this.cursorYPosition == this.copyPosition[0][1]) {
                            this.selectTextUp(g, YOFFSET, localY, i);
                            break;
                        }
                        this.selectTextDown(g, YOFFSET, localY, i);
                        break;
                    }
                    case 2: {
                        if (this.cursorYPosition > this.copyPosition[0][1] || i == this.copyPosition[0][1] && this.cursorXPosition >= this.copyPosition[0][0] && this.cursorYPosition == this.copyPosition[0][1]) {
                            this.selectTextDown(g, YOFFSET, localY, i);
                            break;
                        }
                        this.selectTextUp(g, YOFFSET, localY, i);
                    }
                }
                g.setColor(0, 0, 0);
            }
            if (this.cursorYPosition == i) {
                if (this.arrLines[i].trim().length() == 0) {
                    this.carryLine.append(this.cursor).append(this.arrLines[i]);
                } else if (this.cursorXPosition <= this.arrLines[i].length()) {
                    this.carryLine.append(this.arrLines[i]).insert(this.cursorXPosition, this.cursor);
                } else if (this.cursorXPosition > this.arrLines[i].length()) {
                    this.carryLine.append(this.arrLines[i]).append(this.cursor);
                }
            } else {
                this.carryLine.append(this.arrLines[i]);
            }
            g.drawString(this.carryLine.toString(), 5, YOFFSET + localY, 20);
            this.carryLine.delete(0, this.carryLine.length());
            if (this.copyText == 1) {
                if (this.direction == 1 && this.cursorYPosition <= this.copyPosition[0][1]) {
                    this.copyUpText(i);
                } else if (this.direction == 2 && this.cursorYPosition >= this.copyPosition[0][1]) {
                    this.copyDownText(i);
                }
            }
            localY += normal.getHeight();
        }
        this.copyText = 0;
        this.drawButtons(g, this.form.commandVector);
        if (this.isPopUp) {
            if (this.popupY >= this.getHeight() - bold.getHeight() - ((this.form.commandVector.size() - 1) * small.getHeight() + 1)) {
                --this.popupY;
            }
            this.drawPopUpMenu(g, this.form);
        }
    }

    private void copyDownText(int i) {
        if (i == this.copyPosition[0][1] && this.cursorYPosition > this.copyPosition[0][1]) {
            String s = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(this.copyPosition[0][0], this.arrLines[i].length());
            this.smsText.append(s);
        } else if (i == this.copyPosition[0][1] && this.cursorYPosition == this.copyPosition[0][1]) {
            String s = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(this.copyPosition[0][0], this.cursorXPosition);
            this.smsText.append(s);
        } else if (i == this.cursorYPosition) {
            int curPos = this.cursorXPosition >= this.arrLines[i].length() ? this.arrLines[i].length() - 1 : this.cursorXPosition;
            String s = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(0, curPos);
            this.smsText.append(s);
        } else if (i < this.cursorYPosition && i > this.copyPosition[0][1]) {
            this.smsText.append(this.arrLines[i]);
        } else if (i > this.cursorYPosition && i < this.copyPosition[0][1]) {
            this.smsText.append(this.arrLines[i]);
        }
    }

    private void copyUpText(int i) {
        if (i == this.copyPosition[0][1] && this.cursorYPosition < this.copyPosition[0][1]) {
            String s = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(0, this.copyPosition[0][0]);
            this.smsText.append(s);
        } else if (i == this.copyPosition[0][1] && this.cursorYPosition == this.copyPosition[0][1]) {
            String s = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(this.cursorXPosition, this.copyPosition[0][0]);
            this.smsText.append(s);
        } else if (i == this.cursorYPosition) {
            int curPos = this.cursorXPosition >= this.arrLines[i].length() ? this.arrLines[i].length() - 1 : this.cursorXPosition;
            String s = this.arrLines[i].trim().length() == 0 ? " " : this.arrLines[i].substring(curPos, this.arrLines[i].length());
            this.smsText.append(s);
        } else if (i < this.cursorYPosition && i > this.copyPosition[0][1]) {
            this.smsText.append(this.arrLines[i]);
        } else if (i > this.cursorYPosition && i < this.copyPosition[0][1]) {
            this.smsText.append(this.arrLines[i]);
        }
    }

    public void run() {
    }

    private void wrap(String stringData) {
        Vector<String> lineVector = new Vector<String>();
        Vector<String> positions = new Vector<String>();
        WrapLine wrapLine = new WrapLine(stringData, width - 5);
        while (wrapLine.hasMoreElements()) {
            lineVector.addElement(wrapLine.nextElement().toString());
            positions.addElement(wrapLine.getEndPosition());
        }
        this.arrLines = new String[lineVector.size()];
        this.lineLength = new short[positions.size()];
        lineVector.copyInto(this.arrLines);
        for (int i = 0; i < positions.size(); ++i) {
            this.lineLength[i] = Short.parseShort((String)positions.elementAt(i));
        }
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case -22: 
            case -20: {
                this.executeLSK(this.form);
                break;
            }
            case -21: {
                if (!this.rightString.equals("Options") && !this.rightString.equals("Cancel")) break;
                this.executeRSKPopUp();
                break;
            }
            case -1: {
                this.direction = 1;
                if (this.isPopUp) {
                    this.scrollPopUp(1, this.form.commandVector.size());
                    break;
                }
                if (this.cursorYPosition <= this.startLine && this.startLine > 0) {
                    --this.startLine;
                }
                this.cursorYPosition = this.cursorYPosition > 0 ? (this.cursorYPosition = this.cursorYPosition - 1) : this.cursorYPosition;
                break;
            }
            case -6: {
                this.direction = (byte)2;
                if (this.isPopUp) {
                    this.scrollPopUp(0, this.form.commandVector.size());
                    break;
                }
                if (this.cursorYPosition >= this.numOflinesPerPage && this.arrLines.length - this.startLine > this.numOflinesPerPage) {
                    int n = this.startLine = this.startLine < this.lineLength.length ? (this.startLine = this.startLine + 1) : this.startLine;
                }
                if (this.cursorYPosition >= this.arrLines.length - 1) break;
                ++this.cursorYPosition;
                break;
            }
            case -2: {
                this.direction = 1;
                if (this.cursorXPosition > 0) {
                    --this.cursorXPosition;
                    break;
                }
                if (this.cursorYPosition <= 0) break;
                --this.cursorYPosition;
                this.cursorXPosition = this.arrLines[this.cursorYPosition].length() - 1;
                break;
            }
            case -5: {
                this.direction = (byte)2;
                if (this.cursorYPosition < this.arrLines.length && this.cursorXPosition < this.arrLines[this.cursorYPosition].length() - 1) {
                    ++this.cursorXPosition;
                    break;
                }
                if (this.cursorYPosition >= this.arrLines.length) break;
                ++this.cursorYPosition;
                this.cursorXPosition = 0;
                break;
            }
            case 42: {
                this.executeStarKeyEvent();
                break;
            }
            case 35: {
                this.executePoundKeyEvent();
            }
        }
        this.callPaints();
    }

    public void executePoundKeyEvent() {
        if (this.copyFlag == 1) {
            this.copyFlag = 0;
            this.copyText = 1;
        }
    }

    public void executeStarKeyEvent() {
        if (this.copyFlag == 0) {
            this.copyFlag = 1;
            this.copyPosition[0][0] = this.cursorXPosition;
            this.copyPosition[0][1] = this.cursorYPosition;
        }
    }

    protected void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }
}

