/*
 * Decompiled with CFR 0.152.
 */
package mobi.items;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mobi.forms.MidpForm;
import mobi.items.BaseItem;
import mobi.midp.MobiStatic;
import mobi.util.ResourceBundle;

public class MenuItem
extends BaseItem {
    public int selection;
    boolean didAction;
    int startArray;
    int numOfLinesPerPage;
    int currentLine;
    int topImageHeight;
    String[] array;
    MidpForm form;
    boolean firstTime = true;
    int iconx = 7;
    private int yOffset = 0;
    private Thread titleThread = null;
    private static int titleX = 10;

    public MenuItem(String[] array, MidpForm form) {
        this.setArray(array);
        this.form = form;
        this.fontHeight = (short)bold.getHeight();
        this.numOfLinesPerPage = (height - this.background.getHeight() - this.whiteGround.getHeight() - MobiStatic.mobiViewerImage.getHeight()) / this.fontHeight;
        titleX = bold.stringWidth("W") * 3;
        this.screenTitle = "bookmarks.mobi".equals(form.getMobiAction()) ? ResourceBundle.get("bookmarks") : ("titles.mobi".equals(form.getMobiAction()) ? ResourceBundle.get("choose_title") : (MidpForm.isBundled == 1 ? form.midp.title.getName() : ResourceBundle.get("app_title")));
        this.titleThread = new Thread(this);
        this.scrolling = 1;
        this.load_thread = true;
        load_flag = false;
    }

    private void setArray(String[] arrayIn) {
        if (arrayIn == null || arrayIn.length == 0) {
            return;
        }
        this.array = arrayIn;
    }

    public int getSelection() {
        return this.selection;
    }

    public void run() {
        while (load_flag && this.loading == 1) {
            this.callPaints();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        while (this.scrolling == 1) {
            try {
                this.callPaints();
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void cancelAction() {
        this.didAction = false;
        this.selection = 0;
    }

    protected void keyRepeated(int keyCode) {
        int action = this.getGameAction(keyCode);
        switch (action) {
            case 1: 
            case 6: {
                this.keyPressed(keyCode);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyPressed(int keyCode) {
        if (load_flag) {
            return;
        }
        if (this.intialAppError != null && keyCode == -22) {
            this.form.midp.exitApp();
            return;
        }
        if (this.appErrorStr != null) {
            if (MobiStatic.isDataConnectionProblem) {
                MobiStatic.isDataConnectionProblem = false;
                this.form.midp.exitApp();
            } else {
                this.cancelAlertMessage(this.form);
            }
            return;
        }
        if (this.ALERT_TRUE && keyCode != -22 && keyCode != -20 && keyCode != -21 || this.form.getMobiAction().equals("error.mobi") && keyCode != -22 && keyCode != -20 && keyCode != -21 || keyCode == -2 || keyCode == -5) {
            return;
        }
        if ((this.array == null || this.array.length == 0) && keyCode != -21 && keyCode != -22 && keyCode != -20) {
            return;
        }
        if (this.appErrorStr != null || this.intialAppError != null) {
            return;
        }
        MenuItem menuItem = this;
        synchronized (menuItem) {
            if (this.didAction) {
                return;
            }
            boolean foundKey = true;
            if (!(keyCode != -22 && keyCode != -20 || this.rightString.equals("No") || this.errorStr != null)) {
                this.executeLSK(this.form);
                if (this.selectedCmd == 5 || this.form.commandVector != null && this.form.commandVector.size() > this.selectedCmd && ((String)this.form.commandVector.elementAt(this.selectedCmd)).equals("Delete")) {
                    this.callPaints();
                }
                return;
            }
            if ((keyCode == -22 || keyCode == -20) && this.rightString.equals("No")) {
                this.ALERT_TRUE = true;
                if (MidpForm.isBundled == 0 && this.form.getMobiAction().equals("mainPage1.mobi") || this.form.getMobiAction().equals("titles.mobi")) {
                    this.form.commandAction(13);
                } else if (this.form.getMobiAction().equals("bookmarks.mobi")) {
                    this.form.commandAction(16);
                }
                return;
            }
            if (!(keyCode != -21 || this.rightString.equals("Options") || this.rightString.equals("Cancel") || this.rightString.equals("No"))) {
                this.executeRSK(this.form);
                this.callPaints();
                return;
            }
            if (keyCode == -21 && (this.rightString.equals("Options") || this.rightString.equals("Cancel"))) {
                this.selectedCmd = 1;
                if (!this.isPopUp && !this.isSubPopUp) {
                    this.pauseflag = true;
                    this.executeRSKPopUp();
                } else {
                    MobiStatic.cleanUpGc();
                    this.executeRSKPopUp();
                }
                return;
            }
            if (keyCode == -21 && this.rightString.equals("No")) {
                this.ALERT_TRUE = false;
                this.resetAnyKeyChild();
                this.callPaints();
                return;
            }
            if (keyCode == -1) {
                if (this.isPopUp) {
                    this.scrollPopUp(1, this.form.commandVector.size());
                } else if (this.decrementSelection()) {
                    this.callPaints();
                }
                return;
            }
            if (keyCode == -6) {
                if (this.isPopUp) {
                    this.scrollPopUp(0, this.form.commandVector.size());
                } else if (this.incrementSelection()) {
                    this.callPaints();
                }
                return;
            }
            if (this.isPopUp) {
                this.handlePopUpAction(keyCode, this.form);
                foundKey = false;
                this.callPaints();
            } else {
                int tempSelection = this.findKey(keyCode);
                if (this.array.length < tempSelection || tempSelection == -1) {
                    return;
                }
                this.selection = tempSelection;
                if (keyCode == 42) {
                    this.showSearch(this.form);
                    return;
                }
                if (this.selection == -1 || this.array.length < this.selection) {
                    foundKey = false;
                }
            }
            if (foundKey) {
                this.repaint();
                try {
                    Thread.sleep(75L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.didAction = true;
                this.selection = this.selection == 0 ? 9 : --this.selection;
                if (this.array.length > this.selection) {
                    this.callLoading(0);
                }
                this.form.handleCommand(this.selection);
            }
        }
    }

    private boolean decrementSelection() {
        if (this.currentLine <= this.startArray && this.startArray > 0) {
            --this.startArray;
            this.downArrow = true;
        } else if (this.upArrow && this.startArray <= 0) {
            this.upArrow = false;
            this.callPaints();
        }
        if (this.startArray == 0 && this.yOffset < 0) {
            this.yOffset += this.fontHeight;
        }
        if (this.selection > 0) {
            --this.selection;
            return true;
        }
        return false;
    }

    private boolean incrementSelection() {
        boolean booReturn = false;
        int arrLen = this.array.length;
        if (this.currentLine >= this.numOfLinesPerPage && this.currentLine < arrLen && this.startArray <= arrLen - this.numOfLinesPerPage) {
            this.upArrow = true;
            ++this.startArray;
            booReturn = true;
        } else if (this.downArrow && this.startArray > 0) {
            this.downArrow = false;
            this.callPaints();
        }
        if (this.selection + 1 < this.array.length) {
            ++this.selection;
            booReturn = true;
        }
        return booReturn;
    }

    public int menuSize() {
        return this.array.length;
    }

    protected void paint(Graphics g) {
        if (this.firstTime) {
            this.selection = 0;
            this.firstTime = false;
        }
        int x = 5;
        if (this.intialAppError != null) {
            this.clearScreen(g);
            this.drawErrorScreenTitle(g, "Error");
            g.setColor(0);
            int y = this.background.getHeight() + 10;
            this.drawMenu(g, 20, this.intialAppError, width - x * 4, x + 5, y);
            this.drawButtons(g, this.form.commandVector);
            return;
        }
        Image icon = null;
        if (this.loading == 1 && load_flag) {
            this.draw_loading(g);
            return;
        }
        if (load_flag) {
            return;
        }
        if (this.isPopUp) {
            this.drawPopUpMenu(g, this.form);
            if (!this.getIsPopUpRunning()) {
                this.drawButtons(g, this.form.commandVector);
            }
            return;
        }
        this.setBackGroundImage(g, this.form);
        if (this.scrolling == 0) {
            g.setColor(0xFFFFFF);
            g.fillRect(0, MobiStatic.mobiViewerImage.getHeight() + this.whiteGround.getHeight(), width, this.getHeight());
            g.setColor(0, 0, 0);
            g.setFont(normal);
        }
        this.drawScreenTitle(g, this.screenTitle);
        int y = MobiStatic.mobiViewerImage.getHeight() + this.whiteGround.getHeight() + 2;
        y += this.yOffset;
        if (this.errorStr != null) {
            g.setClip(0, MobiStatic.mobiViewerImage.getHeight() + this.whiteGround.getHeight() - 2, width, height - this.background.getHeight());
            g.drawString(this.errorStr, width / 2, y, 17);
            if (this.appErrorStr != null) {
                g.drawString(this.appErrorStr, width / 2, y + 5 + this.fontHeight, 17);
                this.appErrorStr = null;
            }
            this.drawButtons(g, this.form.commandVector);
            return;
        }
        this.topImageHeight = y / this.fontHeight;
        this.numOfLinesPerPage = (height - y - this.fontHeight) / this.fontHeight;
        g.setClip(0, MobiStatic.mobiViewerImage.getHeight() + this.whiteGround.getHeight() - 2, width, height - this.background.getHeight());
        int selectedOptionY = 0;
        for (int j = this.startArray; j < this.array.length; ++j) {
            String s = this.array[j];
            int iconWidth = 0;
            if (this.selection == j) {
                int temp = 0;
                if (icon != null) {
                    temp = temp + icon.getWidth() + 2;
                }
                if (MobiStatic.numberIcons[j] != null) {
                    temp += MobiStatic.numberIcons[j].getWidth();
                }
                g.setFont(bold);
                if (MobiStatic.numberIcons[j] != null) {
                    this.drawIcon(g, MobiStatic.numberIcons[j], x + iconWidth, y + bold.getHeight() / 2 + 1);
                    iconWidth += MobiStatic.numberIcons[j].getWidth();
                }
                g.setColor(12312047);
                g.drawLine(0, y, width, y);
                g.setColor(0);
                g.setFont(bold);
                selectedOptionY = y = this.drawMenu(g, 20, s, width - iconWidth - x * 4, x + 5 + iconWidth, y);
                this.currentLine = j;
                g.setFont(normal);
            } else {
                g.setColor(12312047);
                g.drawLine(0, y, width, y);
                g.setColor(0);
                if (icon != null) {
                    this.drawIcon(g, icon, x, y + bold.getHeight() / 2);
                    iconWidth = icon.getWidth() + 2;
                }
                if (MobiStatic.numberIcons[j] != null) {
                    this.drawIcon(g, MobiStatic.numberIcons[j], x + iconWidth, y + small.getHeight() / 2 + 2);
                    iconWidth += MobiStatic.numberIcons[j].getWidth();
                }
                this.drawMenu(g, s, x + 5 + iconWidth, y, iconWidth);
            }
            y += this.fontHeight + 2;
        }
        if (selectedOptionY + this.fontHeight + 2 > this.getHeight() - this.background.getHeight() && this.startArray < this.array.length && this.startArray != this.selection) {
            ++this.startArray;
            this.callPaints();
            return;
        }
        g.setColor(187, 221, 239);
        g.drawLine(0, y, width, y);
        if (y > height) {
            this.downArrow = true;
        }
        this.drawButtons(g, this.form.commandVector);
        this.drawArrow(g, this.form);
        this.appErrorStr = (String)this.form.midp.getHashtable().get("errorMessage");
        if (this.appErrorStr != null) {
            if (!MobiStatic.isDataConnectionProblem) {
                this.appErrorStr = this.appErrorStr + " " + ResourceBundle.get("press_any_key_to_continue");
            }
            this.showAlert(g, this.appErrorStr);
        }
        if (this.ALERT_TRUE) {
            this.showAlert(g, this.confirmMessage);
        }
        if (this.titleThread != null && this.load_thread) {
            this.load_thread = false;
            this.loading = 0;
            this.titleThread.start();
        }
        if (this.isFullpage == 0) {
            return;
        }
        this.isFullpage = 0;
    }

    private void drawMenu(Graphics g, String text, int x, int y, int considerableWidth) {
        int widthOfDrawingArea = width - considerableWidth;
        g.setFont(normal);
        if (normal.stringWidth(text) > widthOfDrawingArea) {
            text = this.getDotAppendString(widthOfDrawingArea, text);
        }
        g.setColor(150, 150, 150);
        g.drawString(text, x, y + 2, 20);
    }

    public void setAppError(String error) {
        this.appErrorStr = error;
    }

    public void setIntialAppError(String error) {
        this.intialAppError = error;
    }

    public void setError(String error) {
        this.errorStr = error;
    }

    private void drawScreenTitle(Graphics g, String title) {
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        int adjust = bold.stringWidth("W");
        int imageHeight = MobiStatic.mobiViewerImage.getHeight();
        g.setClip(0, imageHeight, width, this.whiteGround.getHeight());
        g.setColor(0xFFFFFF);
        g.fillRect(0, imageHeight, width, this.whiteGround.getHeight());
        g.setFont(bold);
        g.setColor(0);
        for (int i = 0; i < this.getWidth(); ++i) {
            g.drawImage(this.whiteGround, i, imageHeight, 0x10 | 4);
        }
        g.setClip(adjust, imageHeight, width - adjust * 2, this.whiteGround.getHeight());
        g.drawString(this.screenTitle, titleX, imageHeight, 20);
        titleX = titleX + bold.stringWidth(this.screenTitle) - adjust == 0 ? width - adjust : (titleX = titleX - 1);
    }

    private void drawErrorScreenTitle(Graphics g, String title) {
        g.setFont(bold);
        g.setColor(255, 255, 255);
        for (int i = 0; i < this.getWidth(); ++i) {
            g.drawImage(this.background, i, 0, 0x10 | 4);
        }
        g.drawString(title, width / 2 - bold.stringWidth(title) / 2, 3, 20);
        g.setColor(0);
    }
}

