/*
 * Decompiled with CFR 0.152.
 */
package mobi.data;

import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import mobi.data.RecordId;
import mobi.util.ResourceBundle;

public abstract class MobiStore {
    RecordStore recordStore;

    protected MobiStore() throws RecordStoreException {
        this.openStore();
    }

    private void openStore() throws RecordStoreException {
        this.recordStore = RecordStore.openRecordStore((String)this.getStoreName(), (boolean)true);
    }

    abstract String getStoreName();

    abstract boolean isShared();

    public void close() {
        try {
            if (this.recordStore != null) {
                this.recordStore.closeRecordStore();
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void delete(RecordId recordId) throws RecordStoreException {
        this.recordStore.deleteRecord(recordId.getRecordStoreId());
    }

    public void deleteAll() throws RecordStoreException {
        RecordEnumeration enumeration = this.getEnumeration();
        while (enumeration.hasNextElement()) {
            this.recordStore.deleteRecord(enumeration.nextRecordId());
        }
    }

    RecordEnumeration getEnumeration() throws RecordStoreException {
        return this.recordStore.enumerateRecords(null, null, false);
    }

    public static String getError(RecordStoreException e) {
        if (e instanceof RecordStoreFullException) {
            return ResourceBundle.get("device_is_full");
        }
        return ResourceBundle.get("record_error");
    }
}

