/*
 * Decompiled with CFR 0.152.
 */
package mobi.items;

import java.util.NoSuchElementException;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mobi.forms.ErrorForm;
import mobi.forms.RecordForm;
import mobi.items.BaseItem;
import mobi.items.RecordData;
import mobi.midp.MobiStatic;
import mobi.util.ResourceBundle;
import mobi.util.SplashCanvas;
import mobi.util.WrapLine;

public class RecordItem
extends BaseItem {
    public String stringData = null;
    String pageTitle = null;
    RecordData recordData = null;
    RecordForm recordForm = null;
    String[] contentArray = null;
    String[][] styleArray = null;
    int totalLines = 0;
    int xAxis = 5;
    int yAxis = 0;
    int scrollImage = 0;
    int width = 0;
    int height = 0;
    int startContentArrayIndex = 0;
    int numberOfLinesPerScreen = 0;
    public int imageCounter = -1;
    public int imageCounter_draw = -1;
    public int counter = -1;
    int linesToBeDrawn = 0;
    private int stringLength = 0;
    static final int pixelAdjustment = 2;
    private Thread titleThread = null;
    private static int titleX = 0;
    private int catchYAxis = 0;
    private Thread SCROLL_THREAD = null;
    boolean scrollThread_up = false;
    boolean scrollThread_down = false;
    public static final byte NORMAL = 1;
    public static final byte ITALIC = 2;
    public static final byte BOLD = 3;
    public static final byte HYPERLINK = 4;
    public static final byte FOOTNOTES = 5;
    public static final byte BOLD_ITALIC = 6;
    public static final byte FOOTNOTES_DETAILS = 7;
    Image bufferImage = null;
    String previousHighLightedPoints = "0|-1";
    byte currentHighLighted = 0;
    boolean isHighLighted = false;
    boolean isComingFromViewer = false;
    private byte pageScroll = 0;
    private Vector startStylePoint = new Vector();
    private Vector lastStyleChar = new Vector();
    private Vector fontStyle = new Vector();
    private Vector startHyperLinkVector = new Vector();
    private Vector endHyperLinkVector = new Vector();
    private Vector startImageVector = new Vector();
    private int keyPressed = 0;
    private static final int UP_KEY = 1;
    private static final int DOWN_KEY = 2;
    private byte stopKeyPress = 0;
    final String IMAGE_IDENTIFIER;
    private byte isImageCounterReset = 0;
    private byte isCounterReset = 0;
    private boolean isHyperWrapped = false;
    byte drawGray = 0;
    private static final int IMAGE_HIGHLIGHTED = 1;
    private int currentHighlightPointer = -1;
    private int currentHighlightSubPointer = -1;
    private boolean isHighLightScroll = false;
    private int higlightYcoOrdinate = 0;
    private int arrayPosition = 0;
    private int prevHiglightXcoOrdinate = 0;
    private int prevHiglightYcoOrdinate = 0;
    private int prevArrayPosition = 0;
    private String prevHighlightedString = "";
    int footNotesCounter = -1;
    Vector startFNDetailsVector = new Vector();

    public RecordItem(String stringData, RecordData recordData, RecordForm recordForm, String pageTitle, String[] contentArray) {
        this.IMAGE_IDENTIFIER = "-ManiNaveenBhanu";
        this.stringData = stringData;
        this.recordData = recordData;
        this.recordForm = recordForm;
        this.pageTitle = pageTitle;
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (stringData != null && stringData.trim().length() == 0 && contentArray == null) {
            return;
        }
        this.fontHeight = (short)footnotes.getHeight();
        this.scrollImage = this.titleImageHeight;
        this.linesToBeDrawn = this.numberOfLinesPerScreen = (SplashCanvas.screenHeight - this.background.getHeight() * 2 - 4) / this.fontHeight;
        if (contentArray == null) {
            this.setImageVector(recordData.startImg);
            this.setStyleFontVectors(recordData.startBold.trim(), recordData.endBold.trim(), 'B');
            this.setStyleFontVectors(recordData.startItalic.trim(), recordData.endItalic.trim(), 'I');
            this.setStyleFontVectors(recordData.starta.trim(), recordData.enda.trim(), 'A');
            this.setStyleFontVectors(recordData.startFN.trim(), recordData.endFN.trim(), 'F');
            this.shortStyleStartPointVectors();
            this.shortHyperLinkVector();
            try {
                if (stringData.trim().length() != 0) {
                    this.wrap(stringData);
                }
            }
            catch (NoSuchElementException nse) {
                nse.printStackTrace();
            }
            catch (IndexOutOfBoundsException iob) {
                iob.printStackTrace();
            }
            catch (Throwable t) {
                t.printStackTrace();
                recordForm.midp.getHashtable().put("errorMessage", ResourceBundle.get("outofmemory"));
                new ErrorForm("error.mobi").createForm();
                return;
            }
            this.totalLines = this.contentArray.length;
            recordForm.setContentArray(this.contentArray);
            recordForm.setStyleArray(this.styleArray);
        } else {
            this.contentArray = contentArray;
            this.styleArray = recordForm.getStyleArray();
            this.totalLines = this.contentArray.length;
        }
        this.keyPressed = 2;
        this.bufferImage = Image.createImage((int)this.width, (int)(SplashCanvas.screenHeight - this.background.getHeight() * 2));
        this.drawOnImage();
        titleX = bold.stringWidth("W") * 3;
        this.titleThread = new Thread(this);
        this.scrolling = 1;
        this.load_thread = true;
        if (this.totalLines > this.numberOfLinesPerScreen) {
            this.downArrow = true;
        }
        this.imageCounter = -1;
        this.stopKeyPress = 1;
        load_flag = false;
        this.setVariables();
    }

    private void drawFocus(Graphics g) {
        g.setClip(0, this.background.getHeight(), this.width, SplashCanvas.screenHeight - this.titleImageHeight * 2);
        switch (this.currentHighLighted) {
            case 1: {
                if (!this.isComingFromViewer && this.keyPressed == 2 && this.imageCounter < this.recordData.imageUrl.length - 1) {
                    ++this.imageCounter;
                }
                if (this.isImageCounterReset == 0 && !this.isComingFromViewer && this.keyPressed == 1 && this.imageCounter > 0) {
                    --this.imageCounter;
                }
                this.imageCounter = this.imageCounter < 0 ? 0 : this.imageCounter;
                this.imageCounter = this.imageCounter > this.recordData.imageUrl.length - 1 ? this.recordData.imageUrl.length - 1 : this.imageCounter;
                this.paintImageLink(g, this.imageCounter);
                this.isImageCounterReset = 0;
                break;
            }
            case 4: 
            case 5: {
                this.paintWithStyles(g, this.arrayPosition);
            }
        }
        this.isHighLightScroll = false;
        this.isHighLighted = true;
    }

    public void paint(Graphics g) {
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        if (this.isHighLightScroll && this.isFullpage == 1) {
            this.drawFocus(g);
            this.isFullpage = 0;
            return;
        }
        if (!this.drawTopContent(g)) {
            return;
        }
        this.isHyperWrapped = false;
        this.prevHiglightYcoOrdinate = 0;
        g.setClip(0, this.background.getHeight(), this.width, this.getHeight() - this.background.getHeight() * 2);
        if (this.drawGray == 1) {
            this.paintBlurred(g);
        }
        g.drawImage(this.bufferImage, 0, this.yAxis, 0);
        g.setClip(0, this.background.getHeight(), this.width, this.getHeight() - this.titleImageHeight);
        this.drawRest(g);
        if (this.isComingFromViewer) {
            this.drawFocus(g);
            this.isComingFromViewer = false;
        }
        this.stopKeyPress = 0;
    }

    private void paintBlurred(Graphics g) {
        for (int i = 0; i < this.getWidth(); i += 8) {
            for (int j = 0; j < this.getHeight(); j += 8) {
                g.drawImage(SplashCanvas.pause, i, j, 0x10 | 4);
            }
        }
        this.drawGray = 0;
    }

    private void resetImageCounter() {
        int i;
        int tempCounter = -1;
        for (i = 0; i < this.numberOfLinesPerScreen + this.startContentArrayIndex && i < this.totalLines; ++i) {
            if (!this.contentArray[i].equals("-ManiNaveenBhanu")) continue;
            ++tempCounter;
        }
        this.imageCounter = tempCounter;
        tempCounter = 0;
        for (i = this.startContentArrayIndex; i < this.numberOfLinesPerScreen + this.startContentArrayIndex && i < this.totalLines; ++i) {
            if (!this.contentArray[i].equals("-ManiNaveenBhanu")) continue;
            ++tempCounter;
        }
        this.imageCounter_draw = this.imageCounter - tempCounter;
        this.isImageCounterReset = 1;
    }

    private void resetCounter() {
        int tempCounter = -1;
        for (int i = 0; i < this.numberOfLinesPerScreen + this.startContentArrayIndex && i < this.totalLines; ++i) {
            if (this.contentArray[i].equals("-ManiNaveenBhanu")) {
                ++tempCounter;
            }
            if (this.styleArray[i] == null) continue;
            int[] styleResult = null;
            for (int k = 0; k < this.styleArray[i].length; ++k) {
                styleResult = this.getStylePosition(i, k);
                switch (styleResult[0]) {
                    case 4: 
                    case 5: {
                        ++tempCounter;
                    }
                }
            }
        }
        this.counter = tempCounter;
        this.isCounterReset = 1;
    }

    void drawOnImage() {
        this.yAxis = 4;
        Graphics g = this.bufferImage.getGraphics();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0);
        g.setFont(normal);
        if (this.keyPressed == 1) {
            this.resetImageCounter();
            this.resetCounter();
        }
        for (int i = this.startContentArrayIndex; i < this.numberOfLinesPerScreen + this.startContentArrayIndex && i < this.totalLines; ++i) {
            if (this.contentArray[i].equals("-ManiNaveenBhanu")) {
                if (this.imageCounter_draw < this.recordData.imageUrl.length - 1) {
                    ++this.imageCounter_draw;
                }
                this.paintImageLink(g, this.imageCounter_draw);
            } else if (this.styleArray[i] == null) {
                this.paintString(g, this.contentArray[i], this.xAxis);
            } else {
                this.paintWithStyles(g, i);
            }
            this.yAxis += g.getFont().getHeight();
        }
    }

    private boolean drawTopContent(Graphics g) {
        if (this.loading == 1) {
            this.draw_loading(g);
            return false;
        }
        if (this.stringData != null && this.stringData.trim().length() == 0) {
            return false;
        }
        if (load_flag) {
            return false;
        }
        if (this.isSubPopUp || this.isPopUp) {
            this.drawRest(g);
            return false;
        }
        this.popupY = this.getHeight() - this.background.getHeight();
        this.drawScreenTitle(g, this.pageTitle);
        if (this.isFullpage == 0) {
            return false;
        }
        if (!this.scrollThread_down && !this.scrollThread_up) {
            this.isFullpage = 0;
        }
        return true;
    }

    private void drawRest(Graphics g) {
        if (this.isPopUp) {
            if (this.popupY >= this.getHeight() - bold.getHeight() - ((this.recordForm.commandVector.size() - 1) * small.getHeight() + 1)) {
                this.popupY -= 2;
            }
            this.drawPopUpMenu(g, this.recordForm);
        }
        if (!this.getIsPopUpRunning()) {
            this.drawButtons(g, this.recordForm.commandVector);
        }
        this.appErrorStr = (String)this.recordForm.midp.getHashtable().get("errorMessage");
        if (this.appErrorStr != null) {
            if (!MobiStatic.isDataConnectionProblem) {
                this.appErrorStr = this.appErrorStr + " " + ResourceBundle.get("press_any_key_to_continue");
            }
            this.showAlert(g, this.appErrorStr);
        }
        if (this.anyKeyChild == 1 && this.ALERT_TRUE) {
            this.showAlert(g, this.confirmMessage);
        }
        if (this.ALERT_TRUE && this.anyKeyChild == 0) {
            this.showAlert(g, ResourceBundle.get("last_record") + " " + ResourceBundle.get("press_any_key_to_continue"));
        }
        this.drawArrow(g, this.recordForm);
        if (this.titleThread != null && this.load_thread) {
            this.loading = 0;
            this.load_thread = false;
            this.titleThread.start();
        }
    }

    private void paintImageLink(Graphics g, int imageCounter) {
        String imageName = this.getImageName(imageCounter);
        int localX = this.width / 2 - linkUps.stringWidth(imageName) / 2;
        g.setColor(25, 25, 112);
        g.setFont(this.getStyle((byte)4));
        this.checkHighLight(g, imageName, localX);
        this.paintString(g, imageName, localX);
        g.setColor(0);
        g.setFont(this.getStyle((byte)1));
    }

    private void checkHighLight(Graphics g, String currentData, int localX) {
        if (this.isHighLightScroll || this.isComingFromViewer) {
            g.setColor(255, 192, 192);
            g.fillRect(localX, this.higlightYcoOrdinate, g.getFont().stringWidth(currentData), g.getFont().getHeight());
            g.setColor(25, 25, 112);
            if (this.prevHiglightYcoOrdinate > 0) {
                g.setColor(255, 255, 255);
                g.fillRect(this.prevHiglightXcoOrdinate, this.prevHiglightYcoOrdinate, g.getFont().stringWidth(this.prevHighlightedString), g.getFont().getHeight());
                g.setColor(25, 25, 112);
                this.yAxis = this.prevHiglightYcoOrdinate;
                this.paintString(g, this.prevHighlightedString, this.prevHiglightXcoOrdinate);
                if (this.isHyperWrapped) {
                    this.yAxis += this.fontHeight;
                    ++this.prevArrayPosition;
                    this.isHyperWrapped = false;
                    for (int k = this.prevArrayPosition; k < this.totalLines; ++k) {
                        if (this.styleArray[k] == null) {
                            g.setColor(255, 255, 255);
                            g.fillRect(this.xAxis, this.yAxis, g.getFont().stringWidth(this.contentArray[k]), g.getFont().getHeight());
                            g.setColor(25, 25, 112);
                            this.paintString(g, this.contentArray[k], this.xAxis);
                            this.yAxis += this.fontHeight;
                            continue;
                        }
                        int[] stylePosition = this.getStylePosition(k, 0);
                        int end = stylePosition[1];
                        String data = this.contentArray[this.prevArrayPosition].substring(0, end);
                        g.setColor(255, 255, 255);
                        g.fillRect(this.xAxis, this.yAxis, g.getFont().stringWidth(data.trim()), g.getFont().getHeight());
                        g.setColor(25, 25, 112);
                        this.paintString(g, data.trim(), this.xAxis);
                        break;
                    }
                }
            }
            this.yAxis = this.higlightYcoOrdinate;
            this.prevHighlightedString = currentData;
            this.prevHiglightXcoOrdinate = localX;
            this.prevHiglightYcoOrdinate = this.higlightYcoOrdinate;
            this.prevArrayPosition = this.arrayPosition;
        }
    }

    private void paintWithStyles(Graphics g, int pos) {
        int start = 0;
        int end = 0;
        int localX = 5;
        int[] stylePosition = null;
        int numberOfStyles = this.styleArray[pos].length;
        int lengthOfLine = this.contentArray[pos].length();
        String data = null;
        int pos1 = pos;
        while (--pos1 >= 0 && this.styleArray != null) {
            if (this.styleArray[pos1] == null) continue;
            stylePosition = this.getStylePosition(pos1, this.styleArray[pos1].length - 1);
            g.setFont(this.getStyle((byte)stylePosition[0]));
            break;
        }
        for (int i = 0; i < numberOfStyles; ++i) {
            stylePosition = this.getStylePosition(pos, i);
            end = stylePosition[1];
            data = this.contentArray[pos].substring(start, end);
            if (this.isHighLightScroll && (g.getFont().equals(linkUps) || g.getFont().equals(footnotes))) {
                this.checkHighLight(g, data, localX);
                this.paintString(g, data, localX);
            }
            if (!this.isHighLightScroll) {
                this.paintString(g, data.trim(), localX);
            }
            localX += g.getFont().stringWidth(data);
            start = end;
            g.setFont(this.getStyle((byte)stylePosition[0]));
        }
        boolean isHyperContinue = false;
        data = this.contentArray[pos].substring(start, lengthOfLine);
        if (end <= lengthOfLine) {
            if (this.isHighLightScroll && (g.getFont().equals(linkUps) || g.getFont().equals(footnotes))) {
                isHyperContinue = true;
                this.checkHighLight(g, data, localX);
            }
            this.paintString(g, data, localX);
        }
        if (isHyperContinue) {
            this.isHyperWrapped = true;
            isHyperContinue = false;
            this.yAxis += this.fontHeight;
            for (int k = ++pos; k < this.totalLines; ++k) {
                if (this.styleArray[k] == null) {
                    g.setColor(255, 192, 192);
                    g.fillRect(this.xAxis, this.yAxis, g.getFont().stringWidth(this.contentArray[k]), g.getFont().getHeight());
                    g.setColor(25, 25, 112);
                    this.paintString(g, this.contentArray[k], this.xAxis);
                    this.yAxis += this.fontHeight;
                    continue;
                }
                stylePosition = this.getStylePosition(k, 0);
                end = stylePosition[1];
                data = this.contentArray[pos].substring(0, end);
                g.setColor(255, 192, 192);
                g.fillRect(this.xAxis, this.yAxis, g.getFont().stringWidth(data.trim()), g.getFont().getHeight());
                g.setColor(25, 25, 112);
                this.paintString(g, data.trim(), this.xAxis);
                break;
            }
        }
    }

    private void paintString(Graphics g, String data, int xAxis) {
        g.drawString(data, xAxis, this.yAxis, 0x10 | 4);
    }

    private void setVariables() {
        this.yAxis = this.background.getHeight();
    }

    private int[] getStylePosition(int indexOne, int indexTwo) {
        int[] outputArray = new int[2];
        String tempString = this.styleArray[indexOne][indexTwo];
        outputArray[0] = Integer.parseInt(tempString.substring(0, tempString.indexOf("|")).trim());
        outputArray[1] = Integer.parseInt(tempString.substring(tempString.indexOf("|") + 1).trim());
        return outputArray;
    }

    private Font getStyle(byte font) {
        Font fontObj = null;
        switch (font) {
            case 1: {
                fontObj = normal;
                break;
            }
            case 2: {
                fontObj = italics;
                break;
            }
            case 3: {
                fontObj = bold;
                break;
            }
            case 4: {
                fontObj = linkUps;
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                fontObj = footnotes;
            }
        }
        return fontObj;
    }

    public void keyRepeated(int keyCode) {
        this.keyPressed(keyCode);
    }

    public void keyPressed(int keyCode) {
        this.isFullpage = 1;
        if (!this.haveToReturnControl()) {
            return;
        }
        switch (keyCode) {
            case -22: 
            case -20: {
                if (this.isHighLighted && (this.currentHighLighted == 1 || this.currentHighLighted == 5 || this.currentHighLighted == 4) && keyCode != -22 && !this.isPopUp) {
                    this.recordForm.gotoLink();
                    break;
                }
                if (this.leftString == null || this.leftString.length() == 0) {
                    return;
                }
                if (this.rightString.equals("No")) {
                    this.recordForm.commandAction(13);
                    return;
                }
                this.executeLSK(this.recordForm);
                break;
            }
            case -21: {
                if (this.rightString.equals("Options")) {
                    this.pauseflag = true;
                    this.selectedCmd = 1;
                    this.executeRSKPopUp();
                    break;
                }
                if (this.rightString.equals("Cancel")) {
                    this.yAxis = this.background.getHeight();
                    this.executeRSKPopUp();
                    MobiStatic.cleanUpGc();
                    break;
                }
                if (this.rightString.equals("No")) {
                    this.ALERT_TRUE = false;
                    this.resetAnyKeyChild();
                    this.yAxis = this.background.getHeight();
                    this.callPaints();
                    break;
                }
                this.executeRSK(this.recordForm);
                break;
            }
            case -1: {
                if (this.isPopUp) {
                    this.scrollPopUp(1, this.recordForm.commandVector.size());
                    break;
                }
                if (this.isSubPopUp) {
                    this.scrollPopUp(1, this.recordForm.subCommandVector.size());
                    break;
                }
                if (this.anyKeyChild != 0) break;
                this.keyPressed = 1;
                this.executeUpKeyEvent();
                break;
            }
            case -6: {
                if (this.isPopUp) {
                    this.scrollPopUp(0, this.recordForm.commandVector.size());
                    break;
                }
                if (this.isSubPopUp) {
                    this.scrollPopUp(0, this.recordForm.subCommandVector.size());
                    break;
                }
                if (this.anyKeyChild != 0) break;
                this.keyPressed = 2;
                this.executeDownKeyEvent();
                break;
            }
            default: {
                if (!this.isPopUp) break;
                this.handlePopUpAction(keyCode, this.recordForm);
            }
        }
    }

    private void executeUpKeyEvent() {
        boolean isRePaint = false;
        if (this.canGoForUpHighlight() && this.counter > -1) {
            if (this.isCounterReset == 0 && this.counter > 0) {
                --this.counter;
            }
            this.isCounterReset = 0;
            this.isHighLightScroll = true;
            isRePaint = true;
        } else if (this.linesToBeDrawn > this.numberOfLinesPerScreen) {
            this.scrollThread_up = true;
            this.isHighLighted = false;
            this.prevHiglightXcoOrdinate = 0;
            this.prevHiglightYcoOrdinate = 0;
            this.yAxis = this.titleImageHeight + 2;
            this.linesToBeDrawn -= this.numberOfLinesPerScreen;
            this.startContentArrayIndex -= this.numberOfLinesPerScreen;
            this.currentHighlightPointer = this.startContentArrayIndex + this.numberOfLinesPerScreen;
            this.currentHighlightSubPointer = 0;
            this.downArrow = true;
            isRePaint = true;
            this.drawOnImage();
            this.yAxis = this.background.getHeight() - this.numberOfLinesPerScreen * this.fontHeight;
            this.createScrollThread();
        } else {
            if (this.currentHighlightPointer > -1) {
                --this.currentHighlightPointer;
            }
            if (this.upArrow) {
                this.upArrow = false;
                isRePaint = true;
            }
            if (this.counter > -1 || this.startContentArrayIndex != 0) {
                isRePaint = true;
            }
            this.yAxis = this.background.getHeight();
            this.isHighLighted = false;
            this.imageCounter = -1;
            this.counter = -1;
        }
        if (isRePaint) {
            this.callPaints();
        }
    }

    private void executeDownKeyEvent() {
        boolean isRePaint = false;
        if (this.canGoForNextHighlight() && this.recordData.urlIHF != null && this.counter < this.recordData.urlIHF.size()) {
            if (this.counter < this.recordData.urlIHF.size() - 1) {
                ++this.counter;
            }
            this.isHighLightScroll = true;
            isRePaint = true;
        } else if (this.linesToBeDrawn < this.totalLines) {
            this.scrollThread_down = true;
            this.isHighLighted = false;
            this.prevHiglightXcoOrdinate = 0;
            this.prevHiglightYcoOrdinate = 0;
            this.linesToBeDrawn += this.numberOfLinesPerScreen;
            this.startContentArrayIndex += this.numberOfLinesPerScreen;
            this.currentHighlightPointer = this.startContentArrayIndex - 1;
            this.currentHighlightSubPointer = 0;
            this.upArrow = true;
            isRePaint = true;
            this.drawOnImage();
            this.yAxis = this.getHeight() - this.background.getHeight();
            this.createScrollThread();
        } else {
            if (this.currentHighlightPointer < this.totalLines) {
                ++this.currentHighlightPointer;
            }
            if (this.downArrow) {
                this.downArrow = false;
            }
            isRePaint = true;
            this.isHighLighted = false;
            this.yAxis = this.background.getHeight();
            if (!this.isHighLightScroll && this.recordData.imageUrl != null && this.imageCounter == this.recordData.imageUrl.length - 1) {
                this.imageCounter = this.recordData.imageUrl.length;
            }
            if (!this.isHighLightScroll && this.recordData.urlIHF != null && this.counter == this.recordData.urlIHF.size() - 1) {
                this.counter = this.recordData.urlIHF.size();
            }
        }
        if (isRePaint) {
            this.callPaints();
        }
    }

    private boolean haveToReturnControl() {
        if (this.scrollThread_up || this.scrollThread_down) {
            return false;
        }
        if (load_flag || this.stopKeyPress == 1) {
            return false;
        }
        if (this.appErrorStr != null) {
            this.cancelAlertMessage(this.recordForm);
            return false;
        }
        if (this.ALERT_TRUE && this.anyKeyChild == 0) {
            this.ALERT_TRUE = false;
            this.callPaints();
            return false;
        }
        return true;
    }

    private void createScrollThread() {
        Thread t;
        this.SCROLL_THREAD = t = new Thread(this);
        this.pageScroll = 1;
        this.drawGray = 1;
        t.start();
    }

    public void run() {
        while (this.scrollThread_down && this.pageScroll == 1) {
            try {
                if (this.yAxis > this.background.getHeight()) {
                    this.yAxis -= this.fontHeight;
                    if (this.yAxis < this.background.getHeight()) {
                        this.yAxis = this.background.getHeight();
                    }
                } else {
                    this.scrollThread_down = false;
                    this.SCROLL_THREAD = null;
                    return;
                }
                this.callPaints();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        while (this.scrollThread_up && this.pageScroll == 1) {
            try {
                if (this.yAxis < this.background.getHeight()) {
                    this.yAxis += this.fontHeight;
                    if (this.yAxis > this.background.getHeight()) {
                        this.yAxis = this.background.getHeight();
                    }
                } else {
                    this.scrollThread_up = false;
                    this.SCROLL_THREAD = null;
                    return;
                }
                this.callPaints();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        while (load_flag && this.loading == 1) {
            this.callPaints();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        while (this.scrolling == 1) {
            try {
                this.callPaints();
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void drawScreenTitle(Graphics g, String title) {
        int adjust = bold.stringWidth("W") * 2;
        int screenTitleY = (this.background.getHeight() - bold.getHeight()) / 2;
        g.setClip(0, 0, this.width, this.background.getHeight());
        g.setFont(bold);
        g.setColor(255, 255, 255);
        for (int i = 0; i < this.getWidth(); ++i) {
            g.drawImage(this.background, i, 0, 0x10 | 4);
        }
        g.setClip(adjust, 0, this.width - adjust * 2, this.background.getHeight());
        g.drawString(this.pageTitle, titleX, 3, 20);
        titleX = titleX + bold.stringWidth(this.pageTitle) - adjust == 0 ? this.width - adjust : (titleX = titleX - 1);
        g.setColor(0);
    }

    private String getImageName(int currentImageIndex) {
        String outputImageName = "";
        String actualImageName = this.recordData.imageUrl[currentImageIndex];
        int index = actualImageName.indexOf(".");
        if (index == -1) {
            index = actualImageName.length();
        }
        String leftSideString = actualImageName.substring(0, index);
        index = leftSideString.lastIndexOf(47) + 1;
        actualImageName = leftSideString.substring(index);
        outputImageName = this.getDisplayableImageName(actualImageName);
        return outputImageName;
    }

    private String getDisplayableImageName(String actualImageName) {
        String outputName = "";
        int widthOfDrawingArea = this.width - 10;
        outputName = "View - " + actualImageName.trim();
        if (normal.stringWidth(outputName) > widthOfDrawingArea) {
            outputName = this.getDotAppendString(widthOfDrawingArea, outputName);
        }
        return outputName;
    }

    private boolean canGoForNextHighlight() {
        boolean result = false;
        int startIteratePosition = this.startContentArrayIndex;
        int startIterateSubPosition = 0;
        if (this.currentHighlightPointer != -1) {
            startIteratePosition = this.currentHighlightPointer + 1;
        }
        if (this.currentHighlightSubPointer != -1) {
            startIterateSubPosition = this.currentHighlightSubPointer + 1;
        }
        for (int i = startIteratePosition; i < this.startContentArrayIndex + this.numberOfLinesPerScreen && i < this.totalLines; ++i) {
            if (this.contentArray[i].equals("-ManiNaveenBhanu")) {
                this.currentHighLighted = 1;
                this.arrayPosition = i;
                this.currentHighlightPointer = i;
                this.setYCoOrdinate(i - this.startContentArrayIndex);
                return true;
            }
            if (this.styleArray[i] == null) continue;
            int[] styleResult = null;
            for (int k = 0; k < this.styleArray[i].length; ++k) {
                styleResult = this.getStylePosition(i, k);
                switch (styleResult[0]) {
                    case 4: {
                        this.currentHighLighted = (byte)4;
                        result = true;
                        this.currentHighlightPointer = i;
                        this.currentHighlightSubPointer = k;
                        this.setYCoOrdinate(i - this.startContentArrayIndex);
                        this.arrayPosition = i;
                        break;
                    }
                    case 5: {
                        if (this.footNotesCounter < this.startFNDetailsVector.size() - 1) {
                            ++this.footNotesCounter;
                        }
                        this.currentHighLighted = (byte)5;
                        result = true;
                        this.currentHighlightPointer = i;
                        this.currentHighlightSubPointer = k;
                        this.setYCoOrdinate(i - this.startContentArrayIndex);
                        this.arrayPosition = i;
                    }
                }
                if (result) break;
            }
            if (result) break;
        }
        return result;
    }

    private boolean canGoForUpHighlight() {
        boolean result = false;
        int startIteratePosition = this.startContentArrayIndex + this.numberOfLinesPerScreen;
        int startIterateSubPosition = 0;
        if (this.currentHighlightPointer == -1) {
            return false;
        }
        if (this.currentHighlightPointer != -1) {
            startIteratePosition = this.currentHighlightPointer - 1;
        }
        if (this.counter == 0 && this.currentHighlightPointer == -1) {
            startIteratePosition = -1;
            this.currentHighlightPointer = 0;
        }
        if (this.currentHighlightSubPointer != -1) {
            startIterateSubPosition = this.currentHighlightSubPointer - 1;
        }
        for (int i = startIteratePosition; i >= this.startContentArrayIndex && i < this.contentArray.length; --i) {
            if (this.contentArray[i].equals("-ManiNaveenBhanu")) {
                this.currentHighLighted = 1;
                this.arrayPosition = i;
                this.currentHighlightPointer = i;
                this.setYCoOrdinate(i - this.startContentArrayIndex);
                return true;
            }
            if (this.styleArray[i] == null) continue;
            int[] styleResult = null;
            if (startIterateSubPosition <= 0 || startIterateSubPosition >= this.styleArray[i].length) {
                startIterateSubPosition = this.styleArray[i].length - 1;
            }
            for (int k = this.styleArray[i].length - 1; k >= 0; --k) {
                styleResult = this.getStylePosition(i, k);
                switch (styleResult[0]) {
                    case 4: {
                        this.currentHighLighted = (byte)4;
                        result = true;
                        this.currentHighlightSubPointer = k;
                        this.currentHighlightPointer = i;
                        this.setYCoOrdinate(i - this.startContentArrayIndex);
                        this.arrayPosition = i;
                        break;
                    }
                    case 5: {
                        if (this.footNotesCounter > 0) {
                            --this.footNotesCounter;
                        }
                        this.currentHighLighted = (byte)5;
                        result = true;
                        this.currentHighlightSubPointer = k;
                        this.currentHighlightPointer = i;
                        this.setYCoOrdinate(i - this.startContentArrayIndex);
                        this.arrayPosition = i;
                    }
                }
                if (result) break;
            }
            if (result) break;
        }
        return result;
    }

    private void setYCoOrdinate(int pos) {
        this.higlightYcoOrdinate = pos * footnotes.getHeight() + this.titleImageHeight + 2;
    }

    private void setStyleFontVectors(String startPoint, String endPoint, char fontType) {
        if (!startPoint.equals("")) {
            while (true) {
                if (startPoint.indexOf(",") != -1) {
                    int index = startPoint.indexOf(",");
                    this.startStylePoint.addElement(startPoint.substring(0, index));
                    if (fontType == 'A') {
                        this.startHyperLinkVector.addElement(startPoint.substring(0, index));
                    }
                    startPoint = startPoint.substring(index + 1);
                    index = endPoint.indexOf(",");
                    String endPointInt = endPoint.substring(0, index);
                    this.lastStyleChar.addElement(endPointInt);
                    if (fontType == 'A') {
                        this.endHyperLinkVector.addElement(endPointInt);
                    }
                    endPoint = endPoint.substring(index + 1);
                } else {
                    if (startPoint.equals("")) break;
                    this.startStylePoint.addElement(startPoint);
                    if (fontType == 'A') {
                        this.startHyperLinkVector.addElement(startPoint);
                    }
                    this.lastStyleChar.addElement(String.valueOf(endPoint));
                    if (fontType == 'A') {
                        this.endHyperLinkVector.addElement(endPoint);
                    }
                    startPoint = "";
                    endPoint = "";
                }
                if (fontType == 'B') {
                    this.fontStyle.addElement(Integer.toString(3));
                    continue;
                }
                if (fontType == 'I') {
                    this.fontStyle.addElement(Integer.toString(2));
                    continue;
                }
                if (fontType == 'A') {
                    this.fontStyle.addElement(Integer.toString(4));
                    continue;
                }
                if (fontType != 'F') continue;
                this.fontStyle.addElement(Integer.toString(5));
            }
        }
    }

    private void shortStyleStartPointVectors() {
        try {
            for (int i = 0; i < this.startStylePoint.size(); ++i) {
                for (int j = i + 1; j < this.startStylePoint.size(); ++j) {
                    int y;
                    Object token = this.startStylePoint.elementAt(i);
                    Object dataInt = this.startStylePoint.elementAt(j);
                    int x = Integer.parseInt(token.toString());
                    if (x <= (y = Integer.parseInt(dataInt.toString()))) continue;
                    Object object = this.startStylePoint.elementAt(j);
                    this.startStylePoint.setElementAt(this.startStylePoint.elementAt(i), j);
                    this.startStylePoint.setElementAt(object, i);
                    object = this.lastStyleChar.elementAt(j);
                    this.lastStyleChar.setElementAt(this.lastStyleChar.elementAt(i), j);
                    this.lastStyleChar.setElementAt(object, i);
                    object = this.fontStyle.elementAt(j);
                    this.fontStyle.setElementAt(this.fontStyle.elementAt(i), j);
                    this.fontStyle.setElementAt(object, i);
                }
            }
        }
        catch (Error e) {
            // empty catch block
        }
    }

    private void shortHyperLinkVector() {
        for (int i = 0; i < this.startHyperLinkVector.size(); ++i) {
            int iValue = Integer.parseInt((String)this.startHyperLinkVector.elementAt(i));
            for (int j = i + 1; j < this.startHyperLinkVector.size(); ++j) {
                if (iValue <= Integer.parseInt((String)this.startHyperLinkVector.elementAt(j))) continue;
                Object object = this.startHyperLinkVector.elementAt(j);
                this.startHyperLinkVector.setElementAt(this.startHyperLinkVector.elementAt(i), j);
                this.startHyperLinkVector.setElementAt(object, i);
                object = this.endHyperLinkVector.elementAt(j);
                this.endHyperLinkVector.setElementAt(this.endHyperLinkVector.elementAt(i), j);
                this.endHyperLinkVector.setElementAt(object, i);
            }
        }
    }

    private void wrap(String stringData) {
        Vector<String> lineVector = new Vector<String>();
        WrapLine.imageposition = 0;
        Vector<Vector> finalStyleVector = new Vector<Vector>();
        Vector<Object> image = new Vector<Object>();
        image.addElement(null);
        WrapLine wrapLine = new WrapLine(stringData, this.width, this.startStylePoint, this.lastStyleChar, this.fontStyle);
        this.startStylePoint = null;
        this.lastStyleChar = null;
        this.fontStyle = null;
        MobiStatic.cleanUpGc();
        String tempWrap = "";
        while (true) {
            if (!wrapLine.hasMoreElements()) {
                if (this.startImageVector.size() <= 0) break;
                if (Integer.parseInt((String)this.startImageVector.lastElement()) != WrapLine.imageposition) break;
            }
            System.gc();
            Runtime.getRuntime().gc();
            if (this.startImageVector.indexOf(WrapLine.imageposition + "") != -1) {
                tempWrap = "-ManiNaveenBhanu";
                lineVector.addElement(tempWrap);
                finalStyleVector.addElement(image);
                WrapLine.imageposition = (short)(WrapLine.imageposition + 1);
                continue;
            }
            tempWrap = wrapLine.nextElement().toString();
            finalStyleVector.addElement(wrapLine.getStyleVector());
            lineVector.addElement(tempWrap);
        }
        while (lineVector.lastElement().equals("")) {
            lineVector.removeElementAt(lineVector.size() - 1);
        }
        this.contentArray = new String[lineVector.size()];
        this.createStyleArray(finalStyleVector);
        lineVector.copyInto(this.contentArray);
        finalStyleVector = null;
        lineVector = null;
        wrapLine = null;
        MobiStatic.cleanUpGc();
    }

    private void createStyleArray(Vector finalStyleVector) {
        this.styleArray = new String[finalStyleVector.size()][];
        if (finalStyleVector != null) {
            for (int i = 0; i < finalStyleVector.size(); ++i) {
                if (null != (Vector)finalStyleVector.elementAt(i)) {
                    this.styleArray[i] = new String[((Vector)finalStyleVector.elementAt(i)).size()];
                }
                for (int j = 0; j < ((Vector)finalStyleVector.elementAt(i)).size(); ++j) {
                    if (null == (Vector)finalStyleVector.elementAt(i)) continue;
                    if (null != ((Vector)finalStyleVector.elementAt(i)).elementAt(j)) {
                        this.styleArray[i][j] = ((Vector)finalStyleVector.elementAt(i)).elementAt(j).toString();
                        continue;
                    }
                    this.styleArray[i] = null;
                }
            }
        }
    }

    private void setImageVector(String startImage) {
        if (this.recordData.isImageExist() && !startImage.equals("")) {
            while (true) {
                if (startImage.indexOf(",") != -1) {
                    int index = startImage.indexOf(",");
                    this.startImageVector.addElement(startImage.substring(0, index));
                    startImage = startImage.substring(index + 1);
                    continue;
                }
                if (startImage.equals("")) break;
                this.startImageVector.addElement(startImage);
                startImage = "";
            }
            if (this.startImageVector.elementAt(0).equals("1")) {
                this.stringData = "  " + this.stringData;
                this.stringLength += 2;
            }
        }
    }

    public int getCurrentFocused() {
        return this.currentHighLighted;
    }

    public int getFootNoteDetailsIndex() {
        int output = 0;
        int innerCounter = this.startFNDetailsVector.size() - 1;
        boolean isBreak = false;
        for (int i = this.styleArray.length - 1; i >= 0; --i) {
            if (this.styleArray[i] == null) continue;
            for (int j = this.styleArray[i].length - 1; j >= 0; --j) {
                if (!this.styleArray[i][j].substring(0, this.styleArray[i][j].indexOf("|")).equals(String.valueOf(7))) continue;
                if (this.footNotesCounter == innerCounter) {
                    output = i;
                    isBreak = true;
                    break;
                }
                --innerCounter;
            }
            if (isBreak) break;
        }
        return output;
    }

    public void showFootNoteDetails(int arrayIndex) {
        int linesCounter = 0;
        int count = 1;
        while (arrayIndex >= (linesCounter = count * this.numberOfLinesPerScreen)) {
            ++count;
        }
        if (this.linesToBeDrawn < this.totalLines && (count -= this.linesToBeDrawn / this.numberOfLinesPerScreen) > 0) {
            this.scrollThread_down = true;
            this.prevHiglightXcoOrdinate = 0;
            this.prevHiglightYcoOrdinate = 0;
            this.createScrollThread();
            this.linesToBeDrawn += this.numberOfLinesPerScreen * count;
            this.startContentArrayIndex += this.numberOfLinesPerScreen * count;
            this.currentHighlightPointer = this.startContentArrayIndex - 1;
            this.currentHighlightSubPointer = 0;
            this.upArrow = true;
        }
    }

    public void setPreviousPage() {
        if (this.rightString.equals("Cancel")) {
            this.executeRSKPopUp();
            MobiStatic.cleanUpGc();
        } else {
            this.isComingFromViewer = true;
            this.yAxis = this.background.getHeight();
            this.titleThread = new Thread(this);
            this.loading = 0;
            this.load_thread = true;
            this.scrolling = 1;
            this.callPaints();
        }
    }

    public Image getDataImage() {
        return this.bufferImage;
    }
}

