/*
 * Decompiled with CFR 0.152.
 */
package mobi.forms;

import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import mobi.forms.MidpForm;
import mobi.items.MenuItem;
import mobi.midp.MobiStatic;
import mobi.util.GetData;
import mobi.util.TimeOutException;

public class SubjectsMainForm
extends MidpForm
implements Runnable {
    static String titleId;
    static Vector subjects;
    static Vector ids;
    static String next;
    static int iteration;
    static boolean haveNames;

    public SubjectsMainForm(String mobi, boolean isBack) {
        this.mobiString = mobi;
        this.isBack = isBack;
    }

    public int getIteration() {
        return iteration;
    }

    public void run() {
        if (!this.isBack) {
            Hashtable hashtable;
            iteration = 0;
            String url = MobiStatic.createUrl(this.getMobiAction(), this.midp);
            GetData getData = new GetData();
            try {
                hashtable = getData.getDataHash(url, new String[]{"subjects", "ids", "footnote", "names"});
            }
            catch (Exception e) {
                this.handleError(e);
                return;
            }
            ids = (Vector)hashtable.remove("ids");
            subjects = (Vector)hashtable.remove("subjects");
            haveNames = false;
            if (subjects == null) {
                haveNames = true;
                subjects = (Vector)hashtable.remove("names");
            }
            if (hashtable != null && hashtable.size() != 0) {
                this.midp.setHashtable(hashtable);
            }
            if (hashtable.get("next") != null) {
                next = hashtable.get("next").toString();
            }
        }
    }

    public void commandAction(int priority) {
        if (this.inCommand) {
            return;
        }
        this.inCommand = true;
        if (priority == 0) {
            this.handleCommand(this.menuItem.getSelection());
        } else {
            super.commandAction(priority);
        }
    }

    public void handleCommand(int selection) {
        if (this.menuItem.menuSize() == 10 && selection == 9) {
            ++iteration;
            this.midp.nextForm(this.getMobiAction());
        } else {
            if (selection >= this.menuItem.menuSize()) {
                this.inCommand = false;
                this.menuItem.cancelAction();
                return;
            }
            int selected = selection + iteration * 9;
            this.midp.getHashtable().remove("iteration");
            this.midp.getHashtable().remove("title");
            this.midp.getHashtable().remove("recordsLeft");
            this.midp.getHashtable().put("next", next);
            this.midp.getHashtable().put(haveNames ? "recordId" : "subjectId", ids.elementAt(selected));
            Thread t = new Thread(this.midp);
            t.start();
        }
    }

    public String getMobiAction() {
        return "subjectsMain.mobi";
    }

    public void createForm() {
        if (!this.runDataThread(this)) {
            this.handleError(new TimeOutException(14));
        }
        if (this.handledError) {
            return;
        }
        if (this.midp.getHashtable().get("data") != null) {
            this.midp.setJumpedFlag();
            this.midp.getHashtable().put("next", "record.mobi");
            Thread t = new Thread(this.midp);
            t.start();
            return;
        }
        String[] array = this.processVector(subjects, iteration);
        this.menuItem = new MenuItem(array, this);
        this.menuItem.addCommand(this.submitCommand);
        this.menuItem.addCommand(this.backCommand);
        this.menuItem.setCommandListener(this);
        this.midp.getDisplay().setCurrent((Displayable)this.menuItem);
    }

    public void decrementIteration() {
        --iteration;
    }

    public void incrementIteration() {
        ++iteration;
    }

    static {
        iteration = 0;
        haveNames = false;
    }
}

