/*
 * Decompiled with CFR 0.152.
 */
package mobi.forms;

import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import mobi.data.RecordDataSave;
import mobi.forms.MidpForm;
import mobi.items.RecordData;
import mobi.items.RecordItem;
import mobi.midp.MobiStatic;
import mobi.util.GetData;
import mobi.util.ResourceBundle;
import mobi.util.TimeOutException;

public class RecordForm
extends MidpForm
implements Runnable {
    public static final int MAX_BACK_RECORDS = 15;
    static String titleId;
    static Vector nextBackVector;
    static String subjectId;
    static String categoryId;
    String title;
    Integer nextRecordId;
    RecordItem recordItem = null;
    String data;
    String currentMobi = "";
    RecordData recordData;
    String recordId;
    static String recordIteration;

    public RecordForm(String mobi, boolean isBack) {
        this.mobiString = mobi;
        this.isBack = isBack;
    }

    public void run() {
        String urlStr;
        if (this.handledError) {
            return;
        }
        if ("about.mobi".equals(this.midp.getHashtable().get("next"))) {
            urlStr = "about.mobi";
        } else if ("help.mobi".equals(this.midp.getHashtable().get("next"))) {
            urlStr = "help.mobi";
        } else if ("titlesDrmFormatted.mobi".equals(this.midp.getHashtable().get("next"))) {
            urlStr = "titlesDrmFormatted.mobi";
            try {
                this.checkAndGetDrm();
            }
            catch (Exception e) {
                this.handleError(e);
                return;
            }
            this.midp.getHashtable().put("drms", this.getDrms());
        } else {
            urlStr = "record.mobi";
        }
        this.currentMobi = urlStr;
        if (this.data != null) {
            return;
        }
        if (this.midp.getHashtable().remove("backToRecord") != null) {
            this.recreateFromVector();
            return;
        }
        if (this.midp.getHashtable().get("data") != null) {
            this.data = (String)this.midp.getHashtable().get("data");
            Object obj = this.midp.getHashtable().remove("nextRecordId");
            if (obj != null) {
                this.nextRecordId = Integer.valueOf(obj.toString());
            }
            this.recordId = (String)this.midp.getHashtable().remove("recordId");
            this.recordData = new RecordData(this.midp.getHashtable());
            return;
        }
        this.midp.getHashtable().remove("title");
        if (this.midp.getHashtable().get("subjectId") != null) {
            subjectId = (String)this.midp.getHashtable().get("subjectId");
        }
        if (this.midp.getHashtable().get("categoryId") != null) {
            categoryId = (String)this.midp.getHashtable().get("categoryId");
        }
        if (this.midp.getHashtable().get("recordId") == null && categoryId != null && subjectId != null) {
            this.midp.getHashtable().put("categoryId", categoryId);
            this.midp.getHashtable().put("subjectId", subjectId);
        }
        this.midp.getHashtable().remove("subjectsMain");
        this.midp.getHashtable().remove("subject");
        String url = MobiStatic.createUrl(urlStr, this.midp);
        GetData getData = new GetData();
        try {
            getData.getData(url);
        }
        catch (Exception e) {
            this.handleError(e);
            return;
        }
        this.midp.setHashtable(getData.getHashtable());
        Object obj = this.midp.getHashtable().remove("nextRecordId");
        if (obj != null) {
            this.nextRecordId = Integer.valueOf(obj.toString());
        }
        this.recordId = (String)this.midp.getHashtable().remove("recordId");
        this.recordData = new RecordData(this.midp.getHashtable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(int priority) {
        try {
            if (this.inCommand) {
                return;
            }
            this.inCommand = true;
            if (priority == 1) {
                if (this.nextRecordId == null) {
                    this.recordItem.ALERT_TRUE = true;
                    this.recordItem.callPaints();
                    return;
                }
                this.executeNext(this.nextRecordId);
            } else if (priority == 5) {
                this.commandVector.removeAllElements();
                this.constantVector.removeAllElements();
                if (nextBackVector != null && nextBackVector.size() > 0) {
                    this.recreateFromVector();
                    this.createForm();
                    this.inCommand = false;
                } else {
                    RecordForm.clearNextBackVector();
                    super.commandAction(priority);
                }
            } else if (priority == 10) {
                RecordForm.clearNextBackVector();
                super.commandAction(priority);
            } else if (priority == 12) {
                RecordForm.clearNextBackVector();
                this.midp.getHashtable().put("next", "menu.mobi");
                Thread t = new Thread(this.midp);
                t.start();
            } else if (priority == 14) {
                this.addFormToVector();
                this.midp.getHashtable().put("title", this.title);
                this.midp.getHashtable().put("recordId", this.recordId);
                this.midp.getHashtable().put("next", "bookmark.mobi");
                Thread t = new Thread(this.midp);
                t.start();
            } else if (priority == 15) {
                Integer[] linkUps = this.recordData.getLinkUps();
                int highlightedLinkUps = this.recordItem.gethighlightedLinkUps();
                if (this.recordItem.getisLinkUpShown() && linkUps[highlightedLinkUps] == null) {
                    return;
                }
                this.executeNext(linkUps[highlightedLinkUps]);
            }
        }
        finally {
            this.inCommand = false;
        }
    }

    public void recreateFromVector() {
        String temp = "";
        RecordDataSave save = (RecordDataSave)nextBackVector.lastElement();
        this.data = save.data;
        this.recordData = save.recordData;
        this.title = save.title;
        this.nextRecordId = save.nextRecordId;
        this.recordId = save.recordId;
        temp = this.getIteration((String)this.midp.getHashtable().get("iteration"));
        this.midp.getHashtable().put("iteration", temp);
        nextBackVector.removeElement(save);
    }

    String getIteration(String iteration) {
        try {
            return Integer.toString(Integer.parseInt(iteration) - 1);
        }
        catch (NumberFormatException e) {
            return recordIteration != null ? recordIteration : "";
        }
    }

    public void createForm() {
        if (!this.runDataThread(this)) {
            this.handleError(new TimeOutException(1));
        }
        if (this.handledError) {
            this.inCommand = false;
            this.handledError = false;
            this.commandAction(5);
            return;
        }
        if (this.data == null) {
            this.data = (String)this.midp.getHashtable().get("data");
        }
        if (this.title == null) {
            this.title = (String)this.midp.getHashtable().get("pageTitle");
        }
        if (this.currentMobi.equals("about.mobi")) {
            this.title = ResourceBundle.get("about");
        } else if (this.currentMobi.equals("help.mobi")) {
            this.title = ResourceBundle.get("help");
        } else if (this.currentMobi.equals("titlesDrmFormatted.mobi")) {
            this.title = ResourceBundle.get("license_details");
        }
        try {
            this.recordItem = new RecordItem(this.data, this.recordData, this, this.title);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (!(this.currentMobi.equals("about.mobi") || this.currentMobi.equals("help.mobi") || this.currentMobi.equals("titlesDrmFormatted.mobi"))) {
            Command nextCommand = new Command(ResourceBundle.get("next"), 4, 1);
            if (this.nextRecordId != null) {
                this.recordItem.addCommand(nextCommand);
            }
            this.recordItem.addCommand(this.backCommand);
        } else {
            this.recordItem.addCommand(this.mainMenuCommand);
        }
        if (this.recordData.getACount() > 0) {
            // empty if block
        }
        this.recordItem.setCommandListener(this);
        this.midp.getDisplay().setCurrent((Displayable)this.recordItem);
        this.midp.getHashtable().remove("data");
    }

    static void clearNextBackVector() {
        nextBackVector = null;
    }

    private void addFormToVector() {
        Object obj;
        if (nextBackVector == null) {
            nextBackVector = new Vector();
        }
        nextBackVector.addElement(new RecordDataSave(this.data, this.recordData, this.title, this.nextRecordId, this.recordId));
        if (nextBackVector.size() > 15) {
            nextBackVector.removeElementAt(0);
        }
        if ((obj = this.midp.getHashtable().get("iteration")) != null) {
            recordIteration = obj.toString();
        }
    }

    public void executeNext(Integer recordId) {
        this.midp.getHashtable().remove("title");
        this.midp.getHashtable().put("recordId", recordId.toString());
        this.midp.getHashtable().put("next", "record.mobi");
        this.addFormToVector();
        Thread thread = new Thread(this.midp);
        thread.start();
    }

    public String getMobiAction() {
        return "record.mobi";
    }
}

