/*
 * Decompiled with CFR 0.152.
 */
package mobi.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import mobi.midp.MobiStatic;
import mobi.util.MobiIoException;
import mobi.util.ResourceBundle;
import mobi.util.ResponseCodeException;
import mobi.util.WrongTypeException;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class GetXml {
    public static final int RESPONSE_NOT_VALID = -1;
    public static String connectionStatus = "Connecting...";
    private static HttpConnection connection;
    String url;
    String xml;
    InputStream inputStream;
    private String errorString;
    private int responseCode;

    public GetXml(String url) {
        char sep = url.indexOf(63) == -1 ? (char)'?' : '&';
        this.url = url + sep + "xml=true";
    }

    public String getErrorString() {
        return this.errorString;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    private void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getXml() {
        return this.xml;
    }

    public void closeConnection() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
                this.inputStream = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected InputStream doGet() throws IOException, ResponseCodeException {
        connectionStatus = "Connecting...";
        connection = (HttpConnection)Connector.open((String)this.url);
        connectionStatus = "Connected";
        this.setConnection("GET");
        this.setResponseCode(connection.getResponseCode());
        if (this.responseCode != 200) {
            throw new ResponseCodeException(connection.getResponseMessage(), this.responseCode, 7);
        }
        connectionStatus = "Connected";
        if (!connection.getType().startsWith("text/xml")) {
            throw new ResponseCodeException("wrong type " + connection.getType(), this.responseCode, 9);
        }
        this.inputStream = connection.openInputStream();
        return this.inputStream;
    }

    public KXmlParser getViaHttpConnection() throws XmlPullParserException, ResponseCodeException, WrongTypeException, MobiIoException {
        if (this.url.indexOf("help.mobi") > -1) {
            this.url = ResourceBundle.get("url") + "/j2me/help/helpj2me" + "1.0" + ".jsp?";
        } else if (this.url.indexOf("about.mobi") > -1) {
            this.url = ResourceBundle.get("url") + "/j2me/about/aboutj2me" + "1.0" + "_" + 14 + ".jsp?" + this.makeURL();
        }
        connectionStatus = ResourceBundle.get("before_connection");
        try {
            this.inputStream = this.doPost();
        }
        catch (IOException e) {
            throw new MobiIoException(e.getMessage(), 20);
        }
        connectionStatus = ResourceBundle.get("data_received");
        KXmlParser parser = new KXmlParser();
        parser.setInput(this.inputStream, "UTF-8");
        try {
            parser.nextTag();
        }
        catch (IOException e) {
            throw new MobiIoException(e.getMessage(), 21);
        }
        return parser;
    }

    private String makeURL() {
        StringBuffer buf = new StringBuffer("midletname=" + MobiStatic.appName);
        StringBuffer data = new StringBuffer();
        for (int x = 0; x < buf.length(); ++x) {
            if (buf.charAt(x) == ' ') {
                data.append("%20");
                continue;
            }
            if (buf.charAt(x) == '#') {
                data.append("%23");
                continue;
            }
            if (buf.charAt(x) == '&') {
                data.append("%26");
                continue;
            }
            if (buf.charAt(x) == ':') {
                data.append("%3a");
                continue;
            }
            if (buf.charAt(x) == ',') {
                data.append("%3C");
                continue;
            }
            data.append(buf.charAt(x));
        }
        return data.toString();
    }

    protected InputStream doPost() throws IOException, ResponseCodeException, WrongTypeException {
        String queryString;
        int marker = this.url.indexOf(63) + 1;
        if (marker != -1) {
            queryString = this.url.substring(marker);
            if (this.url.indexOf("searchData.mobi") != -1) {
                queryString = queryString + "&searchType=name";
            }
        } else {
            queryString = null;
        }
        connectionStatus = ResourceBundle.get("about_to_connect");
        connection = (HttpConnection)Connector.open((String)this.url.substring(0, this.url.indexOf("?")), (int)3);
        this.setConnection("POST");
        OutputStream outputStream = connection.openOutputStream();
        connectionStatus = ResourceBundle.get("connection_success");
        if (queryString != null) {
            outputStream.write(queryString.getBytes());
        }
        this.setResponseCode(connection.getResponseCode());
        if (this.responseCode != 200) {
            throw new ResponseCodeException(connection.getResponseMessage(), this.responseCode, 5);
        }
        connectionStatus = ResourceBundle.get("connection_success");
        this.inputStream = connection.openInputStream();
        connectionStatus = ResourceBundle.get("connection_success");
        outputStream.close();
        outputStream = null;
        return this.inputStream;
    }

    private void setConnection(String type) throws IOException {
        connection.setRequestMethod(type);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
    }
}

