/*
 * Decompiled with CFR 0.152.
 */
package mobi.data;

import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStoreException;
import mobi.data.MobiStore;
import mobi.util.ResourceBundle;

public class AutoDrmRecordStore
extends MobiStore {
    String drmKey;

    public String getDrmKey() {
        return this.drmKey;
    }

    public boolean needUpdate() {
        this.drmKey = ResourceBundle.getNull("auto_drm");
        if (this.drmKey == null) {
            return false;
        }
        try {
            return !this.haveAutoDrm(this.drmKey);
        }
        catch (RecordStoreException e) {
            return false;
        }
    }

    public void add(String drmString) throws RecordStoreException {
        byte[] bytes = drmString.getBytes();
        this.recordStore.addRecord(bytes, 0, bytes.length);
    }

    public boolean haveAutoDrm(String autoDrm) throws RecordStoreException {
        RecordEnumeration enumeration = this.getEnumeration();
        while (enumeration.hasNextElement()) {
            String key = new String(enumeration.nextRecord());
            if (!key.equals(autoDrm)) continue;
            return true;
        }
        return false;
    }

    String getStoreName() {
        return "auto_drm";
    }

    boolean isShared() {
        return false;
    }
}

