/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.AppCanvas;
import Kartmania.Application;
import Kartmania.CGTrack;
import Kartmania.CarEngine2D;
import Kartmania.EndHotSeatGameState;
import Kartmania.GetReadyHSGameState;
import Kartmania.HUD;
import Kartmania.IGameState;
import Kartmania.InGameMainMenu;
import Kartmania.LoadingProgress;
import Kartmania.ObjectsCache;
import Kartmania.RaceGameState;
import Kartmania.SelectGameMode;
import Kartmania.SelectHSPlayers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Game {
    public static final int MAX_NUMBER_OF_PLAYERS = 4;
    public static final int TOURNAMENT_TYPE_TIMEATTACK = 1;
    public static final int TOURNAMENT_TYPE_SINGLE_COMPETITION = 2;
    public static final int TOURNAMENT_TYPE_CHAMPIONSHIPS = 3;
    public static final int TOURNAMENT_TYPE_BLUETOOTH = 4;
    public static final int TOURNAMENT_TYPE_HOT_SEAT = 5;
    public static final int[] positionToPoints = new int[]{5, 3, 1, 0};
    public static final int[] m_PointsForPos = new int[]{20, 14, 10, 7, 5, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static int[] championshipRanking = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static int[] championshipSortIndexRanking = new int[12];
    public static final int MAX_NUM_KARTS = 4;
    public static final int MENU3DSCENERY_TRACK = 0;
    public static final int MENU3DSCENERY_GARAGE = 1;
    public static int menuScenery = 0;
    public static boolean stopAndGo = false;
    public static int maxNumLaps = 0;
    public static int currentTrackID;
    public static int currentTrackMode;
    public static int careerTrackID;
    public static int careerGender;
    private boolean gamePaused = false;
    public static boolean netGameRuning;
    public static int timeMultiplayer;
    public IGameState currentGameState = null;
    public static boolean upTouchKeyPressed;
    public static boolean downTouchKeyPressed;
    public static boolean leftTouchKeyPressed;
    public static boolean rightTouchKeyPressed;
    public static String[] levelNames;
    long lastTimeSendPacket = 0L;

    public static void setMenuScenery(int id) {
        menuScenery = id;
    }

    public static void careerReset() {
        careerGender = 0;
        careerTrackID = -1;
        Game.ResetChampionshipRanking();
    }

    public static boolean isChampionshipsFinished() {
        System.out.println("isChampionshipsFinished: " + careerTrackID + " == " + 12);
        return careerTrackID == 12;
    }

    public static int getLeagueFromTrackID(int track) {
        if (track > 4 && track <= 10) {
            return 1;
        }
        if (track > 10 && track <= 17) {
            return 2;
        }
        if (track > 17) {
            return 3;
        }
        return 0;
    }

    public static long getHumanCareerPower() {
        if (careerTrackID > 4 && careerTrackID <= 10) {
            return 2048000L;
        }
        if (careerTrackID > 10 && careerTrackID <= 17) {
            return 1925120L;
        }
        return 0x212000L;
    }

    public static void ResetChampionshipRanking() {
        for (int i = 0; i < 12; ++i) {
            Game.championshipRanking[i] = 0;
        }
        careerTrackID = -1;
    }

    public static void SortChampionshipRanking() {
        int nSize = 12;
        int[] m_TmpTimeArray = new int[12];
        for (int i = 0; i < nSize; ++i) {
            m_TmpTimeArray[i] = championshipRanking[i];
        }
        championshipSortIndexRanking = new int[nSize];
        for (int j = 0; j < nSize; ++j) {
            int nMinValue = m_TmpTimeArray[0];
            int nMinIndex = 0;
            for (int i = 1; i < nSize; ++i) {
                if (m_TmpTimeArray[i] <= nMinValue) continue;
                nMinValue = m_TmpTimeArray[i];
                nMinIndex = i;
            }
            Game.championshipSortIndexRanking[j] = nMinIndex;
            m_TmpTimeArray[nMinIndex] = -10;
        }
        m_TmpTimeArray = null;
        System.out.println("End sort...");
    }

    public static int GetHumanIndexForChampionshipRankingPos() {
        Game.SortChampionshipRanking();
        for (int i = 0; i < 12; ++i) {
            if (championshipSortIndexRanking[i] != 0) continue;
            return i;
        }
        return -1;
    }

    public void draw2D(Graphics g) {
        if (Application.getGame() == null) {
            return;
        }
        if (Application.getGame().isGamePaused()) {
            // empty if block
        }
    }

    public static void storeGame() throws RecordStoreException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Game.serialize(new DataOutputStream(baos));
        RecordStore recordStore = RecordStore.openRecordStore((String)"GameState", (boolean)true);
        byte[] rawData = baos.toByteArray();
        if (recordStore.getNumRecords() != 0) {
            recordStore.setRecord(1, rawData, 0, rawData.length);
        } else {
            recordStore.addRecord(rawData, 0, rawData.length);
        }
        recordStore.closeRecordStore();
    }

    public static void restoreGame() throws RecordStoreException, IOException {
        RecordStore recordStore = RecordStore.openRecordStore((String)"GameState", (boolean)true);
        if (recordStore != null && recordStore.getNumRecords() != 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(recordStore.getRecord(1));
            DataInputStream dis = new DataInputStream(bais);
            Game.deSerialize(dis);
        }
        recordStore.closeRecordStore();
    }

    private static void serialize(DataOutputStream dos) throws IOException {
        dos.writeInt(careerGender);
        dos.writeInt(careerTrackID);
        for (int i = 0; i < 12; ++i) {
            dos.writeInt(championshipRanking[i]);
        }
    }

    private static void deSerialize(DataInputStream dis) throws IOException {
        careerGender = dis.readInt();
        careerTrackID = dis.readInt();
        for (int i = 0; i < 12; ++i) {
            Game.championshipRanking[i] = dis.readInt();
        }
    }

    public void init(int trackID, int trackMode) {
        try {
            currentTrackMode = trackMode;
            currentTrackID = trackID;
            this.initializeCompetition();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initializeCompetition() {
        stopAndGo = false;
        switch (SelectGameMode.selectedGameMode) {
            case 2: {
                Application.testApp.PrepareFinishTimes(CarEngine2D.m_MinTimeAI[currentTrackID], CarEngine2D.m_MaxTimeAI[currentTrackID]);
                Application.testApp.m_nNrOfPlayers = 1;
                Application.testApp.m_nCurrentPlayer = 0;
                LoadingProgress.StepProgress();
                this.createSingleCompetition(1);
                break;
            }
            case 3: {
                Application.testApp.PrepareFinishTimes(CarEngine2D.m_MinTimeAI[currentTrackID], CarEngine2D.m_MaxTimeAI[currentTrackID]);
                Application.testApp.m_nNrOfPlayers = 1;
                Application.testApp.m_nCurrentPlayer = 0;
                LoadingProgress.StepProgress();
                this.createChampionships(1);
                break;
            }
            case 5: {
                Application.testApp.PrepareFinishTimes(50000, 70000);
                Application.testApp.m_nNrOfPlayers = SelectHSPlayers.numHSplayers;
                Application.testApp.m_nCurrentPlayer = 0;
                EndHotSeatGameState.HSplayerID = 0;
                LoadingProgress.StepProgress();
                this.createHotSeat(1);
                break;
            }
            default: {
                System.out.println("Error in initializeCompetition...");
            }
        }
    }

    public void createHotSeat(int nLoad) {
        maxNumLaps = 1;
        long fxPower = 4096L;
        long fxNitro = 4096L;
        long fxHandling = 4096L;
        CGTrack.m_bInvertTrackFlag = currentTrackID % 2 > 0;
        if (nLoad > 0) {
            LoadingProgress.StepProgress();
            Application.testApp.Load(levelNames[currentTrackID], currentTrackID);
        } else {
            LoadingProgress.StepProgress();
            Application.testApp.AfterLoad();
        }
        Application.testApp.m_nTranslateScreenY = 0;
        Application.testApp.SetupBolids(0);
        Application.testApp.GetBolid(0).SetPowerFactorHuman(4096L + 5L * fxPower / 10L);
        Application.testApp.GetBolid(0).SetNitroFactorHuman(5324L + 4L * fxNitro / 10L);
        Application.testApp.GetBolid(0).SetHandlingFactorHuman(4096L + 12L * fxHandling / 10L);
        LoadingProgress.StepProgress();
        Application.testApp.SetupLaps(maxNumLaps);
    }

    public void createSingleCompetition(int nLoad) {
        maxNumLaps = 1;
        long fxPower = 4096L;
        long fxNitro = 4096L;
        long fxHandling = 4096L;
        CGTrack.m_bInvertTrackFlag = currentTrackID % 2 > 0;
        if (nLoad > 0) {
            LoadingProgress.StepProgress();
            Application.testApp.Load(levelNames[currentTrackID], currentTrackID);
        } else {
            LoadingProgress.StepProgress();
            Application.testApp.AfterLoad();
        }
        Application.testApp.m_nTranslateScreenY = 0;
        Application.testApp.SetupBolids(0);
        Application.testApp.GetBolid(0).SetPowerFactorHuman(4096L + 5L * fxPower / 10L);
        Application.testApp.GetBolid(0).SetNitroFactorHuman(5324L + 4L * fxNitro / 10L);
        Application.testApp.GetBolid(0).SetHandlingFactorHuman(4096L + 100L * fxHandling / 10L);
        LoadingProgress.StepProgress();
        Application.testApp.SetupLaps(maxNumLaps);
    }

    public void createChampionships(int nLoad) {
        maxNumLaps = 1;
        long fxPower = 4096L;
        long fxNitro = 4096L;
        long fxHandling = 4096L;
        CGTrack.m_bInvertTrackFlag = currentTrackID % 2 > 0;
        if (nLoad > 0) {
            LoadingProgress.StepProgress();
            Application.testApp.Load(levelNames[currentTrackID], currentTrackID);
        } else {
            LoadingProgress.StepProgress();
            Application.testApp.AfterLoad();
        }
        Application.testApp.m_nTranslateScreenY = 0;
        Application.testApp.SetupBolids(0);
        Application.testApp.GetBolid(0).SetPowerFactorHuman(4096L + 5L * fxPower / 10L);
        Application.testApp.GetBolid(0).SetNitroFactorHuman(5324L + 4L * fxNitro / 10L);
        Application.testApp.GetBolid(0).SetHandlingFactorHuman(4096L + 12L * fxHandling / 10L);
        LoadingProgress.StepProgress();
        Application.testApp.SetupLaps(maxNumLaps);
    }

    public void pauseGame() {
        this.gamePaused = true;
    }

    public void resumeGame() {
        this.gamePaused = false;
        downTouchKeyPressed = false;
        leftTouchKeyPressed = false;
        rightTouchKeyPressed = false;
    }

    public boolean isGamePaused() {
        return this.gamePaused;
    }

    public void startGame() {
        if (SelectGameMode.selectedGameMode == 5) {
            this.EnterState(new GetReadyHSGameState(currentTrackID, currentTrackMode, 1));
        } else {
            this.EnterState(new GetReadyHSGameState(currentTrackID, currentTrackMode, Application.testApp.m_nCurrentPlayer));
        }
        downTouchKeyPressed = false;
        leftTouchKeyPressed = false;
        rightTouchKeyPressed = false;
    }

    public void continueGame() {
        this.EnterState(new RaceGameState(currentTrackID));
        downTouchKeyPressed = false;
        leftTouchKeyPressed = false;
        rightTouchKeyPressed = false;
    }

    public Game(int trackID, int trackMode) {
        if (trackID >= 0 && trackMode >= 0) {
            this.initAppCanvas(trackID, trackMode);
        }
    }

    public void initAppCanvas(int trackID, int trackMode) {
        try {
            this.init(trackID, trackMode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moveToTrack(int trackID, int trackMode) {
        currentTrackMode = trackMode;
        currentTrackID = trackID;
        try {
            this.pauseGame();
            this.init(trackID, trackMode);
            Application.getApplication().getMenu().setCurrentUIScreen(null);
            this.resumeGame();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void EnterState(IGameState newGameState) {
        if (this.currentGameState != null) {
            this.currentGameState.OnLeave();
        }
        newGameState.OnEnter();
        this.currentGameState = newGameState;
    }

    public void processCommands() {
        AppCanvas.GameCommand cmd = null;
        try {
            while ((cmd = Application.gameCanvas.getCommand()) != null) {
                if (cmd.touchX < 0 && cmd.touchY < 0) {
                    if (!cmd.pressed) {
                        if (this.currentGameState == null) continue;
                        this.currentGameState.OnKeyReleased(cmd.keyCode);
                        continue;
                    }
                    if (this.currentGameState == null) continue;
                    this.currentGameState.OnKeyPressed(cmd.keyCode);
                    continue;
                }
                if (cmd.pressed) {
                    if (cmd.touchX > Application.screenWidth - ObjectsCache.menuSbOK.getWidth() && cmd.touchY > Application.screenHeight - ObjectsCache.menuSbOK.getHeight()) {
                        this.askAbortToMainMenu();
                        return;
                    }
                    if (Application.testApp.m_nGameState == 0) {
                        if (this.currentGameState != null) {
                            System.out.println("KEY_NUM8...");
                            this.currentGameState.OnKeyReleased(56);
                        }
                        return;
                    }
                    if (cmd.touchX > Application.screenWidth - ObjectsCache.menuSbOK.getWidth() && cmd.touchY > Application.screenHeight - ObjectsCache.menuSbOK.getHeight()) {
                        this.askAbortToMainMenu();
                    }
                    if (cmd.touchX >= HUD.nitroIconX && cmd.touchY >= HUD.nitroIconY && cmd.touchY <= HUD.nitroIconY + HUD.m_BoostIcon.m_Image.getHeight() && Application.testApp.GetGameState() == 1) {
                        Application.testApp.GetHumanBolid().Sterring_Nitro();
                    }
                    if (cmd.touchX >= HUD.leftIconX && cmd.touchX <= HUD.leftIconX + HUD.m_BoostIcon.m_Image.getWidth() && cmd.touchY >= HUD.leftIconY && cmd.touchY <= HUD.leftIconY + HUD.m_BoostIcon.m_Image.getHeight()) {
                        leftTouchKeyPressed = true;
                    }
                    if (cmd.touchX >= HUD.rightIconX && cmd.touchX <= HUD.rightIconX + HUD.m_BoostIcon.m_Image.getWidth() && cmd.touchY >= HUD.rightIconY && cmd.touchY <= HUD.rightIconY + HUD.m_BoostIcon.m_Image.getHeight()) {
                        rightTouchKeyPressed = true;
                    }
                    if (cmd.touchX >= HUD.downIconX && cmd.touchX <= HUD.downIconX + HUD.m_BoostIcon.m_Image.getWidth() && cmd.touchY >= HUD.downIconY && cmd.touchY <= HUD.downIconY + HUD.m_BoostIcon.m_Image.getHeight()) {
                        downTouchKeyPressed = true;
                    }
                    if (this.currentGameState == null) continue;
                    this.currentGameState.OnTouchPressed(cmd.touchX, cmd.touchY);
                    continue;
                }
                if (cmd.touchX >= HUD.leftIconX && cmd.touchX <= HUD.leftIconX + HUD.m_BoostIcon.m_Image.getWidth() && cmd.touchY >= HUD.leftIconY && cmd.touchY <= HUD.leftIconY + HUD.m_BoostIcon.m_Image.getHeight()) {
                    leftTouchKeyPressed = false;
                }
                if (cmd.touchX >= HUD.rightIconX && cmd.touchX <= HUD.rightIconX + HUD.m_BoostIcon.m_Image.getWidth() && cmd.touchY >= HUD.rightIconY && cmd.touchY <= HUD.rightIconY + HUD.m_BoostIcon.m_Image.getHeight()) {
                    rightTouchKeyPressed = false;
                }
                if (cmd.touchX < HUD.downIconX || cmd.touchX > HUD.downIconX + HUD.m_BoostIcon.m_Image.getWidth() || cmd.touchY < HUD.downIconY || cmd.touchY > HUD.downIconY + HUD.m_BoostIcon.m_Image.getHeight()) continue;
                downTouchKeyPressed = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean updateLogic(long deltaTime) {
        if (this.isGamePaused()) {
            return false;
        }
        this.processCommands();
        for (int i = 0; i < timeMultiplayer; ++i) {
            this.update(deltaTime);
        }
        if (this.currentGameState != null) {
            this.currentGameState.OnUpdate(deltaTime);
        }
        Application.testApp.m_fxDeltaTime = deltaTime;
        if (Application.isUpPressed()) {
            if (Application.testApp.GetGameState() == 1) {
                Application.testApp.GetHumanBolid().Sterring_Nitro();
            }
        } else if (Application.testApp.GetGameState() == 1) {
            if (Application.isDownPressed() || downTouchKeyPressed) {
                Application.testApp.GetHumanBolid().Sterring_Down();
                Application.testApp.GetHumanBolid().SetBreak(1);
            } else {
                Application.testApp.GetHumanBolid().Sterring_Up();
            }
        }
        if (Application.isLeftPressed() || leftTouchKeyPressed) {
            Application.testApp.GetHumanBolid().Sterring_Left();
        } else if (Application.isRightPressed() || rightTouchKeyPressed) {
            Application.testApp.GetHumanBolid().Sterring_Right();
        } else {
            Application.testApp.GetHumanBolid().SetStraight(0);
        }
        Application.testApp.Step();
        return true;
    }

    public void askAbortToMainMenu() {
        Application.game.pauseGame();
        Application.getApplication().getMenu().setCurrentUIScreen(new InGameMainMenu());
    }

    public void storeGameState() {
        try {
            Game.storeGame();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isAnyGameStored() {
        boolean gameStored = false;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"GameState", (boolean)false);
            if (recordStore != null && recordStore.getNumRecords() != 0 && careerTrackID >= 0) {
                gameStored = true;
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gameStored;
    }

    public static void cleanUpGameStateStore() {
        try {
            RecordStore.deleteRecordStore((String)"GameState");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void playerDisconected() {
        netGameRuning = false;
    }

    public void serverTerminated() {
        netGameRuning = false;
    }

    public void update(long deltaTime) {
    }

    public void drawGamePlay(Graphics g) {
        this.draw2D(g);
        if (this.currentGameState != null) {
            this.currentGameState.OnDraw(g);
        }
        Application.getApplication().getMenu().paint(g);
    }

    static {
        currentTrackMode = 0;
        careerTrackID = -1;
        careerGender = 0;
        netGameRuning = true;
        timeMultiplayer = 1;
        upTouchKeyPressed = false;
        downTouchKeyPressed = false;
        leftTouchKeyPressed = false;
        rightTouchKeyPressed = false;
        levelNames = new String[]{"/trck1.tk", "/trck1.tk", "/trck2.tk", "/trck2.tk", "/trck3.tk", "/trck3.tk", "/trck4.tk", "/trck4.tk", "/trck5.tk", "/trck5.tk", "/trck6.tk", "/trck6.tk"};
    }
}

