/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.PackedImage;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CustomFont {
    private int style;
    private int size;
    private int baseline;
    private int height;
    private int width;
    private Image image;
    private int textureSize;
    private int NUM_COLUMNS;
    private int NUM_ROWS;
    private short[] charCodes = null;
    private int[] posXOnBMP = null;
    private int[] posYOnBMP = null;
    private int[] charWidths = null;
    char[] characters = new char[8];
    char[] speedChars = new char[3];

    public int getFontHeight() {
        return this.height;
    }

    public static CustomFont getFont(String fontDefinitionFile) {
        CustomFont newFont = new CustomFont();
        try {
            InputStream is = Application.getApplication().getClass().getResourceAsStream(fontDefinitionFile);
            DataInputStream dis = new DataInputStream(is);
            newFont.createFontFromStream(dis);
            dis.close();
        }
        catch (Exception e) {
            return null;
        }
        return newFont;
    }

    public CustomFont createFontFromStream(DataInputStream dis) throws IOException {
        String fontName = this.deSerializeString(dis);
        this.image = PackedImage.loadImage("/" + fontName);
        this.textureSize = dis.readInt();
        this.NUM_COLUMNS = this.NUM_ROWS = dis.readInt();
        this.width = this.height = this.textureSize / this.NUM_ROWS;
        int numLetters = this.NUM_COLUMNS * this.NUM_ROWS;
        this.charCodes = new short[numLetters];
        this.posXOnBMP = new int[numLetters];
        this.posYOnBMP = new int[numLetters];
        this.charWidths = new int[numLetters];
        for (int i = 0; i < numLetters; ++i) {
            this.charCodes[i] = dis.readShort();
            this.posXOnBMP[i] = dis.readInt();
            this.posYOnBMP[i] = dis.readInt();
            this.charWidths[i] = dis.readInt();
        }
        return null;
    }

    public int getBaselinePosition() {
        return this.baseline;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isUnderlined() {
        return (this.style & 4) != 0;
    }

    public void encodeDynamicStringBuffer(StringBuffer in) {
        for (int i = 0; i < in.length(); ++i) {
            in.setCharAt(i, (char)this.getDecodedCharIndex((short)in.charAt(i)));
        }
    }

    public String encodeDynamicString(String in) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            sb.append((char)this.getDecodedCharIndex((short)in.charAt(i)));
        }
        return sb.toString();
    }

    public int getDecodedCharIndex(short unicodeChar) {
        for (int i = 0; i < this.charCodes.length; ++i) {
            if (unicodeChar != this.charCodes[i]) continue;
            return i;
        }
        return -1;
    }

    public int getCharOnBMPIndex(char character) {
        return character;
    }

    public int charsWidth(String str, int offset, int length) {
        int pixelLength = 0;
        for (int i = offset; i < offset + length; ++i) {
            char onBMPIndex = (char)this.getCharOnBMPIndex(str.charAt(i));
            pixelLength += this.charWidth(onBMPIndex);
        }
        return pixelLength;
    }

    public int charsWidth(StringBuffer str, int offset, int length) {
        int pixelLength = 0;
        for (int i = offset; i < offset + length; ++i) {
            char onBMPIndex = (char)this.getCharOnBMPIndex(str.charAt(i));
            pixelLength += this.charWidth(onBMPIndex);
        }
        return pixelLength;
    }

    public int charWidth(char ch) {
        if (ch >= this.charWidths.length) {
            return 0;
        }
        return this.charWidths[ch];
    }

    public int stringWidth(String str) {
        return this.charsWidth(str, 0, str.length());
    }

    public void drawChar(Graphics g, char character, int x, int y, int anchor) {
        this.drawCharInternal(g, character, x, y, anchor);
    }

    public void drawChars(Graphics g, String data, int offset, int length, int x, int y, int anchor) {
        if ((anchor & 8) != 0) {
            x -= this.charsWidth(data, offset, length);
        } else if ((anchor & 1) != 0) {
            x -= this.charsWidth(data, offset, length) / 2;
        }
        if ((anchor & 0x20) != 0) {
            y -= this.height;
        } else if ((anchor & 2) != 0) {
            y -= this.height / 2;
        }
        for (int i = 0; i < length; ++i) {
            char c = data.charAt(offset + i);
            this.drawCharInternal(g, (char)this.getCharOnBMPIndex(c), x, y, 20);
            x += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    public void drawChars(Graphics g, StringBuffer data, int offset, int length, int x, int y, int anchor) {
        if ((anchor & 8) != 0) {
            x -= this.charsWidth(data, offset, length);
        } else if ((anchor & 1) != 0) {
            x -= this.charsWidth(data, offset, length) / 2;
        }
        if ((anchor & 0x20) != 0) {
            y -= this.height;
        } else if ((anchor & 2) != 0) {
            y -= this.height / 2;
        }
        for (int i = 0; i < length; ++i) {
            char c = data.charAt(offset + i);
            this.drawCharInternal(g, (char)this.getCharOnBMPIndex(c), x, y, 20);
            x += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    private void drawCharInternal(Graphics g, char character, int x, int y, int anchor) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        int charY = character / this.NUM_COLUMNS;
        int charX = character - charY * this.NUM_COLUMNS;
        if ((this.style & 2) != 0) {
            g.setClip(x + 1, y, this.width, this.height / 2);
            g.drawImage(this.image, x - this.width * charX + 1, y - this.height * charY, anchor);
            g.setClip(x, y + this.height / 2, this.width, this.height / 2);
            g.drawImage(this.image, x - this.width * charX, y - this.height * charY, anchor);
            if ((this.style & 1) != 0) {
                g.setClip(x, y, this.width, this.height / 2);
                g.drawImage(this.image, x - this.width * charX + 2, y - this.height * charY, anchor);
                g.setClip(x, y + this.height / 2, this.width, this.height / 2);
                g.drawImage(this.image, x - this.width * charX + 1, y - this.height * charY, anchor);
            }
        } else {
            g.setClip(x, y, this.width, this.height);
            g.clipRect(clipX, clipY, clipW, clipH);
            g.drawImage(this.image, x - this.width * charX, y - this.height * charY, anchor);
            if ((this.style & 1) != 0) {
                g.drawImage(this.image, x - this.width * character + 1, y - this.height * charY, anchor);
            }
        }
        if ((this.style & 4) != 0) {
            g.drawLine(x, y + this.baseline + 2, x + this.width, y + this.baseline + 2);
        }
        g.setClip(clipX, clipY, clipW, clipH);
    }

    public void drawTimeChars(Graphics g, long _currentTime, int p, int x, int y, int anchor) {
        int index = 0;
        long seconds = _currentTime / 1000L;
        long m = seconds / 60L;
        long s = seconds % 60L;
        long mm = _currentTime % 1000L / 10L;
        this.characters[index++] = (char)(16L + m / 10L);
        this.characters[index++] = (char)(16L + m % 10L);
        this.characters[index++] = 26;
        this.characters[index++] = (char)(16L + s / 10L);
        this.characters[index++] = (char)(16L + s % 10L);
        this.characters[index++] = 26;
        this.characters[index++] = (char)(16L + mm / 10L);
        this.characters[index++] = (char)(16L + mm % 10L);
        for (int i = 0; i < 8; ++i) {
            char c = this.characters[i];
            this.drawCharInternal(g, (char)this.getCharOnBMPIndex(c), x, y, 20);
            x += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    public void drawSpeedChars(Graphics g, long _speed, int x, int y, int anchor) {
        if (_speed < 0L) {
            _speed = 0L;
        }
        long h = _speed / 100L;
        long d = (_speed - h * 100L) / 10L;
        long u = _speed - h * 100L - d * 10L;
        this.characters[0] = (char)(h + 16L);
        this.characters[1] = (char)(d + 16L);
        this.characters[2] = (char)(u + 16L);
        for (int i = 0; i < 3; ++i) {
            char c = this.characters[i];
            this.drawCharInternal(g, c, x, y, 20);
            x += this.charWidth((char)this.getCharOnBMPIndex(c));
        }
    }

    public void drawSpeedString(Graphics g, long speed, int x, int y, int anchor) {
        this.drawSpeedChars(g, speed, x, y, anchor);
    }

    public void drawString(Graphics g, String str, int x, int y, int anchor) {
        this.drawChars(g, str, 0, str.length(), x, y, anchor);
    }

    public void drawString(Graphics g, StringBuffer str, int x, int y, int anchor) {
        this.drawChars(g, str, 0, str.length(), x, y, anchor);
    }

    public void drawTimeString(Graphics g, long _currentTime, int x, int y, int anchor) {
        this.drawTimeChars(g, _currentTime, 0, x, y, anchor);
    }

    public String deSerializeString(DataInputStream dis) throws IOException {
        int nameStringLength = dis.readInt();
        byte[] rawName = new byte[nameStringLength];
        dis.read(rawName, 0, nameStringLength);
        return new String(rawName);
    }
}

