/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.Platform;
import Kartmania.UIScreen;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public abstract class ListDialogBox
extends Canvas {
    protected Vector textLines = new Vector();
    private int backgroundColor;
    private String captionText;
    protected int currentItem = 1;

    public ListDialogBox(String caption, Vector main, int color) {
        this.backgroundColor = color;
        this.captionText = caption;
        this.setFullScreenMode(true);
        this.textLines = main;
    }

    public void paint(Graphics g) {
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        UIScreen.drawString(g, this.captionText, this.getWidth() / 2, 0, 17, 0);
        int fontHeight = Application.defaultFont.getFontHeight();
        int yCenterAlign = (this.getHeight() - fontHeight * this.textLines.size()) / 2;
        for (int i = 0; i < this.textLines.size(); ++i) {
            int yPosition = 0 + i * fontHeight + 0 + yCenterAlign;
            UIScreen.drawString(g, Application.defaultFont.encodeDynamicString(i == this.currentItem ? ">" : " ") + (String)this.textLines.elementAt(i), this.getWidth() / 2, yPosition, 17, 0);
        }
        g.setColor(-1);
        g.setFont(Font.getDefaultFont());
        UIScreen.drawString(g, Application.defaultFont.encodeDynamicString(" >"), Platform.SB_X_OFFSET, this.getHeight() - Platform.SB_Y_OFFSET, 36, 0);
    }

    protected void pointerPressed(int x, int y) {
        int w = this.getWidth();
        this.getHeight();
        if (x < w / 4) {
            this.onNoSelected();
        } else if (x > 3 * (w / 4)) {
            this.onYesSelected();
        }
    }

    protected void keyReleased(int keyCode) {
        if (Application.SoftButton2_Code == keyCode) {
            this.onNoSelected();
        } else if (Application.SoftButton1_Code == keyCode) {
            this.onYesSelected();
        } else if (1 == this.getGameAction(keyCode)) {
            if (--this.currentItem < 0) {
                this.currentItem = this.textLines.size() - 1;
            }
            this.repaint();
        } else if (6 == this.getGameAction(keyCode)) {
            if (++this.currentItem >= this.textLines.size()) {
                this.currentItem = 0;
            }
            this.repaint();
        }
    }

    public abstract void onNoSelected();

    public abstract void onYesSelected();
}

