/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.PackedImage;
import Kartmania.UIScreen;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class Utils {
    public static final int SCALE_FIT_WIDTH = 1;
    public static final int SCALE_FIT_HEIGHT = 2;

    public static boolean isPointInRect(int x, int y, int x0, int y0, int xk, int yk) {
        return x > x0 && x < xk && y > y0 && y < yk;
    }

    private static void Bilinear_Interpolate_NoAlpha(int[] inBits, int[] outBits, int w, int h, int outWidth, int outHeight) {
        long ratiox = 4096 * w / outWidth;
        long ratioy = 4096 * h / outHeight;
        for (int i = 0; i < outWidth; ++i) {
            for (int j = 0; j < outHeight; ++j) {
                long x = (long)i * ratiox;
                long y = (long)j * ratioy;
                long x0 = x / 4096L * 4096L;
                long y0 = y / 4096L * 4096L;
                long dx = x - x0;
                long dy = y - y0;
                long _1_dx = 4096L - dx;
                long _1_dy = 4096L - dy;
                long x0_1 = x0 + 4096L >= (long)(4096 * w) ? x0 : x0 + 1L;
                long y0_1 = y0 + 4096L >= (long)(4096 * h) ? y0 : y0 + 1L;
                long r0 = inBits[(int)((x0 + y0 * (long)w) / 4096L)] & 0xFF;
                long g0 = (inBits[(int)((x0 + y0 * (long)w) / 4096L)] & 0xFF00) >> 8;
                long b0 = (inBits[(int)((x0 + y0 * (long)w) / 4096L)] & 0xFF0000) >> 16;
                long a0 = (inBits[(int)((x0 + y0 * (long)w) / 4096L)] & 0xFF000000) >> 24;
                long r1 = inBits[(int)(x0_1 + y0 * (long)w) / 4096] & 0xFF;
                long g1 = (inBits[(int)(x0_1 + y0 * (long)w) / 4096] & 0xFF00) >> 8;
                long b1 = (inBits[(int)(x0_1 + y0 * (long)w) / 4096] & 0xFF0000) >> 16;
                long r2 = inBits[(int)(x0_1 + y0_1 * (long)w) / 4096] & 0xFF;
                long g2 = (inBits[(int)(x0_1 + y0_1 * (long)w) / 4096] & 0xFF00) >> 8;
                long b2 = (inBits[(int)(x0_1 + y0_1 * (long)w) / 4096] & 0xFF0000) >> 16;
                long r3 = inBits[(int)(x0 + y0_1 * (long)w) / 4096] & 0xFF;
                long g3 = (inBits[(int)(x0 + y0_1 * (long)w) / 4096] & 0xFF00) >> 8;
                long b3 = (inBits[(int)(x0 + y0_1 * (long)w) / 4096] & 0xFF0000) >> 16;
                int r = (int)(((r0 * _1_dx + r1 * dx) / 4096L * _1_dy + (r3 * _1_dx + r2 * dx) / 4096L * dy) / 4096L);
                int g = (int)(((g0 * _1_dx + g1 * dx) / 4096L * _1_dy + (g3 * _1_dx + g2 * dx) / 4096L * dy) / 4096L);
                int b = (int)(((b0 * _1_dx + b1 * dx) / 4096L * _1_dy + (b3 * _1_dx + b2 * dx) / 4096L * dy) / 4096L);
                int a = (int)a0;
                outBits[i + j * outWidth] = r + (g << 8) + (b << 16) + (a << 24);
            }
        }
    }

    public static Image scaleImageNoAlpha(Image inImage, int outWidth, int outHeight, boolean alpha) {
        int[] outBits = new int[outWidth * outHeight];
        int[] inBits = new int[inImage.getWidth() * inImage.getHeight()];
        if (inImage.getWidth() == outWidth && inImage.getHeight() == outHeight) {
            return inImage;
        }
        try {
            inImage.getRGB(inBits, 0, inImage.getWidth(), 0, 0, inImage.getWidth(), inImage.getHeight());
        }
        catch (Exception e) {
            return null;
        }
        Utils.Bilinear_Interpolate_NoAlpha(inBits, outBits, inImage.getWidth(), inImage.getHeight(), outWidth, outHeight);
        return Image.createRGBImage((int[])outBits, (int)outWidth, (int)outHeight, (boolean)alpha);
    }

    public static Vector splitText(String newText, String separator) {
        return Utils.splitText(newText, separator, Application.screenWidth, 0);
    }

    public static Vector splitText(String newText, String separator, int screenWidth) {
        return Utils.splitText(newText, separator, screenWidth, 0);
    }

    public static Vector splitText(String newText, String separator, int screenWidth, int fondID) {
        int currentIndex = 0;
        Vector<String> textLines = new Vector<String>();
        separator = Application.defaultFont.encodeDynamicString(separator);
        while (true) {
            int end;
            if ((end = newText.indexOf(separator, currentIndex)) == -1) {
                if (currentIndex >= newText.length()) break;
                textLines.addElement(newText.substring(currentIndex, newText.length()));
                break;
            }
            textLines.addElement(newText.substring(currentIndex, end));
            currentIndex = end + 1;
        }
        if (textLines.size() == 0) {
            textLines.addElement(newText);
        }
        return Utils.fitWidth(textLines, screenWidth, fondID);
    }

    public static Vector fitWidth(Vector inputLines, int screenWidth, int fondID) {
        int currentIndex = 0;
        Vector<String> textLines = new Vector<String>();
        String separator = Application.defaultFont.encodeDynamicString(" ");
        String newLine = new String();
        block0: for (int i = 0; i < inputLines.size(); ++i) {
            String newText = (String)inputLines.elementAt(i);
            currentIndex = 0;
            newLine = new String();
            while (true) {
                int end;
                if ((end = newText.indexOf(separator, currentIndex)) == -1) {
                    String spare = newLine + newText.substring(currentIndex);
                    if (UIScreen.stringWidth(spare, fondID) >= screenWidth) {
                        textLines.addElement(newLine);
                        textLines.addElement(newText.substring(currentIndex));
                        continue block0;
                    }
                    textLines.addElement(spare);
                    continue block0;
                }
                String newLine2 = newLine + newText.substring(currentIndex, end + 1);
                if (UIScreen.stringWidth(newLine2, fondID) >= screenWidth) {
                    textLines.addElement(newLine);
                    newLine = newText.substring(currentIndex, end + 1);
                } else {
                    newLine = newLine + newText.substring(currentIndex, end + 1);
                }
                currentIndex = end + 1;
            }
        }
        return textLines;
    }

    public static Image loadImage(String name) {
        try {
            return PackedImage.loadImage(name);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

