/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.CustomFont;
import Kartmania.Interface2D;
import Kartmania.ObjectsCache;
import Kartmania.Platform;
import Kartmania.UIWindowCaption;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class UIScreen {
    private static final int SCROLL_AXES_ANIM_SPEED = 4;
    public static final int SB_FLAG_DRAW_TEXT = 1;
    public static final int SB_FLAG_DRAW_IMAGE = 2;
    private int sbFlags = 2;
    public boolean smallWnd = false;
    protected long lifeTime = 0L;
    protected int positionX;
    protected int positionY;
    protected int width;
    protected int height;
    protected int clientAreaX;
    protected int clientAreaY;
    protected int clientAreaWidth;
    protected int clientAreaHeight;
    protected boolean showCaption = false;
    protected boolean showScrollbars = false;
    protected boolean showHScrollbars = false;
    protected int YScrollOffset = 0;
    protected int scrollingState = 0;
    protected UIWindowCaption windowCaption = null;
    protected Canvas parentCanvas = null;
    private int[] animOffsets = new int[]{0, 1, 2, 3, 4, 3, 2, 1};
    private String leftSBText;
    private String rightSBText;
    protected Image leftSBImage;
    protected Image rightSBImage;
    public static int defaultClientAreaY = 0;
    public static int defaultClientAreaHeight = 200;

    public void setCaption(UIWindowCaption caption) {
        this.windowCaption = caption;
        this.updateSize();
    }

    public void setParent(Canvas parent) {
        this.parentCanvas = parent;
    }

    public void setPosition(int posX, int posY) {
        this.positionX = posX;
        this.positionY = posY;
    }

    public void setPositionX(int posX) {
        this.positionX = posX;
    }

    public void setPositionY(int posY) {
        this.positionY = posY;
    }

    public void setWidth(int newWidth) {
        this.width = newWidth;
    }

    public void setHeight(int newHeight) {
        this.height = newHeight;
    }

    public int getPositionX() {
        return this.positionX;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void showCaption(boolean show) {
        this.showCaption = show;
    }

    public void showScrollbars(boolean show) {
        this.showScrollbars = show;
    }

    public void showHScrollbars(boolean show) {
        this.showHScrollbars = show;
    }

    public void setSoftButtonText(String left, String right) {
        this.leftSBText = left;
        this.rightSBText = right;
    }

    public void setSoftButtonImage(Image left, Image right) {
        this.leftSBImage = left;
        this.rightSBImage = right;
    }

    protected boolean touchPressed(int x, int y) {
        int offset = this.animOffsets[(int)(this.lifeTime * 4L / 4096L) % this.animOffsets.length];
        int left = Application.screenWidth - ObjectsCache.scrollUpImg.getWidth() / 4 - ObjectsCache.scrollUpImg.getWidth();
        int right = left + ObjectsCache.scrollUpImg.getWidth();
        int top = this.positionY + 2 * this.height / 10 - offset + this.YScrollOffset - 5;
        int bottom = this.positionY + 2 * this.height / 10 - offset + this.YScrollOffset + ObjectsCache.scrollUpImg.getHeight() + 5;
        if (x >= left && x < right && y >= top && y <= bottom) {
            this.scrollingState = -1;
            return true;
        }
        top = this.positionY + 7 * this.height / 10 + offset + this.YScrollOffset - 5;
        bottom = this.positionY + 7 * this.height / 10 + offset + this.YScrollOffset + ObjectsCache.scrollUpImg.getHeight() + 5;
        if (x >= left && x < right && y >= top && y <= bottom) {
            this.scrollingState = 1;
            return true;
        }
        this.scrollingState = 0;
        return false;
    }

    protected boolean touchReleased(int x, int y) {
        this.scrollingState = 0;
        return false;
    }

    protected abstract void keyPressed(int var1);

    protected abstract void keyReleased(int var1);

    public abstract void draw(Graphics var1);

    public abstract void autoSize();

    protected abstract void leftSoftButton();

    protected abstract void rightSoftButton();

    protected void onFocusBack() {
    }

    protected void drawScrollBars(Graphics g) {
        int offset = this.animOffsets[(int)(this.lifeTime * 4L / 4096L) % this.animOffsets.length];
        g.drawImage(ObjectsCache.scrollUpImg, Application.screenWidth - ObjectsCache.scrollUpImg.getWidth() / 4, this.positionY + 2 * this.height / 10 - offset + this.YScrollOffset, 24);
        g.drawImage(ObjectsCache.scrollDownImg, Application.screenWidth - ObjectsCache.scrollUpImg.getWidth() / 4, this.positionY + 7 * this.height / 10 + offset + this.YScrollOffset, 24);
    }

    protected void drawHScrollBars(Graphics g) {
        int anchor = this.positionX + 9;
        g.drawImage(ObjectsCache.scrollLeftImg, anchor, this.positionY + this.clientAreaHeight + Platform.HSCROLLS_OFFSET, 20);
        g.drawImage(ObjectsCache.scrollRightImg, anchor + ObjectsCache.scrollLeftImg.getWidth(), this.positionY + this.clientAreaHeight + Platform.HSCROLLS_OFFSET, 20);
    }

    public void paint(Graphics g) {
        int topOfClientArea = Application.screenHeight - 18 - 138;
        g.setColor(3151637);
        g.fillRect(0, topOfClientArea, Application.screenWidth, 138);
        if (this.windowCaption != null) {
            this.windowCaption.draw(g);
        }
        this.updateSize();
        if (this.showScrollbars && Application.screenWidth > 128) {
            this.drawScrollBars(g);
        }
        if (this.showHScrollbars) {
            this.drawHScrollBars(g);
        }
        this.draw(g);
    }

    public void drawSoftButtons(Graphics g) {
        g.setClip(0, 0, Application.screenWidth, Application.screenHeight);
        g.setColor(11419656);
        g.fillRect(0, Application.screenHeight - 18, Application.screenWidth, 18);
        if ((this.sbFlags & 1) != 0) {
            Interface2D.drawSoftButtons(g, this.leftSBText, this.rightSBText);
        }
        if ((this.sbFlags & 2) != 0) {
            Interface2D.drawSoftButtons(g, this.leftSBImage, this.rightSBImage);
        }
    }

    public void onUpdate(long deltaTime) {
        this.lifeTime += deltaTime * 3L;
        if (this.windowCaption != null) {
            this.windowCaption.update(deltaTime);
        }
    }

    public void onGameAction(int gameAction) {
    }

    public UIScreen() {
        this.updateSize();
        Application.gameCanvas.flushActiveTouchCommands();
    }

    public void updateSize() {
        int topOfClientArea = Application.screenHeight - 18 - 138;
        this.positionX = 0;
        this.positionY = topOfClientArea;
        this.width = Application.screenWidth;
        this.height = 138;
        if (this.windowCaption != null) {
            this.positionY += this.windowCaption.getHeight();
            this.height -= this.windowCaption.getHeight();
        }
    }

    public static int stringWidth(String s, int color) {
        CustomFont font = Application.defaultFont;
        switch (color) {
            case 1: {
                font = Application.smallRedFont;
                break;
            }
            case 2: {
                font = Application.smallGreyFont;
            }
        }
        return font.stringWidth(s);
    }

    public static void drawTimeString(Graphics g, long _currentTime, int x, int y, int center, int color) {
        CustomFont font = Application.defaultFont;
        switch (color) {
            case 1: {
                font = Application.smallRedFont;
                break;
            }
            case 2: {
                font = Application.smallGreyFont;
            }
        }
        font.drawTimeString(g, _currentTime, x, y, center);
    }

    public static void drawString(Graphics g, String s, int x, int y, int center, int color) {
        CustomFont font = Application.defaultFont;
        switch (color) {
            case 1: {
                font = Application.smallRedFont;
                break;
            }
            case 2: {
                font = Application.smallGreyFont;
            }
        }
        font.drawString(g, s, x, y, center);
    }

    public static void drawString(Graphics g, StringBuffer s, int x, int y, int center, int color) {
        CustomFont font = Application.defaultFont;
        switch (color) {
            case 1: {
                font = Application.smallRedFont;
                break;
            }
            case 2: {
                font = Application.smallGreyFont;
            }
        }
        font.drawString(g, s, x, y, center);
    }

    public static void drawString(Graphics g, Vector text, int x, int y, int center, int color) {
        CustomFont font = Application.defaultFont;
        switch (color) {
            case 1: {
                font = Application.smallRedFont;
                break;
            }
            case 2: {
                font = Application.smallGreyFont;
            }
        }
        int fontHeight = font.getFontHeight();
        if ((center & 0x20) != 0) {
            int i = text.size() - 1;
            int j = 0;
            while (i >= 0) {
                font.drawString(g, (String)text.elementAt(i), x, y - j * fontHeight, center);
                --i;
                ++j;
            }
        } else if ((center & 2) != 0) {
            int vCenter = fontHeight * text.size() / 2;
            for (int i = 0; i < text.size(); ++i) {
                font.drawString(g, (String)text.elementAt(i), x, y + i * fontHeight - vCenter, center);
            }
        } else {
            for (int i = 0; i < text.size(); ++i) {
                font.drawString(g, (String)text.elementAt(i), x, y + i * fontHeight, center);
            }
        }
    }
}

