/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.AppCanvas;
import Kartmania.BestScores;
import Kartmania.CGTexture;
import Kartmania.CarEngine2D;
import Kartmania.CareerScreen;
import Kartmania.CustomFont;
import Kartmania.EditChampionshipsUserName;
import Kartmania.FXUtility;
import Kartmania.Game;
import Kartmania.HintScreen;
import Kartmania.LanguagePack;
import Kartmania.LoadingProgress;
import Kartmania.LoadingScreen;
import Kartmania.MasterSoundSwitch;
import Kartmania.MenuSystem;
import Kartmania.ObjectsCache;
import Kartmania.Options;
import Kartmania.PackedImage;
import Kartmania.Platform;
import Kartmania.RandSync;
import Kartmania.SelectGameMode;
import Kartmania.SelectLanguageScreen;
import Kartmania.SelectTrack;
import Kartmania.UserInterface;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;

public class Application
extends MIDlet
implements Runnable {
    public static boolean needDefaultlanguage = false;
    public boolean gameIsContinued = false;
    private boolean firstTimeInit = true;
    public boolean incomingCall = false;
    public static boolean soundEnabled = false;
    public static String App_Version = "";
    public static boolean keyboardEnable = true;
    public static boolean isTouchScreen = false;
    public static CarEngine2D testApp;
    private static int nNokia6280soundCheckTimer;
    private static Player musicPlayer;
    private boolean gameRunning = false;
    public static int screenWidth;
    public static int screenHeight;
    public static CustomFont defaultFont;
    public static CustomFont smallRedFont;
    public static CustomFont smallGreyFont;
    public static LanguagePack lp;
    public static Application instance;
    public static Game game;
    public static UserInterface userInterface;
    public static AppCanvas gameCanvas;
    public static MenuSystem menuSystem;
    public static BestScores bestScores;
    public static boolean Enable_Multilang;
    public static boolean Enable_NetScores;
    public static int SoftButton1_Code;
    public static int SoftButton2_Code;
    private long previousTime;
    private long timeAccumulator;
    public long currentTime = 0L;

    public static Application getApplication() {
        return instance;
    }

    public static Game getGame() {
        return game;
    }

    public Application() {
        instance = this;
    }

    public MenuSystem getMenu() {
        return menuSystem;
    }

    public boolean isInGame() {
        return this.gameRunning;
    }

    public void startGame() {
        LoadingProgress.Reset(true);
        gameCanvas.showLoadingScreen(null, 0, lp.getTranslatedString(Options.languageID, "ID_GAME_LOADING"));
        this.gameIsContinued = false;
        menuSystem.setCurrentUIScreen(null);
        game = new Game(SelectTrack.selectedTrack, 0);
        game.startGame();
        Application.gameCanvas.generalGameMode = 4;
        LoadingProgress.EndProgress();
    }

    public void startGameTimer() {
        this.previousTime = System.currentTimeMillis();
        this.timeAccumulator = 0L;
        this.gameRunning = true;
        new Thread(this).start();
    }

    public void continueGame() {
        gameCanvas.showLoadingScreen(null, 0, lp.getTranslatedString(Options.languageID, "ID_GAME_LOADING"));
        this.gameIsContinued = true;
        menuSystem.setCurrentUIScreen(null);
        game = new Game(-1, -1);
        game.continueGame();
        Application.gameCanvas.generalGameMode = 4;
    }

    public static void vibrate(int duration) {
        if (Options.Vibration) {
            Display.getDisplay((MIDlet)instance).vibrate(duration);
        }
    }

    public void goToCareerScreen() {
        int topOfClientArea;
        if (Application.testApp.m_nCurrentLevelIndex < 0) {
            testApp.Load(Game.levelNames[0], 0);
        } else {
            testApp.AfterLoad();
        }
        Application.testApp.m_nTranslateScreenY = topOfClientArea = 116;
        testApp.SetupBolids(0);
        menuSystem.setCanvas((Canvas)gameCanvas);
        Application.gameCanvas.generalGameMode = 3;
        Application.startMID("/skiJump.mid");
        if (++Game.careerTrackID >= 12) {
            int nPos = Game.GetHumanIndexForChampionshipRankingPos();
            Game.careerReset();
            if (game != null) {
                game.storeGameState();
            }
            Game.cleanUpGameStateStore();
            if (nPos == 0) {
                HintScreen.showHintedScreen(new SelectGameMode(), HintScreen.ID_HINT_GOLD_IN_CHAMPIONSHIPS, 1);
            } else if (nPos == 1) {
                HintScreen.showHintedScreen(new SelectGameMode(), 102, 1);
            } else if (nPos == 2) {
                HintScreen.showHintedScreen(new SelectGameMode(), 103, 1);
            } else {
                HintScreen.showHintedScreen(new SelectGameMode(), 101 + nPos, 1);
            }
            Game.careerReset();
        } else {
            menuSystem.setCurrentUIScreen(new CareerScreen());
        }
    }

    public static void resetCareerLevel(int currentLeague) {
        Game.ResetChampionshipRanking();
        switch (currentLeague) {
            case 1: {
                Game.careerTrackID = 0;
                break;
            }
            case 2: {
                Game.careerTrackID = 5;
                break;
            }
            case 3: {
                Game.careerTrackID = 11;
            }
        }
    }

    public static boolean isProgressedToNextLeague(int currentLeague) {
        return true;
    }

    public static boolean isFirstLeagueTrack() {
        return Game.careerTrackID == 0 || Game.careerTrackID == 5 || Game.careerTrackID == 11 || Game.careerTrackID == 18;
    }

    public void goToMainMenu() {
        int topOfClientArea;
        if (Application.testApp.m_nCurrentLevelIndex < 0) {
            testApp.Load(Game.levelNames[0], 0);
        } else {
            testApp.AfterLoad();
        }
        Application.testApp.m_nTranslateScreenY = topOfClientArea = 116;
        testApp.SetupBolids(0);
        SelectGameMode.selectedGameMode = 2;
        menuSystem.setCanvas((Canvas)gameCanvas);
        SelectGameMode list = new SelectGameMode();
        menuSystem.setCurrentUIScreen(list);
        list.autoSize();
        Application.gameCanvas.generalGameMode = 3;
        Application.startMID("/skiJump.mid");
    }

    public void askForSoundMasterSwitch() {
        menuSystem.setCurrentUIScreen(new MasterSoundSwitch());
    }

    public void newFirstTimeInit() {
        int topOfClientArea;
        keyboardEnable = false;
        Application.gameCanvas.generalGameMode = 3;
        RandSync.Init();
        RandSync.SetStartValue(0);
        App_Version = this.checkStringProperty("MIDlet-Version", "1.0.0");
        Enable_Multilang = this.checkBooleanProperty("EnableMultilanguage", true);
        SoftButton1_Code = -21;
        SoftButton2_Code = -22;
        Enable_NetScores = this.checkBooleanProperty("NetScores", false);
        bestScores = new BestScores();
        bestScores.initDefaultBestScores();
        bestScores.readBestResultsFromStore();
        FXUtility.Init();
        CGTexture.Init(4, 2);
        testApp = new CarEngine2D();
        int nRays = 80 * screenHeight / 320;
        int nCamAltitude = 82 * screenHeight / 320;
        if (nCamAltitude <= nRays) {
            nCamAltitude = nRays + 1;
        }
        int nTranslateY = 21;
        int nCameraDeep = 38400 / screenHeight;
        testApp.SetCameraSettings(screenWidth, screenHeight, nRays, nCamAltitude, nCameraDeep, screenWidth * 4096 / 240, nTranslateY);
        testApp.Load(new String("/trck1.tk"), 0);
        Application.testApp.m_nTranslateScreenY = topOfClientArea = 116;
        testApp.SetupBolids(0);
        keyboardEnable = true;
        Application.startMID("/skiJump.mid");
        if (!Application.gameCanvas.isForeground) {
            this.pauseMID();
        }
    }

    public void firstTimeInit() {
        menuSystem.setCurrentUIScreen(new LoadingScreen());
    }

    public void startApp() {
        AppCanvas.isPressedNumKey2 = false;
        AppCanvas.isPressedNumKey4 = false;
        AppCanvas.isPressedNumKey6 = false;
        AppCanvas.isPressedNumKey8 = false;
        if (this.firstTimeInit) {
            PackedImage.LoadFrom("/logo.txt", "/logo.png");
            PackedImage.LoadFrom("/font.txt", "/font.png");
            PackedImage.LoadFrom("/menu.txt", "/menu.png");
            PackedImage.LoadFrom("/kart.txt", "/kart.png");
            PackedImage.LoadFrom("/kart_shadow.txt", "/kart_shadow.png");
            defaultFont = CustomFont.getFont(Platform.defaultFont);
            smallRedFont = CustomFont.getFont(Platform.smallRedFont);
            smallGreyFont = CustomFont.getFont(Platform.smallGreyFont);
            SoftButton1_Code = -21;
            SoftButton2_Code = -22;
            Options.readDefaults();
            Options.readConfigurationFromStore();
            if (Options.languageID == -1) {
                Options.languageID = 1;
                needDefaultlanguage = true;
            }
            Options.languageID = 0;
            lp = LanguagePack.create("/gameTexts.EEE", Options.languageID);
            if (EditChampionshipsUserName.playerNick == null || EditChampionshipsUserName.playerNick.length() == 0) {
                EditChampionshipsUserName.playerNick = lp.getTranslatedString(Options.languageID, "EDIT_PLAYERS_DEFAULT_PLAYER");
            }
            ObjectsCache.initializeMenuResources();
            userInterface = new UserInterface();
            menuSystem.setCanvas((Canvas)gameCanvas);
            screenWidth = gameCanvas.getWidth();
            screenHeight = gameCanvas.getHeight();
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)gameCanvas);
            this.firstTimeInit = false;
            Application.gameCanvas.generalGameMode = 3;
            gameCanvas.setDialog(null);
            if (lp.getNumLanguages() > 1) {
                menuSystem.setCurrentUIScreen(new SelectLanguageScreen());
            } else {
                this.askForSoundMasterSwitch();
            }
            this.startGameTimer();
        }
        this.incomingCall = false;
    }

    public static boolean isLeftPressed() {
        return (gameCanvas.getKeyStates() & 4) != 0 || AppCanvas.isPressedNumKey4 || AppCanvas.isPressedLeftKey || Game.leftTouchKeyPressed;
    }

    public static boolean isRightPressed() {
        return (gameCanvas.getKeyStates() & 0x20) != 0 || AppCanvas.isPressedNumKey6 || AppCanvas.isPressedRightKey || Game.rightTouchKeyPressed;
    }

    public static boolean isUpPressed() {
        return (gameCanvas.getKeyStates() & 2) != 0 || AppCanvas.isPressedNumKey2 || AppCanvas.isPressedUpKey || Game.upTouchKeyPressed;
    }

    public static boolean isDownPressed() {
        return (gameCanvas.getKeyStates() & 0x40) != 0 || AppCanvas.isPressedNumKey8 || AppCanvas.isPressedDownKey || Game.downTouchKeyPressed;
    }

    public boolean checkBooleanProperty(String propertyName, boolean _default) {
        String value = this.getProperty(propertyName);
        return value == null ? _default : value.compareTo("true") == 0;
    }

    public int checkIntegerProperty(String propertyName, int _default) {
        String value = this.getProperty(propertyName);
        return value == null ? _default : Integer.parseInt(value);
    }

    public String checkStringProperty(String propertyName, String _default) {
        String value = this.getProperty(propertyName);
        return value == null ? _default : value;
    }

    private String getProperty(String propertyName) {
        try {
            return this.getAppProperty(propertyName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void pauseApp() {
        this.incomingCall = true;
    }

    public void destroyApp(boolean unconditional) {
        Options.writeConfigurationToStore();
        if (bestScores != null) {
            bestScores.writeBestResultsToStore();
        }
    }

    public static void quitApp() {
        Application.instance.gameRunning = false;
    }

    public static void hintGC() {
        Runtime.getRuntime().gc();
    }

    public static void startMID(String midName) {
        Application.stopMID();
        if (!soundEnabled) {
            return;
        }
        try {
            musicPlayer = Manager.createPlayer((InputStream)instance.getClass().getResourceAsStream(midName), (String)"audio/midi");
            musicPlayer.setLoopCount(-1);
            musicPlayer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stopMID() {
        try {
            if (musicPlayer != null) {
                musicPlayer.stop();
                musicPlayer.close();
                musicPlayer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pauseMID() {
        try {
            if (musicPlayer != null) {
                musicPlayer.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resumeMID() {
        try {
            if (musicPlayer != null) {
                musicPlayer.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void DrawMemory() {
    }

    public void run() {
        long deltaTime = 0L;
        try {
            while (this.gameRunning) {
                this.currentTime = System.currentTimeMillis();
                deltaTime = this.currentTime - this.previousTime;
                this.previousTime = this.currentTime;
                if (!this.incomingCall) {
                    if (Application.gameCanvas.generalGameMode == 3) {
                        userInterface.update(4096L * deltaTime / 1000L);
                        gameCanvas.draw();
                        this.DrawMemory();
                        gameCanvas.flushGraphics();
                        continue;
                    }
                    boolean repaint = false;
                    if (!this.incomingCall && gameCanvas.isShown()) {
                        if (!game.isGamePaused()) {
                            repaint = game.updateLogic(4096L * deltaTime / 1000L);
                            testApp.DrawWeather();
                            if (!repaint) continue;
                            gameCanvas.draw();
                            this.DrawMemory();
                            gameCanvas.flushGraphics();
                            continue;
                        }
                        Application.testApp.m_fxDeltaTime = 0L;
                        testApp.Step();
                        Application.testApp.m_fxDeltaTime = 4096L * deltaTime / 1000L;
                        testApp.DrawWeather();
                        this.currentTime = this.previousTime = System.currentTimeMillis();
                        this.timeAccumulator = 0L;
                        menuSystem.onUpdate(4096L * deltaTime / 1000L);
                        gameCanvas.draw();
                        this.DrawMemory();
                        gameCanvas.flushGraphics();
                        continue;
                    }
                    this.currentTime = this.previousTime = System.currentTimeMillis();
                    this.timeAccumulator = 0L;
                    continue;
                }
                this.currentTime = this.previousTime = System.currentTimeMillis();
                this.timeAccumulator = 0L;
            }
            instance.destroyApp(true);
            instance.notifyDestroyed();
            instance = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        nNokia6280soundCheckTimer = 0;
        defaultFont = null;
        smallRedFont = null;
        smallGreyFont = null;
        lp = null;
        gameCanvas = new AppCanvas();
        menuSystem = new MenuSystem();
        SoftButton1_Code = 0;
        SoftButton2_Code = 0;
    }
}

