/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.Game;
import Kartmania.Interface2D;
import Kartmania.UIScreen;
import Kartmania.Utils;
import Kartmania.YesNoDialogBox;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class AppCanvas
extends GameCanvas {
    public boolean firstCanvasFrame = true;
    public boolean isForeground = true;
    public static final int GAME_MODE_MAIN_MENU = 3;
    public static final int GAME_MODE_IN_GAME = 4;
    private boolean NokiaUIAvailable = false;
    private static Vector commands = new Vector();
    private static Vector activeTouchCommands = new Vector();
    public static boolean isPressedNumKey2 = false;
    public static boolean isPressedNumKey4 = false;
    public static boolean isPressedNumKey6 = false;
    public static boolean isPressedNumKey8 = false;
    public static boolean isPressedUpKey = false;
    public static boolean isPressedDownKey = false;
    public static boolean isPressedLeftKey = false;
    public static boolean isPressedRightKey = false;
    public int generalGameMode = 3;
    public YesNoDialogBox dialogYesNo = null;
    private Graphics __drawContext;
    public static int __KC = -1;
    private static int KC = -1;

    public AppCanvas() {
        super(false);
        this.setFullScreenMode(true);
        Application.screenHeight = this.getHeight();
        Application.screenWidth = this.getWidth();
        Application.isTouchScreen = this.hasPointerEvents();
        this.__drawContext = this.getGraphics();
        try {
            Game.restoreGame();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Graphics getDrawingContext() {
        this.__drawContext.setClip(0, 0, Application.screenWidth, Application.screenHeight);
        return this.__drawContext;
    }

    public void setCurrentCanvasMode(int newMode) {
        this.generalGameMode = newMode;
    }

    public GameCommand getCommand() {
        if (commands.size() > 0) {
            GameCommand cmd = (GameCommand)commands.elementAt(0);
            commands.removeElementAt(0);
            return cmd;
        }
        return null;
    }

    public void cleanCommands() {
        commands.removeAllElements();
    }

    protected void showNotify() {
        this.isForeground = true;
        if (this.generalGameMode != 4 || Application.menuSystem.getCurrentUIScreen() == null) {
            // empty if block
        }
        Application.getApplication().resumeMID();
        Application.instance.incomingCall = false;
    }

    protected void hideNotify() {
        this.isForeground = false;
        if (Application.getGame() != null) {
            Application.getGame().storeGameState();
        }
        if (this.generalGameMode == 4 && Application.menuSystem.getCurrentUIScreen() == null && Application.getGame() != null && Application.getGame().currentGameState != null && !Application.getGame().currentGameState.isAnyScreenEnabled()) {
            Application.getGame().askAbortToMainMenu();
        }
        isPressedNumKey2 = false;
        isPressedNumKey4 = false;
        isPressedNumKey6 = false;
        isPressedNumKey8 = false;
        isPressedUpKey = false;
        isPressedDownKey = false;
        isPressedLeftKey = false;
        isPressedRightKey = false;
        Application.getApplication().pauseMID();
        Application.instance.incomingCall = true;
    }

    public void keyReleased(int keyCode) {
        KC = keyCode;
        if (keyCode == 35) {
            keyCode = -22;
        }
        if (keyCode == 42) {
            keyCode = -21;
        }
        if (keyCode == 50) {
            isPressedNumKey2 = false;
        }
        if (keyCode == 52) {
            isPressedNumKey4 = false;
        }
        if (keyCode == 54) {
            isPressedNumKey6 = false;
        }
        if (keyCode == 56) {
            isPressedNumKey8 = false;
        }
        try {
            if (this.getGameAction(keyCode) == 1) {
                isPressedUpKey = false;
            }
            if (this.getGameAction(keyCode) == 6) {
                isPressedDownKey = false;
            }
            if (this.getGameAction(keyCode) == 2) {
                isPressedLeftKey = false;
            }
            if (this.getGameAction(keyCode) == 5) {
                isPressedRightKey = false;
            }
        }
        catch (Exception e) {
            __KC = 999;
        }
        if (Application.keyboardEnable) {
            if (this.dialogYesNo != null) {
                __KC = 700;
                this.dialogYesNo.keyReleased(keyCode);
            } else {
                __KC = 701;
                this.insertCommand(keyCode, false);
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == 50) {
            isPressedNumKey2 = true;
        }
        if (keyCode == 52) {
            isPressedNumKey4 = true;
        }
        if (keyCode == 54) {
            isPressedNumKey6 = true;
        }
        if (keyCode == 56) {
            isPressedNumKey8 = true;
        }
        if (this.getGameAction(keyCode) == 1) {
            isPressedUpKey = true;
        }
        if (this.getGameAction(keyCode) == 6) {
            isPressedDownKey = true;
        }
        if (this.getGameAction(keyCode) == 2) {
            isPressedLeftKey = true;
        }
        if (this.getGameAction(keyCode) == 5) {
            isPressedRightKey = true;
        }
        if (Application.keyboardEnable) {
            this.insertCommand(keyCode, true);
        }
    }

    protected void pointerPressed(int x, int y) {
        commands.addElement(new GameCommand(x, y, true));
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
        if (!Interface2D.checkIsLandscape()) {
            commands.addElement(new GameCommand(x, y, false));
        }
    }

    public void draw() {
        Graphics g = this.getDrawingContext();
        try {
            Application.screenWidth = this.getWidth();
            Application.screenHeight = this.getHeight();
            switch (this.generalGameMode) {
                case 3: {
                    Application.userInterface.drawUserInterface(g);
                    break;
                }
                case 4: {
                    Application.game.drawGamePlay(g);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDialog(YesNoDialogBox dlg) {
        this.dialogYesNo = dlg;
    }

    public void DrawPoint(int x, int y, int color) {
        Graphics g = this.getDrawingContext();
        g.setColor(color);
        g.fillRect(x, y, 2, 2);
    }

    public void DrawRect(int x, int y, int w, int h, int color) {
        Graphics g = this.getDrawingContext();
        g.setColor(color);
        g.fillRect(x, y, w, h);
    }

    public void showLoadingScreen(String imageName, int color, String text) {
        Graphics g = this.getDrawingContext();
        Image splashImage = null;
        try {
            splashImage = imageName == null ? null : Image.createImage((String)imageName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (splashImage == null) {
            splashImage = Utils.loadImage(imageName);
        }
        g.setColor(color);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (splashImage != null) {
            g.drawImage(splashImage, this.getWidth() >> 1, this.getHeight() >> 1, 3);
        }
        if (text != null) {
            UIScreen.drawString(g, text, Application.screenWidth >> 1, Application.screenHeight - 3, 33, 0);
        }
        this.flushGraphics();
    }

    public void insertCommand(int keyCode, boolean pressed) {
        commands.addElement(new GameCommand(keyCode, pressed));
    }

    public void flushActiveTouchCommands() {
        activeTouchCommands.removeAllElements();
    }

    public void clearBackground(int ySplitLine, int color1, int color2) {
        Graphics g = this.getDrawingContext();
        g.setColor(color1);
        g.fillRect(0, 0, Application.screenWidth, ySplitLine);
        g.setColor(color2);
        g.fillRect(0, ySplitLine, Application.screenWidth, Application.screenHeight - ySplitLine);
    }

    public void RenderLine(int color, int x1, int y1, int x2, int y2) {
        Graphics g = this.getDrawingContext();
        g.setColor(color);
        g.drawLine(x1, y1, x2, y2);
    }

    public void RenderRoadLine(Image image, int x, int y) {
        Graphics g = this.getDrawingContext();
        g.drawImage(image, x, y, 0);
    }

    public void RenderRoadLine2(int[] buffer, int nWidth, int x, int y) {
        Graphics g = this.getDrawingContext();
        g.drawRGB(buffer, 0, nWidth, x, y, nWidth, 1, false);
    }

    public void RenderRoadLine2Image(Image image, int x, int y) {
        Graphics g = this.getDrawingContext();
        g.drawImage(image, x, y, 0);
    }

    public void RenderHoriz(Image image, int dx, int dy, int nStartX, int nStartY) {
        Graphics g = this.getDrawingContext();
        int nMaxX = image.getWidth();
        if ((nStartX %= nMaxX) > 0) {
            nStartX = -nStartX;
        }
        do {
            g.drawImage(image, nStartX, nStartY, 0);
        } while ((nStartX += nMaxX) < dx);
    }

    public void RenderRect(int color, int x, int y, int width, int height) {
        Graphics g = this.getDrawingContext();
        g.setColor(color);
        g.drawRect(x, y, width, height);
    }

    public void RenderObject1(int x1, int y1, int x2, int y2) {
        long fxOne = 4096 * (x2 - x1) / 1000;
        Graphics g = this.getDrawingContext();
        int nTmp = (int)(3L * fxOne / 4096L);
        if (nTmp < 1) {
            nTmp = 1;
        }
        g.setColor(0);
        int nTmp2 = (int)(38L * fxOne / 4096L);
        if (nTmp2 < 1) {
            nTmp2 = 1;
        }
        g.fillRect(x1, y1, nTmp2, y2 - y1);
        g.setColor(0xD1D1D1);
        int nTmp1 = (int)(7L * fxOne / 4096L);
        if (nTmp1 < 1) {
            nTmp1 = 1;
        }
        g.fillRect(x1 + nTmp, y1, nTmp1, y2 - y1);
        g.setColor(0x9A9A9A);
        nTmp2 = (int)(7L * fxOne / 4096L);
        if (nTmp2 < 1) {
            nTmp2 = 1;
        }
        g.fillRect(x1 + nTmp + nTmp1, y1, nTmp2, y2 - y1);
        g.setColor(0x3C3C3C);
        g.fillRect(x1 + nTmp + nTmp1 + nTmp2, y1, nTmp2, y2 - y1);
        g.setColor(0x212121);
        g.fillRect(x1 + nTmp + nTmp1 + 2 * nTmp2, y1, nTmp2, y2 - y1);
        g.setColor(0);
        nTmp2 = (int)(38L * fxOne / 4096L);
        if (nTmp2 < 1) {
            nTmp2 = 1;
        }
        int xx = x2 - nTmp2;
        g.fillRect(xx, y1, nTmp2, y2 - y1);
        g.setColor(0xD1D1D1);
        nTmp1 = (int)(7L * fxOne / 4096L);
        if (nTmp1 < 1) {
            nTmp1 = 1;
        }
        g.fillRect(xx + nTmp, y1, nTmp1, y2 - y1);
        g.setColor(0x9A9A9A);
        nTmp2 = (int)(7L * fxOne / 4096L);
        if (nTmp2 < 1) {
            nTmp2 = 1;
        }
        g.fillRect(xx + nTmp + nTmp1, y1, nTmp2, y2 - y1);
        g.setColor(0x3C3C3C);
        g.fillRect(xx + nTmp + nTmp1 + nTmp2, y1, nTmp2, y2 - y1);
        g.setColor(0x212121);
        g.fillRect(xx + nTmp + nTmp1 + 2 * nTmp2, y1, nTmp2, y2 - y1);
        int yy = y1 + nTmp;
        g.setColor(0);
        nTmp1 = (int)(35L * fxOne / 4096L);
        if (nTmp1 < 1) {
            nTmp1 = 1;
        }
        if ((nTmp2 = (int)(28L * fxOne / 4096L)) < 1) {
            nTmp2 = 1;
        }
        g.fillRect(x1 + nTmp1, yy, x2 - x1 - 2 * nTmp1, nTmp2);
        g.setColor(0xD1D1D1);
        nTmp2 = (int)(7L * fxOne / 4096L);
        if (nTmp2 < 1) {
            nTmp2 = 1;
        }
        g.fillRect(x1 + nTmp1, yy + nTmp2, x2 - x1 - 2 * nTmp1, nTmp2);
        g.setColor(0x9A9A9A);
        g.fillRect(x1 + nTmp1, yy + 2 * nTmp2, x2 - x1 - 2 * nTmp1, nTmp2);
        yy = y1 + (int)(237L * fxOne / 4096L);
        g.setColor(0);
        nTmp1 = (int)(35L * fxOne / 4096L);
        if (nTmp1 < 1) {
            nTmp1 = 1;
        }
        if ((nTmp2 = (int)(28L * fxOne / 4096L)) < 1) {
            nTmp2 = 1;
        }
        g.fillRect(x1 + nTmp1, yy, x2 - x1 - 2 * nTmp1, nTmp2);
        g.setColor(0xD1D1D1);
        nTmp2 = (int)(7L * fxOne / 4096L);
        if (nTmp2 < 1) {
            nTmp2 = 1;
        }
        g.fillRect(x1 + nTmp1, yy + nTmp2, x2 - x1 - 2 * nTmp1, nTmp2);
        g.setColor(0x9A9A9A);
        g.fillRect(x1 + nTmp1, yy + 2 * nTmp2, x2 - x1 - 2 * nTmp1, nTmp2);
        int xx1 = x1 + (int)(205L * fxOne / 4096L);
        g.setColor(0);
        g.fillRect(xx1, y1 + nTmp, nTmp2, yy + nTmp2 - (y1 + nTmp));
        g.setColor(0xD1D1D1);
        g.fillRect(xx1 + nTmp2, y1 + nTmp + nTmp2, nTmp2, yy + nTmp2 - (y1 + nTmp) - nTmp2);
        int xx2 = x1 + (int)(788L * fxOne / 4096L);
        g.setColor(0);
        g.fillRect(xx2, y1 + nTmp, nTmp2, yy + nTmp2 - (y1 + nTmp));
        g.setColor(0xD1D1D1);
        g.fillRect(xx2 - nTmp2, y1 + nTmp + nTmp2, nTmp2, yy + nTmp2 - (y1 + nTmp) - nTmp2);
        g.setColor(0x3C3C3C);
        g.fillRect(xx1 + 2 * nTmp2, y1 + nTmp + 2 * nTmp2, xx2 - xx1 - 3 * nTmp2, yy - (y1 + nTmp + 2 * nTmp2));
        int fWH = (int)(55L * fxOne) / 4096;
        int nWH = (int)(55L * fxOne / 4096L);
        xx = x1 + (int)(205L * fxOne / 4096L) + 5 * nTmp2;
        yy = y1 + nTmp + 3 * nTmp2;
        g.setColor(0xFFFFFF);
        for (int i = 0; i < 5; ++i) {
            int nX = xx + 2 * i * fWH;
            g.fillRect(nX, yy, nWH, nWH);
            g.fillRect(nX, yy + 2 * fWH, nWH, nWH);
            nX = xx + (2 * i * fWH + fWH);
            g.fillRect(nX, yy + nWH, nWH, nWH);
            g.fillRect(nX, yy + 3 * fWH, nWH, nWH);
        }
    }

    public void RenderObjectLeftTop(Image image, int X, int Y) {
        Graphics g = this.getDrawingContext();
        g.drawImage(image, X, Y, 0);
    }

    public void RenderPieceObjectLeftTop(Image image, int nSrcX, int nSrcY, int nSrcDX, int nSrcDY, int X, int Y) {
        Graphics g = this.getDrawingContext();
        g.drawRegion(image, nSrcX, nSrcY, nSrcDX, nSrcDY, 0, X, Y, 0);
    }

    public void RenderObject(Image image, int CenterX, int BottomY, int transf) {
        Graphics g = this.getDrawingContext();
        int nX = CenterX - image.getWidth() / 2;
        int nY = BottomY - image.getHeight();
        g.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), transf, nX, nY, 0);
    }

    class GameCommand {
        public int keyCode;
        public boolean pressed;
        public int touchX;
        public int touchY;

        GameCommand(int kc, boolean press) {
            this.touchX = -1;
            this.touchY = -1;
            this.keyCode = kc;
            this.pressed = press;
        }

        GameCommand(int x, int y, boolean press) {
            this.touchX = x;
            this.touchY = y;
            this.keyCode = 0;
            this.pressed = press;
        }
    }
}

