/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.BestScores;
import Kartmania.CGTexture;
import Kartmania.CarEngine2D;
import Kartmania.Game;
import Kartmania.ObjectsCache;
import Kartmania.Options;
import Kartmania.RandSync;
import Kartmania.SelectGameMode;
import Kartmania.SelectHSPlayers;
import Kartmania.UICaptionThick;
import Kartmania.UIScreen;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SelectTrack
extends UIScreen {
    public int currentTrackToShow = 0;
    public static final int NUM_TRACKS = 12;
    public static int selectedTrack;
    private int weather;
    private CGTexture[] tracks = null;
    private Image trackIcon = null;
    private int[] animOffsets = new int[]{0, 1, 2, 1};
    public static String[] trackIconNames;
    public int[] trackIconIndexes = new int[]{2, 2, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2};

    public void autoSize() {
    }

    public void onUpdate(long deltaTime) {
        this.lifeTime += deltaTime * 3L;
    }

    protected boolean touchPressed(int x, int y) {
        int offset = 0;
        int left = Application.screenWidth - ObjectsCache.scrollUpImg.getWidth() / 4 - ObjectsCache.scrollUpImg.getWidth();
        int right = left + ObjectsCache.scrollUpImg.getWidth();
        int top = this.positionY + 2 * this.height / 10 - offset + this.YScrollOffset - 5;
        int bottom = this.positionY + 2 * this.height / 10 - offset + this.YScrollOffset + ObjectsCache.scrollUpImg.getHeight() + 5;
        if (x >= left && x < right && y >= top && y <= bottom && SelectGameMode.selectedGameMode != 3) {
            --this.currentTrackToShow;
            if (this.currentTrackToShow < 0) {
                this.currentTrackToShow = 11;
            }
            this.updateTrackShown();
            return true;
        }
        top = this.positionY + 7 * this.height / 10 + offset + this.YScrollOffset - 5;
        bottom = this.positionY + 7 * this.height / 10 + offset + this.YScrollOffset + ObjectsCache.scrollUpImg.getHeight() + 5;
        if (x >= left && x < right && y >= top && y <= bottom && SelectGameMode.selectedGameMode != 3) {
            ++this.currentTrackToShow;
            if (this.currentTrackToShow >= 12) {
                this.currentTrackToShow = 0;
            }
            this.updateTrackShown();
            return true;
        }
        return false;
    }

    public void draw(Graphics g) {
        boolean isTouchScreen = false;
        int oneFourth = Application.screenWidth / 4;
        int nPosX = Application.screenWidth / 2;
        int nPosY = Application.screenHeight - 9 - 49;
        String str = Application.defaultFont.encodeDynamicString(this.currentTrackToShow + 1 + "/12");
        UIScreen.drawString(g, str, Application.screenWidth / 2, Application.screenHeight - 18 - 98 + 3 * Application.defaultFont.getFontHeight() / 2, 17, 0);
        str = Application.lp.getTranslatedString(Options.languageID, "ID_TRACK_COUNTRY_" + this.currentTrackToShow);
        UIScreen.drawString(g, str, nPosX, nPosY - this.tracks[this.currentTrackToShow].m_Image.getHeight() / 2 - Application.defaultFont.getFontHeight() / 4, 33, 0);
        g.drawImage(this.tracks[this.currentTrackToShow].m_Image, nPosX, nPosY, 3);
        if (SelectGameMode.selectedGameMode == 2 && !BestScores.tracksUnlocked[this.currentTrackToShow]) {
            g.drawImage(ObjectsCache.lockIcon, nPosX + this.tracks[this.currentTrackToShow].m_Image.getWidth() / 2, nPosY, 3);
        }
        int nCenterY = nPosY;
        this.drawScrollBars(g);
    }

    public SelectTrack() {
        this.tracks = new CGTexture[12];
        for (int i = 0; i < 12; ++i) {
            this.tracks[i] = CarEngine2D.GetTextureManager().AddTexture(trackIconNames[this.trackIconIndexes[i]], 0, 0, null, null);
        }
        Application.testApp.ResetBestBolidRecord();
        Application.testApp.ResetBolidRecord();
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbBACK);
        this.setCaption(new UICaptionThick(Application.lp.getTranslatedString(Options.languageID, SelectGameMode.selectedGameMode == 3 ? "ID_CAREER_NEXT_RACE" : "ID_CHOOSE_TRACK")));
        if (SelectGameMode.selectedGameMode == 3) {
            this.currentTrackToShow = Game.careerTrackID;
        }
        this.weather = RandSync.nextInt(3);
        this.updateTrackShown();
    }

    protected void rightSoftButton() {
        if (SelectGameMode.selectedGameMode == 2) {
            Application.getApplication().getMenu().setCurrentUIScreen(new SelectGameMode());
        } else if (SelectGameMode.selectedGameMode == 5) {
            Application.getApplication().getMenu().setCurrentUIScreen(new SelectHSPlayers());
        }
    }

    protected void leftSoftButton() {
        if (SelectGameMode.selectedGameMode == 2) {
            if (BestScores.tracksUnlocked[this.currentTrackToShow]) {
                selectedTrack = this.currentTrackToShow;
                Application.getApplication().startGame();
            }
        } else {
            selectedTrack = this.currentTrackToShow;
            Application.getApplication().startGame();
        }
    }

    public void currentItemChanged(int oldID, int currentItemId) {
    }

    public void currentItemSelected(int currentItemId) {
    }

    private void updateTrackShown() {
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
        int gameAction = this.parentCanvas.getGameAction(keyCode);
        if (keyCode == 50) {
            gameAction = 1;
        } else if (keyCode == 56) {
            gameAction = 6;
        } else if (keyCode == 52) {
            gameAction = 2;
        } else if (keyCode == 54) {
            gameAction = 5;
        } else if (keyCode == 53) {
            gameAction = 8;
        }
        switch (gameAction) {
            case 6: {
                if (SelectGameMode.selectedGameMode == 3) break;
                ++this.currentTrackToShow;
                if (this.currentTrackToShow >= 12) {
                    this.currentTrackToShow = 0;
                }
                this.updateTrackShown();
                break;
            }
            case 1: {
                if (SelectGameMode.selectedGameMode == 3) break;
                --this.currentTrackToShow;
                if (this.currentTrackToShow < 0) {
                    this.currentTrackToShow = 11;
                }
                this.updateTrackShown();
                break;
            }
            case 8: {
                this.leftSoftButton();
            }
        }
    }

    static {
        trackIconNames = new String[]{"/giant_ico.png", "/downhill_ico.png", "/slalom_ico.png"};
    }
}

