/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.FXUtility;
import Kartmania.Vector2FX;

class Matrix22FX {
    public long _00;
    public long _01;
    public long _10;
    public long _11;
    static Vector2FX v = new Vector2FX();

    Matrix22FX() {
    }

    public void MatrixF22_Mul_VectorF2(Vector2FX vec, Vector2FX dst) {
        dst.x = (vec.x * this._00 + vec.y * this._10) / 4096L;
        dst.y = (vec.x * this._01 + vec.y * this._11) / 4096L;
    }

    public void Matrix22FX_Copy(Matrix22FX pSrc) {
        this._00 = pSrc._00;
        this._01 = pSrc._01;
        this._10 = pSrc._10;
        this._11 = pSrc._11;
    }

    public void Matrix22FX_Identity() {
        this._00 = 4096L;
        this._01 = 0L;
        this._10 = 0L;
        this._11 = 4096L;
    }

    public void Matrix22FX_Scale(long fxX, long fxY) {
        this._00 = fxX;
        this._01 = 0L;
        this._10 = 0L;
        this._11 = fxY;
    }

    public void MatrixF22_Rot(long fxAngle) {
        int nAngle = (int)(fxAngle / 4096L);
        if (nAngle >= 360) {
            nAngle -= 360;
        }
        if (nAngle < 0) {
            nAngle += 360;
        }
        this._00 = FXUtility.m_CosX[nAngle];
        this._10 = -FXUtility.m_SinX[nAngle];
        this._01 = FXUtility.m_SinX[nAngle];
        this._11 = FXUtility.m_CosX[nAngle];
    }

    public void Matrix22FX_Multiply(Matrix22FX a, Matrix22FX b) {
        this._00 = (a._00 * b._00 + a._10 * b._01) / 4096L;
        this._10 = (a._00 * b._10 + a._10 * b._11) / 4096L;
        this._01 = (a._01 * b._00 + a._11 * b._01) / 4096L;
        this._11 = (a._01 * b._10 + a._11 * b._11) / 4096L;
    }

    public static void GetTransformMatrix(Vector2FX vec, Matrix22FX dst) {
        Matrix22FX.v.x = vec.x;
        Matrix22FX.v.y = vec.y;
        v.Normalize();
        if (Matrix22FX.v.x == 0L) {
            dst._00 = 0x1000000L / Matrix22FX.v.y;
            dst._10 = 0L;
            dst._01 = 0L;
            dst._11 = 0x1000000L / Matrix22FX.v.y;
        } else {
            long fxL2 = (Matrix22FX.v.x * Matrix22FX.v.x + Matrix22FX.v.y * Matrix22FX.v.y) / 4096L;
            dst._00 = 4096L * Matrix22FX.v.y / fxL2;
            dst._10 = 4096L * -Matrix22FX.v.x / fxL2;
            dst._01 = 4096L * Matrix22FX.v.x / fxL2;
            dst._11 = 4096L * Matrix22FX.v.y / fxL2;
        }
    }
}

