/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.ObjectsCache;
import Kartmania.Options;
import Kartmania.Platform;
import Kartmania.SelectGameMode;
import Kartmania.UICaptionThick;
import Kartmania.UIScreen;
import Kartmania.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class HintScreen
extends UIScreen {
    public static int ID_HINT_HOTSEAT = 0;
    public static int ID_HINT_ENTER_CHAMPIONSHIPS = 1;
    public static int ID_HINT_ENTER_CAREER_SCREEN = 2;
    public static int ID_HINT_ENTER_GARAGE = 3;
    public static int ID_HINT_MULTIPLAYER = 4;
    public static int ID_HINT_ENTER_SINGLE_RACE = 5;
    public static int ID_HINT_ENTER_TIME_ATTACK = 6;
    public static int ID_HINT_LOCAL_RESULTS = 7;
    public static int ID_HINT_WORLD_RESULTS = 8;
    public static int ID_HINT_ENTER_SYNCHRONIZATION = 9;
    public static int ID_HINT_END_OF_CHAMPIONSHIPS = 10;
    public static int ID_GAME_OVER = 11;
    public static int ID_HINT_START_LEAGUE1 = 12;
    public static int ID_HINT_START_LEAGUE2 = 13;
    public static int ID_HINT_START_LEAGUE3 = 14;
    public static int ID_HINT_PROMOTED_TO_ADV_LEAGUE = 15;
    public static int ID_HINT_PROMOTED_TO_MAS_LEAGUE = 16;
    public static int ID_HINT_FAILED_TO_PROMOTE = 17;
    public static int ID_HINT_PROMOTED_TO_ADV_LEAGUEB = 18;
    public static int ID_HINT_BRONZE_IN_CHAMPIONSHIPS = 19;
    public static int ID_HINT_SILVER_IN_CHAMPIONSHIPS = 20;
    public static int ID_HINT_GOLD_IN_CHAMPIONSHIPS = 21;
    public static int ID_HINT_NOT_IN_DEMO = 22;
    private static final int MAX_NUM_HINTS = 23;
    private static boolean[] hintsShown = new boolean[23];
    private static String[] hintsTexts = new String[]{"ID_HINT_HOTSEAT", "ID_HINT_ENTER_CHAMPIONSHIPS", "ID_HINT_ENTER_CAREER_SCREEN", "ID_HINT_ENTER_GARAGE", "ID_HINT_MULTIPLAYER", "ID_HINT_ENTER_QUICK_RACE", "ID_HINT_ENTER_TIME_ATTACK", "ID_HINT_LOCAL_RESULTS", "ID_HINT_WORLD_RESULTS", "ID_HINT_ENTER_SYNCHRONIZATION", "ID_HINT_END_OF_CHAMPIONSHIPS1", "ID_GAME_OVER", "ID_HINT_START_LEAGUE1", "ID_HINT_START_LEAGUE2", "ID_HINT_START_LEAGUE3", "ID_HINT_PROMOTED_TO_NEXT_LEAGUE1", "ID_HINT_PROMOTED_TO_NEXT_LEAGUE2", "ID_HINT_END_OF_CHAMPIONSHIPS1", "ID_HINT_PROMOTED_TO_NEXT_LEAGUE1B", "ID_HINT_PROMOTED_TO_NEXT_LEAGUE2B", "ID_HINT_FAILED_CHAMPIONSHIPS", "ID_HINT_GOLD_IN_CHAMPIONSHIPS", "ID_HINT_NOT_IN_DEMO"};
    private static boolean[] hintsSwitchable = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    UIScreen comeBackScreen;
    int hintID;
    Vector askText;
    Vector mainText;
    private boolean scrollable = false;
    private final long SCROLL_SPEED;
    private long scrollOffset = 0L;
    private int textHeight;
    private int askAreaHeight = 0;
    private int mainTextArea;
    private int m_nSoftButtonsState;

    public static void showHintedScreen(UIScreen comeBackScreen, int hintID, int nSoftButtonsState) {
        if (!hintsShown[hintID % 100]) {
            HintScreen hs = new HintScreen(comeBackScreen, hintID, nSoftButtonsState);
            Application.menuSystem.setCurrentUIScreen(hs);
        } else {
            Application.menuSystem.setCurrentUIScreen(comeBackScreen);
        }
    }

    public static void showHintedScreen(UIScreen comeBackScreen, String hintHeader, int hintID, int nSoftButtonsState) {
        if (!hintsShown[hintID % 100]) {
            HintScreen hs = new HintScreen(comeBackScreen, hintHeader, hintID, nSoftButtonsState);
            Application.menuSystem.setCurrentUIScreen(hs);
        } else {
            Application.menuSystem.setCurrentUIScreen(comeBackScreen);
        }
    }

    public HintScreen(UIScreen _comeBackScreen, int _hintID, int nSoftButtonsState) {
        this.SCROLL_SPEED = 30L;
        this.init(_comeBackScreen, null, _hintID, nSoftButtonsState);
    }

    public HintScreen(UIScreen _comeBackScreen, String hintHeader, int _hintID, int nSoftButtonsState) {
        this.SCROLL_SPEED = 30L;
        this.init(_comeBackScreen, hintHeader, _hintID, nSoftButtonsState);
    }

    public void init(UIScreen _comeBackScreen, String hintHeader, int _hintID, int nSoftButtonsState) {
        this.comeBackScreen = _comeBackScreen;
        this.hintID = _hintID;
        this.m_nSoftButtonsState = nSoftButtonsState;
        if (this.m_nSoftButtonsState == 1) {
            this.setSoftButtonImage(ObjectsCache.menuSbOK, null);
        } else if (this.m_nSoftButtonsState == 2) {
            this.setSoftButtonImage(null, ObjectsCache.menuSbBACK);
        } else if (this.m_nSoftButtonsState == 3) {
            this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbBACK);
        }
        if (this.hintID != ID_HINT_GOLD_IN_CHAMPIONSHIPS && this.hintID < 100) {
            if (hintHeader == null) {
                this.setCaption(new UICaptionThick(Application.lp.getTranslatedString(Options.languageID, "ID_HINT_HEADER")));
            } else {
                this.setCaption(new UICaptionThick(Application.lp.getTranslatedString(Options.languageID, hintHeader)));
            }
        } else {
            this.setCaption(new UICaptionThick(Application.lp.getTranslatedString(Options.languageID, "ID_INFO")));
        }
        this.autoSize();
        this.mainTextArea = this.clientAreaHeight;
        int screenW = Application.screenWidth;
        if (this.hintID <= 100) {
            this.mainText = Utils.splitText(Application.lp.getTranslatedString(Options.languageID, hintsTexts[this.hintID]), "+", screenW, 2);
        } else {
            String text = Application.lp.getTranslatedString(Options.languageID, "ID_HINT_END_OF_CHAMPIONSHIPS1") + Application.defaultFont.encodeDynamicString(" " + (this.hintID - 100) + " ") + Application.lp.getTranslatedString(Options.languageID, "ID_HINT_END_OF_CHAMPIONSHIPS2");
            this.mainText = Utils.splitText(text, "+", screenW, 2);
        }
        this.textHeight = (this.mainText.size() + 0) * Application.smallGreyFont.getFontHeight();
        this.checkIfScrollsAreNeeded();
        if (this.scrollable) {
            int nArrowWidth = ObjectsCache.scrollUpImg.getWidth();
            if (this.hintID <= 100) {
                this.mainText = Utils.splitText(Application.lp.getTranslatedString(Options.languageID, hintsTexts[this.hintID]), "+", screenW - nArrowWidth, 2);
            } else {
                String text = Application.lp.getTranslatedString(Options.languageID, "ID_HINT_END_OF_CHAMPIONSHIPS1") + Application.defaultFont.encodeDynamicString(" " + (this.hintID - 100) + " ") + Application.lp.getTranslatedString(Options.languageID, "ID_HINT_END_OF_CHAMPIONSHIPS2");
                this.mainText = Utils.splitText(text, "+", screenW - nArrowWidth, 2);
            }
            this.textHeight = (this.mainText.size() + 0) * Application.smallGreyFont.getFontHeight();
        }
    }

    public void draw(Graphics g) {
        if (this.showScrollbars) {
            this.drawScrollBars(g);
        }
        int yPos = Application.screenHeight - 18;
        this.drawMainText(g, yPos);
    }

    private boolean checkIfScrollsAreNeeded() {
        this.showScrollbars = this.scrollable = this.textHeight > this.mainTextArea;
        return this.scrollable;
    }

    protected boolean touchPressed(int x, int y) {
        int offset = 0;
        int left = Application.screenWidth - ObjectsCache.scrollUpImg.getWidth() / 4 - ObjectsCache.scrollUpImg.getWidth();
        int right = left + ObjectsCache.scrollUpImg.getWidth();
        int top = this.positionY + 2 * this.height / 10 - offset + this.YScrollOffset - 5;
        int bottom = this.positionY + 2 * this.height / 10 - offset + this.YScrollOffset + ObjectsCache.scrollUpImg.getHeight() + 5;
        if (x >= left && x < right && y >= top && y <= bottom) {
            this.scrollingState = -1;
            return true;
        }
        top = this.positionY + 7 * this.height / 10 + offset + this.YScrollOffset - 5;
        bottom = this.positionY + 7 * this.height / 10 + offset + this.YScrollOffset + ObjectsCache.scrollUpImg.getHeight() + 5;
        if (x >= left && x < right && y >= top && y <= bottom) {
            this.scrollingState = 1;
            return true;
        }
        this.scrollingState = 0;
        return false;
    }

    protected boolean touchReleased(int x, int y) {
        this.scrollingState = 0;
        return false;
    }

    private void drawMainText(Graphics g, int bottomY) {
        int fontHeight = Application.smallGreyFont.getFontHeight();
        int yCenterAlign = 0;
        if (!this.scrollable) {
            yCenterAlign = (this.mainTextArea - fontHeight * this.mainText.size()) / 2;
        }
        g.setClip(this.positionX + Platform.WND_MARGIN_LEFT, this.positionY + Platform.WND_MARGIN_TOP, this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT, this.mainTextArea);
        for (int i = 0; i < this.mainText.size(); ++i) {
            int yPosition = this.positionY + this.clientAreaY + i * fontHeight + (int)this.scrollOffset / 4096 + yCenterAlign;
            if (yPosition < 0 || yPosition > Application.screenHeight) continue;
            if (!this.showScrollbars) {
                UIScreen.drawString(g, (String)this.mainText.elementAt(i), this.positionX + this.width / 2, yPosition, 17, 2);
                continue;
            }
            int nArrowWidth = ObjectsCache.scrollUpImg.getWidth();
            UIScreen.drawString(g, (String)this.mainText.elementAt(i), this.positionX + this.width / 2 - nArrowWidth / 2, yPosition, 17, 2);
        }
    }

    private void showOriginalScreen() {
        Application.menuSystem.setCurrentUIScreen(this.comeBackScreen);
    }

    protected void rightSoftButton() {
        if ((this.m_nSoftButtonsState & 2) > 0) {
            Application.menuSystem.setCurrentUIScreen(new SelectGameMode());
        }
    }

    protected void leftSoftButton() {
        if ((this.m_nSoftButtonsState & 1) > 0) {
            this.showOriginalScreen();
        }
    }

    public static void serialize(DataOutputStream dos) throws IOException {
        for (int i = 0; i < 23; ++i) {
            dos.writeBoolean(hintsShown[i]);
        }
    }

    public static void deSerialize(DataInputStream inputStream) throws IOException {
        for (int i = 0; i < 23; ++i) {
            HintScreen.hintsShown[i] = inputStream.readBoolean();
        }
    }

    public void onUpdate(long deltaTime) {
        super.onUpdate(deltaTime);
        if (this.scrollable) {
            int fontHeight;
            int maxScrollValue;
            if (Application.isUpPressed() && this.scrollOffset < 0L) {
                this.scrollOffset += deltaTime * 30L;
            }
            if (Application.isDownPressed() && this.scrollOffset > (long)(4096 * (maxScrollValue = -(fontHeight = Application.smallGreyFont.getFontHeight()) * (this.mainText.size() + 1 - this.mainTextArea / fontHeight)))) {
                this.scrollOffset -= deltaTime * 30L;
            }
        }
    }

    protected void keyReleased(int keyCode) {
        int gameAction = this.parentCanvas.getGameAction(keyCode);
        if (keyCode == 50) {
            gameAction = 1;
        } else if (keyCode == 56) {
            gameAction = 6;
        } else if (keyCode == 52) {
            gameAction = 2;
        } else if (keyCode == 54) {
            gameAction = 5;
        } else if (keyCode == 53) {
            gameAction = 8;
        }
        switch (gameAction) {
            case 8: {
                this.leftSoftButton();
            }
        }
    }

    public void currentItemChanged(int oldID, int currentItemId) {
    }

    public void currentItemSelected(int currentItemId) {
    }

    protected void keyPressed(int keyCode) {
    }

    public void autoSize() {
        this.clientAreaX = Platform.WND_MARGIN_LEFT;
        this.clientAreaWidth = this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT;
        this.clientAreaY = Platform.WND_MARGIN_TOP;
        this.clientAreaHeight = this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM;
    }
}

