/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.CompetitionResultsScreen;
import Kartmania.IGameState;
import Kartmania.Interface2D;
import Kartmania.ObjectsCache;
import Kartmania.Options;
import Kartmania.RaceGameState;
import Kartmania.UICaptionThick;
import Kartmania.UITextBox;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class EndHotSeatGameState
implements IGameState {
    CompetitionResultsScreen competitionResults;
    UITextBox congratulationsScreen;
    String szWinnerNick = new String();
    private static Vector hotSeatResults = new Vector();
    private static Vector resultsColumnNicks = new Vector();
    private static Vector resultsColumnTotal = new Vector();
    private int m_nSubState = 0;
    public static int HSplayerID = 0;

    public static void reset() {
        HSplayerID = 0;
        hotSeatResults.removeAllElements();
    }

    public boolean isAnyScreenEnabled() {
        return true;
    }

    public void OnEnter() {
        this.m_nSubState = 0;
        resultsColumnNicks.removeAllElements();
        resultsColumnTotal.removeAllElements();
        Application.testApp.Sort();
        int nS = Application.testApp.m_SortIndexFinishTimes.length;
        for (int i = 0; i < nS; ++i) {
            int nIndex = Application.testApp.m_SortIndexFinishTimes[i];
            String szNick = new String(Application.lp.getTranslatedString(Options.languageID, "EDIT_PLAYERS_DEFAULT_PLAYER") + Application.defaultFont.encodeDynamicString(" " + (nIndex + 1)));
            long nTotalTime = Application.testApp.m_FinishTimes[nIndex];
            resultsColumnNicks.addElement(szNick);
            resultsColumnTotal.addElement(RaceGameState.formatTime(nTotalTime));
        }
        this.competitionResults = new CompetitionResultsScreen("ID_ROUND_TIMES");
        this.competitionResults.autoSize();
        this.competitionResults.updateList(resultsColumnNicks, resultsColumnTotal);
    }

    public void OnDraw(Graphics g) {
        if (!Application.getGame().isGamePaused()) {
            g.setClip(0, 0, Application.screenWidth, Application.screenHeight);
            g.setColor(-16316665);
            g.fillRect(0, Application.screenHeight - Application.testApp.m_nTranslateScreenY, Application.screenWidth, Application.testApp.m_nTranslateScreenY);
            if (this.competitionResults != null) {
                this.competitionResults.paint(g);
            }
            if (this.congratulationsScreen != null) {
                this.congratulationsScreen.paint(g);
            }
            g.setClip(0, 0, Application.screenWidth, Application.screenHeight);
            g.setColor(11419656);
            g.fillRect(0, Application.screenHeight - 18, Application.screenWidth, 18);
            Interface2D.drawSoftButtons(g, ObjectsCache.menuSbOK, null);
        }
    }

    public void OnKeyReleased(int keyCode) {
        int okButton = Application.SoftButton1_Code;
        int cancelButton = Application.SoftButton2_Code;
        if (!Application.getGame().isGamePaused()) {
            if (keyCode == okButton) {
                this.progressCompetition();
            } else if (keyCode == cancelButton) {
                // empty if block
            }
            int gameAction = Application.gameCanvas.getGameAction(keyCode);
            if (gameAction == 8) {
                this.progressCompetition();
            }
        }
    }

    private void progressCompetition() {
        if (this.m_nSubState == 0) {
            this.m_nSubState = 1;
            resultsColumnNicks.removeAllElements();
            resultsColumnTotal.removeAllElements();
            Application.testApp.Sort();
            int nS = Application.testApp.m_SortIndexFinishTimes.length;
            for (int i = 0; i < nS; ++i) {
                int nIndex = Application.testApp.m_SortIndexFinishTimes[i];
                String szNick = new String(Application.lp.getTranslatedString(Options.languageID, "EDIT_PLAYERS_DEFAULT_PLAYER") + Application.defaultFont.encodeDynamicString(" " + (nIndex + 1)));
                long nTotalTime = Application.testApp.m_FinishTimes[nIndex];
                if (i == 0) {
                    this.szWinnerNick = szNick;
                }
                resultsColumnNicks.addElement(szNick);
                resultsColumnTotal.addElement(RaceGameState.formatTime(nTotalTime));
            }
            this.competitionResults = new CompetitionResultsScreen("ID_ROUND_TIMES");
            this.competitionResults.setCaption(new UICaptionThick(Application.lp.getTranslatedString(Options.languageID, "ID_RACE_RESULTS")));
            this.competitionResults.autoSize();
            this.competitionResults.updateList(resultsColumnNicks, resultsColumnTotal);
        } else if (this.congratulationsScreen == null) {
            this.congratulationsScreen = new UITextBox(false);
            this.congratulationsScreen.setCaption(new UICaptionThick(Application.lp.getTranslatedString(Options.languageID, "ID_RACE_RESULTS")));
            this.congratulationsScreen.autoSize();
            this.congratulationsScreen.setText(Application.lp.getTranslatedString(Options.languageID, "ID_HS_CONGRATULATION") + this.szWinnerNick + Application.defaultFont.encodeDynamicString("+"), "+");
            this.competitionResults = null;
        } else {
            Application.getApplication().goToMainMenu();
        }
    }

    public void OnTouchReleased(int x, int y) {
        if (this.competitionResults != null) {
            this.competitionResults.touchReleased(x, y);
        }
    }

    public void OnTouchPressed(int x, int y) {
        if (x < ObjectsCache.menuSbOK.getWidth() && y > Application.screenHeight - ObjectsCache.menuSbOK.getHeight()) {
            this.progressCompetition();
        } else if (this.competitionResults != null) {
            this.competitionResults.touchPressed(x, y);
        }
    }

    public void OnLeave() {
    }

    public void OnKeyPressed(int keyCode) {
    }

    public void OnUpdate(long deltaTime) {
        if (this.competitionResults != null) {
            this.competitionResults.onUpdate(deltaTime);
        }
    }
}

