/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.BestScores;
import Kartmania.CarEngine2D;
import Kartmania.HUD;
import javax.microedition.lcdui.Graphics;

public class DebugConsole {
    private static final int KEY_0_INT_CODE = 48;
    private static int debugCode;
    private static int debugDigit;
    public static boolean debug_switch_FPS;
    public static boolean debug_switch_MEM;
    public static boolean debug_switch_3D;
    public static boolean debug_switch_2D;
    public static boolean debug_switch_logic;
    public static boolean debug_switch_tracksOnly;
    public static boolean debug_switch_background;
    public static boolean debug_switch_BT;
    public static boolean debug_switch_MEMOPT;
    public static boolean debug_switch_SENSOR;
    public static boolean debug_force_LOD;
    public static boolean debug_show_2DMAP;

    public static void trackDebugCommand(int keyCode) {
        switch (keyCode) {
            case 42: {
                DebugConsole.clear();
                break;
            }
            case 35: {
                DebugConsole.executeDebugCommand();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                int digit = keyCode - 48;
                if (debugDigit == 3) {
                    debugCode = 0;
                    debugDigit = 0;
                }
                if (debugDigit == 0) {
                    debugCode += digit * 100;
                }
                if (debugDigit == 1) {
                    debugCode += digit * 10;
                }
                if (debugDigit == 2) {
                    debugCode += digit;
                }
                ++debugDigit;
            }
        }
    }

    private static void clear() {
        debugCode = 0;
        debugDigit = 0;
    }

    private static void executeDebugCommand() {
        switch (debugCode) {
            case 111: {
                debug_show_2DMAP = !debug_show_2DMAP;
                break;
            }
            case 222: {
                debug_force_LOD = !debug_force_LOD;
                break;
            }
            case 444: {
                debug_switch_SENSOR = !debug_switch_SENSOR;
                break;
            }
            case 999: {
                debug_switch_FPS = !debug_switch_FPS;
                break;
            }
            case 888: {
                BestScores.unlockAllLevelsAndKarts();
                break;
            }
            case 777: {
                debug_switch_MEM = !debug_switch_MEM;
                break;
            }
            case 555: {
                debug_switch_MEMOPT = !debug_switch_MEMOPT;
                break;
            }
            case 100: {
                debug_switch_3D = !debug_switch_3D;
                break;
            }
            case 101: {
                debug_switch_2D = !debug_switch_2D;
                break;
            }
            case 102: {
                debug_switch_logic = !debug_switch_logic;
                break;
            }
            case 103: {
                debug_switch_tracksOnly = !debug_switch_tracksOnly;
                break;
            }
            case 104: {
                debug_switch_background = !debug_switch_background;
                break;
            }
            case 666: {
                debug_switch_BT = !debug_switch_BT;
                break;
            }
            case 300: {
                CarEngine2D.m_bDrawBackground = !CarEngine2D.m_bDrawBackground;
                break;
            }
            case 301: {
                CarEngine2D.m_bDrawHorizontsAndClouds = !CarEngine2D.m_bDrawHorizontsAndClouds;
                break;
            }
            case 302: {
                CarEngine2D.m_bDrawRoad = !CarEngine2D.m_bDrawRoad;
                break;
            }
            case 303: {
                CarEngine2D.m_bDrawObjects = !CarEngine2D.m_bDrawObjects;
                break;
            }
            case 304: {
                CarEngine2D.m_bDrawWeather = !CarEngine2D.m_bDrawWeather;
                break;
            }
            case 305: {
                HUD.disableHUD = !HUD.disableHUD;
                break;
            }
            case 306: {
                CarEngine2D.m_bDrawCars = !CarEngine2D.m_bDrawCars;
                break;
            }
            case 307: {
                HUD.disableHUDStrings = !HUD.disableHUDStrings;
            }
        }
    }

    public static void draw(Graphics g) {
        debug_switch_MEM = true;
        if (debug_switch_MEM) {
            long freeMem = Runtime.getRuntime().freeMemory() / 1024L;
            long totalMem = Runtime.getRuntime().totalMemory() / 1024L;
            long memFree = 4096L - 4096L * freeMem / totalMem;
            int redLineLength = (int)(memFree * (long)Application.screenWidth) / 4096;
            g.setColor(0x40F040);
            g.fillRect(0, 0, Application.screenWidth, 8);
            g.setColor(0xFF4040);
            g.fillRect(0, 0, redLineLength, 8);
        }
    }

    static {
        debugDigit = 0;
        debug_switch_FPS = false;
        debug_switch_MEM = false;
        debug_switch_3D = true;
        debug_switch_2D = true;
        debug_switch_logic = true;
        debug_switch_tracksOnly = false;
        debug_switch_background = true;
        debug_switch_BT = false;
        debug_switch_MEMOPT = false;
        debug_switch_SENSOR = false;
        debug_force_LOD = false;
        debug_show_2DMAP = true;
    }
}

