/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.CGBillboardObject;
import Kartmania.CGTrackNode;
import Kartmania.FXUtility;

class CGCamera {
    public int m_nScreenXSize = 240;
    public int m_nScreenYSize = 320;
    public int m_nScreenHeight = 0;
    public int m_nCameraHeight = 105;
    public int m_nCameraDistance = 150;
    public int m_nRayCastingCount = 100;
    public long m_fxCameraScale = 4096L;
    protected long[] m_arrPlaneDistanceForRay = null;
    public long[] m_arrScaleForRay;
    public int[] m_arrMipMapForRay;
    protected long m_fxFirstPlaneScale = 4096L;
    protected long m_fxLastPlaneScale = 4096L;
    protected long m_fxDeltaScale = (this.m_fxFirstPlaneScale - this.m_fxLastPlaneScale) / (long)this.m_nRayCastingCount;
    protected long m_fxLastDistance;
    protected CGTrackNode m_pCurrentTrackNode = null;

    CGCamera() {
    }

    int FindRayIndexForDistance(long fD) {
        for (int i = 0; i < this.m_nRayCastingCount; ++i) {
            if (this.m_arrPlaneDistanceForRay[i] <= fD) continue;
            return i;
        }
        return this.m_nRayCastingCount - 1;
    }

    public void ResetObj() {
        this.m_pCurrentTrackNode = null;
    }

    public void SetCurrentTrackNode(CGTrackNode pT) {
        this.m_pCurrentTrackNode = pT;
    }

    public CGTrackNode GetCurrentTrackNode() {
        return this.m_pCurrentTrackNode;
    }

    public void PreparePlaneDistanceForRay() {
        int nEyeHeight = this.m_nScreenHeight + this.m_nCameraHeight;
        int nSize = this.m_nRayCastingCount;
        this.m_arrPlaneDistanceForRay = new long[nSize];
        for (int i = 0; i < nSize; ++i) {
            int nScreenPointHeight = this.m_nScreenHeight + i;
            int z = nScreenPointHeight * this.m_nCameraDistance * 4096 / (nEyeHeight - nScreenPointHeight);
            this.m_arrPlaneDistanceForRay[i] = z;
        }
        this.m_fxLastDistance = this.m_arrPlaneDistanceForRay[this.m_nRayCastingCount - 1];
    }

    public void PrepareScaleForRay() {
        int nSize = this.m_nRayCastingCount;
        this.m_arrScaleForRay = new long[nSize];
        long xx = this.CalculateFloatScreenX(409600L, this.m_arrPlaneDistanceForRay[0]);
        xx /= 4096L;
        for (int i = 0; i < nSize; ++i) {
            long fScale;
            long x1 = this.CalculateFloatScreenX(409600L, this.m_arrPlaneDistanceForRay[i]);
            this.m_arrScaleForRay[i] = fScale = x1 / xx;
        }
    }

    public long GetScaleForDistance(long dist) {
        return this.CalculateFloatScreenX(409600L, dist) / 100L;
    }

    public void PrepareMipMapForRay() {
        int i;
        int nSize = this.m_nRayCastingCount;
        this.m_arrMipMapForRay = new int[nSize];
        int nLevel1 = nSize - (int)((long)nSize * 409L / 4096L);
        for (int i2 = nSize - 1; i2 >= nLevel1; --i2) {
            this.m_arrMipMapForRay[i2] = 0;
        }
        int nLevel2 = nSize - (int)((long)nSize * 655L / 4096L);
        for (int i3 = nLevel1 - 1; i3 >= nLevel2; --i3) {
            this.m_arrMipMapForRay[i3] = 1;
        }
        int nLevel3 = nSize - (int)((long)nSize * 1024L / 4096L);
        for (int i4 = nLevel2 - 1; i4 >= nLevel3; --i4) {
            this.m_arrMipMapForRay[i4] = 2;
        }
        int nLevel4 = nSize - (int)((long)nSize * 1638L / 4096L);
        for (int i5 = nLevel3 - 1; i5 >= nLevel4; --i5) {
            this.m_arrMipMapForRay[i5] = 3;
        }
        int nLevel5 = nSize - (int)((long)nSize * 2253L / 4096L);
        for (int i6 = nLevel4 - 1; i6 >= nLevel5; --i6) {
            this.m_arrMipMapForRay[i6] = 4;
        }
        int nLevel6 = nSize - (int)((long)nSize * 2867L / 4096L);
        for (int i7 = nLevel5 - 1; i7 >= nLevel6; --i7) {
            this.m_arrMipMapForRay[i7] = 5;
        }
        int nLevel7 = nSize - (int)((long)nSize * 3482L / 4096L);
        for (i = nLevel6 - 1; i >= nLevel7; --i) {
            this.m_arrMipMapForRay[i] = 6;
        }
        for (i = nLevel7 - 1; i >= 0; --i) {
            this.m_arrMipMapForRay[i] = 7;
        }
    }

    public long CalculateScreenX(long x, long z) {
        long nL = (long)this.m_nCameraDistance * x;
        long nM = ((long)this.m_nCameraDistance * 4096L + z) / 4096L;
        return nL / nM;
    }

    public long CalculateFloatScreenX(long x, long z) {
        long nL = (long)this.m_nCameraDistance * x;
        long nM = ((long)this.m_nCameraDistance * 4096L + z) / 4096L;
        return nL / nM;
    }

    public int CalculateObjectScreenPosition(CGBillboardObject pO, int[] arrScreen) {
        int nEyeHeight = this.m_nScreenHeight + this.m_nCameraHeight;
        long fxScreenPointHeight = (long)(4096 * nEyeHeight) * pO.m_fxTrZ / ((long)(4096 * this.m_nCameraDistance) + pO.m_fxTrZ);
        arrScreen[3] = (int)(fxScreenPointHeight / 4096L - (long)this.m_nScreenHeight);
        long fxD = FXUtility.Sqrt(pO.m_fxTrY * pO.m_fxTrY / 4096L + pO.m_fxTrZ * pO.m_fxTrZ / 4096L);
        long fxScale = this.GetScaleForDistance(fxD);
        long dX = pO.m_fxW * (fxScale / 2L) / 4096L;
        long dY = pO.m_fxH * fxScale / 4096L;
        long fxPivotY = pO.m_fxTrY * fxScale / 4096L;
        dX *= this.m_fxCameraScale;
        dX /= 4096L;
        dY *= this.m_fxCameraScale;
        arrScreen[1] = arrScreen[3] + (int)((dY /= 4096L) / 4096L);
        arrScreen[1] = (int)((long)arrScreen[1] + fxPivotY / 4096L);
        arrScreen[3] = (int)((long)arrScreen[3] + fxPivotY / 4096L);
        long fxX = this.CalculateFloatScreenX(pO.m_fxTrX, pO.m_fxTrZ);
        fxX *= this.m_fxCameraScale;
        fxX /= 4096L;
        int nX = (int)(fxX /= 4096L);
        arrScreen[0] = nX - (int)dX / 4096;
        arrScreen[2] = nX + (int)dX / 4096;
        return 1;
    }

    public int CalculateObjectScreenCenterBottomPosition(CGBillboardObject pO, int[] arrScreen) {
        int nEyeHeight = this.m_nScreenHeight + this.m_nCameraHeight;
        long fxScreenPointHeight = (long)(4096 * nEyeHeight) * pO.m_fxTrZ / ((long)(4096 * this.m_nCameraDistance) + pO.m_fxTrZ);
        arrScreen[1] = (int)(fxScreenPointHeight / 4096L - (long)this.m_nScreenHeight);
        if (arrScreen[1] >= this.m_nRayCastingCount) {
            return 0;
        }
        long fxX = this.CalculateFloatScreenX(pO.m_fxTrX, pO.m_fxTrZ);
        fxX *= this.m_fxCameraScale;
        fxX /= 4096L;
        arrScreen[0] = (int)(fxX /= 4096L);
        return 1;
    }

    public long CalculateObjectScaleForDistance(long fxObjectDistance) {
        int nEyeHeight = this.m_nScreenHeight + this.m_nCameraHeight;
        long fxScreenPointHeight = (long)(4096 * nEyeHeight) * fxObjectDistance / ((long)(4096 * this.m_nCameraDistance) + fxObjectDistance);
        int nScreenPosBottomY = (int)(fxScreenPointHeight / 4096L - (long)this.m_nScreenHeight);
        if (nScreenPosBottomY >= this.m_nRayCastingCount) {
            return -4096L;
        }
        return this.m_fxCameraScale * this.m_arrScaleForRay[nScreenPosBottomY] / 4096L;
    }
}

