/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.PackedImage;
import Kartmania.Utils;
import javax.microedition.lcdui.Image;

public class CGTexture {
    public String m_szName = new String("");
    public Image m_Image = null;
    public int[] m_ImageBuf = null;
    public int m_nSizeX;
    public int m_nSizeY;
    public Image[] m_MipMaps = null;
    public static int m_nNrOfMipMaps = 10;
    public static int m_NrOfMipMapsForObjects = 4;
    public static int m_NrOfMipMapsForBolids = 10;

    public static void Init(int nNrOfMipMapsForObjects, int nNrOfMipMapsForBolids) {
        m_NrOfMipMapsForObjects = nNrOfMipMapsForObjects;
        m_nNrOfMipMaps = m_NrOfMipMapsForBolids = nNrOfMipMapsForBolids;
    }

    public static Image ScaleImage(Image src, int width, int height) {
        return Utils.scaleImageNoAlpha(src, width, height, true);
    }

    public int Create(String szFileName, int nToBuffer, int nMipMaps, int[] arrWidth, int[] arrHeight) {
        Image im = null;
        try {
            im = PackedImage.loadImage(szFileName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (im == null) {
            try {
                im = Image.createImage((String)szFileName);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (im == null) {
            return 0;
        }
        this.m_nSizeX = im.getWidth();
        this.m_nSizeY = im.getHeight();
        if (nToBuffer > 0) {
            this.CreateBufferFrom(im);
        } else if (nMipMaps > 0) {
            this.CreateMipMaps(im, arrWidth, arrHeight);
        } else {
            this.m_Image = im;
        }
        return 1;
    }

    public void CreateMipMaps(Image im, int[] arrWidth, int[] arrHeight) {
        if (this.m_MipMaps != null) {
            return;
        }
        this.m_MipMaps = new Image[m_nNrOfMipMaps];
        for (int i = 0; i < m_nNrOfMipMaps; ++i) {
            if (arrWidth[i] <= 0) {
                arrWidth[i] = 1;
            }
            if (arrHeight[i] <= 0) {
                arrHeight[i] = 1;
            }
            this.m_MipMaps[i] = CGTexture.ScaleImage(im, arrWidth[i], arrHeight[i]);
        }
    }

    public void CreateBufferFrom(Image image) {
        if (this.m_ImageBuf != null) {
            return;
        }
        this.m_ImageBuf = new int[this.m_nSizeX * this.m_nSizeY];
        image.getRGB(this.m_ImageBuf, 0, this.m_nSizeX, 0, 0, this.m_nSizeX, this.m_nSizeY);
    }
}

