/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.CGBillboardObject;
import Kartmania.CGBolid;
import Kartmania.CGBolidRecord;
import Kartmania.CGCamera;
import Kartmania.CGRainSystem;
import Kartmania.CGTexture;
import Kartmania.CGTrack;
import Kartmania.CGTrackNode;
import Kartmania.EditChampionshipsUserName;
import Kartmania.FXUtility;
import Kartmania.LoadingProgress;
import Kartmania.MissionParams;
import Kartmania.Options;
import Kartmania.RandSync;
import Kartmania.RoadRenderer;
import Kartmania.TextureManager;
import Kartmania.Vector2FX;
import Kartmania.Vector3FX;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

class CarEngine2D {
    public static final int SHIFT = 12;
    public static final int[] m_MinTimeAI = new int[]{128000, 132000, 114000, 113000, 125000, 123000, 139000, 119000, 130000, 132000, 136000, 139000};
    public static final int[] m_MaxTimeAI = new int[]{180000, 175000, 145000, 140000, 152000, 150000, 162000, 165000, 145000, 150000, 152000, 150000};
    static boolean m_bDrawBackground = true;
    static boolean m_bDrawHorizontsAndClouds = true;
    static boolean m_bDrawRoad = true;
    static boolean m_bDrawObjects = true;
    static boolean m_bDrawCars = true;
    static boolean m_bDrawWeather = true;
    public int m_nCurrentLevelIndex = -1;
    public int m_nTranslateScreenY = 0;
    long m_fxCameraDistanceFromStart = 12288L;
    long m_fxCameraStraight = 0L;
    int m_nMaxObjectsDistance = 900;
    CGCamera m_Camera = null;
    CGTrack m_Track = null;
    MissionParams m_Mission = null;
    public RoadRenderer m_RoadRenderer = null;
    CGRainSystem m_RainSystem = null;
    static TextureManager m_TextureManager = new TextureManager();
    CGTexture m_BackGroundTexture = null;
    CGTexture m_HorizTexture = null;
    CGTexture m_Horiz2Texture = null;
    CGTexture m_RoadTexture = null;
    CGTexture m_CloudTexture = null;
    int m_nNrOfBolids;
    CGBolid[] m_Bolid;
    public long m_fxDeltaTime;
    public long m_fxCurrentTime;
    CGBolidRecord m_BestBolidRecord = null;
    CGBolidRecord m_BolidRecord = null;
    public long m_fxCameraAngle;
    int m_nGameState;
    public static int m_nPlayerGender = 0;
    public static final int ENGINE2D_STATE_PREPARE = 0;
    public static final int ENGINE2D_STATE_DRIVE = 1;
    public static final int ENGINE2D_STATE_ON_FINISH = 2;
    public static final int ENVIRONMENT_SAFARI = 1;
    public static final int ENVIRONMENT_WINTER = 2;
    public static final int ENVIRONMENT_HALOWEEN = 3;
    public static final int[] levelWeather = new int[]{1, 0, 0, 1, 0, 2, 2, 2, 0, 0, 0, 0};
    public static final int[] levelEnvironment = new int[]{3, 3, 3, 3, 1, 1, 1, 1, 2, 2, 2, 2};
    public CGTexture[] m_TexturesSmoke = null;
    public int m_nNrOfPlayers = 0;
    public int m_nCurrentPlayer = 0;
    public int[] m_FinishTimes = new int[12];
    public int[] m_SortIndexFinishTimes = null;
    int roadLineParamsSize = 0;
    RoadLineParam[] roadLineParams = new RoadLineParam[320];
    Vector2FX g_vecDir = new Vector2FX();
    Vector3FX g_vecPos3D = new Vector3FX();
    Vector2FX v = new Vector2FX();
    public static final int MAX_NUM_BOLIDS = 4;
    CGBillboardObject[] arrObj = new CGBillboardObject[4];
    int[] arrObjIndexes = new int[4];
    CGBolid[] bol = new CGBolid[4];
    Vector2FX vecPos = new Vector2FX();
    Vector2FX vecCameraDir = new Vector2FX();
    int[] arrPixels = new int[4];

    public void SetGameState(int i) {
        this.m_nGameState = i;
    }

    public int GetGameState() {
        return this.m_nGameState;
    }

    public CGBolid GetHumanBolid() {
        return this.m_Bolid[0];
    }

    CGTrack GetTrack() {
        return this.m_Track;
    }

    public static TextureManager GetTextureManager() {
        return m_TextureManager;
    }

    public CGBolid GetBolid(int i) {
        return this.m_Bolid[i];
    }

    CarEngine2D() {
        this.m_RainSystem = new CGRainSystem();
        this.m_RainSystem.Init(180);
    }

    public void PrepareFinishTimes(int nMinTime, int nMaxTime) {
        int i = 1;
        while (i < 12) {
            long fAlpha = 4096 * i / 12;
            long fAdd1 = (long)RandSync.nextInt(250) - 500L;
            long fAdd2 = (long)RandSync.nextInt(250) - 500L;
            this.m_FinishTimes[i] = (int)((long)nMinTime * fAlpha + (long)nMaxTime * (4096L - fAlpha) + fAdd1);
            int n = i;
            this.m_FinishTimes[n] = this.m_FinishTimes[n] / 4096;
            this.m_FinishTimes[i] = (int)((long)nMinTime * fAlpha + (long)nMaxTime * (4096L - fAlpha) + fAdd2);
            int n2 = i++;
            this.m_FinishTimes[n2] = this.m_FinishTimes[n2] / 4096;
        }
    }

    public int GetRankingPos() {
        int nCurPlayer = 0;
        int nSize = this.m_nNrOfPlayers;
        if (nSize == 1) {
            nSize = 12;
        } else {
            nSize = this.m_nCurrentPlayer + 1;
            nCurPlayer = this.m_nCurrentPlayer;
        }
        int[] m_TmpTimeArray = new int[nSize];
        for (int i = 0; i < nSize; ++i) {
            m_TmpTimeArray[i] = this.m_FinishTimes[i];
        }
        int[] m_IndexesArray = new int[nSize];
        for (int j = 0; j < nSize; ++j) {
            int nMinValue = m_TmpTimeArray[0];
            int nMinIndex = 0;
            for (int i = 1; i < nSize; ++i) {
                if (m_TmpTimeArray[i] >= nMinValue) continue;
                nMinValue = m_TmpTimeArray[i];
                nMinIndex = i;
            }
            m_IndexesArray[j] = nMinIndex;
            if (nMinIndex == nCurPlayer) {
                return j;
            }
            m_TmpTimeArray[nMinIndex] = 1000000;
        }
        return -1;
    }

    public int GetSummaryRankingPos() {
        int nCurPlayer = 0;
        int nSize = this.m_nNrOfPlayers;
        if (nSize == 1) {
            nSize = 12;
        } else {
            nSize = this.m_nCurrentPlayer + 1;
            nCurPlayer = this.m_nCurrentPlayer;
        }
        int[] m_TmpTimeArray = new int[nSize];
        for (int i = 0; i < nSize; ++i) {
            m_TmpTimeArray[i] = this.m_FinishTimes[i];
        }
        int[] m_IndexesArray = new int[nSize];
        for (int j = 0; j < nSize; ++j) {
            int nMinValue = m_TmpTimeArray[0];
            int nMinIndex = 0;
            for (int i = 1; i < nSize; ++i) {
                if (m_TmpTimeArray[i] >= nMinValue) continue;
                nMinValue = m_TmpTimeArray[i];
                nMinIndex = i;
            }
            m_IndexesArray[j] = nMinIndex;
            if (nMinIndex == nCurPlayer) {
                return j;
            }
            m_TmpTimeArray[nMinIndex] = 1000000;
        }
        return -1;
    }

    public void Sort() {
        int nCurPlayer = 0;
        int nSize = this.m_nNrOfPlayers;
        if (nSize == 1) {
            nSize = 12;
        } else {
            nSize = this.m_nNrOfPlayers;
            nCurPlayer = -1;
        }
        int[] m_TmpTimeArray = new int[12];
        for (int i = 0; i < nSize; ++i) {
            m_TmpTimeArray[i] = this.m_FinishTimes[i];
        }
        this.m_SortIndexFinishTimes = new int[nSize];
        for (int j = 0; j < nSize; ++j) {
            int nMinValue = m_TmpTimeArray[0];
            int nMinIndex = 0;
            for (int i = 1; i < nSize; ++i) {
                if (m_TmpTimeArray[i] >= nMinValue) continue;
                nMinValue = m_TmpTimeArray[i];
                nMinIndex = i;
            }
            this.m_SortIndexFinishTimes[j] = nMinIndex;
            if (nMinIndex != nCurPlayer || nSize == 12) {
                // empty if block
            }
            m_TmpTimeArray[nMinIndex] = 1000000;
        }
        m_TmpTimeArray = null;
        System.out.println("End sort...");
    }

    public void CreateAllTextures() {
        CarEngine2D.GetTextureManager().AddTexture("/dust1_1.png", 0, 0, null, null);
        CarEngine2D.GetTextureManager().AddTexture("/dust1_2.png", 0, 0, null, null);
        CarEngine2D.GetTextureManager().AddTexture("/dust1_3.png", 0, 0, null, null);
        CarEngine2D.GetTextureManager().AddTexture("/dust2_1.png", 0, 0, null, null);
        CarEngine2D.GetTextureManager().AddTexture("/dust2_2.png", 0, 0, null, null);
        CarEngine2D.GetTextureManager().AddTexture("/dust2_3.png", 0, 0, null, null);
        CarEngine2D.GetTextureManager().AddTexture("/dust3_1.png", 0, 0, null, null);
        CarEngine2D.GetTextureManager().AddTexture("/dust3_2.png", 0, 0, null, null);
        CarEngine2D.GetTextureManager().AddTexture("/dust3_3.png", 0, 0, null, null);
        CarEngine2D.GetTextureManager().AddTexture("/Horiz1Texture1.png", 0, 0, null, null);
        CarEngine2D.GetTextureManager().AddTexture("/Horiz1Texture2.png", 0, 0, null, null);
        CarEngine2D.GetTextureManager().AddTexture("/Horiz1Texture3.png", 0, 0, null, null);
        CarEngine2D.GetTextureManager().AddTexture("/Horiz2Texture1.png", 0, 0, null, null);
        CarEngine2D.GetTextureManager().AddTexture("/Horiz2Texture2.png", 0, 0, null, null);
        CarEngine2D.GetTextureManager().AddTexture("/Horiz2Texture3.png", 0, 0, null, null);
        CGBillboardObject.CreateBillboardObject(18, 0L, 0L, 0L);
        CGBillboardObject.CreateBillboardObject(19, 0L, 0L, 0L);
        CGBillboardObject.CreateBillboardObject(20, 0L, 0L, 0L);
        CGBillboardObject.CreateBillboardObject(21, 0L, 0L, 0L);
        CGBillboardObject.CreateBillboardObject(22, 0L, 0L, 0L);
        CGBillboardObject.CreateBillboardObject(23, 0L, 0L, 0L);
    }

    protected void DeleteIngameTextures() {
        CarEngine2D.GetTextureManager().DeleteTexture("/dust1_1.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/dust1_2.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/dust1_3.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/dust2_1.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/dust2_2.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/dust2_3.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/dust3_1.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/dust3_2.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/dust3_3.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/Horiz1Texture1.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/Horiz1Texture2.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/Horiz1Texture3.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/Horiz2Texture1.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/Horiz2Texture2.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/Horiz2Texture3.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/rocks1.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/rocks2.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/rocks3.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/1_tree_1.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/1_tree_2.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/1_low_grass.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/2_tree_1.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/2_tree_2.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/2_low_grass.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/3_tree_1.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/3_tree_2.png");
        CarEngine2D.GetTextureManager().DeleteTexture("/3_low_grass.png");
    }

    public void PrepareRoad(int nEnvironment) {
        if (this.m_RoadRenderer != null && this.m_RoadRenderer.m_nEnvironment == nEnvironment) {
            return;
        }
        this.m_TexturesSmoke = new CGTexture[3];
        this.m_TexturesSmoke[0] = CarEngine2D.GetTextureManager().AddTexture("/dust" + nEnvironment + "_1.png", 0, 0, null, null);
        this.m_TexturesSmoke[1] = CarEngine2D.GetTextureManager().AddTexture("/dust" + nEnvironment + "_2.png", 0, 0, null, null);
        this.m_TexturesSmoke[2] = CarEngine2D.GetTextureManager().AddTexture("/dust" + nEnvironment + "_3.png", 0, 0, null, null);
        for (int i = 0; i < 320; ++i) {
            this.roadLineParams[i] = new RoadLineParam();
        }
        this.m_RoadRenderer = new RoadRenderer();
        this.m_RoadRenderer.m_nType = 1;
        this.m_RoadTexture = CarEngine2D.GetTextureManager().AddTexture("/Road" + nEnvironment + ".png", 0, 0, null, null);
        this.m_RoadRenderer.m_nType = 2;
        this.m_RoadTexture = null;
        this.m_RoadRenderer.m_Color1 = 50;
        this.m_RoadRenderer.m_Color2 = 60;
        int nRoadBlendColor = 0;
        this.m_RoadRenderer.m_R = (nRoadBlendColor & 0xFF0000) >> 16;
        this.m_RoadRenderer.m_G = (nRoadBlendColor & 0xFF00) >> 8;
        this.m_RoadRenderer.m_B = nRoadBlendColor & 0xFF;
        this.m_RoadRenderer.m_nEnvironment = nEnvironment;
        if (nEnvironment == 1) {
            this.m_RoadRenderer.m_nColor1_R = 186;
            this.m_RoadRenderer.m_nColor1_G = 201;
            this.m_RoadRenderer.m_nColor1_B = 222;
            this.m_RoadRenderer.m_nColor2_R = 255;
            this.m_RoadRenderer.m_nColor2_G = 255;
            this.m_RoadRenderer.m_nColor2_B = 255;
        } else if (nEnvironment == 2) {
            this.m_RoadRenderer.m_nColor1_R = 244;
            this.m_RoadRenderer.m_nColor1_G = 176;
            this.m_RoadRenderer.m_nColor1_B = 113;
            this.m_RoadRenderer.m_nColor2_R = 221;
            this.m_RoadRenderer.m_nColor2_G = 172;
            this.m_RoadRenderer.m_nColor2_B = 92;
        } else {
            this.m_RoadRenderer.m_nColor1_R = 132;
            this.m_RoadRenderer.m_nColor1_G = 104;
            this.m_RoadRenderer.m_nColor1_B = 60;
            this.m_RoadRenderer.m_nColor2_R = 130;
            this.m_RoadRenderer.m_nColor2_G = 99;
            this.m_RoadRenderer.m_nColor2_B = 78;
        }
        if (this.m_RoadTexture != null) {
            this.m_RoadRenderer.SetImage(this.m_RoadTexture.m_Image);
        }
        long fxRoadHalfSize = 300L * this.m_Camera.m_fxCameraScale;
        this.m_RoadRenderer.Setup((int)(fxRoadHalfSize >> 12), this.m_Camera.m_arrScaleForRay, this.m_Camera.m_nRayCastingCount);
    }

    public void SaveBolidRecord() {
        if (this.m_BolidRecord == null) {
            this.m_BestBolidRecord = null;
        } else {
            if (this.m_BestBolidRecord == null) {
                this.m_BestBolidRecord = this.m_BolidRecord;
            } else if (this.m_BolidRecord.GetTotalTime() < this.m_BestBolidRecord.GetTotalTime()) {
                this.m_BestBolidRecord = this.m_BolidRecord;
            }
            this.m_BolidRecord = null;
        }
    }

    public CGBolidRecord GetBestBolidRecord() {
        return this.m_BestBolidRecord;
    }

    public void ResetBestBolidRecord() {
        if (this.m_BestBolidRecord != null) {
            this.m_BestBolidRecord.Reset();
        }
        this.m_BestBolidRecord = null;
    }

    public CGBolidRecord GetBolidRecord() {
        return this.m_BolidRecord;
    }

    public void ResetBolidRecord() {
        if (this.m_BolidRecord != null) {
            this.m_BolidRecord.Reset();
            this.m_BolidRecord = null;
        }
    }

    public void Load(String szFileName, int nLevelNr) {
        LoadingProgress.Reset(true);
        this.m_nCurrentLevelIndex = nLevelNr;
        int nEnvironment = levelEnvironment[nLevelNr];
        this.m_BackGroundTexture = null;
        this.m_HorizTexture = null;
        this.m_Horiz2Texture = null;
        this.m_RoadTexture = null;
        if (this.m_Bolid != null && this.m_Bolid[0] != null) {
            this.m_Bolid[0].ResetObj();
            this.m_Bolid[0] = null;
            this.m_Bolid = null;
        }
        if (this.m_Track != null) {
            this.m_Track.ResetObj();
            this.m_Track = null;
        }
        this.m_Track = new CGTrack();
        if (this.m_Mission == null) {
            this.m_Mission = new MissionParams();
        }
        try {
            DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream(szFileName));
            this.deSerialize(dis);
        }
        catch (Exception e) {
            return;
        }
        this.PrepareRoad(nEnvironment);
        LoadingProgress.StepProgress();
        this.m_Track.GenerateObjects_Env(nEnvironment);
        if (nEnvironment == 1) {
            this.m_Track.GenerateObjects_1();
        } else if (nEnvironment == 2) {
            this.m_Track.GenerateObjects_2();
        } else if (nEnvironment == 3) {
            this.m_Track.GenerateObjects_3();
        }
        LoadingProgress.StepProgress();
        CGTexture bgTexture = CarEngine2D.GetTextureManager().AddTexture("/BackGround" + nEnvironment + ".png", 0, 0, null, null);
        this.m_BackGroundTexture = new CGTexture();
        this.m_BackGroundTexture.m_nSizeX = bgTexture.m_Image.getWidth();
        this.m_BackGroundTexture.m_nSizeY = Application.screenHeight;
        this.m_BackGroundTexture.m_szName = this.m_BackGroundTexture.m_szName;
        this.m_BackGroundTexture.m_Image = CGTexture.ScaleImage(bgTexture.m_Image, this.m_BackGroundTexture.m_nSizeX, this.m_BackGroundTexture.m_nSizeY);
        LoadingProgress.StepProgress();
        this.m_HorizTexture = CarEngine2D.GetTextureManager().AddTexture("/Horiz1Texture" + nEnvironment + ".png", 0, 0, null, null);
        this.m_Horiz2Texture = CarEngine2D.GetTextureManager().AddTexture("/Horiz2Texture" + nEnvironment + ".png", 0, 0, null, null);
        this.AfterLoad();
        this.m_fxCurrentTime = 0L;
        LoadingProgress.EndProgress();
    }

    public void AfterLoad() {
        this.m_fxCameraDistanceFromStart = 4096L;
        this.m_fxCameraStraight = 0L;
        this.m_Camera.SetCurrentTrackNode(null);
        this.m_Track.m_vecLastCameraDir.x = -409600L;
        this.m_Track.m_vecLastCameraDir.y = -409600L;
        this.m_Camera.SetCurrentTrackNode(this.m_Track.m_pFirstTrackNode);
        this.m_nGameState = 0;
        this.m_Track.m_nCurrentCheckPointIndex = 0;
        this.m_Track.m_nCurrentStoneIndex = 0;
        this.m_Track.m_fxCurrentCameraAngle = 4096000L;
        this.m_RainSystem.SetMode(levelWeather[this.m_nCurrentLevelIndex]);
    }

    private void deSerialize(DataInputStream dis) throws IOException {
        this.m_Track.deSerialize(dis);
        this.m_Mission.deSerialize(dis);
        this.m_Track.CreateCheckPointsFromMissionParams(this.m_Mission);
    }

    public void Go() {
        for (int i = 0; i < this.m_nNrOfBolids; ++i) {
            this.m_Bolid[i].Go();
        }
        this.m_nGameState = 1;
        this.m_fxCurrentTime = 0L;
    }

    public long GetMaxObjectsDistanceScale() {
        return this.m_Camera.CalculateObjectScaleForDistance(this.m_nMaxObjectsDistance * 4096);
    }

    public void SetCameraSettings(int nScreenX, int nScreenY, int nRayCount, int nCameraY, int nCameraDeep, long fxScale, int nTranslateScreenY) {
        this.m_Camera = new CGCamera();
        this.m_Camera.m_nScreenXSize = nScreenX;
        this.m_Camera.m_nScreenYSize = nScreenY;
        this.m_Camera.m_nCameraHeight = nCameraY;
        this.m_Camera.m_nCameraDistance = nCameraDeep;
        this.m_Camera.m_nRayCastingCount = nRayCount;
        this.m_Camera.m_fxCameraScale = fxScale;
        this.m_Camera.PreparePlaneDistanceForRay();
        this.m_Camera.PrepareScaleForRay();
        this.m_Camera.PrepareMipMapForRay();
        this.m_fxCameraDistanceFromStart = 4096L;
        this.m_fxCameraStraight = 0L;
        this.m_Camera.SetCurrentTrackNode(null);
        this.m_nTranslateScreenY = nTranslateScreenY;
    }

    public int GetHumanRacePosition() {
        long fxHumanDist = this.m_Bolid[0].GetRealDistanceFromStart();
        int nPos = 0;
        for (int i = 1; i < this.m_nNrOfBolids; ++i) {
            if (this.m_Bolid[i].GetState() != 2 && this.m_Bolid[i].GetRealDistanceFromStart() <= fxHumanDist) continue;
            ++nPos;
        }
        return nPos;
    }

    public int GetBolidRacePosition(int nIndex) {
        long fxHumanDist = this.m_Bolid[nIndex].GetRealDistanceFromStart();
        int nPos = 0;
        for (int i = 0; i < this.m_nNrOfBolids; ++i) {
            if (nIndex == i || this.m_Bolid[i].GetState() != 2 && this.m_Bolid[i].GetRealDistanceFromStart() <= fxHumanDist) continue;
            ++nPos;
        }
        return nPos;
    }

    public void SetupLaps(int n) {
        for (int i = 0; i < this.m_nNrOfBolids; ++i) {
            this.m_Bolid[i].SetupLaps(n);
        }
        this.m_nGameState = 0;
    }

    void StepBolids() {
        for (int i = 0; i < this.m_nNrOfBolids; ++i) {
            this.m_Bolid[i].Step();
        }
        if (this.m_nGameState == 1 && this.m_Bolid[0].GetState() == 2) {
            this.m_nGameState = 2;
        }
        this.m_fxCameraDistanceFromStart = this.m_Bolid[0].GetDistanceFromStart() - 102400L;
        this.m_fxCameraStraight = this.m_Bolid[0].GetCurrentStraight();
        CGTrackNode pTN = this.m_Track.FindPlaceOnTrack3D(this.m_Bolid[0].GetDistanceFromStart(), 0L, null, this.g_vecPos3D, this.g_vecDir);
        this.m_Bolid[0].GetBillboardObject().m_fxY = this.g_vecPos3D.y;
        if (this.m_fxCameraDistanceFromStart > this.m_Track.m_fxTrackLength) {
            this.m_fxCameraDistanceFromStart -= this.m_Track.m_fxTrackLength;
            this.m_Camera.SetCurrentTrackNode(this.m_Track.m_pFirstTrackNode);
        } else if (this.m_fxCameraDistanceFromStart < 0L) {
            this.m_fxCameraDistanceFromStart = this.m_Track.m_fxTrackLength + this.m_fxCameraDistanceFromStart;
        }
    }

    void DrawWeather() {
        if (m_bDrawWeather && this.m_RainSystem != null) {
            this.m_RainSystem.Step(this.m_fxDeltaTime);
            this.m_RainSystem.Render();
        }
    }

    void DrawBackground() {
        if (this.m_BackGroundTexture != null) {
            int nW = this.m_BackGroundTexture.m_Image.getWidth();
            int numHorizonStrips = this.m_Camera.m_nScreenXSize / nW;
            for (int i = 0; i <= numHorizonStrips; ++i) {
                Application.gameCanvas.RenderObjectLeftTop(this.m_BackGroundTexture.m_Image, i * nW, 0 - this.m_nTranslateScreenY);
            }
        } else {
            Graphics g = Application.gameCanvas.getDrawingContext();
            g.setColor(-1);
            g.fillRect(0, this.m_Camera.m_nScreenYSize - this.m_Camera.m_nRayCastingCount - this.m_nTranslateScreenY, this.m_Camera.m_nScreenXSize, this.m_Camera.m_nRayCastingCount);
            g.setColor(-7360513);
            g.fillRect(0, 0 - this.m_nTranslateScreenY, this.m_Camera.m_nScreenXSize, this.m_Camera.m_nScreenYSize - this.m_Camera.m_nRayCastingCount);
        }
    }

    void DrawHorizontsAndClouds() {
        if (m_bDrawHorizontsAndClouds && this.m_HorizTexture != null && this.m_HorizTexture.m_Image != null) {
            int nStartY;
            int nAngle = (int)this.m_Track.m_fxCurrentCameraAngle / 4096;
            if (nAngle > 200) {
                nAngle -= 360;
            }
            int nStartX = (int)(this.m_fxCameraAngle / 180L * (long)this.m_HorizTexture.m_Image.getWidth() / 4096L);
            if (this.m_Horiz2Texture != null && this.m_Horiz2Texture.m_Image != null) {
                int nStartY2 = this.m_Camera.m_nScreenYSize - this.m_Camera.m_nRayCastingCount - this.m_Horiz2Texture.m_Image.getHeight() + 3 + nAngle;
                this.m_RoadRenderer.m_nLandShaftY = this.m_Camera.m_nScreenYSize - nStartY2 - this.m_Horiz2Texture.m_Image.getHeight();
                Application.gameCanvas.RenderHoriz(this.m_Horiz2Texture.m_Image, this.m_Camera.m_nScreenXSize, this.m_Horiz2Texture.m_Image.getHeight(), nStartX / 2, nStartY2 - this.m_nTranslateScreenY);
            }
            if (this.m_Camera.m_nScreenYSize - (nStartY = this.m_Camera.m_nScreenYSize - this.m_Camera.m_nRayCastingCount - this.m_HorizTexture.m_Image.getHeight() + 3 + nAngle) - this.m_HorizTexture.m_Image.getHeight() > this.m_RoadRenderer.m_nLandShaftY) {
                this.m_RoadRenderer.m_nLandShaftY = this.m_Camera.m_nScreenYSize - nStartY - this.m_HorizTexture.m_Image.getHeight();
            }
            Application.gameCanvas.RenderHoriz(this.m_HorizTexture.m_Image, this.m_Camera.m_nScreenXSize, this.m_HorizTexture.m_Image.getHeight(), nStartX, nStartY - this.m_nTranslateScreenY);
        }
    }

    void DrawRoadToTable() {
        long fxRoadHalfSize = 150L * this.m_Camera.m_fxCameraScale;
        CGTrackNode pNN = this.m_Camera.GetCurrentTrackNode();
        CGTrackNode pOutNode = null;
        int nLastRayIndex = -1;
        int g_lastRayNumber = 0;
        long fxLastV = -4096L;
        this.roadLineParamsSize = 0;
        int nStepSize = 1;
        if (m_bDrawRoad) {
            for (int i = 0; i <= 300; i += nStepSize) {
                int nScreenY = this.m_Camera.m_nScreenYSize - 1 - i;
                long fxStartRayZ = 0L;
                long fxStartRayY = i * 4096;
                long fxStopRayZ = this.m_Camera.m_nCameraDistance * 4096;
                long fxStopRayY = (i - this.m_Camera.m_nCameraHeight) * 4096;
                long fxDlg = FXUtility.Sqrt(fxStopRayZ * fxStopRayZ / 4096L + fxStopRayY * fxStopRayY / 4096L);
                fxStopRayZ *= 4096L;
                fxStopRayZ /= fxDlg;
                fxStopRayY *= 4096L;
                fxStopRayY /= fxDlg;
                fxStopRayZ = (long)((float)fxStopRayZ * ((float)this.m_Camera.m_fxLastDistance / 4096.0f));
                fxStopRayY = (long)((float)fxStopRayY * ((float)this.m_Camera.m_fxLastDistance / 4096.0f));
                long fxV = this.m_Track.GetZForRay(fxStartRayY, fxStartRayZ, fxStopRayY += fxStartRayY, fxStopRayZ += fxStartRayZ, pNN);
                if ((float)fxV < 0.0f && fxLastV < 0L && ++g_lastRayNumber > 10) break;
                fxLastV = fxV;
                long fxZ = fxV;
                pOutNode = this.m_Track.GetXForZ(fxZ, pNN, this.v);
                if (pOutNode == null) break;
                long fxX = this.v.x;
                long fxY = this.v.y;
                pNN = pOutNode;
                long fxDist = FXUtility.Sqrt(fxY * fxY / 4096L + fxZ * fxZ / 4096L);
                int nRayIndex = this.m_Camera.FindRayIndexForDistance(fxDist);
                if (nRayIndex < nLastRayIndex) break;
                nLastRayIndex = nRayIndex;
                fxX = this.m_Camera.CalculateFloatScreenX(fxX, fxZ);
                int nX = (int)((fxX *= this.m_Camera.m_fxCameraScale) / 0x1000000L);
                long v1 = (this.m_fxCameraDistanceFromStart + fxDist) / 4096L % 256L;
                this.roadLineParams[this.roadLineParamsSize].depth = fxDist;
                this.roadLineParams[this.roadLineParamsSize].nRayIndex = nRayIndex;
                this.roadLineParams[this.roadLineParamsSize].nX = nX + this.m_Camera.m_nScreenXSize / 2;
                this.roadLineParams[this.roadLineParamsSize].nY = nScreenY - this.m_nTranslateScreenY;
                this.roadLineParams[this.roadLineParamsSize].uv = v1;
                ++this.roadLineParamsSize;
            }
        }
        this.m_RoadRenderer.m_nLandShaftY = Application.screenHeight - this.m_nTranslateScreenY - this.roadLineParams[this.roadLineParamsSize - 1].nY;
        if (this.m_RoadRenderer.m_nLandShaftY < Application.screenHeight / 3) {
            this.m_RoadRenderer.m_nLandShaftY = Application.screenHeight / 3;
        }
    }

    void Step() {
        int i;
        this.m_fxCurrentTime += this.m_fxDeltaTime;
        this.StepBolids();
        for (i = 0; i < this.m_nNrOfBolids; ++i) {
            this.bol[i] = this.m_Bolid[i];
        }
        for (i = 0; i < this.m_nNrOfBolids; ++i) {
            int nIndex = -1;
            long fxD = -4096L;
            for (int k = 0; k < this.m_nNrOfBolids; ++k) {
                if (this.bol[k] == null || this.bol[k].GetRealDistanceFromStart() <= fxD) continue;
                nIndex = k;
                fxD = this.bol[k].GetRealDistanceFromStart();
            }
            if (nIndex < 0) break;
            this.arrObj[this.m_nNrOfBolids - 1 - i] = this.bol[nIndex].GetBillboardObject();
            this.arrObjIndexes[this.m_nNrOfBolids - 1 - i] = nIndex;
            this.bol[nIndex] = null;
        }
        CGTrackNode pN = this.m_Track.PrepareTrackForCamera(this.m_fxCameraDistanceFromStart, this.m_fxCameraStraight, null, this.m_Camera.m_fxLastDistance, this.vecPos, this.vecCameraDir, this.arrObj, this.m_nNrOfBolids);
        this.m_Camera.SetCurrentTrackNode(pN);
        this.m_fxCameraAngle = Vector2FX.AngleFromVector(this.vecCameraDir);
        this.DrawBackground();
        this.DrawHorizontsAndClouds();
        this.roadLineParamsSize = 0;
        this.DrawRoadToTable();
        this.m_RoadRenderer.DrawLand(this.m_Camera.m_nScreenYSize - this.m_nTranslateScreenY);
        int nCenterX = 0;
        int nBottomY = 0;
        CGTexture.m_nNrOfMipMaps = CGTexture.m_NrOfMipMapsForObjects;
        if (m_bDrawObjects) {
            for (int j = this.roadLineParamsSize - 1; j >= 0; --j) {
                int nSize = this.m_Track.m_arrCurrentObjects.size();
                for (int i2 = nSize - 1; i2 >= this.m_nNrOfBolids; --i2) {
                    CGBillboardObject pO = (CGBillboardObject)this.m_Track.m_arrCurrentObjects.elementAt(i2);
                    if (pO.m_fxTrZ < 0L || pO.m_fxTrZ > (long)(this.m_nMaxObjectsDistance * 4096)) {
                        this.m_Track.m_arrCurrentObjects.removeElementAt(i2);
                        continue;
                    }
                    if (pO.m_fxTrZ < this.roadLineParams[j].depth || this.m_Camera.CalculateObjectScreenPosition(pO, this.arrPixels) <= 0) continue;
                    this.arrPixels[1] = this.m_Camera.m_nScreenYSize - this.arrPixels[1];
                    this.arrPixels[3] = this.m_Camera.m_nScreenYSize - this.arrPixels[3];
                    this.arrPixels[0] = this.arrPixels[0] + this.m_Camera.m_nScreenXSize / 2;
                    this.arrPixels[2] = this.arrPixels[2] + this.m_Camera.m_nScreenXSize / 2;
                    if (this.arrPixels[0] > this.m_Camera.m_nScreenXSize || this.arrPixels[2] < 0) {
                        this.m_Track.m_arrCurrentObjects.removeElementAt(i2);
                        continue;
                    }
                    nCenterX = (this.arrPixels[0] + this.arrPixels[2]) / 2;
                    if (nCenterX > this.m_Camera.m_nScreenXSize || nCenterX < 0) {
                        this.m_Track.m_arrCurrentObjects.removeElementAt(i2);
                        continue;
                    }
                    nBottomY = this.arrPixels[3];
                    if (pO.m_nLinearScale > 0) {
                        int width = this.arrPixels[2] - this.arrPixels[0] + 1;
                        int height = this.arrPixels[3] - this.arrPixels[1] + 1;
                        Application.gameCanvas.RenderObject1(nCenterX - width / 2, nBottomY - height - this.m_nTranslateScreenY, nCenterX + width / 2, nBottomY - this.m_nTranslateScreenY);
                    } else {
                        long fxD = FXUtility.Sqrt(pO.m_fxTrX * pO.m_fxTrX / 4096L + pO.m_fxTrY * pO.m_fxTrY / 4096L + pO.m_fxTrZ * pO.m_fxTrZ / 4096L);
                        int nRayIndex = this.m_Camera.FindRayIndexForDistance(fxD);
                        long fxScalePercent = this.m_Camera.m_arrScaleForRay[nRayIndex];
                        int nMipMapIndex = (int)(fxScalePercent * (long)CGTexture.m_nNrOfMipMaps / 4096L) + 1;
                        if (nMipMapIndex >= CGTexture.m_nNrOfMipMaps) {
                            nMipMapIndex = CGTexture.m_nNrOfMipMaps - 1;
                        }
                        if (nMipMapIndex < 0) {
                            nMipMapIndex = 0;
                        }
                        Application.gameCanvas.RenderObject(pO.m_Texture.m_MipMaps[nMipMapIndex], nCenterX, nBottomY - this.m_nTranslateScreenY, pO.m_nMirrored);
                    }
                    this.m_Track.m_arrCurrentObjects.removeElementAt(i2);
                }
                this.m_RoadRenderer.DrawLine(j, this.roadLineParams[j].nRayIndex, this.roadLineParams[j].depth, this.roadLineParams[j].nX, this.roadLineParams[j].nY, this.roadLineParams[j].uv);
            }
        }
        CGTexture.m_nNrOfMipMaps = CGTexture.m_NrOfMipMapsForBolids;
        if (m_bDrawCars) {
            for (int i3 = this.m_nNrOfBolids - 1; i3 >= 0; --i3) {
                int nBolidIndex;
                CGBillboardObject pO = (CGBillboardObject)this.m_Track.m_arrCurrentObjects.elementAt(i3);
                if (pO.m_fxTrZ < 0L || pO.m_fxTrZ > (long)(this.m_nMaxObjectsDistance * 4096) || this.m_Camera.CalculateObjectScreenPosition(pO, this.arrPixels) <= 0 || this.m_Bolid[nBolidIndex = this.arrObjIndexes[i3]].IsHuman() == 2 && this.m_nGameState < 1) continue;
                this.arrPixels[1] = this.m_Camera.m_nScreenYSize - this.arrPixels[1];
                this.arrPixels[3] = this.m_Camera.m_nScreenYSize - this.arrPixels[3];
                this.arrPixels[0] = this.arrPixels[0] + this.m_Camera.m_nScreenXSize / 2;
                this.arrPixels[2] = this.arrPixels[2] + this.m_Camera.m_nScreenXSize / 2;
                nCenterX = (this.arrPixels[0] + this.arrPixels[2]) / 2;
                nBottomY = this.arrPixels[3];
                int nAngleVariant = 3;
                int nTransf = 0;
                long fxBolidAngle = Vector2FX.AngleFromVector(this.m_Bolid[nBolidIndex].m_DirVector);
                if ((fxBolidAngle -= this.m_fxCameraAngle) > 737280L) {
                    fxBolidAngle -= 1474560L;
                } else if (fxBolidAngle < -737280L) {
                    fxBolidAngle += 1474560L;
                }
                if (nBolidIndex > 0) {
                    if (fxBolidAngle > 143360L) {
                        nAngleVariant = 0;
                        nTransf = 2;
                    } else if (fxBolidAngle > 81920L) {
                        nAngleVariant = 1;
                        nTransf = 2;
                    } else if (fxBolidAngle > 10L) {
                        nAngleVariant = 2;
                        nTransf = 2;
                    } else if (fxBolidAngle < -143360L) {
                        nAngleVariant = 0;
                    } else if (fxBolidAngle < -81920L) {
                        nAngleVariant = 1;
                    } else if (fxBolidAngle < -10L) {
                        nAngleVariant = 2;
                    }
                } else if (this.m_Bolid[nBolidIndex].IsStraightLeft() > 0) {
                    nAngleVariant = this.m_Bolid[nBolidIndex].m_fxSterringLeftTime < 600L ? 2 : 1;
                    this.m_Bolid[nBolidIndex].m_nViewAngleVariant = nAngleVariant;
                } else if (this.m_Bolid[nBolidIndex].IsStraightRight() > 0) {
                    nAngleVariant = this.m_Bolid[nBolidIndex].m_fxSterringRightTime < 600L ? 2 : 1;
                    nTransf = 2;
                    this.m_Bolid[nBolidIndex].m_nViewAngleVariant = -nAngleVariant;
                } else {
                    long fxff = this.m_Bolid[nBolidIndex].GetCurrentSterringStraight();
                    if (this.m_Bolid[nBolidIndex].m_nViewAngleVariant == 1) {
                        this.m_Bolid[nBolidIndex].m_nViewAngleVariant = nAngleVariant = 2;
                    } else if (this.m_Bolid[nBolidIndex].m_nViewAngleVariant == -1) {
                        nAngleVariant = 2;
                        this.m_Bolid[nBolidIndex].m_nViewAngleVariant = -nAngleVariant;
                        nTransf = 2;
                    } else if (this.m_Bolid[nBolidIndex].m_nViewAngleVariant == 2) {
                        this.m_Bolid[nBolidIndex].m_nViewAngleVariant = nAngleVariant = 3;
                    } else if (this.m_Bolid[nBolidIndex].m_nViewAngleVariant == -2) {
                        this.m_Bolid[nBolidIndex].m_nViewAngleVariant = nAngleVariant = 3;
                        nTransf = 2;
                    }
                }
                if (this.m_Bolid[0].IsDrift() != 0) {
                    nAngleVariant = 0;
                    nTransf = this.m_Bolid[0].IsDrift() > 0 ? 2 : 0;
                }
                int nMipMapIndex = 1;
                Application.gameCanvas.RenderObject(this.m_Bolid[nBolidIndex].m_TexturesShadow[nAngleVariant].m_MipMaps[nMipMapIndex], nCenterX, nBottomY - this.m_nTranslateScreenY, nTransf);
                int nNoise = 0;
                if (this.m_Bolid[nBolidIndex].m_nState == 1 && this.m_Bolid[nBolidIndex].m_fxCurrentVelocity > 204800L) {
                    nNoise = Application.screenHeight > 200 ? RandSync.nextInt(3) : RandSync.nextInt(2);
                }
                Application.gameCanvas.RenderObject(this.m_Bolid[nBolidIndex].m_Textures[nAngleVariant].m_MipMaps[nMipMapIndex], nCenterX, nBottomY - this.m_nTranslateScreenY - (nNoise += this.m_Bolid[nBolidIndex].m_nJumpHeight), nTransf);
                this.m_Bolid[nBolidIndex].DrawSmoke(nCenterX, nBottomY - this.m_nTranslateScreenY - nNoise, Application.gameCanvas.getDrawingContext());
                if (nBolidIndex != 0) continue;
            }
        }
    }

    public void SetupBolids(int nCount) {
        int i;
        this.m_nNrOfBolids = nCount;
        long[] arrStartPos = new long[4];
        long[] arrStartStraight = new long[4];
        long[] arrMaxVelocity = new long[4];
        long[] arrAccelerate = new long[4];
        String[] arrNick = new String[]{EditChampionshipsUserName.playerNick, Application.lp.getTranslatedString(Options.languageID, "RIDER_NAME_0"), Application.lp.getTranslatedString(Options.languageID, "RIDER_NAME_1"), Application.lp.getTranslatedString(Options.languageID, "RIDER_NAME_2")};
        if (nCount == 0) {
            this.ResetBestBolidRecord();
            this.m_nNrOfBolids = 1;
            arrStartPos[0] = 0x190000L;
            arrStartStraight[0] = 0L;
            arrMaxVelocity[0] = 1843200L;
            arrAccelerate[0] = 327680L;
            this.m_Bolid = new CGBolid[this.m_nNrOfBolids];
            for (i = 0; i < this.m_nNrOfBolids; ++i) {
                this.m_Bolid[i] = new CGBolid(i);
            }
            this.m_Bolid[0].SetHuman(1);
        }
        for (i = 0; i < this.m_nNrOfBolids; ++i) {
            this.m_Bolid[i].Setup(arrStartPos[i], arrStartStraight[i], arrMaxVelocity[i], arrAccelerate[i]);
            this.m_Bolid[i].SetBolidIndex(i);
            this.m_Bolid[i].SetNick(arrNick[i]);
        }
        this.m_nGameState = 0;
    }

    public class RoadLineParam {
        public long depth;
        public int nRayIndex;
        public int nX;
        public int nY;
        public long uv;
    }
}

