/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.CarEngine2D;
import Kartmania.RandSync;
import java.util.Random;

public class CGRainSystem {
    public static final int modeNone = 0;
    public static final int modeRain = 1;
    public static final int modeSnow = 2;
    private int[] tabColor = new int[]{0x555566, 0x444455, 0x666677, 0x333344};
    int m_nMaxDrops;
    int[] m_arrDropX = null;
    int[] m_arrDropY = null;
    int[] m_arrDropZ = null;
    Random m_rnd;
    int m_nDropIndex;
    int m_nDropX;
    int m_nDropY;
    int m_nTime;
    int m_nMode = 0;
    private int[] colors = new int[]{-3092225, -2565889, -986881, -460545, -1};

    public void Init(int nMaxDrops) {
        this.m_nMaxDrops = nMaxDrops;
        this.m_rnd = new Random();
        this.m_arrDropX = new int[this.m_nMaxDrops];
        this.m_arrDropY = new int[this.m_nMaxDrops];
        this.m_arrDropZ = new int[this.m_nMaxDrops];
        for (int i = 0; i < this.m_nMaxDrops; ++i) {
            this.m_arrDropX[i] = Math.abs(RandSync.nextInt()) % Application.screenWidth;
            this.m_arrDropY[i] = Math.abs(RandSync.nextInt()) % Application.screenHeight;
            this.m_arrDropZ[i] = Math.abs(RandSync.nextInt(5)) + 1;
        }
        this.m_nTime = 0;
    }

    public void Step(long deltaTime) {
        if (this.m_nMode == 0) {
            return;
        }
        int m_nDeltaX = -5;
        int m_nDeltaY = 8;
        long speed = Application.testApp.m_Bolid[0].GetCurrentVelocity() / (Application.testApp.m_Bolid[0].m_fxMaxVelocityPerSec / 4096L);
        if (speed > 4096L) {
            m_nDeltaX = -1;
            m_nDeltaY = 8;
        } else if (speed > 3072L) {
            m_nDeltaX = -1;
            m_nDeltaY = 8;
        } else if (speed > 2048L) {
            m_nDeltaX = -2;
            m_nDeltaY = 8;
        } else if (speed > 1024L) {
            m_nDeltaX = -3;
            m_nDeltaY = 8;
        }
        if (this.m_nMode == 2) {
            m_nDeltaX /= 2;
            m_nDeltaY /= 2;
        } else {
            m_nDeltaX *= 2;
            m_nDeltaY *= 2;
        }
        for (int i = 0; i < this.m_nMaxDrops; ++i) {
            int n = i;
            this.m_arrDropX[n] = this.m_arrDropX[n] + m_nDeltaX * this.m_arrDropZ[i];
            if (this.m_arrDropX[i] < 0) {
                int n2 = i;
                this.m_arrDropX[n2] = this.m_arrDropX[n2] + Application.screenWidth;
            }
            int n3 = i;
            this.m_arrDropY[n3] = this.m_arrDropY[n3] + m_nDeltaY * this.m_arrDropZ[i];
            if (this.m_arrDropY[i] <= Application.testApp.m_Camera.m_nScreenYSize) continue;
            int n4 = i;
            this.m_arrDropY[n4] = this.m_arrDropY[n4] - Application.testApp.m_Camera.m_nScreenYSize;
        }
        this.m_nTime -= (int)(deltaTime * 1000L);
        if (this.m_nTime <= 0) {
            this.m_nDropX = Math.abs(RandSync.nextInt()) % Application.screenWidth;
            this.m_nDropY = Math.abs(RandSync.nextInt()) % Application.testApp.m_Camera.m_nScreenYSize;
            this.m_nTime = 3000 + Math.abs(RandSync.nextInt()) % 1000;
            this.m_nDropIndex = Math.abs(RandSync.nextInt()) % 2;
        }
    }

    public void Render() {
        if (this.m_nMode == 0) {
            return;
        }
        int nDropSize = 1;
        int nDX = 4;
        int nDY = 10;
        int nAdd = 2;
        long speed = Application.testApp.m_Bolid[0].GetCurrentVelocity() / (Application.testApp.m_Bolid[0].m_fxMaxVelocityPerSec / 4096L);
        if (speed > 4096L) {
            nAdd = 1;
            nDX = 1;
            nDY = 5;
        } else if (speed > 3072L) {
            nAdd = 2;
            nDX = 1;
            nDY = 6;
        } else if (speed > 2048L) {
            nAdd = 2;
            nDX = 2;
            nDY = 8;
        } else if (speed > 1024L) {
            nAdd = 2;
            nDX = 3;
            nDY = 9;
        }
        if (this.m_nMode == 2) {
            nDropSize = 1;
            for (int i = 0; i < this.m_nMaxDrops; i += nAdd) {
                Application.gameCanvas.RenderRect(this.colors[this.m_arrDropZ[i] - 1], this.m_arrDropX[i], this.m_arrDropY[i], nDropSize, nDropSize);
            }
        } else {
            int color1 = 0x7788CC;
            int color2 = 0x997744;
            if (CarEngine2D.levelEnvironment[Application.testApp.m_nCurrentLevelIndex] == 2) {
                color1 = 0x88AACC;
                color2 = 0xCC9944;
            }
            for (int i = 0; i < this.m_nMaxDrops; i += nAdd) {
                int nScale = 1;
                if (this.m_arrDropZ[i] < 2) {
                    nScale = 2;
                }
                int nC = color1;
                if (this.m_arrDropY[i] > Application.screenHeight / 2 - Application.testApp.m_nTranslateScreenY) {
                    nC = color2;
                }
                Application.gameCanvas.RenderLine(nC, this.m_arrDropX[i], this.m_arrDropY[i], this.m_arrDropX[i] - nDX * nDropSize / nScale, this.m_arrDropY[i] + nDY * nDropSize / nScale);
            }
        }
    }

    public void SetMode(int b) {
        this.m_nMode = b;
    }
}

