/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.FXUtility;
import Kartmania.RandSync;
import java.util.Random;

public class CGSnowSystem {
    int m_nMaxDrops;
    int[] m_arrDropX = null;
    int[] m_arrDropY = null;
    int[] m_arrDropZ = null;
    Random m_rnd = new Random();
    int m_nDropIndex;
    int m_nDropX;
    int m_nDropY;
    int m_nTime;
    private int[] colors = new int[]{-3092225, -2565889, -986881, -460545, -1};

    public void Init(int nMaxDrops) {
        this.m_nMaxDrops = nMaxDrops;
        this.m_arrDropX = new int[this.m_nMaxDrops];
        this.m_arrDropY = new int[this.m_nMaxDrops];
        this.m_arrDropZ = new int[this.m_nMaxDrops];
        for (int i = 0; i < this.m_nMaxDrops; ++i) {
            this.m_arrDropX[i] = FXUtility.abs(RandSync.nextInt()) % Application.testApp.m_Camera.m_nScreenXSize;
            this.m_arrDropY[i] = FXUtility.abs(RandSync.nextInt()) % Application.testApp.m_Camera.m_nScreenYSize;
            this.m_arrDropZ[i] = FXUtility.abs(RandSync.nextInt(5)) + 1;
        }
        this.m_nTime = 0;
    }

    public void StepRain() {
        int m_nDeltaX = -10;
        int m_nDeltaY = 23;
        for (int i = 0; i < this.m_nMaxDrops; ++i) {
            int n = i;
            this.m_arrDropX[n] = this.m_arrDropX[n] + m_nDeltaX;
            if (this.m_arrDropX[i] < 0) {
                int n2 = i;
                this.m_arrDropX[n2] = this.m_arrDropX[n2] + Application.testApp.m_Camera.m_nScreenXSize;
            }
            int n3 = i;
            this.m_arrDropY[n3] = this.m_arrDropY[n3] + m_nDeltaY;
            if (this.m_arrDropY[i] <= Application.testApp.m_Camera.m_nScreenYSize) continue;
            int n4 = i;
            this.m_arrDropY[n4] = this.m_arrDropY[n4] - Application.testApp.m_Camera.m_nScreenYSize;
        }
        this.m_nTime -= (int)((float)Application.testApp.m_fxDeltaTime * 1000.0f);
        if (this.m_nTime <= 0) {
            this.m_nDropX = FXUtility.abs(RandSync.nextInt()) % Application.testApp.m_Camera.m_nScreenXSize;
            this.m_nDropY = FXUtility.abs(RandSync.nextInt()) % Application.testApp.m_Camera.m_nScreenYSize;
            this.m_nTime = 3000 + FXUtility.abs(RandSync.nextInt()) % 1000;
            this.m_nDropIndex = FXUtility.abs(RandSync.nextInt()) % 2;
        }
    }

    public void StepSnow() {
        for (int i = 0; i < this.m_nMaxDrops; ++i) {
            int n = i;
            this.m_arrDropY[n] = this.m_arrDropY[n] + (int)((long)this.m_arrDropZ[i] * (2L * Application.testApp.m_Camera.m_fxCameraScale) / 4096L);
            if (this.m_arrDropY[i] <= Application.testApp.m_Camera.m_nScreenYSize) continue;
            int n2 = i;
            this.m_arrDropY[n2] = this.m_arrDropY[n2] - Application.testApp.m_Camera.m_nScreenYSize;
        }
    }

    public void RenderSnow() {
        int nDropSize = 1;
        for (int i = 0; i < this.m_nMaxDrops; ++i) {
            Application.gameCanvas.RenderRect(this.colors[this.m_arrDropZ[i] - 1], this.m_arrDropX[i], this.m_arrDropY[i], nDropSize, nDropSize);
        }
    }
}

