/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.Interface2D;
import Kartmania.ObjectsCache;
import Kartmania.PackedImage;
import Kartmania.UIScreen;
import Kartmania.Utils;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class YesNoDialogBox {
    private Vector textLines = new Vector();
    private int backgroundColor;
    private String captionText;
    private Image image;
    private Timer animTimer;
    private Image[] animation;
    private int currentFrame = 0;
    private boolean pingPong = false;
    private int width;
    private int height;

    public YesNoDialogBox(String caption, String main, int color, String imgName, int numFrames, long speed) {
        this.width = Application.gameCanvas.getWidth();
        this.height = Application.gameCanvas.getHeight();
        this.init(caption, main, color);
        this.animation = new Image[numFrames];
        try {
            for (int i = 0; i < numFrames; ++i) {
                this.animation[i] = PackedImage.loadImage(imgName + i + ".png");
            }
            this.animTimer = new Timer();
            this.animTimer.schedule((TimerTask)new AnimTask(), speed, speed);
        }
        catch (Exception e) {
            // empty catch block
        }
        Application.gameCanvas.setDialog(this);
    }

    public YesNoDialogBox(String caption, String main, int color, String imgName) {
        this.init(caption, main, color);
        try {
            this.image = PackedImage.loadImage(imgName);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void init(String caption, String main, int color) {
        this.backgroundColor = color;
        this.captionText = caption;
        this.textLines = Utils.splitText(main, "+", this.width, 0);
    }

    public YesNoDialogBox(String caption, String main, int color) {
        this.init(caption, main, color);
    }

    public void draw(Graphics g) {
        this.width = Application.screenWidth = Application.gameCanvas.getWidth();
        this.height = Application.screenHeight = Application.gameCanvas.getHeight();
        if (this.animation != null) {
            this.image = this.animation[this.currentFrame];
        }
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.width, this.height);
        UIScreen.drawString(g, this.captionText, this.width >> 1, 0, 17, 0);
        int fontHeight = Application.defaultFont.getFontHeight();
        int yCenterAlign = (this.height - fontHeight * this.textLines.size() - (this.image != null ? this.image.getHeight() : 0)) / 2;
        int yPosition = 0;
        for (int i = 0; i < this.textLines.size(); ++i) {
            yPosition = 0 + i * fontHeight + 0 + yCenterAlign;
            UIScreen.drawString(g, (String)this.textLines.elementAt(i), this.width >> 1, yPosition, 17, 0);
        }
        if (this.image != null) {
            g.drawImage(this.image, this.width >> 1, yPosition += fontHeight, 17);
        }
        Interface2D.drawSoftButtons(g, ObjectsCache.menuSbOK, ObjectsCache.menuSbCANCEL);
        Application.gameCanvas.flushGraphics();
    }

    public void cleanUp() {
        if (this.animTimer != null) {
            this.animTimer.cancel();
            this.animTimer = null;
        }
    }

    protected void keyReleased(int keyCode) {
        if (Application.SoftButton2_Code == keyCode) {
            Application.gameCanvas.setDialog(null);
            this.cleanUp();
            this.onNoSelected();
            return;
        }
        if (Application.SoftButton1_Code == keyCode) {
            Application.gameCanvas.setDialog(null);
            this.cleanUp();
            this.onYesSelected();
            return;
        }
        int gameAction = Application.gameCanvas.getGameAction(keyCode);
        switch (gameAction) {
            case 8: {
                Application.gameCanvas.setDialog(null);
                this.cleanUp();
                this.onYesSelected();
            }
        }
    }

    public abstract void onNoSelected();

    public abstract void onYesSelected();

    class AnimTask
    extends TimerTask {
        public void run() {
            if (!YesNoDialogBox.this.pingPong) {
                if (++YesNoDialogBox.this.currentFrame == YesNoDialogBox.this.animation.length) {
                    --YesNoDialogBox.this.currentFrame;
                    YesNoDialogBox.this.pingPong = true;
                }
            } else if (--YesNoDialogBox.this.currentFrame < 0) {
                YesNoDialogBox.this.currentFrame = 0;
                YesNoDialogBox.this.pingPong = false;
            }
            YesNoDialogBox.this.draw(Application.gameCanvas.getDrawingContext());
        }
    }
}

