/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.EndCompetitionGameState;
import Kartmania.EndHotSeatGameState;
import Kartmania.Game;
import Kartmania.GetReadyHSGameState;
import Kartmania.HUD;
import Kartmania.IGameState;
import Kartmania.Interface2D;
import Kartmania.ObjectsCache;
import Kartmania.Options;
import Kartmania.SelectGameMode;
import javax.microedition.lcdui.Graphics;

public class RaceGameState
implements IGameState {
    int prevNumFinishedLaps = -1;
    int prevPosition = -1;
    long prevBestTime = -1L;
    long m_fxDelayTime = 0L;
    private int frame = 0;

    public boolean isAnyScreenEnabled() {
        return false;
    }

    public void OnLeave() {
    }

    public RaceGameState(int _trackID) {
    }

    public void OnEnter() {
        Game.stopAndGo = true;
        this.m_fxDelayTime = 0L;
    }

    public void OnTouchReleased(int x, int y) {
    }

    public void OnTouchPressed(int x, int y) {
    }

    public void OnUpdate(long deltaTime) {
        HUD.update(deltaTime);
        if (Application.testApp.GetHumanBolid().GetFinishedLaps() == Game.maxNumLaps && Application.testApp.GetHumanBolid().GetCurrentVelocity() < 1L) {
            this.m_fxDelayTime += Application.testApp.m_fxDeltaTime;
            if (this.m_fxDelayTime > 8192L) {
                if (SelectGameMode.selectedGameMode == 5) {
                    Application.testApp.m_FinishTimes[Application.testApp.m_nCurrentPlayer] = Application.testApp.GetBolid(0).GetLapTime(0);
                    if (Application.testApp.m_nCurrentPlayer < Application.testApp.m_nNrOfPlayers - 1) {
                        ++Application.testApp.m_nCurrentPlayer;
                        Application.getGame().pauseGame();
                        Application.getGame().createHotSeat(0);
                        Application.getGame().EnterState(new GetReadyHSGameState(Game.currentTrackID, Game.currentTrackMode, ++EndHotSeatGameState.HSplayerID));
                        Application.getGame().resumeGame();
                    } else {
                        Application.getGame().EnterState(new EndHotSeatGameState());
                    }
                } else if (SelectGameMode.selectedGameMode != 1) {
                    Application.testApp.m_FinishTimes[0] = Application.testApp.GetBolid(0).GetLapTime(0);
                    Application.getGame().EnterState(new EndCompetitionGameState());
                }
            }
        }
    }

    public static String formatTime(long time) {
        if (time == 999999L) {
            return Application.lp.getTranslatedString(Options.languageID, "ID_DISQUALIFIED");
        }
        return Application.defaultFont.encodeDynamicString(HUD.formatTimeAsc(time));
    }

    public void OnDraw(Graphics g) {
        if (!Application.getGame().isGamePaused()) {
            g.setClip(0, 0, Application.screenWidth, Application.screenHeight);
            g.setColor(-16316665);
            g.fillRect(0, Application.screenHeight - Application.testApp.m_nTranslateScreenY, Application.screenWidth, Application.testApp.m_nTranslateScreenY);
            Interface2D.drawPauseButton(g, ObjectsCache.menuSbPAUSE, Application.testApp.GetHumanBolid().GetFinishedLaps() > 0);
            if (!Application.getGame().isGamePaused() && Application.menuSystem.getCurrentUIScreen() == null) {
                HUD.draw(g);
            }
            if (this.frame < 10 && !Application.getApplication().gameIsContinued) {
                HUD.setLight(3);
                HUD.drawSemaphore(g);
            }
            if (this.isShowFinishFlag()) {
                // empty if block
            }
        }
    }

    private boolean isShowFinishFlag() {
        ++this.frame;
        return Application.testApp.GetHumanBolid().IsShowFinishFlag();
    }

    public void OnKeyPressed(int keyCode) {
    }

    public void OnKeyReleased(int keyCode) {
        if (keyCode == Application.SoftButton2_Code) {
            Application.game.askAbortToMainMenu();
        }
    }
}

