/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.CGTexture;
import Kartmania.CarEngine2D;
import java.io.DataInputStream;
import java.io.IOException;

public class CGBillboardObject {
    static String[] bilboardsFilename = new String[]{"/2_tree_2.png", "/2_tree_1.png", "/2_low_grass.png", "/4.png", "/9.png", "/1_tree_2.png", "/1_tree_1.png", "/1_low_grass.png", "/5.png", "/9.png", "/3_tree_1.png", "/3_tree_2.png", "/3_low_grass.png", "/8.png", "/9.png", "/curve_1.png", "/curve_1.png", "/sign_start.png", "/sign_check.png", "/sign_meta.png", "/rocks_1.png", "/rocks_2.png", "/rocks_3.png"};
    static int[] bilboardsWidths = new int[]{34, 100, 34, 64, 83, 48, 125, 42, 35, 83, 48, 127, 42, 42, 83, 24, 24, 27, 27, 27, 40, 40, 40};
    static int[] bilboardsHeights = new int[]{84, 125, 27, 54, 33, 122, 161, 27, 46, 33, 122, 125, 27, 26, 33, 30, 30, 33, 33, 33, 20, 20, 20};
    static int[] bilboardsScale = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] bilboardsIsMirrored = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0};
    public long m_fxX;
    public long m_fxY;
    public long m_fxZ;
    public long m_fxH;
    public long m_fxW;
    public long m_fxTrX;
    public long m_fxTrY;
    public long m_fxTrZ;
    public int m_nMirrored = 0;
    public int m_nLinearScale;
    public long m_fxDistanceFromStart;
    public CGTexture m_Texture;

    public void deSerialize(DataInputStream dis) throws IOException {
        int nL = dis.readInt();
        char[] szTextureName = new char[nL];
        for (int i = 0; i < nL; ++i) {
            char b;
            szTextureName[i] = b = (char)dis.readByte();
        }
        String str = new String(szTextureName);
        String szFullName = "/" + str;
        this.m_fxX = dis.readInt() * 4096;
        this.m_fxZ = dis.readInt() * 4096;
        this.m_fxW = dis.readInt() * 4096;
        this.m_fxH = dis.readInt() * 4096;
        this.m_fxY = dis.readInt() * 4096;
        this.m_nLinearScale = dis.readInt();
        this.m_nMirrored = dis.readInt();
        if (this.m_nMirrored > 0) {
            this.m_nMirrored = 2;
        }
        long fxScaleMin = Application.testApp.GetMaxObjectsDistanceScale();
        long fxDeltaScale = (4096L - fxScaleMin) / (long)(CGTexture.m_nNrOfMipMaps - 1);
        int[] arrWidth = new int[CGTexture.m_nNrOfMipMaps];
        int[] arrHeight = new int[CGTexture.m_nNrOfMipMaps];
        for (int i = 0; i < CGTexture.m_nNrOfMipMaps; ++i) {
            arrWidth[i] = (int)(Application.testApp.m_Camera.m_fxCameraScale * (this.m_fxW / 4096L) * (fxScaleMin + (long)i * fxDeltaScale) / 0x1000000L);
            arrHeight[i] = (int)(Application.testApp.m_Camera.m_fxCameraScale * (this.m_fxH / 4096L) * (fxScaleMin + (long)i * fxDeltaScale) / 0x1000000L);
        }
        this.m_Texture = CarEngine2D.GetTextureManager().AddTexture(szFullName, 0, 1, arrWidth, arrHeight);
    }

    public static CGBillboardObject CreateBillboardObject(int nType, long x, long y, long z) {
        String szFullName = null;
        CGBillboardObject pO = new CGBillboardObject();
        pO.m_fxX = x;
        pO.m_fxY = y;
        pO.m_fxZ = z;
        pO.m_fxW = bilboardsWidths[nType - 1] << 12;
        pO.m_fxH = bilboardsHeights[nType - 1] << 12;
        pO.m_nLinearScale = bilboardsScale[nType - 1];
        pO.m_nMirrored = bilboardsIsMirrored[nType - 1];
        szFullName = bilboardsFilename[nType - 1];
        if (szFullName != null) {
            if (pO.m_nMirrored > 0) {
                pO.m_nMirrored = 2;
            }
            CGTexture.m_nNrOfMipMaps = CGTexture.m_NrOfMipMapsForObjects;
            long fxScaleMin = 13L * Application.testApp.GetMaxObjectsDistanceScale() / 10L;
            long fxDeltaScale = (4096L - fxScaleMin) / (long)(CGTexture.m_nNrOfMipMaps - 1);
            int[] arrWidth = new int[CGTexture.m_nNrOfMipMaps];
            int[] arrHeight = new int[CGTexture.m_nNrOfMipMaps];
            for (int i = 0; i < CGTexture.m_nNrOfMipMaps; ++i) {
                arrWidth[i] = (int)(Application.testApp.m_Camera.m_fxCameraScale * (pO.m_fxW / 4096L) * (fxScaleMin + (long)i * fxDeltaScale) / 0x1000000L);
                arrHeight[i] = (int)(Application.testApp.m_Camera.m_fxCameraScale * (pO.m_fxH / 4096L) * (fxScaleMin + (long)i * fxDeltaScale) / 0x1000000L);
            }
            pO.m_Texture = CarEngine2D.GetTextureManager().AddTexture(szFullName, 0, 1, arrWidth, arrHeight);
        }
        return pO;
    }
}

