/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.CGTexture;
import Kartmania.CarEngine2D;
import Kartmania.ChampionshipsResultsScreen;
import Kartmania.ContinueOrNewChampionships;
import Kartmania.Game;
import Kartmania.HintScreen;
import Kartmania.ObjectsCache;
import Kartmania.Options;
import Kartmania.SelectGameMode;
import Kartmania.SelectTrack;
import Kartmania.UICaptionThick;
import Kartmania.UIScreen;
import javax.microedition.lcdui.Graphics;

public class CareerScreen
extends UIScreen {
    private final long SCROLL_AXES_ANIM_SPEED;
    private int[] animOffsets = new int[]{0, 1, 2, 3, 4, 3, 2, 1};
    public static int NUM_MENU_ELEMENTS = 2;
    public static int DEFAULT_VSPACING = 1;
    private int menuID = 0;
    private CGTexture[] tracks = null;
    private String[] menuLabels = new String[]{"ID_CAREER_NEXT_RACE", "ID_CAREER_RANKING"};
    public static String[] trackIconNames = new String[]{"/giant_ico.png", "/downhill_ico.png", "/slalom_ico.png"};
    public int[] trackIconIndexes = new int[]{2, 2, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2};
    public static int careerPointsTOCHANGE = 0;

    public void autoSize() {
    }

    public CareerScreen() {
        this.SCROLL_AXES_ANIM_SPEED = 6L;
        this.tracks = new CGTexture[12];
        for (int i = 0; i < 12; ++i) {
            this.tracks[i] = CarEngine2D.GetTextureManager().AddTexture(trackIconNames[this.trackIconIndexes[i]], 0, 0, null, null);
        }
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbBACK);
        this.setCaption(new UICaptionThick(Application.lp.getTranslatedString(Options.languageID, "ID_CAREER_SCREEN_HEADER")));
    }

    public void onUpdate(long deltaTime) {
        this.lifeTime += deltaTime;
    }

    public void draw(Graphics g) {
        boolean isTouchScreen = false;
        int oneFourth = Application.screenWidth / 4;
        int nPosX = Application.screenWidth / 2;
        int nPosY = Application.screenHeight - 9 - 49;
        String str = Application.defaultFont.encodeDynamicString(Game.careerTrackID + 1 + "/12");
        UIScreen.drawString(g, str, Application.screenWidth / 2, Application.screenHeight - 18 - 98 + 3 * Application.defaultFont.getFontHeight() / 2, 17, 0);
        str = Application.lp.getTranslatedString(Options.languageID, "ID_TRACK_COUNTRY_" + Game.careerTrackID);
        UIScreen.drawString(g, str, nPosX, nPosY - this.tracks[Game.careerTrackID].m_Image.getHeight() / 2 - Application.defaultFont.getFontHeight() / 4, 33, 0);
        g.drawImage(this.tracks[Game.careerTrackID].m_Image, nPosX, nPosY, 3);
        int yPos = Application.screenHeight - 18 - ObjectsCache.menuWhiteSquare.getHeight();
        this.drawMenu(g, yPos);
    }

    protected boolean touchPressed(int x, int y) {
        int top = Application.screenHeight - 18 - ObjectsCache.menuWhiteSquare.getHeight() - ObjectsCache.menuHScrollSmall[0].getHeight();
        int bottom = top + ObjectsCache.menuHScrollSmall[0].getHeight();
        if (y >= top && y <= bottom) {
            if (x <= ObjectsCache.menuHScrollSmall[0].getWidth() + 5) {
                this.menuID = 1 - this.menuID;
                return true;
            }
            if (x >= Application.screenWidth - ObjectsCache.menuHScrollSmall[0].getWidth() - 5) {
                this.menuID = 1 - this.menuID;
                return true;
            }
        }
        return false;
    }

    private void drawDots(Graphics g, int numElements, int current, int xPos, int yPos) {
        if (numElements > 0) {
            int startSquaresX = (Application.screenWidth - numElements * 6) / 2;
            for (int i = 0; i < numElements; ++i) {
                int xOffset = startSquaresX + i * 6;
                g.drawImage(i == current ? ObjectsCache.menuWhiteSquare : ObjectsCache.menuRedSquare, xOffset, yPos, 33);
            }
        }
    }

    private void drawMenu(Graphics g, int yPos) {
        int nStopX;
        int startX;
        int x;
        int oneSecond = Application.screenWidth / 2;
        int oneThird = Application.screenWidth / 3;
        g.drawImage(ObjectsCache.menuCaptionSmall[2], 0, yPos, 36);
        g.drawImage(ObjectsCache.menuCaptionSmall[3], Application.screenWidth, yPos, 40);
        for (x = ObjectsCache.menuCaptionSmall[2].getWidth(); x < oneSecond; ++x) {
            g.drawImage(ObjectsCache.menuCaptionSmall[5], x, yPos, 36);
        }
        for (x = oneSecond; x <= Application.screenWidth - ObjectsCache.menuCaptionSmall[3].getWidth(); ++x) {
            g.drawImage(ObjectsCache.menuCaptionSmall[5], x, yPos, 36);
        }
        if (Application.screenWidth > 128) {
            if (this.menuID == 0) {
                g.drawImage(ObjectsCache.menuCaptionSmall[1], oneSecond, yPos, 40);
                startX = oneThird / 2;
                int nStopX2 = oneSecond - ObjectsCache.menuCaptionSmall[1].getWidth();
                for (int x2 = startX; x2 <= nStopX2; x2 += ObjectsCache.menuCaptionSmall[4].getWidth()) {
                    g.drawImage(ObjectsCache.menuCaptionSmall[4], x2, yPos, 36);
                }
            } else {
                int startX2;
                g.drawImage(ObjectsCache.menuCaptionSmall[0], oneSecond, yPos, 36);
                nStopX = 5 * (oneThird / 2);
                for (int x3 = startX2 = oneSecond + ObjectsCache.menuCaptionSmall[0].getWidth(); x3 <= nStopX; x3 += ObjectsCache.menuCaptionSmall[4].getWidth()) {
                    g.drawImage(ObjectsCache.menuCaptionSmall[4], x3, yPos, 36);
                }
            }
        } else if (this.menuID == 0) {
            g.drawImage(ObjectsCache.menuCaptionSmall[1], oneSecond, yPos, 40);
            startX = 0;
            int nStopX3 = oneSecond - ObjectsCache.menuCaptionSmall[1].getWidth();
            for (int x4 = startX; x4 <= nStopX3; x4 += ObjectsCache.menuCaptionSmall[4].getWidth()) {
                g.drawImage(ObjectsCache.menuCaptionSmall[4], x4, yPos, 36);
            }
        } else {
            int startX3;
            g.drawImage(ObjectsCache.menuCaptionSmall[0], oneSecond, yPos, 36);
            nStopX = Application.screenWidth;
            for (int x5 = startX3 = oneSecond + ObjectsCache.menuCaptionSmall[0].getWidth(); x5 <= nStopX; x5 += ObjectsCache.menuCaptionSmall[4].getWidth()) {
                g.drawImage(ObjectsCache.menuCaptionSmall[4], x5, yPos, 36);
            }
        }
        int offset = this.animOffsets[(int)(this.lifeTime * 6L) / 4096 % this.animOffsets.length];
        g.drawImage(ObjectsCache.menuHScrollSmall[0], 0 + offset, yPos, 36);
        g.drawImage(ObjectsCache.menuHScrollSmall[1], Application.screenWidth - offset, yPos, 40);
        yPos -= ObjectsCache.menuCaptionSmall[0].getHeight() >> 1;
        if (Application.screenWidth > 128) {
            UIScreen.drawString(g, Application.lp.getTranslatedString(Options.languageID, this.menuLabels[0]), Application.screenWidth / 3, yPos, 3, 2);
            UIScreen.drawString(g, Application.lp.getTranslatedString(Options.languageID, this.menuLabels[1]), 2 * Application.screenWidth / 3, yPos, 3, 2);
        } else {
            UIScreen.drawString(g, Application.lp.getTranslatedString(Options.languageID, this.menuLabels[0]), Application.screenWidth / 4, yPos, 3, 2);
            UIScreen.drawString(g, Application.lp.getTranslatedString(Options.languageID, this.menuLabels[1]), 3 * Application.screenWidth / 4, yPos, 3, 2);
        }
    }

    protected void rightSoftButton() {
        if (Application.getGame() != null) {
            Application.getGame().storeGameState();
        }
        Application.getApplication().getMenu().setCurrentUIScreen(new ContinueOrNewChampionships());
    }

    protected void leftSoftButton() {
        if (Game.isChampionshipsFinished()) {
            Game.careerReset();
            Game.cleanUpGameStateStore();
            HintScreen.showHintedScreen(new SelectGameMode(), HintScreen.ID_HINT_END_OF_CHAMPIONSHIPS, 1);
        } else if (this.menuID == 0) {
            SelectTrack.selectedTrack = Game.careerTrackID;
            Application.getApplication().startGame();
        } else if (this.menuID == 1) {
            Application.getApplication().getMenu().setCurrentUIScreen(new ChampionshipsResultsScreen(this));
        }
    }

    public void currentItemChanged(int oldID, int currentItemId) {
    }

    public void currentItemSelected(int currentItemId) {
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
        int gameAction = this.parentCanvas.getGameAction(keyCode);
        if (keyCode == 50) {
            gameAction = 1;
        } else if (keyCode == 56) {
            gameAction = 6;
        } else if (keyCode == 52) {
            gameAction = 2;
        } else if (keyCode == 54) {
            gameAction = 5;
        } else if (keyCode == 53) {
            gameAction = 8;
        }
        switch (gameAction) {
            case 2: {
                this.menuID = 1 - this.menuID;
                break;
            }
            case 5: {
                this.menuID = 1 - this.menuID;
                break;
            }
            case 8: {
                this.leftSoftButton();
            }
        }
    }
}

