/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.CGTexture;
import Kartmania.PackedImage;
import java.util.Vector;

public class TextureManager {
    private Vector m_arrTextures = new Vector(3, 2);

    public CGTexture AddTexture(String szName, int bCreateBuffer, int bCreateMipMaps, int[] arrWidth, int[] arrHeight) {
        CGTexture t = this.GetTexture(szName);
        if (t != null) {
            return t;
        }
        if (PackedImage.loadImage(szName) == null) {
            // empty if block
        }
        t = new CGTexture();
        t.m_szName = szName;
        int ret = 0;
        try {
            ret = t.Create(szName, bCreateBuffer, bCreateMipMaps, arrWidth, arrHeight);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ret == 0) {
            return null;
        }
        this.m_arrTextures.addElement(t);
        return t;
    }

    public CGTexture GetTexture(String szName) {
        int nSize = this.m_arrTextures.size();
        for (int i = 0; i < nSize; ++i) {
            if (!((CGTexture)this.m_arrTextures.elementAt((int)i)).m_szName.equals(szName)) continue;
            return (CGTexture)this.m_arrTextures.elementAt(i);
        }
        return null;
    }

    public void DeleteTexture(CGTexture t) {
        int nSize = this.m_arrTextures.size();
        for (int i = 0; i < nSize; ++i) {
            if ((CGTexture)this.m_arrTextures.elementAt(i) != t) continue;
            this.m_arrTextures.removeElementAt(i);
            return;
        }
    }

    public void DeleteTexture(String szName) {
        CGTexture t = this.GetTexture(szName);
        if (t != null) {
            this.DeleteTexture(t);
        }
    }

    public void Destroy() {
        this.m_arrTextures.removeAllElements();
    }
}

