/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.CGBillboardObject;
import Kartmania.CGTrack;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class CGTrackPiece {
    public static int TRACK_PIECE_LINE = 0;
    public static int TRACK_PIECE_TURN = 1;
    public static int TRACK_PIECE_BEZIER = 2;
    public Vector m_arrObjects = new Vector();
    public int m_nPieceType;
    public int m_nPieceLength;
    public int m_nPieceAngle;
    public int m_nPieceHeight;
    public int m_nPieceBezierSize;

    public void ResetObj() {
        this.m_arrObjects.removeAllElements();
    }

    public int GetObjectsSize() {
        return this.m_arrObjects.size();
    }

    public CGBillboardObject GetObject(int nIndex) {
        return (CGBillboardObject)this.m_arrObjects.elementAt(nIndex);
    }

    public void AddObject(CGBillboardObject pO) {
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            CGBillboardObject pOO = this.GetObject(i);
            if (pOO.m_fxDistanceFromStart <= pO.m_fxDistanceFromStart) continue;
            this.m_arrObjects.insertElementAt(pO, i);
            return;
        }
        this.m_arrObjects.addElement(pO);
    }

    public void deSerialize(DataInputStream dis) throws IOException {
        this.m_nPieceType = dis.readByte();
        this.m_nPieceLength = dis.readInt();
        this.m_nPieceAngle = -dis.readByte() * 5;
        this.m_nPieceHeight = dis.readInt();
        if (CGTrack.m_bInvertTrackFlag) {
            this.m_nPieceAngle = -this.m_nPieceAngle;
            this.m_nPieceHeight = -this.m_nPieceHeight;
        }
        this.m_nPieceBezierSize = dis.readByte() * 10;
        int numObjects = dis.readByte();
        if (numObjects > 0) {
            for (int i = 0; i < numObjects; ++i) {
                CGBillboardObject pO = new CGBillboardObject();
                pO.deSerialize(dis);
                this.m_arrObjects.addElement(pO);
            }
        }
    }
}

