/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.ObjectsCache;
import Kartmania.Platform;
import Kartmania.UIScreen;
import Kartmania.Utils;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class UITextBox
extends UIScreen {
    private Vector textLines = new Vector();
    private int textHeight = 0;
    private long scrollOffset = 0L;
    private boolean scrollable = false;
    private final int SCROLL_SPEED;
    private UIScreen combackScreen = null;

    public UITextBox(boolean _scrollable) {
        this.SCROLL_SPEED = 30;
        this.scrollable = _scrollable;
        this.showScrollbars(this.scrollable);
    }

    public UITextBox(boolean _scrollable, UIScreen nextScreen) {
        this.SCROLL_SPEED = 30;
        this.scrollable = _scrollable;
        this.combackScreen = nextScreen;
        this.showScrollbars(this.scrollable);
    }

    public void autoSize() {
        this.clientAreaX = Platform.WND_MARGIN_LEFT;
        this.clientAreaWidth = this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT;
        this.clientAreaY = Platform.WND_MARGIN_TOP;
        this.clientAreaHeight = this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM;
    }

    public void onUpdate(long deltaTime) {
        super.onUpdate(deltaTime);
        if (this.scrollable) {
            int maxScrollValue;
            if ((Application.isUpPressed() || this.scrollingState == -1) && this.scrollOffset < 0L) {
                this.scrollOffset += deltaTime * 30L;
            }
            if ((Application.isDownPressed() || this.scrollingState == 1) && this.scrollOffset > (long)(4096 * (maxScrollValue = -Application.defaultFont.getFontHeight() * (this.textLines.size() - this.clientAreaHeight / Application.defaultFont.getFontHeight())))) {
                this.scrollOffset -= deltaTime * 30L;
            }
        }
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
        int gameAction = this.parentCanvas.getGameAction(keyCode);
        if (keyCode == 50) {
            gameAction = 1;
        } else if (keyCode == 56) {
            gameAction = 6;
        } else if (keyCode == 52) {
            gameAction = 2;
        } else if (keyCode == 54) {
            gameAction = 5;
        } else if (keyCode == 53) {
            gameAction = 8;
        }
        switch (gameAction) {
            case 8: {
                this.leftSoftButton();
            }
        }
    }

    protected void rightSoftButton() {
        if (this.rightSBImage != null && this.combackScreen != null) {
            Application.getApplication().getMenu().setCurrentUIScreen(this.combackScreen);
            this.combackScreen.onFocusBack();
        }
    }

    public void setText(String newText, String separator) {
        int screenWidth = Application.screenWidth;
        this.textLines = Utils.splitText(newText, separator, screenWidth);
        this.textHeight = this.textLines.size() * Application.defaultFont.getFontHeight();
        this.showScrollbars = this.scrollable = this.textHeight > this.clientAreaHeight;
        if (this.scrollable) {
            int nArrowWidth = 5 * ObjectsCache.scrollUpImg.getWidth() / 4;
            this.textLines = Utils.splitText(newText, separator, screenWidth - nArrowWidth);
            this.textHeight = this.textLines.size() * Application.defaultFont.getFontHeight();
        }
    }

    public void setText(String newText) {
        this.setText(newText, "+");
    }

    public void draw(Graphics g) {
        if (this.showScrollbars) {
            this.drawScrollBars(g);
        }
        int fontHeight = Application.defaultFont.getFontHeight();
        int yCenterAlign = 0;
        if (!this.scrollable) {
            yCenterAlign = (this.clientAreaHeight - fontHeight * this.textLines.size()) / 2;
        }
        g.setClip(this.positionX + Platform.WND_MARGIN_LEFT, this.positionY + Platform.WND_MARGIN_TOP, this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT, this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM);
        int nArrowWidth = 5 * ObjectsCache.scrollUpImg.getWidth() / 4;
        for (int i = 0; i < this.textLines.size(); ++i) {
            int yPosition = this.positionY + this.clientAreaY + i * fontHeight + (int)(this.scrollOffset / 4096L) + yCenterAlign;
            if (yPosition < 0 || yPosition > Application.screenHeight) continue;
            if (!this.showScrollbars) {
                UIScreen.drawString(g, (String)this.textLines.elementAt(i), this.positionX + this.width / 2, yPosition, 17, 0);
                continue;
            }
            UIScreen.drawString(g, (String)this.textLines.elementAt(i), this.positionX + this.width / 2 - nArrowWidth / 2, yPosition, 17, 0);
        }
    }

    protected void leftSoftButton() {
        if (this.leftSBImage != null && this.combackScreen != null) {
            Application.getApplication().getMenu().setCurrentUIScreen(this.combackScreen);
            this.combackScreen.onFocusBack();
        }
    }
}

