/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.ObjectsCache;
import Kartmania.Options;
import Kartmania.UIScreen;
import Kartmania.UIWindowCaption;
import javax.microedition.lcdui.Graphics;

public class UICaptionExtended
implements UIWindowCaption {
    private static int mainMenuID = 0;
    private long lifeTime = 0L;
    public static int CAPTION_START_ID = 0;
    public static int CAPTION_HISCORES_ID = 1;
    public static int CAPTION_OPTIONS_ID = 2;
    public static int CAPTION_HELP_ID = 3;
    public static int CAPTION_CREDITS_ID = 4;
    public static int CAPTION_QUIT_ID = 5;
    private static final int SCROLL_AXES_ANIM_SPEED = 8;
    private int[] animOffsets = new int[]{0, 1, 2, 3, 4, 5, 4, 3, 2, 1};
    private static String[] mainMenuStrings = new String[]{"ID_START", "ID_BEST_RESULTS", "ID_OPTIONS", "ID_HELP", "ID_CREDITS", "ID_QUIT"};

    public UICaptionExtended(int dots, int id, UIScreen _screen) {
        mainMenuID = id;
    }

    public void update(long deltaTime) {
        this.lifeTime += deltaTime;
    }

    public int getHeight() {
        return ObjectsCache.menuCaption[0].getHeight() + 9;
    }

    public void draw(Graphics g) {
        g.setClip(0, 0, Application.screenWidth, Application.screenHeight);
        int topOfClientArea = Application.screenHeight - 18 - 138;
        this.drawMenuCaption(g, topOfClientArea);
        g.drawImage(ObjectsCache.menuRedLine, Application.screenWidth >> 1, topOfClientArea + ObjectsCache.menuCaption[0].getHeight() + 5, 17);
        int startSquaresX = (Application.screenWidth - mainMenuStrings.length * 6) / 2;
        for (int i = 0; i < mainMenuStrings.length; ++i) {
            int xOffset = startSquaresX + i * 6;
            g.drawImage(i == mainMenuID ? ObjectsCache.menuWhiteSquare : ObjectsCache.menuRedSquare, xOffset, topOfClientArea + ObjectsCache.menuCaption[0].getHeight(), 17);
        }
        UIScreen.drawString(g, Application.lp.getTranslatedString(Options.languageID, mainMenuStrings[mainMenuID]), Application.screenWidth >> 1, topOfClientArea + ObjectsCache.menuCaption[0].getHeight() / 2, 3, 0);
        g.drawImage(ObjectsCache.menuHScrollBig[0], this.animOffsets[(int)(this.lifeTime * 8L / 4096L) % this.animOffsets.length], topOfClientArea + ObjectsCache.menuCaption[0].getHeight() / 2, 6);
        g.drawImage(ObjectsCache.menuHScrollBig[1], Application.screenWidth - this.animOffsets[(int)(this.lifeTime * 8L / 4096L) % this.animOffsets.length], topOfClientArea + ObjectsCache.menuCaption[0].getHeight() / 2, 10);
    }

    private void drawMenuCaption(Graphics g, int topOfClientArea) {
        int w = ObjectsCache.menuCaption[4].getWidth();
        for (int x = 0; x <= Application.screenWidth / w; x += w) {
            g.drawImage(ObjectsCache.menuCaption[4], x * w, topOfClientArea, 20);
        }
        g.drawImage(ObjectsCache.menuCaption[2], 0, topOfClientArea, 20);
        g.drawImage(ObjectsCache.menuCaption[3], Application.screenWidth, topOfClientArea, 24);
        g.drawImage(ObjectsCache.menuCaption[0], ObjectsCache.menuCaption[2].getWidth(), topOfClientArea, 20);
        g.drawImage(ObjectsCache.menuCaption[1], Application.screenWidth - ObjectsCache.menuCaption[3].getWidth(), topOfClientArea, 24);
    }

    public void currentItemChanged(int item) {
    }
}

