/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.Platform;
import Kartmania.UIScreen;
import javax.microedition.lcdui.Graphics;

public abstract class UIEditBox
extends UIScreen {
    private final int DEFAULT_EDIT_TEXT_LENGTH;
    private final int KEY_PRESSES_DELAY;
    private int editTextMaxLength = 8;
    protected String editableText;
    int lastKeyPressed = -1;
    int numPresses = 0;
    long timeOfLastPress = 0L;
    String previewChar = "";
    boolean flash = true;
    private static char[] keyNum2Chars = new char[]{'A', 'B', 'C'};
    private static char[] keyNum3Chars = new char[]{'D', 'E', 'F'};
    private static char[] keyNum4Chars = new char[]{'G', 'H', 'I'};
    private static char[] keyNum5Chars = new char[]{'J', 'K', 'L'};
    private static char[] keyNum6Chars = new char[]{'M', 'N', 'O'};
    private static char[] keyNum7Chars = new char[]{'P', 'Q', 'R', 'S'};
    private static char[] keyNum8Chars = new char[]{'T', 'U', 'V'};
    private static char[] keyNum9Chars = new char[]{'W', 'X', 'Y', 'Z'};

    public UIEditBox(String initialText) {
        this.DEFAULT_EDIT_TEXT_LENGTH = 8;
        this.KEY_PRESSES_DELAY = 700;
        this.editableText = initialText;
    }

    public void autoSize() {
        this.clientAreaX = Platform.WND_MARGIN_LEFT;
        this.clientAreaWidth = this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT;
        this.clientAreaY = Platform.WND_MARGIN_TOP;
        this.clientAreaHeight = this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM;
    }

    public void draw(Graphics g) {
        int fontHeight = Application.defaultFont.getFontHeight();
        int yCenterAlign = (this.clientAreaHeight - fontHeight) / 2;
        g.setClip(this.positionX + Platform.WND_MARGIN_LEFT, this.positionY + Platform.WND_MARGIN_TOP, this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT, this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM);
        int yPosition = this.positionY + this.clientAreaY + yCenterAlign;
        UIScreen.drawString(g, this.editableText, this.positionX + this.width / 2, yPosition, 17, 0);
        int nameStringWidth = UIScreen.stringWidth(this.editableText, 0);
        UIScreen.drawString(g, Application.defaultFont.encodeDynamicString(this.previewChar), 1 + nameStringWidth / 2 + this.positionX + this.width / 2, yPosition, 20, 0);
    }

    private void addChar(int key, int numPresses) {
        char ch = '\u0000';
        if (key != -1 && (ch = this.getCharFromKeyPress(key, numPresses)) != '\u0000') {
            this.editableText = this.editableText.length() < this.editTextMaxLength ? this.editableText + Application.defaultFont.encodeDynamicString("" + ch) : this.editableText.substring(0, this.editTextMaxLength - 1) + Application.defaultFont.encodeDynamicString("" + ch);
        }
    }

    public char getCharFromKeyPress(int key, int numPresses) {
        switch (key) {
            case 50: {
                return keyNum2Chars[numPresses % 3];
            }
            case 51: {
                return keyNum3Chars[numPresses % 3];
            }
            case 52: {
                return keyNum4Chars[numPresses % 3];
            }
            case 53: {
                return keyNum5Chars[numPresses % 3];
            }
            case 54: {
                return keyNum6Chars[numPresses % 3];
            }
            case 55: {
                return keyNum7Chars[numPresses % 4];
            }
            case 56: {
                return keyNum8Chars[numPresses % 3];
            }
            case 57: {
                return keyNum9Chars[numPresses % 4];
            }
        }
        return '\u0000';
    }

    public void onUpdate(long deltaTime) {
        long currTime = System.currentTimeMillis();
        if (currTime - this.timeOfLastPress > 700L) {
            this.addChar(this.lastKeyPressed, this.numPresses);
            this.lastKeyPressed = -1;
            this.numPresses = 0;
        }
        if (this.lastKeyPressed != -1) {
            char prevChar = this.getCharFromKeyPress(this.lastKeyPressed, this.numPresses);
            this.previewChar = prevChar != '\u0000' ? new String("" + prevChar) : "";
        } else {
            this.flash = !this.flash;
            this.previewChar = this.flash ? "_" : " ";
        }
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == -8) {
            this.lastKeyPressed = -1;
            this.numPresses = 0;
            if (this.editableText.length() > 0) {
                this.editableText = this.editableText.substring(0, this.editableText.length() - 1);
            }
        } else if (this.lastKeyPressed != keyCode) {
            this.addChar(this.lastKeyPressed, this.numPresses);
            this.lastKeyPressed = keyCode;
            this.numPresses = 0;
        } else {
            ++this.numPresses;
        }
        this.timeOfLastPress = System.currentTimeMillis();
    }
}

