/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.AppCanvas;
import Kartmania.Application;
import Kartmania.ObjectsCache;
import Kartmania.UIScreen;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class MenuSystem {
    private Canvas parentCanvas;
    private UIScreen currentUIScreen = null;

    public void setCanvas(Canvas canvas) {
        this.parentCanvas = canvas;
    }

    public UIScreen getCurrentUIScreen() {
        return this.currentUIScreen;
    }

    public void setCurrentUIScreen(UIScreen uiScreen) {
        this.currentUIScreen = uiScreen;
        if (this.currentUIScreen != null) {
            this.currentUIScreen.setParent(this.parentCanvas);
            this.currentUIScreen.autoSize();
        }
    }

    public void paint(Graphics g) {
        if (this.currentUIScreen != null) {
            this.currentUIScreen.paint(g);
            this.currentUIScreen.drawSoftButtons(g);
        }
    }

    public void onUpdate(long deltaTime) {
        if (this.currentUIScreen != null) {
            this.currentUIScreen.autoSize();
            this.currentUIScreen.onUpdate(deltaTime);
            this.processCommands();
        }
    }

    public void processCommands() {
        try {
            AppCanvas.GameCommand cmd = null;
            while ((cmd = Application.gameCanvas.getCommand()) != null && this.currentUIScreen != null) {
                if (cmd.touchX < 0 && cmd.touchY < 0) {
                    if (cmd.pressed) {
                        this.currentUIScreen.keyPressed(cmd.keyCode);
                        continue;
                    }
                    if (cmd.keyCode == Application.SoftButton1_Code) {
                        this.currentUIScreen.leftSoftButton();
                        continue;
                    }
                    if (cmd.keyCode == Application.SoftButton2_Code) {
                        this.currentUIScreen.rightSoftButton();
                        continue;
                    }
                    this.currentUIScreen.keyReleased(cmd.keyCode);
                    if (this.parentCanvas == null || this.currentUIScreen == null) continue;
                    this.currentUIScreen.onGameAction(this.parentCanvas.getGameAction(cmd.keyCode));
                    continue;
                }
                if (cmd.pressed) {
                    if (cmd.touchX < ObjectsCache.menuSbOK.getWidth() * 2 && cmd.touchY > Application.screenHeight - ObjectsCache.menuSbOK.getHeight() * 2) {
                        this.currentUIScreen.leftSoftButton();
                    } else if (cmd.touchX > Application.screenWidth - 2 * ObjectsCache.menuSbOK.getWidth() && cmd.touchY > Application.screenHeight - ObjectsCache.menuSbOK.getHeight() * 2) {
                        this.currentUIScreen.rightSoftButton();
                    }
                    this.currentUIScreen.touchPressed(cmd.touchX, cmd.touchY);
                    continue;
                }
                this.currentUIScreen.touchReleased(cmd.touchX, cmd.touchY);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

