/*
 * Decompiled with CFR 0.152.
 */
package Kartmania;

import Kartmania.Application;
import Kartmania.ObjectsCache;
import Kartmania.Platform;
import Kartmania.UIListColumn;
import Kartmania.UIListItem;
import Kartmania.UIListTextItem;
import Kartmania.UIScreen;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class UIList
extends UIScreen {
    private static int COLUMN_SEPARATOR_WIDTH = 4;
    private int[] animOffsets = new int[]{0, 1, 2, 1};
    protected int minScrollOffset = 0;
    protected int maxScrollOffset = 0;
    protected int currentScrollOffset = 0;
    protected Vector columns = null;
    protected Vector headers = new Vector();
    protected boolean enableSelection = true;
    protected int currentItem = 0;
    protected int centerMode = 1;
    public boolean drawColumnSeparators = false;
    public boolean showHeaders = false;

    void setCurrentItem(int nIndex) {
        this.currentItem = nIndex >= 0 && nIndex < this.getColumn((int)0).items.size() ? nIndex : -1;
    }

    public UIList(Vector _columns) {
        this.showScrollbars = true;
        this.columns = _columns;
        this.minScrollOffset = 0;
        this.maxScrollOffset = 0;
        this.currentScrollOffset = 0;
        this.currentItem = -1;
    }

    public UIList() {
        this.showScrollbars = true;
        this.columns = new Vector();
        this.columns.addElement(new UIListColumn(4096L, 1));
        this.minScrollOffset = 0;
        this.maxScrollOffset = 0;
        this.currentScrollOffset = 0;
        this.currentItem = -1;
    }

    protected UIListColumn getColumn(int id) {
        return (UIListColumn)this.columns.elementAt(id);
    }

    protected boolean touchPressed(int x, int y) {
        int offset = 0;
        int left = Application.screenWidth - ObjectsCache.scrollUpImg.getWidth() / 4 - ObjectsCache.scrollUpImg.getWidth();
        int right = left + ObjectsCache.scrollUpImg.getWidth();
        int top = this.positionY + 2 * this.height / 10 - offset + this.YScrollOffset - 5;
        int bottom = this.positionY + 2 * this.height / 10 - offset + this.YScrollOffset + ObjectsCache.scrollUpImg.getHeight() + 5;
        if (x >= left && x < right && y >= top && y <= bottom) {
            this.scrollingState = -1;
            return true;
        }
        top = this.positionY + 7 * this.height / 10 + offset + this.YScrollOffset - 5;
        bottom = this.positionY + 7 * this.height / 10 + offset + this.YScrollOffset + ObjectsCache.scrollUpImg.getHeight() + 5;
        if (x >= left && x < right && y >= top && y <= bottom) {
            this.scrollingState = 1;
            return true;
        }
        this.scrollingState = 0;
        return false;
    }

    protected boolean touchReleased(int x, int y) {
        this.scrollingState = 0;
        return false;
    }

    protected void moveUp() {
        this.currentScrollOffset -= 5;
        if (this.currentScrollOffset < this.minScrollOffset) {
            this.currentScrollOffset = this.minScrollOffset;
        }
    }

    protected void moveDown() {
        this.currentScrollOffset += 5;
        if (this.currentScrollOffset > this.maxScrollOffset) {
            this.currentScrollOffset = this.maxScrollOffset;
        }
    }

    protected void keyPressed(int gameAction) {
    }

    public void draw(Graphics g) {
        int numItems = this.getColumn((int)0).items.size();
        int fontHeight = 18;
        this.maxScrollOffset = (numItems + 1) * fontHeight - this.clientAreaHeight;
        if (this.maxScrollOffset < 0) {
            this.maxScrollOffset = 0;
        }
        if (Application.isDownPressed() || this.scrollingState == 1) {
            this.moveDown();
        } else if (Application.isUpPressed() || this.scrollingState == -1) {
            this.moveUp();
        }
        g.setClip(this.positionX + this.clientAreaX, this.positionY + this.clientAreaY + 3 * fontHeight / 4, this.clientAreaWidth, this.clientAreaHeight - 3 * fontHeight / 4);
        int itemsBaselineY = this.positionY + this.height / 2 - fontHeight / 2;
        numItems = this.getColumn((int)0).items.size();
        int startOffset = 0;
        int endOffset = numItems - 1;
        itemsBaselineY = this.positionY;
        if (this.showHeaders) {
            itemsBaselineY += fontHeight;
        }
        for (int i = startOffset; i <= endOffset; ++i) {
            int itemIndex = i;
            if (itemIndex < 0) {
                itemIndex += numItems;
            }
            if (itemIndex >= numItems) {
                itemIndex -= numItems;
            }
            int xx = 0;
            int yPosition = itemsBaselineY + i * fontHeight - this.currentScrollOffset;
            if (i == this.currentItem) {
                g.setColor(11419656);
                if (Application.screenWidth > 128) {
                    g.fillRect(0, yPosition - fontHeight / 4, Application.screenWidth, fontHeight);
                } else {
                    g.fillRect(0, yPosition - fontHeight / 4, Application.screenWidth, fontHeight);
                }
            }
            for (int cc = 0; cc < this.columns.size(); ++cc) {
                UIListColumn column = this.getColumn(cc);
                long _width = (long)this.clientAreaWidth * column.width / 4096L;
                UIListItem item = (UIListItem)column.items.elementAt(itemIndex);
                if (item.isVisible()) {
                    item.draw(g, xx, yPosition, (int)_width, fontHeight, column.alignment);
                }
                xx = (int)((long)xx + (_width + (long)COLUMN_SEPARATOR_WIDTH));
            }
        }
        g.setClip(this.positionX + this.clientAreaX, this.positionY + this.clientAreaY, this.clientAreaWidth, this.clientAreaHeight);
        if (this.showHeaders) {
            int xx = this.positionX + this.clientAreaX;
            for (int cc = 0; cc < this.columns.size(); ++cc) {
                UIListColumn column = this.getColumn(cc);
                long _width = (long)this.clientAreaWidth * column.width;
                if (column.alignment == 1) {
                    UIScreen.drawString(g, (String)this.headers.elementAt(cc), xx + (int)(_width / 4096L) / 2, this.positionY + this.clientAreaY, 17, 0);
                } else {
                    UIScreen.drawString(g, (String)this.headers.elementAt(cc), xx, this.positionY + this.clientAreaY, 20, 0);
                }
                xx = (int)((long)xx + _width / 4096L);
                xx += COLUMN_SEPARATOR_WIDTH;
            }
        }
        if (this.parentCanvas != null) {
            g.setClip(0, 0, this.parentCanvas.getWidth(), this.parentCanvas.getHeight());
        } else {
            g.setClip(0, 0, Application.screenWidth, Application.screenHeight);
        }
        if (this.maxScrollOffset > 0 && Application.screenWidth > 128) {
            this.drawScrollBars(g);
        }
        this.postDraw(g);
    }

    public void autoSize() {
        if (!this.smallWnd) {
            this.clientAreaX = Platform.WND_MARGIN_LEFT;
            this.clientAreaWidth = this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT;
            this.clientAreaY = Platform.WND_MARGIN_TOP;
            this.clientAreaHeight = this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM;
        } else {
            this.clientAreaX = 7;
            this.clientAreaWidth = this.width - 7 - 0;
            this.clientAreaY = 0;
            this.clientAreaHeight = this.height - 0 - 9;
        }
    }

    public void postDraw(Graphics g) {
    }

    protected void leftSoftButton() {
    }

    protected void rightSoftButton() {
    }

    public void clearList() {
        for (int i = 0; i < this.columns.size(); ++i) {
            this.getColumn(i).empty();
        }
    }

    public void append(String newItem, Image img) {
        this.getColumn((int)0).items.addElement(new UIListTextItem(newItem));
    }

    public void append(UIListItem item, int columnID) {
        this.getColumn((int)columnID).items.addElement(item);
    }

    public void append(String newItem) {
        this.getColumn((int)0).items.addElement(new UIListTextItem(newItem));
    }

    protected void keyReleased(int keyCode) {
        int gameAction = this.parentCanvas.getGameAction(keyCode);
        if (keyCode == 50) {
            gameAction = 1;
        } else if (keyCode == 56) {
            gameAction = 6;
        } else if (keyCode == 52) {
            gameAction = 2;
        } else if (keyCode == 54) {
            gameAction = 5;
        } else if (keyCode == 53) {
            gameAction = 8;
        }
        if (gameAction == 8) {
            this.leftSoftButton();
        }
    }

    public void setCenterMode(int mode) {
        this.centerMode = mode;
    }
}

